/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.base;

import com.teacode.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.RequireLevel;
import org.ontobox.box.RequireManager;
import org.ontobox.box.base.BaseBoxWorker;
import org.ontobox.box.helper.DateHelper;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.SplittedName;

public abstract class BaseBoxWriter
implements BoxWriter {
    private static Logger logger = Logger.getLogger(BaseBoxWriter.class.getName());
    protected BaseBoxWorker worker;
    public boolean requireWorked = false;

    protected BaseBoxWriter(BaseBoxWorker worker) {
        this.worker = worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void require(String uri) {
        if (this.requireWorked) {
            throw new IllegalStateException("Require is working already (use subrequire)");
        }
        this.requireWorked = true;
        try {
            if (this.subRequire(uri, Collections.<String>emptyList())) {
                this.worker.write().annotate(this.worker.resolve(uri, Entity.ONTOLOGY), "http://ontobox.org/#required", RequireLevel.DIRECT.name());
            }
        }
        finally {
            this.requireWorked = false;
        }
    }

    private boolean subRequire(String uri, List<String> required) {
        if (required.contains(uri)) {
            StringBuilder sb = new StringBuilder();
            for (String s : required) {
                sb.append(s).append(" -> ");
            }
            sb.append(uri);
            throw new IllegalStateException("Require infinite loop detected: " + sb);
        }
        Integer id = this.worker.id(uri);
        if ("http://ontobox.org/".equals(uri)) {
            return false;
        }
        if (this.worker.entity(uri) != Entity.ONTOLOGY) {
            final ArrayList<String> r = new ArrayList<String>(required);
            r.add(uri);
            if (!this.worker.box.manager.loadRequired(this.worker, new RequireManager.SubRequireLoader(){

                @Override
                public void require(String uri) {
                    if (BaseBoxWriter.this.subRequire(uri, r)) {
                        BaseBoxWriter.this.worker.write().annotate(BaseBoxWriter.this.worker.resolve(uri, Entity.ONTOLOGY), "http://ontobox.org/#required", RequireLevel.INDIRECT.name());
                    }
                }
            }, uri)) {
                throw new IllegalArgumentException(uri + " is unknown ontology");
            }
        } else {
            if (RequireLevel.DIRECT == this.worker.isRequired(id)) {
                return false;
            }
            if (this.worker.isRequired(id) == null) {
                throw new IllegalArgumentException(uri + " cannot be required because it already exists as user created");
            }
        }
        return true;
    }

    public void assertNotReadOnly(String uri) {
        String ont;
        Integer id;
        SplittedName splittedName = NameHelper.splitName(uri);
        if (splittedName != null && (id = this.worker.id(ont = splittedName.ontology())) != null && (this.worker.isRequired(id) != null || ont.equals("http://ontobox.org/"))) {
            throw new IllegalArgumentException(ont + " is read-only");
        }
    }

    public void assertNotReadOnly(int id) {
        this.assertNotReadOnly(this.worker.name(id));
    }

    protected abstract int createOntology(String var1);

    @Override
    public int newOntology(String uri) {
        this.assertNotReadOnly(uri);
        return this.createOntology(uri);
    }

    protected abstract int createClass(String var1);

    @Override
    public int newClass(String fn) {
        this.assertNotReadOnly(fn);
        return this.createClass(fn);
    }

    protected abstract int createObject(String var1);

    @Override
    public int newObject(String fn) {
        this.assertNotReadOnly(fn);
        return this.createObject(fn);
    }

    @Override
    public int newLWObject() {
        return this.newObject(this.newName(this.worker.resolve("|")));
    }

    protected abstract int createOProperty(String var1);

    @Override
    public int newOProperty(String fn) {
        this.assertNotReadOnly(fn);
        return this.createOProperty(fn);
    }

    protected abstract int createTProperty(String var1);

    @Override
    public int newTProperty(String fn) {
        this.assertNotReadOnly(fn);
        return this.createTProperty(fn);
    }

    protected abstract int createType(String var1);

    @Override
    public int newType(String fn) {
        this.assertNotReadOnly(fn);
        return this.createType(fn);
    }

    @Override
    public String newName(int ont) {
        String ontURI = this.worker.name(ont);
        this.assertNotReadOnly(ontURI);
        return ontURI + "#_" + UUID.randomUUID().toString().replace("-", "");
    }

    protected abstract void domainForTProperty(int var1, Integer var2);

    protected abstract void domainForOProperty(int var1, Integer var2);

    @Override
    public void setDomain(int prop, Integer domain) {
        Entity e = this.worker.extractEntity(prop, Entity.TPROPERTY, Entity.OPROPERTY);
        this.assertNotReadOnly(prop);
        if (e == Entity.TPROPERTY) {
            this.domainForTProperty(prop, domain);
        } else {
            this.domainForOProperty(prop, domain);
        }
    }

    protected abstract void rangeForTProperty(int var1, Integer var2);

    protected abstract void rangeForOProperty(int var1, Integer var2);

    @Override
    public void setRange(int prop, Integer range) {
        Entity e = this.worker.extractEntity(prop, Entity.TPROPERTY, Entity.OPROPERTY);
        this.assertNotReadOnly(prop);
        if (e == Entity.TPROPERTY) {
            this.rangeForTProperty(prop, range);
        } else {
            this.rangeForOProperty(prop, range);
        }
    }

    protected abstract void removeValueForTProperty(int var1, int var2, int var3);

    protected abstract void removeValueForOProperty(int var1, int var2, int var3);

    @Override
    public void removeValue(int object, int prop, int index) {
        this.worker.extractEntity(object, Entity.ONTOBJECT);
        this.assertNotReadOnly(object);
        Entity e = this.worker.extractEntity(prop, Entity.TPROPERTY, Entity.OPROPERTY);
        if (e == Entity.TPROPERTY) {
            this.removeValueForTProperty(object, prop, index);
        } else {
            this.removeValueForOProperty(object, prop, index);
        }
    }

    @Override
    public void removeValues(int object, int prop) {
        Entity e = this.worker.extractEntity(prop, Entity.TPROPERTY, Entity.OPROPERTY);
        if (e == Entity.TPROPERTY) {
            int tsize = this.worker.strings(object, prop).length;
            for (int t = 0; t < tsize; ++t) {
                this.removeValue(object, prop, tsize - t - 1);
            }
        } else {
            int tsize = this.worker.objects(object, prop).length;
            for (int t = 0; t < tsize; ++t) {
                this.removeValue(object, prop, tsize - t - 1);
            }
        }
    }

    @Override
    public void removeValues(int name) {
        for (int oprop : this.worker.oprops(name)) {
            this.removeValues(name, oprop);
        }
        for (int tprop : this.worker.tprops(name)) {
            this.removeValues(name, tprop);
        }
    }

    protected abstract void deleteForType(int var1);

    protected abstract void deleteForClass(int var1);

    protected abstract void deleteForObject(int var1);

    protected abstract void deleteForOntology(int var1);

    protected abstract void deleteForOProperty(int var1);

    protected abstract void deleteForTProperty(int var1);

    @Override
    public void delete(int id) {
        Entity e = this.worker.extractEntity(id);
        this.assertNotReadOnly(id);
        switch (e) {
            case ONTCLASS: {
                this.deleteForClass(id);
                break;
            }
            case ONTOBJECT: {
                this.deleteForObject(id);
                break;
            }
            case ONTOLOGY: {
                this.deleteForOntology(id);
                break;
            }
            case OPROPERTY: {
                this.deleteForOProperty(id);
                break;
            }
            case TPROPERTY: {
                this.deleteForTProperty(id);
                break;
            }
            case TYPE: {
                this.deleteForType(id);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected abstract void renameOntology(int var1, String var2);

    protected abstract void renameNamedEntity(int var1, String var2);

    @Override
    public void rename(int id, String newFn) {
        Entity e = this.worker.extractEntity(id);
        String n = this.worker.name(id);
        if (n.equals(newFn)) {
            return;
        }
        this.assertNotReadOnly(id);
        if (e == Entity.ONTOLOGY) {
            this.renameOntology(id, newFn);
        } else {
            this.renameNamedEntity(id, newFn);
        }
    }

    protected abstract void annotateForEntity(int var1, String var2, String var3);

    @Override
    public void annotate(int id, String name, String value) {
        if (this.worker.extractEntity(id) == Entity.ONTOBJECT && !name.equals("http://ontobox.org/#Lock")) {
            throw new IllegalArgumentException("Objects cannot be annotated (" + name + ")");
        }
        this.annotateForEntity(id, name, value);
    }

    @Override
    public void addObject(int object, int oprop, int value) {
        this.addObject(object, oprop, -1, value);
    }

    @Override
    public void addString(int object, int tprop, String value) {
        this.addString(object, tprop, -1, value);
    }

    @Override
    public void addBinary(int object, int tprop, byte[] value) {
        this.addBinary(object, tprop, -1, value);
    }

    @Override
    public void addBinary(int object, int tprop, int index, byte[] value) {
        this.addString(object, tprop, index, Base64.encodeBytes((byte[])value));
    }

    @Override
    public void addInt(int object, int tprop, int value) {
        this.addInt(object, tprop, -1, value);
    }

    @Override
    public void addInt(int object, int tprop, int index, int value) {
        this.addString(object, tprop, index, String.valueOf(value));
    }

    @Override
    public void addLong(int object, int tprop, long value) {
        this.addLong(object, tprop, -1, value);
    }

    @Override
    public void addLong(int object, int tprop, int index, long value) {
        this.addString(object, tprop, index, String.valueOf(value));
    }

    @Override
    public void addDateTime(int object, int tprop, Date value) {
        this.addDateTime(object, tprop, -1, value);
    }

    @Override
    public void addDateTime(int object, int tprop, int index, Date value) {
        this.addString(object, tprop, index, DateHelper.format(value));
    }

    @Override
    public void addBoolean(int object, int tprop, boolean value) {
        this.addBoolean(object, tprop, -1, value);
    }

    @Override
    public void addBoolean(int object, int tprop, int index, boolean value) {
        this.addString(object, tprop, index, String.valueOf(value));
    }

    @Override
    public void addString(int object, int tprop, File file, String encoding) {
        this.addString(object, tprop, -1, file, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addString(int object, int tprop, int index, File file, String encoding) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            try {
                this.addString(object, tprop, index, reader);
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addString(int object, int tprop, Reader reader) {
        this.addString(object, tprop, -1, reader);
    }

    @Override
    public void addString(int object, int tprop, int index, Reader reader) {
        try {
            int read;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[10000];
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
            }
            this.addString(object, tprop, index, sb.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addBinary(int object, int tprop, File file) {
        this.addBinary(object, tprop, -1, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBinary(int object, int tprop, int index, File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            try {
                this.addBinary(object, tprop, index, in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addBinary(int object, int tprop, InputStream in) {
        this.addBinary(object, tprop, -1, in);
    }

    @Override
    public void addBinary(int object, int tprop, int index, InputStream in) {
        try {
            int read;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[10000];
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            this.addBinary(object, tprop, index, out.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

