/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import java.util.logging.Logger;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.RHelper;

public class TempHelper {
    private static final Logger logger = Logger.getLogger(TempHelper.class.getName());

    public static boolean makeTemporary(BoxWorker worker, int entity) {
        Entity ent = worker.entity(entity);
        if (ent != Entity.ONTOBJECT) {
            throw new IllegalArgumentException("Only objects can be temporary (" + (Object)((Object)ent) + ")");
        }
        int tempClass = worker.resolve("http://ontobox.org/#Temporary", Entity.ONTCLASS);
        if (RHelper.isInstanceOf(worker, entity, tempClass)) {
            return false;
        }
        worker.write().addObjectClass(entity, tempClass);
        return true;
    }

    public static boolean isTemporary(BoxWorker worker, int entity) {
        Entity ent = worker.entity(entity);
        if (ent != Entity.ONTOBJECT) {
            return false;
        }
        Integer tempClass = worker.resolve("http://ontobox.org/#Temporary", Entity.ONTCLASS);
        return RHelper.isInstanceOf(worker, entity, tempClass);
    }

    public static synchronized void cleanUp(BoxWorker worker) {
        Integer tempClass = worker.resolve("http://ontobox.org/#Temporary", Entity.ONTCLASS);
        int[] objects = worker.objects(tempClass);
        int removed = 0;
        for (int object : objects) {
            if (worker.owners(object).length != 0) continue;
            worker.write().delete(object);
            ++removed;
        }
        logger.info(removed + " temporary objects removed");
    }
}

