/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.Values;
import org.ontobox.box.helper.impl.DirectOValues;
import org.ontobox.box.helper.impl.DirectTValues;
import org.ontobox.box.helper.impl.InverseOValues;

public final class VMap
implements Map<String, Values> {
    private final BoxWorker worker;
    private final int objectId;

    public VMap(BoxWorker worker, int objectId) {
        this.worker = worker;
        this.objectId = objectId;
    }

    public VMap(BoxWorker worker, String objectName) {
        this(worker, worker.resolve(objectName, Entity.ONTOBJECT));
    }

    public int id() {
        return this.objectId;
    }

    public String name() {
        return this.worker.name(this.objectId);
    }

    @Override
    public int size() {
        return this.worker.tprops(this.objectId).length + this.worker.oprops(this.objectId).length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        String name = (String)key;
        Entity entity = this.worker.entity(name);
        if (entity == null) {
            return MapHelper.isTkey(this.worker, this.objectId, name) || MapHelper.isOkey(this.worker, this.objectId, name);
        }
        int id = this.worker.id(name);
        if (entity == Entity.TPROPERTY && RHelper.contains(this.worker.tprops(this.objectId), id)) {
            return true;
        }
        return entity == Entity.OPROPERTY && RHelper.contains(this.worker.oprops(this.objectId), id);
    }

    @Override
    public Values get(Object key) {
        String name = (String)key;
        Entity entity = this.worker.entity(name);
        if (entity == null) {
            if (MapHelper.isTkey(this.worker, this.objectId, name)) {
                return new DirectTValues(this.worker, this.objectId, MapHelper.tkey(this.worker, this.objectId, name));
            }
            if (MapHelper.isOkey(this.worker, this.objectId, name)) {
                return new DirectOValues(this.worker, this.objectId, MapHelper.okey(this.worker, this.objectId, name));
            }
            return null;
        }
        int id = this.worker.id(name);
        if (entity == Entity.TPROPERTY && RHelper.contains(this.worker.tprops(this.objectId), id)) {
            return new DirectTValues(this.worker, this.objectId, id);
        }
        if (entity == Entity.OPROPERTY && RHelper.contains(this.worker.oprops(this.objectId), id)) {
            return new DirectOValues(this.worker, this.objectId, id);
        }
        return null;
    }

    public Values inverse(String name) {
        Entity entity = this.worker.entity(name);
        if (entity == null) {
            if (MapHelper.isTkey(this.worker, this.objectId, name)) {
                throw new IllegalArgumentException("Only OProperties and OKeys are supported (" + name + ")");
            }
            if (MapHelper.isOkey(this.worker, this.objectId, name)) {
                return new InverseOValues(this.worker, this.objectId, MapHelper.okey(this.worker, this.objectId, name));
            }
            return null;
        }
        int id = this.worker.id(name);
        if (entity == Entity.TPROPERTY) {
            throw new IllegalArgumentException("Only OProperties and OKeys are supported (" + name + ")");
        }
        if (entity == Entity.OPROPERTY && RHelper.contains(this.worker.oprops(this.objectId), id)) {
            return new InverseOValues(this.worker, this.objectId, id);
        }
        return null;
    }

    @Override
    public Set<String> keySet() {
        String mname;
        HashSet<String> ret = new HashSet<String>();
        for (int prop : this.worker.tprops(this.objectId)) {
            mname = MapHelper.name(this.worker, prop);
            if (mname != null) {
                ret.add(mname);
                continue;
            }
            ret.add(this.worker.name(prop));
        }
        for (int prop : this.worker.oprops(this.objectId)) {
            mname = MapHelper.name(this.worker, prop);
            if (mname != null) {
                ret.add(mname);
                continue;
            }
            ret.add(this.worker.name(prop));
        }
        return ret;
    }

    @Override
    public Collection<Values> values() {
        ArrayList<Values> ret = new ArrayList<Values>();
        for (int prop : this.worker.tprops(this.objectId)) {
            ret.add(new DirectTValues(this.worker, this.objectId, prop));
        }
        for (int prop : this.worker.oprops(this.objectId)) {
            ret.add(new DirectOValues(this.worker, this.objectId, prop));
        }
        return ret;
    }

    @Override
    public Set<Map.Entry<String, Values>> entrySet() {
        HashSet<Map.Entry<String, Values>> ret = new HashSet<Map.Entry<String, Values>>();
        for (final int prop : this.worker.tprops(this.objectId)) {
            ret.add(new Map.Entry<String, Values>(){

                @Override
                public String getKey() {
                    String mname = MapHelper.name(VMap.this.worker, prop);
                    if (mname != null) {
                        return mname;
                    }
                    return VMap.this.worker.name(prop);
                }

                @Override
                public Values getValue() {
                    return new DirectTValues(VMap.this.worker, VMap.this.objectId, prop);
                }

                @Override
                public Values setValue(Values value) {
                    throw new UnsupportedOperationException("The entry is read-only");
                }
            });
        }
        for (final int prop : this.worker.oprops(this.objectId)) {
            ret.add(new Map.Entry<String, Values>(){

                @Override
                public String getKey() {
                    String mname = MapHelper.name(VMap.this.worker, prop);
                    if (mname != null) {
                        return mname;
                    }
                    return VMap.this.worker.name(prop);
                }

                @Override
                public Values getValue() {
                    return new DirectOValues(VMap.this.worker, VMap.this.objectId, prop);
                }

                @Override
                public Values setValue(Values value) {
                    throw new UnsupportedOperationException("The entry is read-only");
                }
            });
        }
        return ret;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Too slow operation");
    }

    @Override
    public Values put(String key, Values value) {
        throw new UnsupportedOperationException("The map is read-only");
    }

    @Override
    public Values remove(Object key) {
        throw new UnsupportedOperationException("The map is read-only");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Values> m) {
        throw new UnsupportedOperationException("The map is read-only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("The map is read-only");
    }

    public VMap mMap(String key) {
        return this.get(key).map();
    }

    public List<VMap> mMaps(String key) {
        return this.get(key).maps();
    }

    public int mSize(String key) {
        return this.get(key).size();
    }

    public boolean isObject(String key) {
        return this.get(key).isObject();
    }

    public String mString(String key) {
        return this.get(key).string();
    }

    public List<String> mStrings(String key) {
        return this.get(key).strings();
    }

    public Integer mInteger(String key) {
        return this.get(key).integer();
    }

    public List<Integer> mIntegers(String key) {
        return this.get(key).integers();
    }

    public Long mLong(String key) {
        return this.get(key).longV();
    }

    public List<Long> mLongs(String key) {
        return this.get(key).longs();
    }

    public Date mDateTime(String key) {
        return this.get(key).dateTime();
    }

    public List<Date> mDateTimes(String key) {
        return this.get(key).dateTimes();
    }

    public boolean mBoolean(String key) {
        return this.get(key).booleanV();
    }

    public List<Boolean> mBooleans(String key) {
        return this.get(key).booleans();
    }
}

