/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import java.util.Date;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;

public class WHelper {
    public static ClassAddition ontclass(BoxWorker worker, String className) {
        int cl = worker.entity(className) == Entity.ONTCLASS ? worker.resolve(className) : worker.write().newClass(className);
        return new ClassAddition(worker, cl);
    }

    public static ObjectAddition object(BoxWorker worker, int ont, String className) {
        BoxWriter writer = worker.write();
        int obj = writer.newObject(writer.newName(ont));
        writer.addObjectClass(obj, worker.resolve(className));
        return new ObjectAddition(worker, obj);
    }

    public static ObjectAddition object(BoxWorker worker, String name, String className) {
        BoxWriter writer = worker.write();
        int obj = writer.newObject(name);
        writer.addObjectClass(obj, worker.resolve(className));
        return new ObjectAddition(worker, obj);
    }

    public static ObjectAddition object(BoxWorker worker, int object) {
        return new ObjectAddition(worker, object);
    }

    public static class ObjectAddition {
        protected final BoxWorker worker;
        protected final int object;

        public ObjectAddition(BoxWorker worker, int object) {
            this.worker = worker;
            this.object = object;
        }

        public ObjectAddition addString(String prop, String val) {
            if (val != null) {
                this.worker.write().addString(this.object, this.worker.resolve(prop), val);
            }
            return this;
        }

        public ObjectAddition addInt(String tprop, Integer value) {
            if (value != null) {
                this.worker.write().addInt(this.object, this.worker.resolve(tprop), value);
            }
            return this;
        }

        public ObjectAddition addLong(String tprop, Long value) {
            if (value != null) {
                this.worker.write().addLong(this.object, this.worker.resolve(tprop), value);
            }
            return this;
        }

        public ObjectAddition addDateTime(String prop, Date date) {
            if (date != null) {
                this.worker.write().addDateTime(this.object, this.worker.resolve(prop), date);
            }
            return this;
        }

        public ObjectAddition addObject(String prop, String val) {
            if (val != null) {
                return this.addObject(prop, this.worker.resolve(val));
            }
            return this;
        }

        public ObjectAddition addObject(String prop, Integer val) {
            if (val != null) {
                this.worker.write().addObject(this.object, this.worker.resolve(prop), val);
            }
            return this;
        }

        public ObjectAddition setObjectCascade(String oprop, Integer value) {
            int op = this.worker.resolve(oprop);
            int[] values = this.worker.objects(this.object, op);
            this.setObject(oprop, value);
            BoxWriter writer = this.worker.write();
            for (int v : values) {
                writer.delete(v);
            }
            return this;
        }

        public ObjectAddition setObject(String oprop, Integer value) {
            int op = this.worker.resolve(oprop);
            BoxWriter writer = this.worker.write();
            writer.removeValues(this.object, op);
            if (value != null) {
                writer.addObject(this.object, op, value);
            }
            return this;
        }

        public ObjectAddition setInt(String oprop, Integer value) {
            int op = this.worker.resolve(oprop);
            BoxWriter writer = this.worker.write();
            writer.removeValues(this.object, op);
            if (value != null) {
                writer.addInt(this.object, op, value);
            }
            return this;
        }

        public ObjectAddition setBoolean(String oprop, Boolean bool) {
            int op = this.worker.resolve(oprop);
            BoxWriter writer = this.worker.write();
            writer.removeValues(this.object, op);
            if (bool != null) {
                writer.addBoolean(this.object, op, bool);
            }
            return this;
        }

        public ObjectAddition setString(String oprop, String value) {
            int op = this.worker.resolve(oprop);
            BoxWriter writer = this.worker.write();
            writer.removeValues(this.object, op);
            if (value != null) {
                writer.addString(this.object, op, value);
            }
            return this;
        }

        public ObjectAddition setDateTime(String oprop, Date date) {
            int op = this.worker.resolve(oprop);
            BoxWriter writer = this.worker.write();
            writer.removeValues(this.object, op);
            if (date != null) {
                writer.addDateTime(this.object, op, date);
            }
            return this;
        }

        public String name() {
            return this.worker.name(this.object);
        }

        public int id() {
            return this.object;
        }
    }

    public static class ClassAddition {
        protected final BoxWorker worker;
        protected final int cl;

        private ClassAddition(BoxWorker worker, int cl) {
            this.worker = worker;
            this.cl = cl;
        }

        public ClassAddition tprop(String name, Integer maxCard) {
            return this.tprop(name, null, maxCard);
        }

        public ClassAddition tprop(String name, String range, Integer maxCard) {
            BoxWriter writer = this.worker.write();
            int propId = writer.newTProperty(name);
            writer.setDomain(propId, this.cl);
            if (range != null) {
                writer.setRange(propId, this.worker.resolve(range));
            }
            if (maxCard != null) {
                writer.annotate(propId, "http://ontobox.org/#maxcard", String.valueOf(maxCard));
            }
            return this;
        }

        public ClassAddition tpropDmapString(String name, Integer maxCard) {
            return this.tprop(name, "http://ontobox.org/#dmapString", maxCard);
        }

        public ClassAddition tpropDmapBinary(String name, Integer maxCard) {
            return this.tprop(name, "http://ontobox.org/#dmapBinary", maxCard);
        }

        public ClassAddition oprop(String name, String range, Integer maxCard) {
            BoxWriter writer = this.worker.write();
            int propId = writer.newOProperty(name);
            writer.setDomain(propId, this.cl);
            if (range != null) {
                writer.setRange(propId, this.worker.resolve(range));
            }
            if (maxCard != null) {
                writer.annotate(propId, "http://ontobox.org/#maxcard", String.valueOf(maxCard));
            }
            return this;
        }

        public ClassAddition subclassof(String name) {
            BoxWriter writer = this.worker.write();
            writer.addSubclass(this.worker.resolve(name), this.cl);
            return this;
        }

        public ClassAddition anno(String name, String value) {
            this.worker.write().annotate(this.cl, name, value);
            return this;
        }
    }
}

