/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.helper;

import com.teacode.web.HTMLHelper;
import com.teacode.web.NamedCharReferences;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagNode;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.Searcher;
import org.ontobox.box.helper.WHelper;
import org.ontobox.box.query.QContext;
import org.ontobox.box.query.Query;
import org.ontobox.exchange.MVX;
import org.ontobox.libretto.Handler;
import org.ontobox.storage.StorageBox;

public class XMLHelper {
    private static Logger logger = Logger.getLogger(XMLHelper.class.getName());
    public static final String XML_URI = "http://xml.ontobox.org/";
    public static final String NODE_CLASS = "http://xml.ontobox.org/#Node";
    public static final String NAMESPACE_CLASS = "http://xml.ontobox.org/#Namespace";
    public static final String NAMESPACE_PREFIX = "http://xml.ontobox.org/#prefix";
    public static final String NAMESPACE_URI = "http://xml.ontobox.org/#uri";
    public static final String NAMED_CLASS = "http://xml.ontobox.org/#Named";
    public static final String NAMED_NAME = "http://xml.ontobox.org/#name";
    public static final String NAMED_NAMESPACE = "http://xml.ontobox.org/#ns";
    public static final String CONTAINER_CLASS = "http://xml.ontobox.org/#Container";
    public static final String CONTAINER_CONTENT = "http://xml.ontobox.org/#content";
    public static final String ELEMENT_CLASS = "http://xml.ontobox.org/#Element";
    public static final String ELEMENT_ATTRIBUTES = "http://xml.ontobox.org/#attributes";
    public static final String ATTRIBUTE_CLASS = "http://xml.ontobox.org/#Attribute";
    public static final String ATTRIBUTE_VALUE = "http://xml.ontobox.org/#value";
    public static final String COMMENT_CLASS = "http://xml.ontobox.org/#Comment";
    public static final String COMMENT_COMMENT = "http://xml.ontobox.org/#comment";
    public static final String TEXT_CLASS = "http://xml.ontobox.org/#Text";
    public static final String TEXT_TEXT = "http://xml.ontobox.org/#text";
    public static final String CDATA_CLASS = "http://xml.ontobox.org/#CDATA";
    public static final String DOCUMENT_CLASS = "http://xml.ontobox.org/#Document";
    public static final String DOCUMENT_ROOT = "http://xml.ontobox.org/#root";
    protected static Set<String> selfClosingHTMLTags = new HashSet<String>(Arrays.asList("area", "base", "basefont", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr", "frame", "isindex"));
    protected static Set<String> noEscapingTags = new HashSet<String>(Arrays.asList("script"));

    public static void create(BoxWorker worker) {
        BoxWriter writer = worker.write();
        String title = "http://ln.ontobox.org/#title";
        writer.newOntology(XML_URI);
        WHelper.ontclass(worker, NODE_CLASS);
        WHelper.ontclass(worker, NAMESPACE_CLASS).tprop(NAMESPACE_PREFIX, "http://ontobox.org/#string", 1).tprop(NAMESPACE_URI, "http://ontobox.org/#string", 1).anno("http://ln.ontobox.org/#title", "prefix . \"http://xml.ontobox.org/\";\n$o=?;\n(\"Namespace: \"+$o/:prefix, $o/uri);");
        WHelper.ontclass(worker, NAMED_CLASS).tprop(NAMED_NAME, "http://ontobox.org/#string", 1).oprop(NAMED_NAMESPACE, NAMESPACE_CLASS, 1);
        WHelper.ontclass(worker, CONTAINER_CLASS).oprop(CONTAINER_CONTENT, NODE_CLASS, null);
        WHelper.ontclass(worker, ATTRIBUTE_CLASS).subclassof(NAMED_CLASS).tprop(ATTRIBUTE_VALUE, "http://ontobox.org/#string", 1).anno("http://ln.ontobox.org/#title", "prefix . \"http://xml.ontobox.org/\";\n$o=?;\n$p=$o/ns/:prefix;\n$n=if ($p) $p+\":\"+$o/name else $o/name;\n(\"Attr: \"+$n, $o/value);");
        WHelper.ontclass(worker, ELEMENT_CLASS).subclassof(NODE_CLASS).subclassof(NAMED_CLASS).subclassof(CONTAINER_CLASS).oprop(ELEMENT_ATTRIBUTES, ATTRIBUTE_CLASS, null).anno("http://ln.ontobox.org/#title", "prefix . \"http://xml.ontobox.org/\";\n$o=?;\n$p=$o/ns/:prefix; \n$n=if ($p) $p+\":\"+$o/name else $o/name;\n$attrs=$o/attributes/{$p=ns/:prefix; \" \"+(if ($p) $p+\":\"+name else name)+'=\"'+esc(value)+'\"'}/v:join();\n$attrs=if ($attrs) $attrs else \"\";\n$i=\"<\"+$n+$attrs+\">\";\n(\"Element: \"+$n, $i);");
        WHelper.ontclass(worker, COMMENT_CLASS).subclassof(NODE_CLASS).tprop(COMMENT_COMMENT, "http://ontobox.org/#string", 1).anno("http://ln.ontobox.org/#title", "prefix . \"http://xml.ontobox.org/\";\n$n=?/comment;\n(\"Comment: \"+$n, $n);");
        WHelper.ontclass(worker, TEXT_CLASS).subclassof(NODE_CLASS).tprop(TEXT_TEXT, "http://ontobox.org/#string", 1).anno("http://ln.ontobox.org/#title", "prefix . \"http://xml.ontobox.org/\";\n$n=?/text;\n(\"Text: \"+$n, $n);");
        WHelper.ontclass(worker, CDATA_CLASS).subclassof(TEXT_CLASS);
        WHelper.ontclass(worker, DOCUMENT_CLASS).subclassof(CONTAINER_CLASS).oprop(DOCUMENT_ROOT, ELEMENT_CLASS, 1).anno("http://ln.ontobox.org/#title", "prefix . \"http://xml.ontobox.org/\";\n$n=?/root/name;\n(\"Document: \"+$n, $n);");
    }

    protected static void assertRequired(BoxWorker worker) {
        if (worker.entity(XML_URI) != Entity.ONTOLOGY) {
            throw new IllegalStateException("http://xml.ontobox.org/ must be required to work with XML");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int importXML(BoxWorker worker, int ontology, File xmlFile) {
        int n;
        XMLHelper.assertRequired(worker);
        FileInputStream in = new FileInputStream(xmlFile);
        try {
            n = XMLHelper.importXML(worker, ontology, in);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)in).close();
        return n;
    }

    public static int importXML(BoxWorker worker, int ontology, InputStream in) {
        XMLStreamReader parser;
        XMLHelper.assertRequired(worker);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            parser = factory.createXMLStreamReader(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            return XMLHelper.parse(worker, ontology, parser);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString() + "\n" + XMLHelper.getPosition(parser), e);
        }
    }

    private static String getPosition(XMLStreamReader parser) {
        Location location = parser.getLocation();
        if (location == null) {
            return "<unknown location>";
        }
        return "Line: " + location.getLineNumber() + ", column: " + location.getColumnNumber();
    }

    private static int parse(BoxWorker worker, int ontology, XMLStreamReader parser) throws XMLStreamException {
        BoxWriter writer = worker.write();
        int doc = writer.newObject(writer.newName(ontology));
        writer.addObjectClass(doc, worker.resolve(DOCUMENT_CLASS, Entity.ONTCLASS));
        block5: while (true) {
            int next = parser.next();
            switch (next) {
                case 1: {
                    int el = XMLHelper.parseElement(worker, ontology, parser);
                    writer.addObject(doc, worker.resolve(DOCUMENT_ROOT, Entity.OPROPERTY), el);
                    writer.addObject(doc, worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY), el);
                    continue block5;
                }
                case 5: {
                    int comment = XMLHelper.parseComment(worker, ontology, parser);
                    writer.addObject(doc, worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY), comment);
                    continue block5;
                }
                case 8: {
                    return doc;
                }
            }
            logger.warning("Skipped state: " + next);
        }
    }

    private static int parseComment(BoxWorker worker, int ontology, XMLStreamReader parser) throws XMLStreamException {
        BoxWriter writer = worker.write();
        int ret = writer.newObject(writer.newName(ontology));
        writer.addObjectClass(ret, worker.resolve(COMMENT_CLASS, Entity.ONTCLASS));
        writer.addString(ret, worker.resolve(COMMENT_COMMENT, Entity.TPROPERTY), parser.getText());
        return ret;
    }

    private static int parseText(BoxWorker worker, int ontology, XMLStreamReader parser) throws XMLStreamException {
        BoxWriter writer = worker.write();
        int ret = writer.newObject(writer.newName(ontology));
        writer.addObjectClass(ret, worker.resolve(TEXT_CLASS, Entity.ONTCLASS));
        writer.addString(ret, worker.resolve(TEXT_TEXT, Entity.TPROPERTY), parser.getText());
        return ret;
    }

    private static int getNameSpace(BoxWorker worker, int ontology, String prefix, String uri) {
        Integer ns = Searcher.findByString(worker, NAMESPACE_PREFIX, prefix).andByString(NAMESPACE_URI, uri).single();
        if (ns == null) {
            BoxWriter writer = worker.write();
            ns = writer.newObject(writer.newName(ontology));
            writer.addObjectClass(ns, worker.resolve(NAMESPACE_CLASS, Entity.ONTCLASS));
            writer.addString((int)ns, worker.resolve(NAMESPACE_PREFIX, Entity.TPROPERTY), prefix);
            writer.addString((int)ns, worker.resolve(NAMESPACE_URI, Entity.TPROPERTY), uri);
        }
        return ns;
    }

    private static int parseElement(BoxWorker worker, int ontology, XMLStreamReader parser) throws XMLStreamException {
        int next;
        BoxWriter writer = worker.write();
        int el = writer.newObject(writer.newName(ontology));
        writer.addObjectClass(el, worker.resolve(ELEMENT_CLASS, Entity.ONTCLASS));
        String name = parser.getLocalName();
        String prefix = parser.getPrefix();
        String uri = parser.getNamespaceURI();
        writer.addString(el, worker.resolve(NAMED_NAME, Entity.TPROPERTY), name);
        if (prefix != null && uri != null) {
            writer.addObject(el, worker.resolve(NAMED_NAMESPACE, Entity.OPROPERTY), XMLHelper.getNameSpace(worker, ontology, prefix, uri));
        }
        int count = parser.getAttributeCount();
        for (int t = 0; t < count; ++t) {
            int attr = writer.newObject(writer.newName(ontology));
            writer.addObjectClass(attr, worker.resolve(ATTRIBUTE_CLASS, Entity.ONTCLASS));
            writer.addString(attr, worker.resolve(NAMED_NAME, Entity.TPROPERTY), parser.getAttributeLocalName(t));
            writer.addString(attr, worker.resolve(ATTRIBUTE_VALUE, Entity.TPROPERTY), parser.getAttributeValue(t));
            String attrPrefix = parser.getAttributePrefix(t);
            String attrUri = parser.getAttributeNamespace(t);
            if (attrPrefix != null && attrUri != null) {
                writer.addObject(attr, worker.resolve(NAMED_NAMESPACE, Entity.OPROPERTY), XMLHelper.getNameSpace(worker, ontology, attrPrefix, attrUri));
            }
            writer.addObject(el, worker.resolve(ELEMENT_ATTRIBUTES, Entity.OPROPERTY), attr);
        }
        block8: while (true) {
            next = parser.next();
            switch (next) {
                case 1: {
                    int e = XMLHelper.parseElement(worker, ontology, parser);
                    writer.addObject(el, worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY), e);
                    continue block8;
                }
                case 5: {
                    int comment = XMLHelper.parseComment(worker, ontology, parser);
                    writer.addObject(el, worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY), comment);
                    continue block8;
                }
                case 4: {
                    int text = XMLHelper.parseText(worker, ontology, parser);
                    writer.addObject(el, worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY), text);
                    continue block8;
                }
                case 2: {
                    if (!parser.getLocalName().equals(name)) {
                        throw new IllegalStateException("Missing expected end tag " + name);
                    }
                    return el;
                }
                case 8: {
                    throw new IllegalStateException("Missing expected end tag " + name);
                }
            }
            break;
        }
        throw new RuntimeException("Illegal state: " + next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportXML(BoxWorker worker, File file, int docObject) {
        try {
            FileOutputStream out = new FileOutputStream(file);
            try {
                XMLHelper.exportXML(worker, out, docObject);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void exportXML(BoxWorker worker, OutputStream out, int docObject) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
            XMLHelper.exportXML(worker, writer, docObject);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void exportXML(BoxWorker worker, Writer writer, int docObject) {
        block4: {
            try {
                if (XMLHelper.isXML(worker, docObject)) {
                    XMLHelper.writeContainer(worker, writer, docObject, true, true);
                    break block4;
                }
                if (XMLHelper.isElement(worker, docObject)) {
                    XMLHelper.writeNode(worker, writer, docObject, true, true);
                    break block4;
                }
                throw new RuntimeException("Unsupported object: " + worker.name(docObject));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void exportHTML(BoxWorker worker, Writer writer, int docObject) {
        block4: {
            try {
                if (XMLHelper.isXML(worker, docObject)) {
                    XMLHelper.writeContainer(worker, writer, docObject, false, true);
                    break block4;
                }
                if (XMLHelper.isElement(worker, docObject)) {
                    XMLHelper.writeNode(worker, writer, docObject, false, true);
                    break block4;
                }
                throw new RuntimeException("Unsupported object: " + worker.name(docObject));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void writeNode(BoxWorker worker, Writer writer, int c, boolean xmlMode, boolean escapeText) throws IOException {
        String s;
        HashMap<String, String> xmlns = new HashMap<String, String>();
        int containerProp = worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY);
        int elementClass = worker.resolve(ELEMENT_CLASS, Entity.ONTCLASS);
        int commentClass = worker.resolve(COMMENT_CLASS, Entity.ONTCLASS);
        int textClass = worker.resolve(TEXT_CLASS, Entity.ONTCLASS);
        if (RHelper.isInstanceOf(worker, c, elementClass)) {
            String elName = RHelper.stringValue(worker, c, NAMED_NAME);
            if (elName != null) {
                int[] attrs;
                xmlns.clear();
                writer.write("<");
                Integer ns = RHelper.objectValue(worker, c, NAMED_NAMESPACE);
                if (ns != null) {
                    String prefix = RHelper.stringValue(worker, (int)ns, NAMESPACE_PREFIX);
                    String uri = RHelper.stringValue(worker, (int)ns, NAMESPACE_URI);
                    if (prefix != null) {
                        xmlns.put(prefix, uri);
                        if (!prefix.isEmpty()) {
                            elName = prefix + ":" + elName;
                        }
                    }
                }
                writer.write(elName);
                for (int attr : attrs = worker.objects(c, worker.resolve(ELEMENT_ATTRIBUTES, Entity.OPROPERTY))) {
                    String an = RHelper.stringValue(worker, attr, NAMED_NAME);
                    Integer ans = RHelper.objectValue(worker, attr, NAMED_NAMESPACE);
                    String av = RHelper.stringValue(worker, attr, ATTRIBUTE_VALUE);
                    if (ans != null) {
                        String prefix = RHelper.stringValue(worker, (int)ans, NAMESPACE_PREFIX);
                        String uri = RHelper.stringValue(worker, (int)ans, NAMESPACE_URI);
                        if (prefix != null) {
                            xmlns.put(prefix, uri);
                            if (!prefix.isEmpty()) {
                                an = prefix + ":" + an;
                            }
                        }
                    }
                    writer.write(32);
                    writer.write(an);
                    writer.write("=\"");
                    writer.write(HTMLHelper.escape((String)av));
                    writer.write("\"");
                }
                for (Map.Entry entry : xmlns.entrySet()) {
                    writer.write(" xmlns");
                    String p = (String)entry.getKey();
                    String u = (String)entry.getValue();
                    if (!p.isEmpty()) {
                        writer.write(":");
                        writer.write(p);
                    }
                    writer.write("=\"");
                    writer.write(HTMLHelper.escape((String)u));
                    writer.write("\"");
                }
                if (worker.objects(c, containerProp).length > 0) {
                    writer.write(">");
                    boolean esc = escapeText;
                    if (!xmlMode && noEscapingTags.contains(elName.toLowerCase())) {
                        esc = false;
                    }
                    XMLHelper.writeContainer(worker, writer, c, xmlMode, esc);
                    writer.write("</");
                    writer.write(elName);
                    writer.write(">");
                } else if (xmlMode) {
                    writer.write("/>");
                } else {
                    writer.write(">");
                    if (!selfClosingHTMLTags.contains(elName.toLowerCase())) {
                        writer.write("</");
                        writer.write(elName);
                        writer.write(">");
                    }
                }
            }
        } else if (RHelper.isInstanceOf(worker, c, commentClass)) {
            writer.write("<!--");
            String s2 = RHelper.stringValue(worker, c, COMMENT_COMMENT);
            if (s2 != null) {
                writer.write(HTMLHelper.escapeLight((String)s2));
            }
            writer.write("-->");
        } else if (RHelper.isInstanceOf(worker, c, textClass) && (s = RHelper.stringValue(worker, c, TEXT_TEXT)) != null) {
            if (escapeText) {
                writer.write(HTMLHelper.escapeLight((String)s));
            } else {
                writer.write(s);
            }
        }
    }

    private static void writeContainer(BoxWorker worker, Writer writer, int container, boolean xmlMode, boolean escapeText) throws IOException {
        int containerProp = worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY);
        for (int c : worker.objects(container, containerProp)) {
            XMLHelper.writeNode(worker, writer, c, xmlMode, escapeText);
        }
    }

    public static boolean isXML(BoxWorker worker, int object) {
        Entity docCl = worker.entity(DOCUMENT_CLASS);
        return docCl == Entity.ONTCLASS && RHelper.isInstanceOf(worker, object, worker.id(DOCUMENT_CLASS));
    }

    public static boolean isElement(BoxWorker worker, int object) {
        Entity docCl = worker.entity(ELEMENT_CLASS);
        return docCl == Entity.ONTCLASS && RHelper.isInstanceOf(worker, object, worker.id(ELEMENT_CLASS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int importHTML(BoxWorker worker, int ontology, File file, String charset) {
        int n;
        XMLHelper.assertRequired(worker);
        FileInputStream in = new FileInputStream(file);
        try {
            n = XMLHelper.importHTML(worker, ontology, in, charset);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)in).close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int importHTML(BoxWorker worker, int ontology, InputStream in, String charset) {
        int n;
        XMLHelper.assertRequired(worker);
        InputStreamReader reader = new InputStreamReader(in, charset);
        try {
            n = XMLHelper.importHTML(worker, ontology, reader);
        }
        catch (Throwable throwable) {
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        ((Reader)reader).close();
        return n;
    }

    public static int importHTML(BoxWorker worker, int ontology, Reader reader) {
        XMLHelper.assertRequired(worker);
        HtmlCleaner cleaner = new HtmlCleaner();
        CleanerProperties props = cleaner.getProperties();
        props.setNamespacesAware(false);
        props.setIgnoreQuestAndExclam(true);
        try {
            TagNode node = cleaner.clean(reader);
            BoxWriter writer = worker.write();
            int doc = writer.newObject(writer.newName(ontology));
            writer.addObjectClass(doc, worker.resolve(DOCUMENT_CLASS, Entity.ONTCLASS));
            int root = XMLHelper.convertTagNode(worker, ontology, doc, node);
            writer.addObject(doc, worker.resolve(DOCUMENT_ROOT, Entity.OPROPERTY), root);
            return doc;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String unesc(String text) {
        return HTMLHelper.unescape((String)NamedCharReferences.process((String)text));
    }

    private static int convertTagNode(BoxWorker worker, int ontology, int container, TagNode tagNode) {
        BoxWriter writer = worker.write();
        int el = writer.newObject(writer.newName(ontology));
        writer.addObjectClass(el, worker.resolve(ELEMENT_CLASS, Entity.ONTCLASS));
        String name = tagNode.getName();
        writer.addString(el, worker.resolve(NAMED_NAME, Entity.TPROPERTY), name);
        writer.addObject(container, worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY), el);
        for (Object o : tagNode.getAttributes().keySet()) {
            String s = (String)o;
            String v = XMLHelper.unesc(tagNode.getAttributeByName(s));
            int attr = writer.newObject(writer.newName(ontology));
            writer.addObjectClass(attr, worker.resolve(ATTRIBUTE_CLASS, Entity.ONTCLASS));
            writer.addString(attr, worker.resolve(NAMED_NAME, Entity.TPROPERTY), s);
            writer.addString(attr, worker.resolve(ATTRIBUTE_VALUE, Entity.TPROPERTY), v);
            writer.addObject(el, worker.resolve(ELEMENT_ATTRIBUTES, Entity.OPROPERTY), attr);
        }
        for (Object o : tagNode.getChildren()) {
            ContentToken ct;
            if (o instanceof TagNode) {
                XMLHelper.convertTagNode(worker, ontology, el, (TagNode)o);
                continue;
            }
            if (o instanceof ContentToken) {
                ct = (ContentToken)o;
                int textObj = writer.newObject(writer.newName(ontology));
                writer.addObjectClass(textObj, worker.resolve(TEXT_CLASS, Entity.ONTCLASS));
                writer.addString(textObj, worker.resolve(TEXT_TEXT, Entity.TPROPERTY), XMLHelper.unesc(ct.getContent()));
                writer.addObject(el, worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY), textObj);
                continue;
            }
            if (!(o instanceof CommentToken)) continue;
            ct = (CommentToken)o;
            int comment = writer.newObject(writer.newName(ontology));
            writer.addObjectClass(comment, worker.resolve(COMMENT_CLASS, Entity.ONTCLASS));
            writer.addString(comment, worker.resolve(COMMENT_COMMENT, Entity.TPROPERTY), ct.getContent());
            writer.addObject(el, worker.resolve(CONTAINER_CONTENT, Entity.OPROPERTY), comment);
        }
        return el;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws XMLStreamException, IOException {
        StorageBox box = new StorageBox();
        try {
            BoxWorker worker = box.work();
            try {
                int ont = worker.write().newOntology("http://xml-test/");
                int doc = XMLHelper.importXML(worker, ont, new File("xml/test.xml"));
                StringWriter sw = new StringWriter();
                XMLHelper.exportXML(worker, sw, doc);
                XMLHelper.exportXML(worker, new File("xml/out.xml"), doc);
                new Handler().box2libretto(worker, new PrintWriter(System.out));
                ont = worker.write().newOntology("http://html-test/");
                doc = XMLHelper.importHTML(worker, ont, new File("xml/index.html"), "UTF-8");
                sw = new StringWriter();
                XMLHelper.exportXML(worker, sw, doc);
                System.out.println(sw.toString());
                XMLHelper.exportXML(worker, new File("xml/out.xhtml"), doc);
                MVX.exportFile(new File("xml/xml.mvx"), worker);
                String x = "<root>\u0430\u0431\u0432</root>";
                doc = XMLHelper.importXML(worker, ont, new ByteArrayInputStream(x.getBytes("UTF-8")));
                QContext ctx = new QContext();
                ctx.setPrefix("x", XML_URI);
                Query q = ctx.createQuery("?/x:root/x:content/x:text");
                q.setObject(0, doc);
                System.out.println(worker.qString(ctx, q));
                sw = new StringWriter();
                XMLHelper.exportXML(worker, sw, doc);
                System.out.println(sw.toString());
            }
            finally {
                worker.close();
            }
        }
        finally {
            box.close();
        }
    }
}

