/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box.query;

import java.util.AbstractList;
import java.util.Date;
import java.util.List;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.DateHelper;
import org.ontobox.box.helper.VMap;
import org.ontobox.box.helper.Values;
import org.ontobox.libretto.ChoicePoint;
import org.ontobox.libretto.adapter.EntityId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;

public class QueryValues
implements Values {
    private final BoxWorker worker;
    private final OntCollection col;

    public QueryValues(BoxWorker worker, OntCollection col) {
        Object o;
        this.worker = worker;
        if (col == null) {
            col = OntCC.newCol();
        }
        if (!col.isEmpty() && (o = col.get(0)) instanceof ChoicePoint) {
            if (col.size() == 1) {
                col = ((ChoicePoint)o).getCollection();
            } else {
                OntCollection old = col;
                col = OntCC.newCol();
                for (Object e : old) {
                    if (e instanceof ChoicePoint) {
                        col.addAllTyped(((ChoicePoint)e).getCollection());
                        continue;
                    }
                    col.add(e);
                }
            }
        }
        this.col = col;
    }

    @Override
    public boolean isEmpty() {
        return this.col.isEmpty();
    }

    @Override
    public int size() {
        return this.col.size();
    }

    @Override
    public boolean isObject() {
        return this.col.isObjCol();
    }

    @Override
    public boolean isEntity() {
        if (this.isObject()) {
            return true;
        }
        if (this.col.isEmpty()) {
            return false;
        }
        for (Object o : this.col) {
            if (o instanceof EntityId) continue;
            return false;
        }
        return true;
    }

    @Override
    public VMap map() {
        if (this.col.isEmpty()) {
            return null;
        }
        ObjectId obj = (ObjectId)this.col.get(0);
        return new VMap(this.worker, obj.id());
    }

    @Override
    public List<VMap> maps() {
        return new AbstractList<VMap>(){

            @Override
            public VMap get(int index) {
                ObjectId obj = (ObjectId)QueryValues.this.col.get(index);
                return new VMap(QueryValues.this.worker, obj.id());
            }

            @Override
            public int size() {
                return QueryValues.this.col.size();
            }
        };
    }

    @Override
    public Integer object() {
        if (this.col.isEmpty()) {
            return null;
        }
        ObjectId obj = (ObjectId)this.col.get(0);
        return obj.id();
    }

    @Override
    public List<Integer> objects() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                ObjectId obj = (ObjectId)QueryValues.this.col.get(index);
                return obj.id();
            }

            @Override
            public int size() {
                return QueryValues.this.col.size();
            }
        };
    }

    @Override
    public Integer entity() {
        if (this.col.isEmpty()) {
            return null;
        }
        EntityId entity = (EntityId)this.col.get(0);
        return entity.id();
    }

    @Override
    public List<Integer> entities() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                EntityId obj = (EntityId)QueryValues.this.col.get(index);
                return obj.id();
            }

            @Override
            public int size() {
                return QueryValues.this.col.size();
            }
        };
    }

    private String convertToString(Object o) {
        if (o instanceof EntityId) {
            return this.worker.name(((EntityId)o).id());
        }
        try {
            return o.toString();
        }
        catch (Throwable e) {
            return e.toString();
        }
    }

    private Integer convertToInteger(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return Integer.valueOf(o.toString());
    }

    private Long convertToLong(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.valueOf(o.toString());
    }

    @Override
    public String string() {
        if (this.col.isEmpty()) {
            return null;
        }
        return this.convertToString(this.col.get(0));
    }

    @Override
    public List<String> strings() {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return QueryValues.this.convertToString(QueryValues.this.col.get(index));
            }

            @Override
            public int size() {
                return QueryValues.this.col.size();
            }
        };
    }

    @Override
    public Integer integer() {
        if (this.col.isEmpty()) {
            return null;
        }
        return this.convertToInteger(this.col.get(0));
    }

    @Override
    public List<Integer> integers() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return QueryValues.this.convertToInteger(QueryValues.this.col.get(index));
            }

            @Override
            public int size() {
                return QueryValues.this.col.size();
            }
        };
    }

    @Override
    public Long longV() {
        if (this.col.isEmpty()) {
            return null;
        }
        return this.convertToLong(this.col.get(0));
    }

    @Override
    public List<Long> longs() {
        return new AbstractList<Long>(){

            @Override
            public Long get(int index) {
                return QueryValues.this.convertToLong(QueryValues.this.col.get(index));
            }

            @Override
            public int size() {
                return QueryValues.this.col.size();
            }
        };
    }

    private Date convertToDateTime(Object o) {
        return DateHelper.parse(this.convertToString(o));
    }

    @Override
    public Date dateTime() {
        if (this.col.isEmpty()) {
            return null;
        }
        return this.convertToDateTime(this.col.get(0));
    }

    @Override
    public List<Date> dateTimes() {
        return new AbstractList<Date>(){

            @Override
            public Date get(int index) {
                return QueryValues.this.convertToDateTime(QueryValues.this.col.get(index));
            }

            @Override
            public int size() {
                return QueryValues.this.col.size();
            }
        };
    }

    @Override
    public boolean booleanV() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Boolean> booleans() {
        throw new UnsupportedOperationException();
    }
}

