/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.box64.test;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.CharObjectMap;
import org.ontobox.box64.test.DiskMapper;
import org.ontobox.box64.test.Mapper;
import org.ontobox.fast.util.Memory;

public class NameMap {
    static final String ONT = "http://ontology.ontobox.org/";
    static final String OBJ = "localobject";

    public static long testId(Mapper mapper) {
        long t1 = System.currentTimeMillis();
        for (int ont = 0; ont < 10; ++ont) {
            String ontName = ONT + ont;
            for (int obj = 0; obj < 100000; ++obj) {
                mapper.id(ontName + "#" + OBJ + obj);
            }
        }
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    public static void testChar() {
        char ch;
        CharObjectMap map = CCreator.newCharObjectMap((int)200);
        for (ch = '\u0000'; ch != '\uffff'; ch = (char)(ch + '\u0001')) {
            map.put(ch, (Object)Character.valueOf(ch));
        }
        System.out.println("SIZE: " + map.size());
        int counter = 0;
        for (ch = '\u0000'; ch != '\uffff'; ch = (char)(ch + '\u0001')) {
            if (ch != ((Character)map.get(ch)).charValue()) {
                throw new RuntimeException(String.valueOf(ch));
            }
            ++counter;
        }
        System.out.println("SIZE2:" + counter);
    }

    public static void main(String[] args) throws Exception {
        long t1 = Memory.getUsedMemory();
        DiskMapper mapper = new DiskMapper();
        for (int ont = 0; ont < 10; ++ont) {
            String ontName = ONT + ont;
            for (int obj = 0; obj < 100000; ++obj) {
                mapper.addObject(ontName, OBJ + obj);
            }
        }
        long t2 = Memory.getUsedMemory();
        long m = t2 - t1;
        System.out.println("Memory: " + m / 1024L / 1024L + "MB");
        mapper.test();
        System.out.println(mapper.id("http://ontology.ontobox.org/7"));
        System.out.println(mapper.id("http://ontology.ontobox.org/7#localobject7"));
        System.out.println();
        System.out.println(NameMap.testId(mapper));
        System.out.println(NameMap.testId(mapper));
    }
}

