/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.exchange;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntSet;
import com.teacode.exception.ExUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.OntologyHelper;
import org.ontobox.box.helper.ProgressListener;
import org.ontobox.exchange.mvx.ImportMVX;
import org.ontobox.exchange.mvx.MVXLoader;
import org.ontobox.exchange.mvx.MVXSaver;
import org.ontobox.exchange.mvx.N;
import org.ontobox.exchange.mvx.Ontologies;
import org.ontobox.exchange.mvx.OntologyProcessor;
import org.ontobox.exchange.mvx.XmlLoader;
import org.ontobox.exchange.mvx.ZipSaver;
import org.ontobox.exchange.mvx.xml.XMLWriter;

public class MVX {
    public static final ProgressListener LISTENER = new ProgressListener(){

        @Override
        public void nextStep(String text) {
        }
    };

    public static void importFile(File file, BoxWorker worker) throws IOException {
        XmlLoader.processFromZIP(new FileInputStreamGenerator(file), new ImportMVX(worker, new HashMap<String, String>(), LISTENER));
    }

    public static void importFile(File file, BoxWorker worker, OntologyProcessor ontologyProcessor) throws IOException {
        XmlLoader.processFromZIP(new FileInputStreamGenerator(file), new ImportMVX(worker, new HashMap<String, String>(), LISTENER, ontologyProcessor));
    }

    public static void importFile(File file, BoxWorker worker, Map<String, String> annotations, ProgressListener listener) throws IOException {
        XmlLoader.processFromZIP(new FileInputStreamGenerator(file), new ImportMVX(worker, annotations, listener));
    }

    public static void importBuffer(final byte[] data, BoxWorker worker) throws IOException {
        XmlLoader.processFromZIP(new XmlLoader.InputStreamGenerator(){

            @Override
            public InputStream in() throws IOException {
                return new ByteArrayInputStream(data);
            }
        }, new ImportMVX(worker, new HashMap<String, String>(), LISTENER));
    }

    public static Ontologies ontologies(File file) throws IOException {
        final Ontologies ret = new Ontologies();
        XmlLoader.processFromZIP(new FileInputStreamGenerator(file), new XmlLoader.XmlProcessor(){

            @Override
            public boolean processXml(int step, InputStream in) {
                MVXLoader.ontologies(in, ret);
                return false;
            }
        });
        return ret;
    }

    public static void importUnpackedFile(File file, BoxWorker worker) throws IOException {
        MVX.importUnpackedFile(file, worker, new HashMap<String, String>(), LISTENER);
    }

    public static void importUnpackedFile(File file, BoxWorker worker, Map<String, String> annotations, ProgressListener listener) throws IOException {
        XmlLoader.processUnpacked(new FileInputStreamGenerator(file), new ImportMVX(worker, annotations, listener));
    }

    public static void exportFile(File file, BoxWorker worker) {
        MVX.exportFile(file, worker, Collections.<String, String>emptyMap(), LISTENER);
    }

    protected static FileOutputStream open(File file) {
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage()), (Throwable)e);
        }
    }

    public static void exportFile(final File file, final BoxWorker worker, final Map<String, String> annotations, final ProgressListener listener) {
        ZipSaver.saveZip(MVX.open(file), new ZipSaver.XMLCreater(){

            @Override
            public void createXML(XMLWriter writer) throws Exception {
                listener.nextStep("\u0421\u043e\u0437\u0434\u0430\u0435\u0442\u0441\u044f " + file.getName());
                new MVXSaver(writer, worker).saveBackup(annotations, listener);
            }

            @Override
            public void onError() {
                file.delete();
            }
        });
    }

    public static byte[] exportBuffer(final BoxWorker worker) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipSaver.saveZip(out, new ZipSaver.XMLCreater(){

            @Override
            public void createXML(XMLWriter writer) throws Exception {
                new MVXSaver(writer, worker).saveBackup(Collections.<String, String>emptyMap(), LISTENER);
            }

            @Override
            public void onError() {
            }
        });
        return out.toByteArray();
    }

    public static void exportOntology(final BoxWorker worker, final File file, final int ontology, boolean autoRequire) {
        int[] used;
        final IntSet required = CCreator.newIntSet((int)10);
        for (int i : used = OntologyHelper.getUsedOntologies(worker, ontology)) {
            String name = worker.name(i);
            if (name.equals("http://ontobox.org/") || name.equals("http://ontobox.org/map") || N.isBadOntology(name)) continue;
            if (worker.isRequired(i) != null || autoRequire) {
                required.add(i);
                continue;
            }
            throw new IllegalStateException("Ontology " + worker.name(ontology) + " is using another ontology " + worker.name(i));
        }
        ZipSaver.saveZip(MVX.open(file), new ZipSaver.XMLCreater(){

            @Override
            public void createXML(XMLWriter writer) throws Exception {
                new MVXSaver(writer, worker).saveBackupOntology(ontology, required);
            }

            @Override
            public void onError() {
                file.delete();
            }
        });
    }

    protected static class FileInputStreamGenerator
    implements XmlLoader.InputStreamGenerator {
        private final File file;

        public FileInputStreamGenerator(File file) {
            this.file = file;
        }

        @Override
        public InputStream in() throws IOException {
            return new FileInputStream(this.file);
        }
    }
}

