/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.exchange.mvx;

import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.IntProcessor;
import com.teacode.util.Base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.RequireLevel;
import org.ontobox.box.helper.ProgressListener;
import org.ontobox.exchange.mvx.N;
import org.ontobox.exchange.mvx.xml.XMLWriter;

public class MVXSaver {
    private final XMLWriter writer;
    private final BoxWorker worker;

    public MVXSaver(XMLWriter writer, BoxWorker worker) {
        this.writer = writer;
        this.worker = worker;
    }

    private static boolean isCorrectString(String str) {
        int size = str.length();
        for (int t = 0; t < size; ++t) {
            char ch = str.charAt(t);
            if (ch < ' ' && ch != '\r' && ch != '\n' && ch != '\t') {
                return false;
            }
            if (ch < '\ud800') continue;
            return false;
        }
        return true;
    }

    private static byte[] unicode(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void saveAnnotation(String name, String value, String indent) throws IOException {
        String tvalue = null;
        String b64 = null;
        if (MVXSaver.isCorrectString(value)) {
            tvalue = value;
        } else {
            b64 = Base64.encodeBytes((byte[])MVXSaver.unicode(value));
        }
        this.writer.openCloseTag(indent, "annotation", new XMLWriter.Attr("name", name), new XMLWriter.Attr("value", tvalue), new XMLWriter.Attr("base64", b64));
    }

    private void saveAnnotations(int ae, String indent) throws Exception {
        for (String name : this.worker.annames(ae)) {
            String value = this.worker.anno(ae, name);
            this.saveAnnotation(name, value, indent);
        }
    }

    private void saveAnnotations(Map<String, String> ae, String indent) throws Exception {
        for (Map.Entry<String, String> entry : ae.entrySet()) {
            this.saveAnnotation(entry.getKey(), entry.getValue(), indent);
        }
    }

    private void saveOntology(int ont, String indent) throws Exception {
        this.writer.openTag(indent, "ontology", new XMLWriter.Attr("uri", this.worker.name(ont)));
        String newIndent = indent + "  ";
        this.saveAnnotations(ont, newIndent);
        for (int type : this.worker.types(ont)) {
            this.saveType(type, newIndent);
        }
        for (int cl : this.worker.classes(ont)) {
            this.saveOntClass(cl, newIndent);
        }
        for (int tprop : this.worker.tprops(ont)) {
            this.saveTProperty(tprop, newIndent);
        }
        for (int oprop : this.worker.oprops(ont)) {
            this.saveOProperty(oprop, newIndent);
        }
        for (int obj : this.worker.objects(ont)) {
            this.saveOntObject(obj, newIndent);
        }
        this.writer.closeTag(indent, "ontology");
    }

    private void saveType(int type, String indent) throws Exception {
        this.writer.openTag(indent, "type", new XMLWriter.Attr("name", this.worker.local(type)));
        this.saveAnnotations(type, indent + "  ");
        this.writer.closeTag(indent, "type");
    }

    private void saveOntClass(int cl, String indent) throws Exception {
        this.writer.openTag(indent, "ontclass", new XMLWriter.Attr("name", this.worker.local(cl)));
        String newIndent = indent + "  ";
        this.saveAnnotations(cl, newIndent);
        for (int superClass : this.worker.classesDirect(cl)) {
            this.writer.openCloseTag(newIndent, "superClass", new XMLWriter.Attr("name", this.worker.name(superClass)));
        }
        this.writer.closeTag(indent, "ontclass");
    }

    private String name(Integer id) {
        if (id == null) {
            return null;
        }
        return this.worker.name(id);
    }

    private void saveTProperty(int tprop, String indent) throws Exception {
        this.writer.openTag(indent, "tproperty", new XMLWriter.Attr("name", this.worker.local(tprop)), new XMLWriter.Attr("domainClass", this.name(this.worker.domain(tprop))), new XMLWriter.Attr("rangeType", this.name(this.worker.range(tprop))));
        this.saveAnnotations(tprop, indent + "  ");
        this.writer.closeTag(indent, "tproperty");
    }

    private void saveOProperty(int oprop, String indent) throws Exception {
        this.writer.openTag(indent, "oproperty", new XMLWriter.Attr("name", this.worker.local(oprop)), new XMLWriter.Attr("domainClass", this.name(this.worker.domain(oprop))), new XMLWriter.Attr("rangeClass", this.name(this.worker.range(oprop))));
        this.saveAnnotations(oprop, indent + "  ");
        this.writer.closeTag(indent, "oproperty");
    }

    private void saveOntObject(int obj, String indent) throws Exception {
        XMLWriter.Attr nameAttr;
        int[] classes = this.worker.classesDirect(obj);
        int badClasses = 0;
        for (int cl : classes) {
            String name = this.worker.name(cl);
            if (!N.isBadEntity(name)) continue;
            ++badClasses;
        }
        if (badClasses > 0 && badClasses == classes.length) {
            return;
        }
        this.writer.openTag(indent, "ontobject", new XMLWriter.Attr("name", this.worker.local(obj)));
        String newIndent = indent + "  ";
        for (int cl : classes) {
            this.writer.openCloseTag(newIndent, "objectClass", new XMLWriter.Attr("name", this.worker.name(cl)));
        }
        for (int oprop : this.worker.oprops(obj)) {
            nameAttr = new XMLWriter.Attr("oproperty", this.worker.name(oprop));
            for (int v : this.worker.objects(obj, oprop)) {
                this.writer.openCloseTag(newIndent, "ovalue", nameAttr, new XMLWriter.Attr("value", this.worker.name(v)));
            }
        }
        for (int tprop : this.worker.tprops(obj)) {
            nameAttr = new XMLWriter.Attr("tproperty", this.worker.name(tprop));
            for (String value : this.worker.strings(obj, tprop)) {
                String tvalue = null;
                String b64 = null;
                if (MVXSaver.isCorrectString(value)) {
                    tvalue = value;
                } else {
                    b64 = Base64.encodeBytes((byte[])MVXSaver.unicode(value));
                }
                this.writer.openCloseTag(newIndent, "tvalue", nameAttr, new XMLWriter.Attr("value", tvalue), new XMLWriter.Attr("base64", b64));
            }
        }
        this.writer.closeTag(indent, "ontobject");
    }

    public void saveBackup(Map<String, String> project, ProgressListener listener) throws Exception {
        String indent = "";
        this.writer.openTag(indent, "ontobox", new XMLWriter.Attr[0]);
        String newIndent = indent + "  ";
        if (!project.isEmpty()) {
            this.writer.openTag(newIndent, "annotations", new XMLWriter.Attr[0]);
            this.saveAnnotations(project, newIndent + "  ");
            this.writer.closeTag(newIndent, "annotations");
        }
        ArrayList<Integer> required = new ArrayList<Integer>();
        ArrayList<Integer> ontologies = new ArrayList<Integer>();
        for (int ont : this.worker.ontologies()) {
            String uri = this.worker.name(ont);
            RequireLevel requireLevel = this.worker.isRequired(ont);
            if (uri.equals("http://ontobox.org/") || RequireLevel.INDIRECT == requireLevel || N.isBadOntology(uri)) continue;
            if (RequireLevel.DIRECT == requireLevel) {
                required.add(ont);
                continue;
            }
            ontologies.add(ont);
        }
        Collections.sort(required);
        Collections.sort(ontologies);
        for (Integer ont : required) {
            String uri = this.worker.name(ont);
            this.writer.openCloseTag(newIndent, "require", new XMLWriter.Attr("uri", uri));
        }
        for (Integer ont : ontologies) {
            String uri = this.worker.name(ont);
            listener.nextStep("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442\u0441\u044f " + uri);
            this.saveOntology(ont, newIndent);
        }
        this.writer.closeTag(indent, "ontobox");
    }

    public void saveBackupOntology(int ontology, IntSet required) throws Exception {
        String indent = "";
        this.writer.openTag(indent, "ontobox", new XMLWriter.Attr[0]);
        final String newIndent = indent + "  ";
        required.forEach(new IntProcessor(){

            public boolean process(int i) {
                String uri = MVXSaver.this.worker.name(i);
                try {
                    MVXSaver.this.writer.openCloseTag(newIndent, "require", new XMLWriter.Attr("uri", uri));
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.saveOntology(ontology, newIndent);
        this.writer.closeTag(indent, "ontobox");
    }
}

