/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast;

import com.teacode.collection.ReverseIterable;
import com.teacode.exception.ExUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.ontobox.box.exception.AlreadyExistsException;
import org.ontobox.box.exception.DeleteException;
import org.ontobox.box.exception.DomainException;
import org.ontobox.box.exception.IllegalNameException;
import org.ontobox.box.exception.NotFoundException;
import org.ontobox.box.exception.RangeException;
import org.ontobox.fast.Engine;
import org.ontobox.fast.Transaction;
import org.ontobox.fast.action.AddTValue;
import org.ontobox.fast.action.ReadAction;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class TransactionRW
implements Transaction {
    public static boolean DEBUG = false;
    private static final Logger logger = Logger.getLogger(TransactionRW.class.getName());
    private Engine engine;
    private List<WriteAction> currentBuffer;

    public TransactionRW(Engine engine) {
        this.engine = engine;
    }

    @Override
    public final synchronized void write(WriteAction action) {
        this.engine.waitForWrite(this);
        Storage storage = this.engine.storage;
        if (action instanceof AddTValue) {
            AddTValue v = (AddTValue)action;
            Integer propId = storage.id(v.getPropertyName());
            String value = v.getValue();
            if (value == null) {
                throw new IllegalArgumentException("A TProperty value is not allowed to be NULL (" + v.getPropertyName() + ")");
            }
            int size = value.length();
            if (storage.isDeclaredDMapBinaryTProp(propId)) {
                if (size % 4 != 0) {
                    throw new IllegalArgumentException("Incorrect Base64 string (length must be multiple of 4)");
                }
                int s = size;
                if (s > 0 && value.charAt(s - 1) == '=') {
                    --s;
                }
                if (s > 0 && value.charAt(s - 1) == '=') {
                    --s;
                }
                for (int t = 0; t < s; ++t) {
                    char ch = value.charAt(t);
                    if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '+' || ch == '/') continue;
                    throw new IllegalArgumentException("Incorrect Base64 string (symbol " + ch + " is not allowed)");
                }
            }
            if (storage.isDMapTProp(propId)) {
                String key = size <= storage.maxDMapValueAsKey ? storage.dMapKeyPrefix + value : storage.dmap.addValue(value);
                action = new AddTValue(v.getObjectName(), v.getPropertyName(), key, v.getIndex());
            }
        }
        try {
            action.preverify(storage);
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException(e, TransactionRW.getActionDescription(action));
        }
        catch (DeleteException e) {
            throw new DeleteException(e, TransactionRW.getActionDescription(action));
        }
        catch (DomainException e) {
            throw new DomainException(e, TransactionRW.getActionDescription(action));
        }
        catch (IllegalNameException e) {
            throw new IllegalNameException(e, TransactionRW.getActionDescription(action));
        }
        catch (NotFoundException e) {
            throw new NotFoundException(e, TransactionRW.getActionDescription(action));
        }
        catch (RangeException e) {
            throw new RangeException(e, TransactionRW.getActionDescription(action));
        }
        catch (IllegalStateException e) {
            throw (IllegalStateException)ExUtil.copy((Throwable)new IllegalStateException(e.getMessage() + "\n" + TransactionRW.getActionDescription(action)), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw (IllegalArgumentException)ExUtil.copy((Throwable)new IllegalArgumentException(e.getMessage() + "\n" + TransactionRW.getActionDescription(action)), (Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw (UnsupportedOperationException)ExUtil.copy((Throwable)new UnsupportedOperationException(e.getMessage() + "\n" + TransactionRW.getActionDescription(action)), (Throwable)e);
        }
        catch (Throwable e) {
            logger.warning("Unknown exception class: " + e.getClass().getName());
            throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage() + "\n" + TransactionRW.getActionDescription(action)), (Throwable)e);
        }
        if (DEBUG) {
            logger.info("Do: " + TransactionRW.getActionDescription(action));
        }
        action.doAction(storage);
        if (this.currentBuffer == null) {
            this.currentBuffer = new ArrayList<WriteAction>();
        }
        this.currentBuffer.add(action);
    }

    private static String getActionDescription(WriteAction a) {
        StringBuilder sb = new StringBuilder();
        sb.append("Action: ").append(a.getClass().getSimpleName());
        for (String s : a.saveData()) {
            sb.append(" ");
            sb.append(s);
        }
        return sb.toString();
    }

    @Override
    public final <R> R read(ReadAction<R> action) {
        this.engine.waitForWrite(this);
        return action.read(this.engine.storage);
    }

    @Override
    public final synchronized boolean close(boolean rollback) {
        boolean ret = false;
        if (this.currentBuffer != null) {
            this.engine.waitForWrite(this);
            if (rollback) {
                logger.info("rolling back " + this.currentBuffer.size() + " actions");
                Storage storage = this.engine.storage;
                for (WriteAction writeAction : new ReverseIterable(this.currentBuffer)) {
                    WriteAction undo = writeAction.getUndoAction();
                    if (DEBUG) {
                        logger.info("Undo: " + TransactionRW.getActionDescription(undo));
                    }
                    undo.preverify(storage);
                    undo.doAction(storage);
                }
            } else {
                ret = !this.currentBuffer.isEmpty();
                this.engine.putTransactionActions(this.currentBuffer);
            }
        }
        this.engine.free(this);
        this.engine = null;
        return ret;
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        this.close(true);
    }
}

