/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntObjectMap;
import org.ontobox.box.event.AddOValueEvent;
import org.ontobox.box.exception.RangeException;
import org.ontobox.fast.action.AddValue;
import org.ontobox.fast.action.RemoveOValue;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;

public class AddOValue
extends AddValue
implements AddOValueEvent {
    private final String value;
    private final int index;
    private int realIndex;

    public AddOValue(String[] data) {
        this(data[0], data[1], data[2], Integer.parseInt(data[3]));
    }

    public AddOValue(String name, String propertyName, String value, int index) {
        super(name, propertyName);
        this.value = value;
        this.index = index;
    }

    private void verifyRange(Storage storage) {
        Integer range = storage.opropRange.getDirect(storage.id(this.propertyName));
        if (range != null) {
            IntList list = storage.objectClasses.getDirect(storage.id(this.value));
            if (list.contains(range.intValue())) {
                return;
            }
            if (storage.getAllSuperclasses(list).contains(range.intValue())) {
                return;
            }
            throw new RangeException(this.name, this.propertyName, storage.name(range), this.value);
        }
    }

    @Override
    public final void preverify(Storage storage) {
        if (this.value == null) {
            throw new IllegalArgumentException("value cannot be null (" + this.propertyName + ')');
        }
        storage.verifyExistentObject(this.name);
        storage.verifyExistentOProperty(this.propertyName);
        storage.verifyExistentObject(this.value);
        Integer propId = storage.id(this.propertyName);
        BMapIntIntLazy v = (BMapIntIntLazy)storage.ovalues.get(propId.intValue());
        int size = v == null ? 0 : v.getDirect(storage.id(this.name)).size();
        Integer card = storage.propMaxCard.get(propId.intValue());
        if (storage.useCard && card != null && size == card) {
            throw new IllegalArgumentException("too many values (" + card + " already) for " + this.propertyName);
        }
        if (this.index < -1 || this.index > size) {
            throw new IllegalArgumentException("index: " + this.index + " (must be 0;" + size + " inclusive) for " + this.propertyName);
        }
        this.verifyDomain(storage, storage.opropDomain);
        this.verifyRange(storage);
    }

    @Override
    public final void doAction(Storage storage) {
        IntObjectMap<BMapIntIntLazy> ovalues = storage.ovalues;
        int propId = storage.id(this.propertyName);
        BMapIntIntLazy v = (BMapIntIntLazy)ovalues.get(propId);
        if (v == null) {
            v = new BMapIntIntLazy();
            ovalues.put(propId, (Object)v);
        }
        Integer id = storage.id(this.name);
        this.realIndex = this.index == -1 ? v.getDirect(id).size() : this.index;
        v.add(id, this.index, storage.id(this.value));
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.propertyName, this.value, String.valueOf(this.index)};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new RemoveOValue(this.name, this.propertyName, this.realIndex);
    }

    @Override
    public final String getValue() {
        return this.value;
    }

    @Override
    public final int getIndex() {
        return this.realIndex;
    }
}

