/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.process.IntProcessor;
import java.util.ArrayList;
import java.util.Collection;
import org.ontobox.box.event.AddObjectClassEvent;
import org.ontobox.fast.action.RemoveObjectClass;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class AddObjectClass
implements WriteAction,
AddObjectClassEvent {
    private final String name;
    private final String className;
    private final Collection<String> oldClassNames = new ArrayList<String>();

    public AddObjectClass(String[] data) {
        this(data[0], data[1]);
    }

    public AddObjectClass(String name, String className) {
        this.name = name;
        this.className = className;
    }

    @Override
    public final void preverify(Storage storage) {
        storage.verifyExistentObject(this.name);
        storage.verifyExistentClass(this.className);
        if (storage.objectClasses.getDirect(storage.id(this.name)).contains(storage.id(this.className).intValue())) {
            throw new IllegalArgumentException("Already done");
        }
    }

    @Override
    public final void doAction(final Storage storage) {
        int objectId = storage.id(this.name);
        storage.objectClasses.getDirect(objectId).forEach(new IntProcessor(){

            public boolean process(int i) {
                AddObjectClass.this.oldClassNames.add(storage.name(i));
                return true;
            }
        });
        storage.objectClasses.add(objectId, storage.id(this.className));
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.className};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new RemoveObjectClass(this.name, this.className);
    }

    @Override
    public final String getObjectName() {
        return this.name;
    }

    @Override
    public final String getClassName() {
        return this.className;
    }

    @Override
    public final Collection<String> getOldClassNames() {
        return this.oldClassNames;
    }
}

