/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.IntCollection;
import com.teacode.collection.primitive.process.IntProcessor;
import org.ontobox.box.event.DeleteClassEvent;
import org.ontobox.box.exception.DeleteException;
import org.ontobox.fast.action.CreateClass;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class DeleteClass
implements WriteAction,
DeleteClassEvent {
    private final String name;

    public DeleteClass(String[] data) {
        this(data[0]);
    }

    public DeleteClass(String name) {
        this.name = name;
    }

    @Override
    public final String getClassName() {
        return this.name;
    }

    static String getEntities(final Storage storage, IntCollection ids, final int limit) {
        final StringBuilder sb = new StringBuilder();
        ids.forEach(new IntProcessor(){
            private int t = 0;

            public boolean process(int id) {
                if (this.t == limit) {
                    return false;
                }
                if (this.t > 0) {
                    sb.append(", ");
                }
                sb.append(storage.name(id));
                ++this.t;
                return true;
            }
        });
        return sb.toString();
    }

    @Override
    public final void preverify(Storage storage) {
        storage.verifyExistentClass(this.name);
        int id = storage.id(this.name);
        int ontId = storage.classes.getDirect(id);
        if (ontId == storage.id("http://ontobox.org/")) {
            throw new DeleteException("Class", this.name, "Predefined class cannot be deleted (" + this.name + ")");
        }
        if (!storage.subclasses.getReverse(id).isEmpty()) {
            throw new DeleteException("Class", this.name, "It has superclass(es) " + DeleteClass.getEntities(storage, (IntCollection)storage.subclasses.getReverse(id), 10));
        }
        if (!storage.subclasses.getDirect(id).isEmpty()) {
            throw new DeleteException("Class", this.name, "It has subclass(es) " + DeleteClass.getEntities(storage, (IntCollection)storage.subclasses.getDirect(id), 10));
        }
        if (!storage.objectClasses.getReverse(id).isEmpty()) {
            throw new DeleteException("Class", this.name, "It has object(s)");
        }
        if (!storage.tpropDomain.getReverse(id).isEmpty()) {
            throw new DeleteException("Class", this.name, "It is used as the domain of " + storage.name(storage.tpropDomain.getReverse(id).getAny()) + " TProperty");
        }
        if (!storage.opropDomain.getReverse(id).isEmpty()) {
            throw new DeleteException("Class", this.name, "It is used as the domain of " + storage.name(storage.opropDomain.getReverse(id).getAny()) + " OProperty");
        }
        if (!storage.opropRange.getReverse(id).isEmpty()) {
            throw new DeleteException("Class", this.name, "It is used as a range");
        }
    }

    @Override
    public final void doAction(Storage storage) {
        int id = storage.id(this.name);
        storage.subclasses.removeReverseKey(id);
        storage.classes.removeDirectKey(id);
        storage.deleteNameAndAnno(this.name);
        storage.dropStructureCache();
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new CreateClass(this.name);
    }
}

