/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.DeleteTPropertyEvent;
import org.ontobox.box.exception.DeleteException;
import org.ontobox.fast.action.CreateTProperty;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapInt;

public class DeleteTProperty
implements WriteAction,
DeleteTPropertyEvent {
    private final String name;

    public DeleteTProperty(String[] data) {
        this(data[0]);
    }

    public DeleteTProperty(String name) {
        this.name = name;
    }

    @Override
    public final String getPropertyName() {
        return this.name;
    }

    @Override
    public final void preverify(Storage storage) {
        storage.verifyExistentTProperty(this.name);
        BMapInt ts = storage.getValueMap(storage.id(this.name));
        if (ts != null && ts.keys().length != 0) {
            throw new DeleteException("Tproperty", this.name, "There is a string value, so TProperty cannot be deleted");
        }
    }

    @Override
    public final void doAction(Storage storage) {
        int id = storage.id(this.name);
        storage.tpropDomain.removeDirectKey(id);
        storage.tpropRange.removeDirectKey(id);
        storage.tProperties.removeDirectKey(id);
        storage.tstrings.removeKey(id);
        storage.tintegers.removeKey(id);
        storage.tlongs.removeKey(id);
        storage.tbooleans.removeKey(id);
        storage.deleteNameAndAnno(this.name);
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new CreateTProperty(this.name);
    }
}

