/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.DeleteTypeEvent;
import org.ontobox.box.exception.DeleteException;
import org.ontobox.fast.action.CreateType;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class DeleteType
implements WriteAction,
DeleteTypeEvent {
    private final String name;

    public DeleteType(String[] data) {
        this(data[0]);
    }

    public DeleteType(String name) {
        this.name = name;
    }

    @Override
    public void preverify(Storage storage) {
        storage.verifyExistentType(this.name);
        int id = storage.id(this.name);
        int ontId = storage.types.getDirect(id);
        if (ontId == storage.id("http://ontobox.org/")) {
            throw new DeleteException("Type", this.name, "Predefined type cannot be deleted");
        }
        if (!storage.opropRange.getReverse(id).isEmpty()) {
            throw new DeleteException("Type", this.name, "Used as a range");
        }
    }

    @Override
    public void doAction(Storage storage) {
        storage.types.removeDirectKey(storage.id(this.name));
        storage.deleteNameAndAnno(this.name);
    }

    @Override
    public String[] saveData() {
        return new String[]{this.name};
    }

    @Override
    public WriteAction getUndoAction() {
        return new CreateType(this.name);
    }

    public String getName() {
        return this.name;
    }
}

