/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.process.IntProcessor;
import java.util.ArrayList;
import java.util.Collection;
import org.ontobox.box.event.RemoveSubclassEvent;
import org.ontobox.fast.action.AddSubclass;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class RemoveSubclass
implements WriteAction,
RemoveSubclassEvent {
    private final String superName;
    private final String subName;
    private final Collection<String> newSuperNames = new ArrayList<String>();

    public RemoveSubclass(String[] data) {
        this(data[0], data[1]);
    }

    public RemoveSubclass(String superName, String subName) {
        this.superName = superName;
        this.subName = subName;
    }

    @Override
    public final void preverify(Storage storage) {
        storage.verifyExistentClass(this.superName);
        storage.verifyExistentClass(this.subName);
        if (!storage.subclasses.getDirect(storage.id(this.superName)).contains(storage.id(this.subName).intValue())) {
            throw new IllegalArgumentException(this.subName + " is not direct subclass of " + this.superName);
        }
    }

    @Override
    public final void doAction(final Storage storage) {
        int superId = storage.id(this.superName);
        int subId = storage.id(this.subName);
        int index = storage.subclasses.getDirect(superId).indexOf(0, subId);
        storage.subclasses.removeDirect(superId, index);
        storage.dropStructureCache();
        storage.subclasses.getReverse(subId).forEach(new IntProcessor(){

            public boolean process(int i) {
                RemoveSubclass.this.newSuperNames.add(storage.name(i));
                return true;
            }
        });
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.superName, this.subName};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new AddSubclass(this.superName, this.subName);
    }

    @Override
    public final String getSuperName() {
        return this.superName;
    }

    @Override
    public final String getSubName() {
        return this.subName;
    }

    @Override
    public final Collection<String> getNewSuperNames() {
        return this.newSuperNames;
    }
}

