/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import org.ontobox.box.event.SetOPropertyRangeEvent;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;

public class SetOPropertyRange
implements WriteAction,
SetOPropertyRangeEvent {
    private final String name;
    private final String range;
    private String oldRange;

    public SetOPropertyRange(String[] data) {
        this(data[0], data[1]);
    }

    public SetOPropertyRange(String name, String range) {
        this.name = name;
        this.range = range;
    }

    @Override
    public final void preverify(Storage storage) {
        BMapIntIntLazy ov;
        storage.verifyExistentOProperty(this.name);
        if (this.range != null) {
            storage.verifyExistentClass(this.range);
        }
        if ((ov = (BMapIntIntLazy)storage.ovalues.get(storage.id(this.name).intValue())) != null && ov.keys().length != 0) {
            throw new IllegalStateException("There are ovalues, so range cannot be changed");
        }
    }

    @Override
    public final void doAction(Storage storage) {
        int id = storage.id(this.name);
        Integer oldRangeId = storage.opropRange.getDirect(id);
        if (oldRangeId != null) {
            this.oldRange = storage.name(oldRangeId);
        }
        if (this.range == null) {
            storage.opropRange.put(id, null);
        } else {
            storage.opropRange.put(id, storage.id(this.range));
        }
    }

    @Override
    public final String[] saveData() {
        return new String[]{this.name, this.range};
    }

    @Override
    public final WriteAction getUndoAction() {
        return new SetOPropertyRange(this.name, this.oldRange);
    }

    public final String getName() {
        return this.name;
    }

    public final String getRange() {
        return this.range;
    }

    public final String getOldRange() {
        return this.oldRange;
    }
}

