/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.action;

import com.teacode.collection.primitive.IntObjectMap;
import com.teacode.collection.primitive.process.IntObjectProcessor;
import com.teacode.collection.primitive.process.ObjectProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ontobox.box.event.SetURIEvent;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.box.helper.SplittedName;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

public class SetURI
implements WriteAction,
SetURIEvent {
    private final String uri;
    private final String newUri;

    public SetURI(String[] data) {
        this(data[0], data[1]);
    }

    public SetURI(String uri, String newUri) {
        this.uri = uri;
        this.newUri = newUri;
    }

    @Override
    public String getOldURI() {
        return this.uri;
    }

    @Override
    public String getNewURI() {
        return this.newUri;
    }

    @Override
    public void preverify(Storage storage) {
        storage.verifyExcistentOntology(this.uri);
        storage.verifyNewOntology(this.newUri);
    }

    @Override
    public void doAction(Storage storage) {
        final HashMap rename = new HashMap();
        storage.ids.forEachName(new ObjectProcessor<String>(){

            public boolean process(String name) {
                SplittedName data = NameHelper.splitName(name);
                if (data != null && data.ontology().equals(SetURI.this.uri)) {
                    String newName = SetURI.this.newUri + '#' + data.local();
                    rename.put(name, newName);
                }
                return true;
            }
        });
        for (Map.Entry entry : rename.entrySet()) {
            storage.changeName((String)entry.getKey(), (String)entry.getValue());
        }
        storage.changeName(this.uri, this.newUri);
        IntObjectMap<Map<String, String>> annotations = storage.annotations;
        final ArrayList names = new ArrayList();
        final String uriHash = this.uri + '#';
        annotations.forEachEntry((IntObjectProcessor)new IntObjectProcessor<Map<String, String>>(){

            public boolean process(int id, Map<String, String> map) {
                names.clear();
                for (String s : map.keySet()) {
                    if (!s.startsWith(uriHash)) continue;
                    names.add(s);
                }
                for (String name : names) {
                    String newName = SetURI.this.newUri + '#' + NameHelper.splitName(name).local();
                    String value = map.get(name);
                    map.remove(name);
                    map.put(newName, value);
                }
                return true;
            }
        });
    }

    @Override
    public String[] saveData() {
        return new String[]{this.uri, this.newUri};
    }

    @Override
    public WriteAction getUndoAction() {
        return new SetURI(this.newUri, this.uri);
    }
}

