/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.box;

import java.io.File;
import java.util.logging.Logger;
import org.ontobox.box.BoxListenerManager;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.base.BaseBox;
import org.ontobox.fast.Engine;
import org.ontobox.fast.Transaction;
import org.ontobox.fast.box.FastBoxWorker;
import org.ontobox.fast.box.FastListenerManager;
import org.ontobox.storage.StorageBox;

public class FastBox
extends BaseBox {
    private static Logger logger = Logger.getLogger(StorageBox.class.getName());
    private final Engine engine;
    private final FastListenerManager manager;

    public FastBox() {
        logger.info("OntoBox Storage: Memory only mode (data is not persistent)");
        this.engine = new Engine();
        this.manager = new FastListenerManager();
        this.engine.setListener(this.manager);
    }

    public FastBox(File dir) {
        logger.info("OntoBox Storage: Normal file mode (persistent), " + dir.getAbsolutePath());
        this.engine = new Engine(dir, true);
        this.manager = new FastListenerManager();
        this.engine.setListener(this.manager);
    }

    public FastBox(File dir, boolean useCard) {
        if (useCard) {
            logger.info("OntoBox Storage: Normal file mode (persistent), " + dir.getAbsolutePath());
        } else {
            logger.info("OntoBox Storage: Legacy file mode (persistent, max. cardinality is not verified), " + dir.getAbsolutePath());
        }
        this.engine = new Engine(dir, useCard);
        this.manager = new FastListenerManager();
        this.engine.setListener(this.manager);
    }

    @Override
    public BoxWorker workRO() {
        return new FastBoxWorker(this, true, false);
    }

    @Override
    public BoxWorker work() {
        return new FastBoxWorker(this, false, false);
    }

    @Override
    public BoxWorker workAutocommit() {
        return new FastBoxWorker(this, false, true);
    }

    final Transaction openTransaction(boolean ro) {
        if (ro) {
            return this.engine.openTransactionRO();
        }
        return this.engine.openTransactionRW();
    }

    @Override
    public void close() {
        this.manager.close();
        this.engine.close();
    }

    @Override
    public BoxListenerManager getListenerManager() {
        return this.manager;
    }
}

