/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.storage;

import com.teacode.file.buffer.ReadBuffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ontobox.fast.action.Check;
import org.ontobox.fast.action.WriteAction;
import org.ontobox.fast.storage.Storage;

class BinaryLogLoader {
    private static final Logger logger = Logger.getLogger(BinaryLogLoader.class.getName());
    private static final Map<String, Constructor> constructorCache = new HashMap<String, Constructor>();
    private final File file;

    public BinaryLogLoader(File file) {
        this.file = file;
    }

    public int loadActions(Storage storage) throws IOException {
        int actionCounter = 0;
        long t1 = System.nanoTime();
        FileChannel channel = new FileInputStream(this.file).getChannel();
        try {
            ReadBuffer buffer = new ReadBuffer(channel);
            ArrayList<WriteAction> transaction = new ArrayList<WriteAction>();
            block9: while (true) {
                int transactionActions = 0;
                transaction.clear();
                try {
                    while (true) {
                        String name = buffer.getASCIICompact();
                        int len = buffer.getByte();
                        String[] data = new String[len];
                        for (int t = 0; t < len; ++t) {
                            data[t] = buffer.getString();
                        }
                        Constructor<?> constructor = constructorCache.get(name);
                        if (constructor == null) {
                            try {
                                constructor = Class.forName("org.ontobox.fast.action." + name).getConstructor(String[].class);
                                constructorCache.put(name, constructor);
                            }
                            catch (ClassNotFoundException e) {
                                throw new RuntimeException("Unsupported/unknown action \"" + name + "\" (" + this.file + ")");
                            }
                        }
                        Object[] args = new Object[]{data};
                        WriteAction action = (WriteAction)constructor.newInstance(args);
                        transaction.add(action);
                        if (!(action instanceof Check)) {
                            ++actionCounter;
                            ++transactionActions;
                            continue;
                        }
                        break;
                    }
                }
                catch (ReadBuffer.EOF e) {
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                int lastIndex = transaction.size() - 1;
                if (lastIndex < 0 || !(transaction.get(lastIndex) instanceof Check)) {
                    if (transactionActions != 0) {
                        logger.warning("Skipped " + transactionActions + " last transaction actions.");
                    }
                    long t2 = System.nanoTime();
                    logger.info("Loading " + this.file + ": " + (t2 - t1) / 1000L / 1000L + " ms");
                    int n = actionCounter;
                    return n;
                }
                int t = 0;
                while (true) {
                    if (t >= lastIndex) continue block9;
                    ((WriteAction)transaction.get(t)).doAction(storage);
                    ++t;
                }
                break;
            }
        }
        finally {
            channel.close();
        }
    }
}

