/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.storage;

import com.teacode.file.buffer.WriteBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.ontobox.fast.action.WriteAction;

class BinaryLogSaver {
    private final FileChannel channel;
    private final WriteBuffer buffer;

    public BinaryLogSaver(File file) {
        if (file.exists()) {
            throw new IllegalStateException("Binary log file " + file + " exists yet, system has started incorrectly.");
        }
        try {
            this.channel = new FileOutputStream(file).getChannel();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.buffer = new WriteBuffer(this.channel);
    }

    public final void saveAction(WriteAction action) throws IOException {
        this.buffer.putASCIICompact(action.getClass().getSimpleName());
        String[] strings = action.saveData();
        this.buffer.putByte((byte)strings.length);
        for (String string : strings) {
            this.buffer.putString(string);
        }
    }

    public void flush() {
        if (this.buffer != null) {
            this.buffer.flush();
        }
    }

    public void close() {
        if (this.buffer != null) {
            this.buffer.flush();
            try {
                this.channel.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

