/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.storage;

import com.teacode.collection.primitive.process.IntObjectProcessor;
import com.teacode.collection.primitive.process.ObjectProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.ontobox.box.helper.NameHelper;
import org.ontobox.fast.id.IdSupport;
import org.ontobox.fast.storage.Storage;
import org.ontobox.fast.util.mapmany.BMapIntBooleanLazy;
import org.ontobox.fast.util.mapmany.BMapIntIntLazy;
import org.ontobox.fast.util.mapmany.BMapIntLongLazy;
import org.ontobox.fast.util.mapmany.BMapIntStringLazy;
import org.ontobox.fast.util.mapone.BMapOneIntInt;

public class Verifier {
    private static final Logger logger = Logger.getLogger(Verifier.class.getName());

    private static void verifyDupNames(Storage storage) {
        IdSupport ids = storage.ids;
        final HashSet names = new HashSet(ids.size());
        ids.forEachName(new ObjectProcessor<String>(){

            public boolean process(String name) {
                if (names.contains(name)) {
                    logger.severe("Duplicate name (one name for many ids): " + name);
                }
                names.add(name);
                return true;
            }
        });
    }

    private static void verifyIdNames(Storage storage) {
        final IdSupport ids = storage.ids;
        ids.forEachName(new ObjectProcessor<String>(){

            public boolean process(String name) {
                int id = ids.id(name);
                String s = ids.name(id);
                if (!s.equals(name)) {
                    logger.severe("Wrong name-id link. " + name + "->" + id + ", but " + id + "->" + s);
                }
                return true;
            }
        });
    }

    private static String nameId(Storage storage, Integer id) {
        StringBuilder sb = new StringBuilder();
        sb.append(storage.name(id)).append(" (").append(id).append(')');
        return sb.toString();
    }

    private static String nameId(Storage storage, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(" (").append(storage.id(name)).append(')');
        return sb.toString();
    }

    private static void verifyOntologyExistence(Storage storage, Map<String, BMapOneIntInt> entities) {
        for (Map.Entry<String, BMapOneIntInt> entity : entities.entrySet()) {
            String entityType = entity.getKey();
            BMapOneIntInt map = entity.getValue();
            int[] arr$ = map.directKeySet();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer id = arr$[i$];
                Integer ontId = map.getDirect(id);
                if (storage.ontologies.contains(ontId.intValue())) continue;
                logger.severe("Unknown ontology: " + Verifier.nameId(storage, ontId) + " for " + entityType + ' ' + Verifier.nameId(storage, id));
            }
        }
    }

    private static void verifyOntologyLink(Storage storage, Map<String, BMapOneIntInt> entities) {
        for (Map.Entry<String, BMapOneIntInt> entity : entities.entrySet()) {
            String entityType = entity.getKey();
            BMapOneIntInt map = entity.getValue();
            int[] arr$ = map.directKeySet();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer ontId;
                String ontName;
                Integer id = arr$[i$];
                String fullName = storage.name(id);
                if (fullName.startsWith((ontName = storage.name(ontId = map.getDirect(id))) + '#')) continue;
                String correctName = NameHelper.splitName(fullName).ontology();
                logger.severe("Wrong ontology: " + Verifier.nameId(storage, ontId) + " for " + entityType + ' ' + Verifier.nameId(storage, id) + ", must be " + Verifier.nameId(storage, correctName));
            }
        }
    }

    private static void verifyTPropertiesType(final Storage storage) {
        final Integer intType = storage.id("http://ontobox.org/#int");
        final Integer longType = storage.id("http://ontobox.org/#long");
        final Integer dateType = storage.id("http://ontobox.org/#date");
        final Integer booleanType = storage.id("http://ontobox.org/#boolean");
        storage.tstrings.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntStringLazy>(){

            public boolean process(int key, BMapIntStringLazy value) {
                Integer range = storage.tpropRange.getDirect(key);
                if (range != null) {
                    if (range.equals(intType)) {
                        logger.severe("TProperty " + Verifier.nameId(storage, key) + " has string values, but its range is " + "http://ontobox.org/#int");
                    }
                    if (range.equals(longType)) {
                        logger.severe("TProperty " + Verifier.nameId(storage, key) + " has string values, but its range is " + "http://ontobox.org/#long");
                    }
                    if (range.equals(dateType)) {
                        logger.severe("TProperty " + Verifier.nameId(storage, key) + " has string values, but its range is " + "http://ontobox.org/#date");
                    }
                    if (range.equals(booleanType)) {
                        logger.severe("TProperty " + Verifier.nameId(storage, key) + " has string values, but its range is " + "http://ontobox.org/#boolean");
                    }
                }
                return true;
            }
        });
        storage.tintegers.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntIntLazy>(){

            public boolean process(int key, BMapIntIntLazy value) {
                Integer range = storage.tpropRange.getDirect(key);
                if (range == null || !range.equals(intType)) {
                    logger.severe("TProperty " + Verifier.nameId(storage, key) + " has integer values, but its range is not " + "http://ontobox.org/#int");
                }
                return true;
            }
        });
        storage.tlongs.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntLongLazy>(){

            public boolean process(int key, BMapIntLongLazy value) {
                Integer range = storage.tpropRange.getDirect(key);
                if (range == null || !range.equals(longType) && !range.equals(dateType)) {
                    logger.severe("TProperty " + Verifier.nameId(storage, key) + " has long values, but its range is not " + "http://ontobox.org/#long" + " or " + "http://ontobox.org/#date");
                }
                return true;
            }
        });
        storage.tbooleans.forEachEntry((IntObjectProcessor)new IntObjectProcessor<BMapIntBooleanLazy>(){

            public boolean process(int key, BMapIntBooleanLazy value) {
                Integer range = storage.tpropRange.getDirect(key);
                if (range == null || !range.equals(booleanType)) {
                    logger.severe("TProperty " + Verifier.nameId(storage, key) + " has boolean values, but its range is not " + "http://ontobox.org/#boolean");
                }
                return true;
            }
        });
    }

    public static void verify(Storage storage) {
        HashMap<String, BMapOneIntInt> entities = new HashMap<String, BMapOneIntInt>(5);
        entities.put("t-property", storage.tProperties);
        entities.put("o-property", storage.oProperties);
        entities.put("type", storage.types);
        entities.put("class", storage.classes);
        entities.put("object", storage.objects);
        Verifier.verifyDupNames(storage);
        Verifier.verifyIdNames(storage);
        Verifier.verifyOntologyLink(storage, entities);
        Verifier.verifyOntologyExistence(storage, entities);
        Verifier.verifyTPropertiesType(storage);
    }
}

