/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.test;

import org.ontobox.box.Box;
import org.ontobox.box.BoxClient;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.helper.WHelper;
import org.ontobox.fast.box.FastBox;

public class StressTest {
    private static String URI = "http://stest.teacode.com/";
    private static String CLASS = URI + "#Class";
    private static String TPROP = URI + "#TProp";

    private static long getUsedMemory() {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        return rt.totalMemory() - rt.freeMemory();
    }

    protected static void dropCVS() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void logCVS(Box box) {
        int count = 0;
        BoxWorker worker = box.work();
        try {
            count = worker.objects(worker.id(URI)).length;
        }
        finally {
            worker.close();
        }
        long memory = StressTest.getUsedMemory();
        System.out.println(count + ", " + (double)memory / 1024.0 / 1024.0 + "MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        StressTest.dropCVS();
        FastBox box = new FastBox();
        try {
            box.client(new BoxClient<Void>(){

                @Override
                public Void process(BoxWorker worker) throws Exception {
                    worker.write().newOntology(URI);
                    WHelper.ontclass(worker, CLASS).tprop(TPROP, null);
                    return null;
                }
            });
            StressTest.logCVS(box);
            BoxClient<Void> client = new BoxClient<Void>(){

                @Override
                public Void process(BoxWorker worker) throws Exception {
                    int ont = worker.id(URI);
                    int cl = worker.id(CLASS);
                    int prop = worker.id(TPROP);
                    BoxWriter writer = worker.write();
                    for (int t = 0; t < 10000; ++t) {
                        int obj = writer.newObject(writer.newName(ont));
                        writer.addObjectClass(obj, cl);
                        writer.addInt(obj, prop, t);
                    }
                    return null;
                }
            };
            for (int block = 0; block < 200; ++block) {
                box.client(client);
                StressTest.logCVS(box);
            }
        }
        finally {
            box.close();
        }
    }
}

