/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.ontobox.fast.storage.Storage;

public class AnnoNameVerifier {
    private static final Logger logger = Logger.getLogger(AnnoNameVerifier.class.getName());
    private static final Map<String, String> deprecated = new HashMap<String, String>();

    public static String getNewName(String name) {
        String n = deprecated.get(name);
        if (n != null) {
            logger.warning("Annotation " + name + " replaced with " + n);
            return n;
        }
        try {
            Storage.verifyAnnoName(name);
            return name;
        }
        catch (Exception e) {
            try {
                return "http://ontobox.org/#legacy-name-" + URLEncoder.encode(name, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new IllegalStateException(e1);
            }
        }
    }

    static {
        deprecated.put("org.meta2project.fast.property.mincard", "http://ontobox.org/#mincard");
        deprecated.put("http://meta2project.org/model#mincard", "http://ontobox.org/#mincard");
        deprecated.put("org.meta2project.fast.property.maxcard", "http://ontobox.org/#maxcard");
        deprecated.put("http://meta2project.org/model#maxcard", "http://ontobox.org/#maxcard");
        deprecated.put("org.meta2project.model.Title", "http://meta2project.org/model#title");
        deprecated.put("org.meta2project.model.Comment", "http://meta2project.org/model#comment");
        deprecated.put("org.meta2project.model.Cascade", "http://meta2project.org/model#cascade");
        deprecated.put("com.teacode.meta2.client.control", "http://meta2project.org/meta2#control");
        deprecated.put("org.meta2project.client.control", "http://meta2project.org/meta2#control");
        deprecated.put("org.meta2project.client.node.mask", "http://meta2project.org/meta2#mask");
        deprecated.put("org.meta2project.view", "http://meta2project.org/meta2#view");
    }
}

