/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.map;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntObjectMap;

public class MapIntIntList {
    private final IntObjectMap<IntList> map;
    private static final IntList EMPTY_LIST = CCreator.newIntList((int)1);

    public MapIntIntList() {
        this.map = CCreator.newIntObjectMap((int)16);
    }

    public MapIntIntList(int size) {
        this.map = CCreator.newIntObjectMap((int)size);
    }

    public final int add(int key, int value) {
        IntList list = (IntList)this.map.get(key);
        if (list == null) {
            list = CCreator.newIntList((int)16);
            this.map.put(key, (Object)list);
        }
        list.add(value);
        return list.size() - 1;
    }

    public final int add(int key, int index, int value) {
        if (index == -1) {
            return this.add(key, value);
        }
        IntList list = (IntList)this.map.get(key);
        if (list == null) {
            list = CCreator.newIntList((int)16);
            this.map.put(key, (Object)list);
        }
        list.insert(index, value);
        return index;
    }

    public final IntList get(int key) {
        IntList list = (IntList)this.map.get(key);
        if (list == null) {
            return EMPTY_LIST;
        }
        return list;
    }

    public final int[] keys() {
        return this.map.keys();
    }

    public final void removeKey(int key) {
        this.map.removeKey(key);
    }

    public final void removeValues(int key, int value) {
        IntList list = this.get(key);
        int index = 0;
        while ((index = list.indexOf(index, value)) != -1) {
            list.removeIndex(index);
        }
        if (list.isEmpty()) {
            this.map.removeKey(key);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(int id) {
        return this.map.containsKey(id);
    }
}

