/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.map;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntObjectMap;
import com.teacode.collection.primitive.LongList;

public class MapIntLongList {
    private final IntObjectMap<LongList> map;
    private static final LongList EMPTY_LIST = CCreator.newLongList((int)1);

    public MapIntLongList() {
        this.map = CCreator.newIntObjectMap((int)16);
    }

    public MapIntLongList(int size) {
        this.map = CCreator.newIntObjectMap((int)size);
    }

    public final int add(int key, long value) {
        LongList list = (LongList)this.map.get(key);
        if (list == null) {
            list = CCreator.newLongList((int)16);
            this.map.put(key, (Object)list);
        }
        list.add(value);
        return list.size() - 1;
    }

    public final int add(int key, int index, long value) {
        if (index == -1) {
            return this.add(key, value);
        }
        LongList list = (LongList)this.map.get(key);
        if (list == null) {
            list = CCreator.newLongList((int)16);
            this.map.put(key, (Object)list);
        }
        list.insert(index, value);
        return index;
    }

    public final LongList get(int key) {
        LongList list = (LongList)this.map.get(key);
        if (list == null) {
            return EMPTY_LIST;
        }
        return list;
    }

    public final int[] keys() {
        return this.map.keys();
    }

    public final void removeKey(int key) {
        this.map.removeKey(key);
    }

    public final void removeValues(int key, int value) {
        LongList list = this.get(key);
        int index = 0;
        while ((index = list.indexOf(index, (long)value)) != -1) {
            list.removeIndex(index);
        }
        if (list.isEmpty()) {
            this.map.removeKey(key);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

