/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.map;

import com.teacode.collection.primitive.CCreator;
import com.teacode.collection.primitive.IntObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MapIntStringList {
    private final IntObjectMap<List<String>> map = CCreator.newIntObjectMap((int)16);

    public final int add(int key, String value) {
        ArrayList<String> list = (ArrayList<String>)this.map.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.map.put(key, list);
        }
        list.add(value);
        return list.size() - 1;
    }

    public final int add(int key, int index, String value) {
        if (index == -1) {
            return this.add(key, value);
        }
        ArrayList<String> list = (ArrayList<String>)this.map.get(key);
        if (list == null) {
            list = new ArrayList<String>();
            this.map.put(key, list);
        }
        list.add(index, value);
        return index;
    }

    public final List<String> get(int key) {
        List list = (List)this.map.get(key);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final int[] keys() {
        return this.map.keys();
    }

    public final void removeKey(int key) {
        this.map.removeKey(key);
    }

    public final void removeValues(int key, String value) {
        int index;
        List<String> list = this.get(key);
        while ((index = list.indexOf(value)) != -1) {
            list.remove(index);
        }
        if (list.isEmpty()) {
            this.map.removeKey(key);
        }
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

