/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.fast.util.mapmany;

import com.teacode.collection.primitive.IntList;
import com.teacode.collection.primitive.IntSet;
import com.teacode.collection.primitive.process.IntProcessor;
import org.ontobox.fast.util.map.MapIntIntList;
import org.ontobox.fast.util.map.MapIntIntSet;

public class BMapIntInt {
    private final MapIntIntList direct;
    private final MapIntIntSet reverse = new MapIntIntSet();

    public BMapIntInt() {
        this.direct = new MapIntIntList();
    }

    public BMapIntInt(int size) {
        this.direct = new MapIntIntList(size);
    }

    public final void add(int key, int value) {
        this.direct.add(key, value);
        this.reverse.put(value, key);
    }

    public final void add(int key, int index, int value) {
        this.direct.add(key, index, value);
        this.reverse.put(value, key);
    }

    public final boolean isEmpty() {
        return this.direct.isEmpty();
    }

    public final IntList getDirect(int key) {
        return this.direct.get(key);
    }

    public final IntSet getReverse(int value) {
        return this.reverse.get(value);
    }

    public final int[] keys() {
        return this.direct.keys();
    }

    public final int[] reverseKeySet() {
        return this.reverse.keys();
    }

    final void removeDirectKey(final int key) {
        this.getDirect(key).forEach(new IntProcessor(){

            public boolean process(int value) {
                BMapIntInt.this.reverse.removeValues(value, key);
                return true;
            }
        });
        this.direct.removeKey(key);
    }

    public final void removeReverseKey(final int val) {
        this.getReverse(val).forEach(new IntProcessor(){

            public boolean process(int k) {
                BMapIntInt.this.direct.removeValues(k, val);
                return true;
            }
        });
        this.reverse.removeKey(val);
    }

    public final void removeDirect(int key, int index) {
        IntList vList = this.direct.get(key);
        int value = vList.get(index);
        this.reverse.removeValues(value, key);
        vList.removeIndex(index);
        if (vList.isEmpty()) {
            this.removeDirectKey(key);
        }
    }

    public boolean containsDirectKey(int id) {
        return this.direct.containsKey(id);
    }
}

