/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.filebox;

import java.io.File;
import org.ontobox.box.BoxDirectClient;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.base.BaseBoxWorker;
import org.ontobox.box.helper.RHelper;
import org.ontobox.filebox.FileBox;

public class FileWorker
extends BaseBoxWorker {
    private final FileBox box;
    private final BoxWorker worker;

    public FileWorker(FileBox box, BoxWorker worker) {
        super(box);
        this.box = box;
        this.worker = worker;
    }

    @Override
    protected int[] objectsForOntology(int id) {
        return this.worker.objects(id);
    }

    @Override
    protected int[] objectsForClass(int id) {
        return this.worker.objects(id);
    }

    @Override
    protected int[] objectsDirectForClass(int id) {
        return this.worker.objectsDirect(id);
    }

    @Override
    protected int[] classesForClass(int id) {
        return this.worker.classes(id);
    }

    @Override
    protected int[] classesForObject(int id) {
        return this.worker.classes(id);
    }

    @Override
    protected int[] classesForOntology(int id) {
        return this.worker.classes(id);
    }

    @Override
    protected int[] classesDirectForClass(int id) {
        return this.worker.classesDirect(id);
    }

    @Override
    protected int[] classesDirectForObject(int id) {
        return this.worker.classesDirect(id);
    }

    @Override
    protected int[] classesDirectForOntology(int id) {
        return this.worker.classesDirect(id);
    }

    @Override
    protected int[] subclassesForClass(int id) {
        return this.worker.subclasses(id);
    }

    @Override
    protected int[] subclassesDirectForClass(int id) {
        return this.worker.subclassesDirect(id);
    }

    @Override
    protected int[] typesForOntology(int id) {
        return this.worker.types(id);
    }

    @Override
    protected int[] tpropsForClass(int id) {
        return this.worker.tprops(id);
    }

    @Override
    protected int[] tpropsForObject(int id) {
        return this.worker.tprops(id);
    }

    @Override
    protected int[] tpropsForOntology(int id) {
        return this.worker.tprops(id);
    }

    @Override
    protected int[] tpropsDirectForClass(int id) {
        return this.worker.tpropsDirect(id);
    }

    @Override
    protected int[] opropsForClass(int id) {
        return this.worker.oprops(id);
    }

    @Override
    protected int[] opropsForObject(int id) {
        return this.worker.oprops(id);
    }

    @Override
    protected int[] opropsForOntology(int id) {
        return this.worker.oprops(id);
    }

    @Override
    protected int[] opropsDirectForClass(int id) {
        return this.worker.opropsDirect(id);
    }

    @Override
    protected String[] stringsForTProperty(int id) {
        throw new UnsupportedOperationException();
    }

    protected File extractFile(int id) {
        if (RHelper.isInstanceOf(this.worker, id, this.worker.id("http://filebox.ontobox.org/#Resource"))) {
            String localName = this.worker.local(id);
            if (localName.equals("root")) {
                return this.box.roots.get(this.worker.name(id));
            }
            return new File(FileBox.decodePath(localName));
        }
        return null;
    }

    @Override
    protected String[] stringsForObject(int id, int prop) {
        File f = this.extractFile(id);
        if (f != null) {
            if (this.worker.id("http://filebox.ontobox.org/#name") == prop) {
                String[] ret = new String[]{f.getName()};
                if (ret[0].isEmpty()) {
                    ret[0] = f.getAbsolutePath();
                }
                return ret;
            }
            if (this.worker.id("http://filebox.ontobox.org/#fullName") == prop) {
                String[] ret = new String[]{f.getAbsolutePath()};
                return ret;
            }
        }
        return this.worker.strings(id, prop);
    }

    @Override
    protected int[] ovaluesForObject(int id, int prop) {
        File f = this.extractFile(id);
        if (f != null && this.worker.id("http://filebox.ontobox.org/#list") == prop) {
            File[] list = f.listFiles();
            int size = list.length;
            int[] ret = new int[size];
            for (int t = 0; t < size; ++t) {
                ret[t] = FileBox.makeFile(this.worker, list[t], this.worker.ontology(id));
            }
            return ret;
        }
        return EMPTY_INT;
    }

    @Override
    protected int[] ownersForOProperty(int prop, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int[] ownersForTProperty(int prop, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Integer rangeForTProperty(int id) {
        return this.worker.range(id);
    }

    @Override
    protected Integer rangeForOProperty(int id) {
        return this.worker.range(id);
    }

    @Override
    protected Integer domainForTProperty(int id) {
        return this.worker.domain(id);
    }

    @Override
    protected Integer domainForOProperty(int id) {
        return this.worker.domain(id);
    }

    @Override
    protected String annoForEntity(int id, String name) {
        return this.worker.anno(id, name);
    }

    @Override
    protected String[] annamesForEntity(int id) {
        return this.worker.annames(id);
    }

    @Override
    public BoxWriter write() {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public String name(int id) {
        return this.worker.name(id);
    }

    @Override
    public Integer id(String name) {
        return this.worker.id(name);
    }

    @Override
    public Entity entity(int id) {
        return this.worker.entity(id);
    }

    @Override
    public int[] ontologies() {
        return this.worker.ontologies();
    }

    @Override
    public <T> T clientDirect(BoxDirectClient<T> client) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTransactionId() {
        return 0;
    }

    @Override
    public boolean commit() {
        return false;
    }

    public boolean commitGCDisabled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback() {
    }

    @Override
    public void close() {
        this.worker.close();
    }
}

