/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto;

import com.teacode.exception.ExUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.TempHelper;
import org.ontobox.libretto.BreakException;
import org.ontobox.libretto.CalledFrom;
import org.ontobox.libretto.ChoicePoint;
import org.ontobox.libretto.ExceptionPass;
import org.ontobox.libretto.FieldContainer;
import org.ontobox.libretto.LabelException;
import org.ontobox.libretto.LibrettoEnv;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.M;
import org.ontobox.libretto.Modifier;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.PathStackRecord;
import org.ontobox.libretto.PredStackRecord;
import org.ontobox.libretto.PropValContainer;
import org.ontobox.libretto.ReturnException;
import org.ontobox.libretto.ThroughException;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.EntityId;
import org.ontobox.libretto.adapter.OPropertyId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.PropertyId;
import org.ontobox.libretto.adapter.TPropertyId;
import org.ontobox.libretto.adapter.TypeId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.collection.PathComparator;
import org.ontobox.libretto.datatype.DValue;
import org.ontobox.libretto.function.FunctionDef;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.function.OntCollectionCP;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.metalang.EmbeddedLanguage;
import org.ontobox.libretto.parser.Asterisk;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.Instruction;
import org.ontobox.libretto.parser.IterProg;
import org.ontobox.libretto.parser.KeyWord;
import org.ontobox.libretto.parser.Operation;
import org.ontobox.libretto.parser.Operator;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;
import org.ontobox.libretto.parser.VarTable;

public final class Interp {
    private static final Logger logger = Logger.getLogger(Interp.class.getName());
    public final LocalContext konto;
    private final VarTable vars;
    private final FunctionTable functions;
    private final Parser parser;
    private final Map<String, Object> fieldValues;
    public ObjectId editedObj = null;
    public PropertyId editedProp = null;
    String editedPropName;
    public Object objCreatorContext;
    private int yieldvar = -1;

    public Interp(LocalContext kn, VarTable vs, FunctionTable functions, Parser prs) {
        this.konto = kn;
        this.vars = vs;
        this.functions = functions;
        this.parser = prs;
        this.fieldValues = new HashMap<String, Object>();
    }

    void setModifier(Modifier md) {
    }

    public FunctionTable getFunctions() {
        return this.functions;
    }

    private static OntCollection formCollection(Object o) {
        if (o instanceof OntCollection) {
            return OntCC.newCol((OntCollection)o);
        }
        if (Interp.isFalse(o)) {
            return OntCC.newCol();
        }
        return OntCC.singleton(o);
    }

    public final OntCollection computePath(Token query) {
        Object o;
        Sequence seq = query.getSeq();
        this.vars.reset();
        Token pathInstr = seq.get(0);
        this.fieldValues.clear();
        OntCollection col = pathInstr.getType() == TokenType.PATH_EXP ? this.calcPath(null, pathInstr, CalledFrom.OUTSIDE, null, null, null) : ((o = this.calcPredicate(null, pathInstr, M.P_COMPUTE, null, null, null)) instanceof OntCollection ? (OntCollection)o : (Interp.isFalse(o) ? OntCC.newCol() : OntCC.singleton(o)));
        if (seq.size() == 1) {
            return col;
        }
        throw new RuntimeException("System error: global property command " + query.getPosition());
    }

    public ObjectId getModifiedObject() {
        return this.editedObj;
    }

    public Object applyOperators(Object oo, Sequence seq, Object ddot, Integer indx, Object previous) {
        if (seq.getParent().getType() == TokenType.SWITCH) {
            return this.calcSwitch(oo, seq.getParent(), ddot, indx, previous);
        }
        Object result = null;
        for (int i = 0; i < seq.size(); ++i) {
            Token command = seq.get(i);
            if (command.getType() == TokenType.ASSIGN_INSTR) {
                Token var = command.getSub(0);
                if (this.parser.isSpecVar(var)) {
                    throw new RuntimeException("The explicit assignment to system variables is forbidden (" + var + ") " + var.getPosition());
                }
                Token varvalue = command.getSub(1);
                Object res = this.calcPredicate(oo, varvalue, M.P_COMPUTE, ddot, indx, previous);
                this.vars.putVarValue(var, OntCC.normalize(res));
                continue;
            }
            if (command.getType() == TokenType.MAP) {
                oo = this.konto.createMap();
                continue;
            }
            if (command.getType() == TokenType.PROPERTY_COMMAND) {
                Token cpath = command.getSub(0);
                this.editedObj = null;
                OntCollection oc = Helper.wrapInCol(oo);
                result = this.calcPath(oc, cpath, CalledFrom.PRED, ddot, indx, previous);
                continue;
            }
            result = this.calcPredicate(oo, command, M.P_COMPUTE, ddot, indx, previous);
        }
        return result;
    }

    int modifyObj(Object mo, Token command, int inserted, Integer indx, Object previous) {
        Operator otype = Operator.values()[command.getValue()];
        ObjectId leditedObj = this.editedObj;
        Object lobjCreatorContext = this.objCreatorContext;
        String leditedPropName = this.editedPropName;
        PropertyId leditedProp = this.editedProp;
        if (leditedObj == null) {
            return inserted;
        }
        if (command.isRightmostEditedProp()) {
            Object res = null;
            if (otype != Operator.DELETE_VALUE) {
                Token cterm = command.getSub(0);
                if (command.isPropInObjCreator()) {
                    res = this.calcPredicate(lobjCreatorContext, cterm, M.P_COMPUTE, leditedObj, null, null);
                    if (Interp.isFalse(res)) {
                        if (otype == Operator.ASSIGN) {
                            throw new EmptyValException();
                        }
                        return inserted;
                    }
                } else {
                    res = this.calcPredicate(leditedObj, cterm, M.P_COMPUTE, leditedObj, null, null);
                }
            }
            if (res != null && res.equals(Boolean.FALSE)) {
                res = OntCC.newCol();
            }
            if (leditedProp == null) {
                leditedProp = ((OntCollection)res).isDataCol() ? TPropertyId.newId(MapHelper.tkey(this.konto.getWorker(), leditedObj.id(), leditedPropName)) : OPropertyId.newId(MapHelper.okey(this.konto.getWorker(), leditedObj.id(), leditedPropName));
            }
            switch (otype) {
                case DELETE_VALUE: {
                    this.konto.removePropValues(leditedObj, leditedProp);
                    break;
                }
                case ASSIGN: {
                    this.konto.removePropValues(leditedObj, leditedProp);
                    this.konto.addPropValues(leditedObj, leditedProp, res, 0);
                    break;
                }
                case INSERT_AFTER: {
                    int num = this.konto.getPropValNumber(leditedObj, leditedProp);
                    this.konto.addPropValues(leditedObj, leditedProp, res, inserted);
                    break;
                }
                case INSERT_BEFORE: {
                    this.konto.addPropValues(leditedObj, leditedProp, res, 0);
                }
            }
        } else {
            if (!(mo instanceof PropValContainer)) {
                throw new RuntimeException("Something wrong with a modified value in property command " + command.getPosition());
            }
            PropValContainer pc = (PropValContainer)mo;
            int index = pc.getIndex() + inserted;
            Object res = null;
            if (otype != Operator.DELETE_VALUE) {
                Token cterm = command.getSub(0);
                res = this.calcPredicate(mo, cterm, M.P_COMPUTE, mo, indx, previous);
                if (!(res instanceof OntCollection)) {
                    res = Boolean.FALSE.equals(res) ? OntCC.newCol() : OntCC.newCol().addAllTyped(res);
                }
                if (leditedProp == null) {
                    leditedProp = ((OntCollection)res).isDataCol() ? TPropertyId.newId(MapHelper.tkey(this.konto.getWorker(), leditedObj.id(), leditedPropName)) : OPropertyId.newId(MapHelper.okey(this.konto.getWorker(), leditedObj.id(), leditedPropName));
                }
            }
            switch (otype) {
                case ASSIGN: {
                    this.konto.removePropValue(leditedObj, leditedProp, index);
                    --inserted;
                    this.konto.addPropValues(leditedObj, leditedProp, res, index);
                    inserted += ((OntCollection)res).size();
                    break;
                }
                case DELETE_VALUE: {
                    this.konto.removePropValue(leditedObj, leditedProp, index);
                    --inserted;
                    break;
                }
                case INSERT_AFTER: {
                    this.konto.addPropValues(leditedObj, leditedProp, res, index + 1);
                    inserted += ((OntCollection)res).size();
                    break;
                }
                case INSERT_BEFORE: {
                    this.konto.addPropValues(leditedObj, leditedProp, res, index);
                    inserted += ((OntCollection)res).size();
                }
            }
        }
        return inserted;
    }

    public OntCollection createObjOrMap(Token cur, Integer indx, Object previous) {
        OntCollection result = OntCC.newCol();
        EntityId objOrMap = null;
        Sequence mapseq = cur.getSeq();
        BoxWorker worker = this.konto.getWorker();
        ArrayList<ClassId> cls = new ArrayList<ClassId>();
        block7: for (Token tk : mapseq) {
            TokenType type = tk.getType();
            switch (type) {
                case MAP: 
                case OBJ_NAME: {
                    if (objOrMap != null) {
                        result.addAllTyped(objOrMap);
                    }
                    EntityId entityId = objOrMap = type == TokenType.MAP ? this.konto.createMap() : this.konto.getObject(tk, KeyWord.CREATE_OR_UPDATE);
                    if (tk.isTemporaryObj()) {
                        TempHelper.makeTemporary(worker, objOrMap.id());
                    }
                    for (ClassId sup : cls) {
                        if (RHelper.isInstanceOf(worker, objOrMap.id(), sup.id())) continue;
                        worker.write().addObjectClass(objOrMap.id(), sup.id());
                    }
                    continue block7;
                }
                case CLASS_NAME: {
                    ClassId sup = this.konto.getClass(tk.getName(), this.konto.getTokenURI(tk), KeyWord.UPDATE);
                    cls.add(sup);
                    break;
                }
                case OBJ_MODIFIER: {
                    try {
                        this.applyOperators(objOrMap, tk.getSeq(), objOrMap, indx, previous);
                        break;
                    }
                    catch (EmptyValException e) {
                        this.konto.getWorker().write().delete(objOrMap.id());
                        objOrMap = null;
                    }
                }
            }
        }
        if (objOrMap != null) {
            result.addAllTyped(objOrMap);
        }
        return result;
    }

    private Object calcSwitch(Object curvalue, Token swtch, Object ddot, Integer indx, Object previous) {
        Sequence sw = swtch.getSeq();
        for (int i = 0; i < sw.size(); i += 2) {
            Token cond = sw.get(i);
            if (cond != null && !Interp.isTrue(this.calcPredicate(curvalue, cond, M.P_COMPUTE, ddot, indx, previous))) continue;
            return this.calcPredicate(curvalue, sw.get(i + 1), M.P_COMPUTE, ddot, indx, previous);
        }
        return Boolean.FALSE;
    }

    OntCollection generateSeq(OntCollection input, IterProg prog) {
        Map<String, List<Instruction>> program = prog.code;
        Boolean previous = Boolean.FALSE;
        Integer indx = -1;
        String curstate = "start";
        OntCollection result = OntCC.newCol();
        boolean thesame = false;
        HashSet sameset = new HashSet();
        Iterator elit = input.iterator();
        Object ooo = null;
        if (elit.hasNext()) {
            ooo = elit.next();
        }
        boolean first = true;
        block0: while (first || ooo != null) {
            Integer n = indx;
            Integer n2 = indx = Integer.valueOf(indx + 1);
            List<Instruction> curinstr = program.get(curstate);
            if (curinstr == null) {
                if (curstate.equals("stop")) break;
                throw new RuntimeException("State '" + curstate + "' is undefined.");
            }
            boolean success = false;
            for (Instruction instr : curinstr) {
                if (instr.condition != null && !Interp.isTrue(this.eval(ooo, instr.condition, indx, previous))) continue;
                success = true;
                thesame = instr.thesame;
                Sequence newval = instr.newvalues;
                if (instr.newstate != null && instr.newstate.equals("error")) {
                    throw new RuntimeException("Composer reports error at value " + Helper.shortenString(ooo) + ": " + this.eval(ooo, newval.get(0), indx, previous));
                }
                sameset.clear();
                for (Token tok : instr.newvalues) {
                    if (tok.getType() == TokenType.YIELD) {
                        result.addAllTyped(this.eval(ooo, tok.getSub(0), indx, previous));
                        continue;
                    }
                    this.eval(ooo, tok, indx, previous);
                }
                if (curstate.equals("stop")) break block0;
                curstate = instr.newstate;
                break;
            }
            if (!success) {
                throw new RuntimeException("Failed to handle value " + Helper.shortenString(ooo) + " at state " + curstate);
            }
            if (curstate == null) break;
            if (thesame) continue;
            first = false;
            previous = ooo;
            if (elit.hasNext()) {
                ooo = elit.next();
                continue;
            }
            if (!program.containsKey("stop")) break;
            curstate = "stop";
        }
        return result;
    }

    public OntCollection modifyObjects(OntCollection col, Token modifier, Integer indx, Object previous) {
        Sequence seq = modifier.getSeq();
        OntCollection result = OntCC.newCol();
        if (col == null) {
            this.applyOperators(null, seq, null, null, null);
            return result;
        }
        for (Object oo : col) {
            oo = ObjectContainer.getObject(oo);
            try {
                this.applyOperators(oo, seq, oo, indx, previous);
            }
            catch (BreakException e) {
                throw new BreakException(result);
            }
            result.addAllTyped(oo);
        }
        this.editedObj = null;
        return result;
    }

    private static boolean manageCollection(OntCollection oc, Deque<Object> ipStack, int curpoint, Deque<PredStackRecord> stack) {
        if (oc == null) {
            ipStack.push(Boolean.FALSE);
            return false;
        }
        if (oc.isEmpty()) {
            ipStack.push(Boolean.FALSE);
            return false;
        }
        if (oc.size() == 1) {
            Object m = oc.get(0);
            if (m instanceof ChoicePoint) {
                return Interp.manageCollection(((ChoicePoint)m).getCollection(), ipStack, curpoint, stack);
            }
            ipStack.push(m);
            return false;
        }
        new PredStackRecord(oc, curpoint, ipStack, stack);
        return true;
    }

    private static Object isInCollection(Object obj, Collection col) {
        boolean contains = false;
        for (Object ooo : col) {
            if (!ooo.equals(obj)) continue;
            return obj;
        }
        return Boolean.FALSE;
    }

    private static Collection toIntCollection(Collection col) {
        OntCollection oc = OntCC.newCol();
        for (Object ooo : col) {
            oc.addAllTyped(Integer.valueOf((String)ooo));
        }
        return oc;
    }

    private OntCollection getAllInCP(ChoicePoint rec) {
        OntCollection c = OntCC.newCol();
        while (rec.hasNext()) {
            c.addAllTyped(rec.next());
        }
        return c;
    }

    private String stringSegment(Token cur, Object curvalue, Integer indx, Object previous) {
        Sequence s = cur.getSeq();
        Token tok = s.get(0);
        String rstr = (String)tok.getObj();
        for (int i = 1; i < s.size(); i += 2) {
            tok = s.get(i);
            Object o = this.calcPredicate(curvalue, tok, M.P_COMPUTE, null, indx, previous);
            if (o instanceof OntCollection) {
                if (((OntCollection)o).size() == 1) {
                    o = ((OntCollection)o).get(0);
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (Object e : (OntCollection)o) {
                        sb.append(e.toString());
                    }
                    o = sb.toString();
                }
            }
            if (o instanceof ObjectContainer) {
                o = ObjectContainer.getObject(o);
            }
            if (Interp.isFalse(o)) {
                o = "()";
            } else if (o instanceof ObjectId) {
                o = this.konto.getWorker().name(((ObjectId)o).id());
            }
            rstr = rstr + o.toString() + s.get(i + 1).getObj();
        }
        return rstr;
    }

    public Object calcPredicate(Object curvalue, Token prTok, M mode, Object ddot, Integer indx, Object previous) {
        Iterator collectionIt;
        if (prTok.getType() == TokenType.QUOTED_EXP) {
            if (mode != M.P_COMPUTE) {
                throw new RuntimeException("Misplaced quoted expression " + prTok.getPosition());
            }
            return this.createClosure(prTok);
        }
        Sequence pred = prTok.getType() != TokenType.TERM_EXP ? prTok.createSingleton() : prTok.getSeq();
        ArrayDeque<PredStackRecord> stack = new ArrayDeque<PredStackRecord>();
        ArrayDeque<Object> ipStack = new ArrayDeque<Object>();
        OntCollection collection = null;
        int index = 0;
        if (Interp.isFalse(curvalue)) {
            curvalue = Boolean.FALSE;
            collectionIt = OntCC.newCol().iterator();
        } else if (curvalue instanceof OntCollection) {
            collection = (OntCollection)curvalue;
            collectionIt = collection.iterator();
            curvalue = collectionIt.next();
        } else {
            collectionIt = OntCC.newCol().iterator();
        }
        boolean isStatic = true;
        OntCollection filter = OntCC.newCol();
        int curpoint = pred.size() - 1;
        OntCollection result = OntCC.newCol();
        if (curvalue == null) {
            curvalue = Boolean.FALSE;
        }
        while (true) {
            Object o;
            Token cur = pred.get(curpoint);
            TokenType type = cur.getType();
            switch (type) {
                case VAR_REF: {
                    OntCollection oc;
                    int varnum = cur.getValue();
                    if (this.parser.isSpecVar(cur)) {
                        if (varnum == this.konto.getHandler().indexVarNumber) {
                            if (indx == null) {
                                throw new RuntimeException("The index value for $_i is not determined " + cur.getPosition());
                            }
                            ipStack.push(indx);
                            isStatic = false;
                            break;
                        }
                        if (varnum == this.konto.getHandler().thisVarNumber) {
                            isStatic = false;
                            ipStack.push(curvalue);
                            break;
                        }
                        if (varnum == this.konto.getHandler().prevVarNumber) {
                            if (previous == null) {
                                throw new RuntimeException("The previous value for $_prev is not determined " + cur.getPosition());
                            }
                            isStatic = false;
                            ipStack.push(previous);
                            break;
                        }
                    }
                    if ((o = this.vars.getVarValue(varnum)) == null) {
                        if (varnum < 0) {
                            throw new RuntimeException("Local variable is not instantiated $" + cur.getName() + ' ' + cur.getPosition());
                        }
                        throw new RuntimeException("Global variable is not instantiated $" + cur.getName() + ' ' + cur.getPosition());
                    }
                    if (o instanceof OntCollection) {
                        oc = (OntCollection)o;
                        if (curpoint == 0) {
                            result.addAllTyped(oc);
                            ipStack.push(!oc.isEmpty());
                            break;
                        }
                        Interp.manageCollection(oc, ipStack, curpoint, stack);
                        break;
                    }
                    ipStack.push(o);
                    break;
                }
                case MAP_OBJECT_CREATOR: {
                    this.objCreatorContext = curvalue;
                    OntCollection oc = this.createObjOrMap(cur, indx, previous);
                    if (Interp.isFalse(oc)) {
                        ipStack.push(Boolean.FALSE);
                        break;
                    }
                    if (curpoint == 0) {
                        result.addAllTyped(oc);
                        ipStack.push(!oc.isEmpty());
                        break;
                    }
                    Interp.manageCollection(oc, ipStack, curpoint, stack);
                    break;
                }
                case PROP_NAME: {
                    OntCollection oc;
                    isStatic = false;
                    Object curval = curvalue instanceof ObjectContainer ? ((ObjectContainer)curvalue).getObject() : curvalue;
                    PropertyId pp = this.konto.getProperty(cur);
                    if (curval.equals(Boolean.FALSE)) {
                        if (pp == null && !cur.isKey()) {
                            throw new RuntimeException("Property '" + this.konto.getFullName(cur) + "' not found");
                        }
                        ipStack.push(Boolean.FALSE);
                        break;
                    }
                    if (curval instanceof EntityId && !(curval instanceof ObjectId)) {
                        if (!cur.isKey()) {
                            throw new RuntimeException("Only @keys can be used as entity annotations");
                        }
                        int eid = ((EntityId)curval).id();
                        String key = this.konto.getFullName(cur);
                        String annoValue = this.konto.getWorker().anno(eid, key);
                        if (annoValue != null) {
                            ipStack.push(annoValue);
                            break;
                        }
                        ipStack.push(Boolean.FALSE);
                        break;
                    }
                    if (!(curval instanceof ObjectId)) {
                        throw new RuntimeException("Invalid attempt to apply property '" + this.konto.getFullName(cur) + "' to a non-object");
                    }
                    ObjectId oo = (ObjectId)curval;
                    String uri = this.konto.getTokenURI(cur);
                    try {
                        BoxWorker worker = this.konto.getWorker();
                        this.konto.getLE();
                        int fnum = LibrettoEnv.getGetter(this.konto, cur);
                        oc = fnum != -1 ? OntCC.newCol().addAllTyped(this.calcSGetter(oo, null, fnum)) : (pp instanceof OPropertyId ? OntCC.newCol(worker, worker.objects(oo.id(), pp.id())) : this.konto.typedCollection(Arrays.asList(worker.strings(oo.id(), pp.id())), (TPropertyId)pp));
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = oc;
                            } else {
                                result.addAllTyped(oc);
                            }
                            ipStack.push(!oc.isEmpty());
                            break;
                        }
                        Interp.manageCollection(oc, ipStack, curpoint, stack);
                    }
                    catch (Exception e) {
                        if (!cur.isKey() && pp == null) {
                            throw new RuntimeException("The property '" + cur + "' not found");
                        }
                        if (this.konto.isMap(oo)) {
                            oc = this.konto.getMapKeyValues(oo, cur.getName());
                            if (oc == null) {
                                oc = OntCC.newCol();
                            }
                            if (curpoint == 0) {
                                if (result.isEmpty()) {
                                    result = oc;
                                } else {
                                    result.addAllTyped(oc);
                                }
                                ipStack.push(!oc.isEmpty());
                                break;
                            }
                            Interp.manageCollection(oc, ipStack, curpoint, stack);
                            break;
                        }
                        ipStack.push(Boolean.FALSE);
                    }
                    break;
                }
                case PATH_EXP: {
                    Sequence seq = cur.getSeq();
                    if (!seq.isAbsolutePath()) {
                        isStatic = false;
                    }
                    OntCollection col = Interp.isFalse(curvalue) ? null : (curvalue instanceof ChoicePoint ? ((ChoicePoint)curvalue).getCollection() : OntCC.singleton(curvalue));
                    OntCollection resc = this.calcPath(col, cur, CalledFrom.PRED, ddot, indx, previous);
                    if (curpoint == 0) {
                        if (result.isEmpty()) {
                            result = resc;
                        } else {
                            result.addAllTyped(resc);
                        }
                        ipStack.push(!resc.isEmpty());
                        break;
                    }
                    Interp.manageCollection(resc, ipStack, curpoint, stack);
                    break;
                }
                case QUOTED_EXP: {
                    ipStack.push(this.createClosure(cur));
                    break;
                }
                case ANONYM_FUN: {
                    o = this.applyOperators(curvalue, cur.getSeq(), ddot, indx, previous);
                    OntCollection resc = o instanceof OntCollection ? (OntCollection)o : (Interp.isFalse(o) ? OntCC.newCol() : OntCC.singleton(o));
                    if (curpoint == 0) {
                        result = resc;
                        ipStack.push(!resc.isEmpty());
                        break;
                    }
                    Interp.manageCollection(resc, ipStack, curpoint, stack);
                    break;
                }
                case CLOSURE: {
                    Token fun = cur.getSub(0);
                    Object[] rargs1 = (Object[])cur.getObj();
                    rargs1[0] = curvalue;
                    if (fun.getType() != TokenType.ANONYM_FUN) {
                        throw new RuntimeException("Use '!' or functions eval/1 and eval/2 for handling anonymous functions");
                    }
                    Token body = fun;
                    this.vars.pushEnv(rargs1, (HashMap)fun.getObj());
                    try {
                        o = this.applyOperators(curvalue, body.getSeq(), ddot, indx, previous);
                    }
                    catch (RuntimeException e) {
                        throw new RuntimeException(e.getMessage() + " in anonymous function");
                    }
                    OntCollection resc = OntCC.newCol();
                    if (o != null && !o.equals(Boolean.FALSE)) {
                        resc.addAllTyped(o);
                    }
                    this.vars.popEnv();
                    if (curpoint == 0) {
                        result = resc;
                        ipStack.push(!resc.isEmpty());
                        break;
                    }
                    Interp.manageCollection(resc, ipStack, curpoint, stack);
                    break;
                }
                case EMBEDDED_LANG: {
                    List al = (List)cur.getObj();
                    EmbeddedLanguage el = (EmbeddedLanguage)al.get(0);
                    Object code = al.get(1);
                    OntCollection col = Interp.isFalse(curvalue) ? OntCC.newCol() : OntCC.singleton(curvalue);
                    OntCollection resc = el.execute(this.konto, code, col);
                    if (curpoint == 0) {
                        result = resc;
                        ipStack.push(!resc.isEmpty());
                        break;
                    }
                    Interp.manageCollection(resc, ipStack, curpoint, stack);
                    break;
                }
                case FORALL_QUANT: {
                    isStatic = false;
                    Token pth = cur.getSub();
                    OntCollection col = Interp.isFalse(curvalue) ? null : OntCC.singleton(curvalue);
                    col = this.calcPath(col, pth, CalledFrom.PATH, ddot, indx, previous);
                    if (col.isEmpty()) {
                        if (cur.getValue() == 2) {
                            ipStack.push(Boolean.FALSE);
                            break;
                        }
                        ipStack.push(Boolean.TRUE);
                        break;
                    }
                    Token ps = cur.getSub(1);
                    o = this.calcPredicate(col, ps.getSub(), M.P_ALL, ddot, indx, previous);
                    if (o instanceof OntCollection) {
                        ipStack.push(!((OntCollection)o).isEmpty());
                        break;
                    }
                    ipStack.push(o);
                    break;
                }
                case ASTERISK: {
                    OntCollection resc;
                    if (cur.getValue() == Asterisk.AST_ALL.ordinal()) {
                        resc = this.konto.getAllObjects();
                    } else {
                        String uri = this.konto.getTokenURI(cur);
                        if (uri == null) {
                            if (cur.getPrefix() == null) {
                                throw new RuntimeException("Default ontology not defined in '*' " + cur.getPosition());
                            }
                            throw new RuntimeException("Ontology with prefix '" + cur.getPrefix() + "' not defined" + cur.getPosition());
                        }
                        resc = OntCC.newCol(CollectionType.OBJECT_COL);
                        resc.addAll(this.konto.getAllOntObjects(uri));
                    }
                    if (curpoint == 0) {
                        result = resc;
                        ipStack.push(!resc.isEmpty());
                        break;
                    }
                    Interp.manageCollection(resc, ipStack, curpoint, stack);
                    break;
                }
                case INDX: {
                    ipStack.push(indx);
                    break;
                }
                case BASIC_TYPE: {
                    ipStack.push(cur.getObj());
                    break;
                }
                case DOT: {
                    OntCollection oc;
                    isStatic = false;
                    if (Interp.isFalse(curvalue)) {
                        if (ddot == null) {
                            ipStack.push(Boolean.FALSE);
                            break;
                        }
                        if (ddot instanceof OntCollection) {
                            if (curpoint == 0) {
                                if (result.isEmpty()) {
                                    result = Interp.formCollection(ddot);
                                } else {
                                    result.addAllTyped(ddot);
                                }
                                ipStack.push(!((OntCollection)ddot).isEmpty());
                                break;
                            }
                            Interp.manageCollection((OntCollection)ddot, ipStack, curpoint, stack);
                            break;
                        }
                        ipStack.push(ddot);
                        break;
                    }
                    if (curvalue instanceof OntCollectionCP) {
                        oc = ((OntCollectionCP)curvalue).getCollection();
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = Interp.formCollection(oc);
                            } else {
                                result.addAllTyped(oc);
                            }
                            ipStack.push(!oc.isEmpty());
                            break;
                        }
                        Interp.manageCollection(oc, ipStack, curpoint, stack);
                        break;
                    }
                    ipStack.push(curvalue);
                    break;
                }
                case DDOT: {
                    isStatic = false;
                    if (ddot == null) {
                        throw new RuntimeException("'..' is not determined '" + cur.getName() + "' " + cur.getPosition());
                    }
                    if (ddot instanceof OntCollection) {
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = Interp.formCollection(ddot);
                            } else {
                                result.addAllTyped(ddot);
                            }
                            ipStack.push(!((OntCollection)ddot).isEmpty());
                            break;
                        }
                        Interp.manageCollection((OntCollection)ddot, ipStack, curpoint, stack);
                        break;
                    }
                    ipStack.push(ddot);
                    break;
                }
                case YIELD: {
                    o = this.calcPredicate(curvalue, cur.getSub(0), M.P_COMPUTE, ddot, null, null);
                    OntCollection oc = (OntCollection)this.vars.getVarValue(this.yieldvar);
                    oc.addAllTyped(o);
                    if (o instanceof OntCollection) {
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = Interp.formCollection(o);
                            } else {
                                result.addAllTyped(o);
                            }
                            ipStack.push(!((OntCollection)o).isEmpty());
                            break;
                        }
                        Interp.manageCollection((OntCollection)o, ipStack, curpoint, stack);
                        break;
                    }
                    ipStack.push(o);
                    break;
                }
                case RETURN: {
                    o = cur.getSeq().size() == 1 ? this.calcPredicate(curvalue, cur.getSub(0), M.P_COMPUTE, ddot, indx, previous) : OntCC.newCol();
                    throw new ReturnException(o);
                }
                case GET_FIELD: {
                    if (!this.fieldValues.containsKey(cur.getName())) {
                        throw new RuntimeException("Can not retrieve data from undefined field '" + cur.getName() + "' " + cur.getPosition());
                    }
                    ipStack.push(this.fieldValues.get(cur.getName()));
                    break;
                }
                case OBJ_NAME: {
                    ObjectId oo = this.konto.getOntObject(cur);
                    ipStack.push(oo);
                    break;
                }
                case ENTITY_TYPE: {
                    ipStack.push(cur.getObj());
                    break;
                }
                case PROPERTY_COMMAND: {
                    Token cpath = cur.getSub(0);
                    this.editedObj = null;
                    OntCollection col = Interp.isFalse(curvalue) ? null : OntCC.singleton(curvalue);
                    result = this.calcPath(col, cpath, CalledFrom.PRED, col, indx, previous);
                    break;
                }
                case OPER: {
                    Object arg1;
                    int oper;
                    if (cur.isPrefixOp()) {
                        oper = cur.getValue();
                        arg1 = ipStack.pop();
                        if (arg1 instanceof ObjectContainer) {
                            arg1 = ((ObjectContainer)arg1).getObject();
                        }
                        Operation opt = Operation.values()[oper];
                        switch (opt) {
                            case UMINUS: {
                                if (arg1 instanceof Integer) {
                                    int n = (Integer)arg1;
                                    ipStack.push(-n);
                                    break;
                                }
                                try {
                                    double f = Interp.getDouble(arg1, cur);
                                    ipStack.push(-f);
                                }
                                catch (FailureException e) {
                                    ipStack.push(Boolean.FALSE);
                                }
                                break;
                            }
                            case NOT: {
                                ipStack.push(!Interp.getBoolean(arg1));
                            }
                        }
                        break;
                    }
                    oper = cur.getValue();
                    Object arg2 = ipStack.pop();
                    arg1 = ipStack.pop();
                    if (arg1 instanceof ObjectContainer) {
                        arg1 = ((ObjectContainer)arg1).getObject();
                    }
                    if (arg2 instanceof ObjectContainer) {
                        arg2 = ((ObjectContainer)arg2).getObject();
                    }
                    if (oper == Operation.AND.ordinal()) {
                        ipStack.push(Interp.getBoolean(arg1) && Interp.getBoolean(arg2));
                        break;
                    }
                    if (oper == Operation.OR.ordinal()) {
                        ipStack.push(Interp.getBoolean(arg1) || Interp.getBoolean(arg2));
                        break;
                    }
                    if (Interp.isFalse(arg1) || Interp.isFalse(arg2)) {
                        if (oper == Operation.NEQ.ordinal()) {
                            ipStack.push(Boolean.TRUE);
                            break;
                        }
                        ipStack.push(Boolean.FALSE);
                        break;
                    }
                    if (arg1 instanceof EntityId) {
                        if (arg2 instanceof EntityId) {
                            ipStack.push(this.objectRel((EntityId)arg1, (EntityId)arg2, oper, cur));
                            break;
                        }
                        throw new RuntimeException("Error in application of arithmetic operator/relation to objects " + cur.getPosition());
                    }
                    if (oper == Operation.MULT.ordinal() || oper == Operation.PLUS.ordinal() || oper == Operation.MINUS.ordinal() || oper == Operation.DIV.ordinal() || oper == Operation.MOD.ordinal()) {
                        try {
                            ipStack.push(Interp.arithOp(arg1, arg2, oper, cur));
                        }
                        catch (FailureException e) {
                            ipStack.push(Boolean.FALSE);
                        }
                        break;
                    }
                    if (oper == Operation.PPLUS.ordinal()) {
                        ipStack.push(arg1.toString() + arg2.toString());
                        break;
                    }
                    if (oper == Operation.IN.ordinal()) {
                        Object set = cur.getObj();
                        if (set instanceof Token) {
                            if ((set = this.calcPredicate(null, (Token)set, M.P_COMPUTE, null, indx, previous)) instanceof ChoicePoint) {
                                set = ((ChoicePoint)set).getCollection();
                            }
                            if (set instanceof OntCollection && ((OntCollection)set).size() == 1) {
                                Object m = ((OntCollection)set).get(0);
                                if (m instanceof ChoicePoint) {
                                    set = ((ChoicePoint)m).getCollection();
                                } else if (this.konto.isMap(m)) {
                                    set = m;
                                }
                            }
                            if (!(set instanceof OntCollection)) {
                                throw new RuntimeException("The 2nd argument of 'in' must be either a sequence or a map");
                            }
                        }
                        if (set instanceof Map) {
                            int monthi;
                            Date date = this.konto.getNormalizedDate(arg1.toString());
                            if (date == null) {
                                throw new RuntimeException("If the 2nd argument of 'in' is map, then the 1st must be a date");
                            }
                            Map datedata = (Map)set;
                            boolean datein = true;
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTime(date);
                            if (datedata.containsKey("year")) {
                                int yeari = cal.get(1);
                                boolean bl = datein = datein && Interp.isInCollection(yeari, (Collection)datedata.get("year")) != null;
                            }
                            if (datedata.containsKey("month")) {
                                monthi = cal.get(2) + 1;
                                boolean bl = datein = datein && Interp.isInCollection(monthi, (Collection)datedata.get("month")) != null;
                            }
                            if (datedata.containsKey("day")) {
                                monthi = cal.get(5);
                                datein = datein && Interp.isInCollection(monthi, (Collection)datedata.get("day")) != null;
                            }
                            ipStack.push(datein);
                            break;
                        }
                        ipStack.push(Interp.isInCollection(arg1, (Collection)set));
                        break;
                    }
                    try {
                        ipStack.push(Interp.arithRel(arg1, arg2, oper, cur));
                    }
                    catch (FailureException e) {
                        ipStack.push(Boolean.FALSE);
                    }
                    break;
                }
                case ASSIGN_INSTR: {
                    Sequence ss = cur.getSeq();
                    Token vr = ss.get(0);
                    if (this.parser.isSpecVar(vr)) {
                        throw new RuntimeException("The explicit assignment to system variables is forbidden (" + vr + ") " + vr.getPosition());
                    }
                    Token tr = ss.get(1);
                    isStatic = false;
                    o = this.calcPredicate(curvalue, tr, M.P_COMPUTE, ddot, indx, previous);
                    this.vars.putVarValue(vr, o);
                    if (o instanceof OntCollection) {
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = Interp.formCollection(o);
                            } else {
                                result.addAllTyped(o);
                            }
                            ipStack.push(!((OntCollection)o).isEmpty());
                            break;
                        }
                        Interp.manageCollection((OntCollection)o, ipStack, curpoint, stack);
                        break;
                    }
                    ipStack.push(o);
                    break;
                }
                case PREDICATE: {
                    isStatic = false;
                    o = this.calcPredicate(curvalue, cur.getSub(), M.P_COMPUTE, ddot, indx, previous);
                    if (o instanceof OntCollection) {
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = Interp.formCollection(o);
                            } else {
                                result.addAllTyped(o);
                            }
                            ipStack.push(!((OntCollection)o).isEmpty());
                            break;
                        }
                        Interp.manageCollection((OntCollection)o, ipStack, curpoint, stack);
                        break;
                    }
                    ipStack.push(o);
                    break;
                }
                case SWITCH: {
                    isStatic = false;
                    o = this.calcSwitch(curvalue, cur, ddot, indx, previous);
                    if (o instanceof OntCollection) {
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = Interp.formCollection(o);
                            } else {
                                result.addAllTyped(o);
                            }
                            ipStack.push(!((OntCollection)o).isEmpty());
                            break;
                        }
                        Interp.manageCollection((OntCollection)o, ipStack, curpoint, stack);
                        break;
                    }
                    ipStack.push(o);
                    break;
                }
                case STRING_SEGMENT: {
                    isStatic = false;
                    String rstr = this.stringSegment(cur, curvalue, indx, previous);
                    if (rstr == null) {
                        ipStack.push(Boolean.FALSE);
                        break;
                    }
                    ipStack.push(rstr);
                    break;
                }
                case IF_EXP: 
                case FOR_EXP: {
                    isStatic = false;
                    OntCollection col = Interp.isFalse(curvalue) ? null : OntCC.singleton(curvalue);
                    OntCollection resc = this.calcPath(col, cur, CalledFrom.PRED, ddot, indx, previous);
                    if (curpoint == 0) {
                        if (result.isEmpty()) {
                            result = resc;
                        } else {
                            result.addAllTyped(resc);
                        }
                        ipStack.push(!resc.isEmpty());
                        break;
                    }
                    Interp.manageCollection(resc, ipStack, curpoint, stack);
                    break;
                }
                case FUN_CALL: {
                    isStatic = false;
                    if (ddot != null && !(ddot instanceof OntCollection)) {
                        ddot = OntCC.singleton(ddot);
                    }
                    if ((o = this.calcFunction(cur, curvalue, (OntCollection)ddot, index, ddot, previous)) == null) {
                        ipStack.push(Boolean.FALSE);
                        break;
                    }
                    if (o instanceof ChoicePoint) {
                        ChoicePoint rec = (ChoicePoint)o;
                        if (curpoint == 0) {
                            OntCollection c = this.getAllInCP(rec);
                            if (result.isEmpty()) {
                                result = Interp.formCollection(c);
                                break;
                            }
                            result.addAllTyped(c);
                            break;
                        }
                        if (!rec.hasNext()) {
                            ipStack.push(Boolean.FALSE);
                            break;
                        }
                        ipStack.push(rec.next());
                        if (!rec.hasNext()) break;
                        new PredStackRecord((ChoicePoint)o, curpoint, ipStack, stack);
                        break;
                    }
                    if (o instanceof OntCollection) {
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = Interp.formCollection(o);
                            } else {
                                result.addAllTyped(o);
                            }
                            ipStack.push(!((OntCollection)o).isEmpty());
                            break;
                        }
                        Interp.manageCollection((OntCollection)o, ipStack, curpoint, stack);
                        break;
                    }
                    ipStack.push(o);
                    break;
                }
                case CLASS_NAME: {
                    OntCollection oc = OntCC.newCol();
                    if (Interp.isFalse(curvalue)) {
                        Collection<ObjectId> ls = ObjectId.convert(this.konto.getWorker(), this.konto.getClassObjects(cur));
                        oc = OntCC.newCol(ls);
                        if (curpoint == 0) {
                            if (result.isEmpty()) {
                                result = oc;
                            } else {
                                result.addAllTyped(oc);
                            }
                            ipStack.push(!oc.isEmpty());
                            break;
                        }
                        Interp.manageCollection(oc, ipStack, curpoint, stack);
                        break;
                    }
                    if (curvalue instanceof ObjectId) {
                        ClassId cl = this.konto.getOntClass(cur);
                        if (RHelper.isInstanceOf(this.konto.getWorker(), ((ObjectId)curvalue).id(), cl.id())) {
                            ipStack.push(curvalue);
                            break;
                        }
                        ipStack.push(Boolean.FALSE);
                        break;
                    }
                    ipStack.push(Boolean.FALSE);
                    break;
                }
                case BREAK: {
                    throw new BreakException();
                }
                case SET_EXP: {
                    isStatic = false;
                    Sequence pps = cur.getSeq();
                    OntCollection res = null;
                    for (int i = 0; i < pps.size(); ++i) {
                        o = this.calcPredicate(curvalue, pps.get(i), M.P_COMPUTE, ddot, indx, previous);
                        if (res == null) {
                            res = Interp.formCollection(o);
                            continue;
                        }
                        res.addAllTyped(o);
                    }
                    if (curpoint == 0) {
                        if (result.isEmpty()) {
                            result = res;
                        } else {
                            result.addAllTyped(res);
                        }
                        if (res == null) {
                            result = res = OntCC.newCol();
                        }
                        ipStack.push(!res.isEmpty());
                        break;
                    }
                    Interp.manageCollection(res, ipStack, curpoint, stack);
                }
            }
            if (curpoint == 0) {
                PredStackRecord frame;
                o = ipStack.peek();
                Object ooo = o;
                if (o instanceof ObjectContainer) {
                    o = ((ObjectContainer)o).getObject();
                }
                if (o instanceof OntCollectionCP) {
                    o = ((OntCollectionCP)o).getCollection();
                }
                if (o instanceof Boolean) {
                    if (((Boolean)o).booleanValue()) {
                        if (result.isEmpty()) {
                            result.addAllTyped(Boolean.TRUE);
                        }
                        if (mode == M.P_CHECK) {
                            return Boolean.TRUE;
                        }
                        if (mode == M.P_FILTER || mode == M.P_ALL) {
                            filter.addAllTyped(curvalue);
                            if (collectionIt.hasNext()) {
                                curvalue = collectionIt.next();
                                ++index;
                                curpoint = pred.size() - 1;
                                ipStack.clear();
                                stack.clear();
                                continue;
                            }
                            if (mode == M.P_FILTER) {
                                return filter;
                            }
                            return Boolean.TRUE;
                        }
                        if (stack.isEmpty()) {
                            if (collectionIt.hasNext() && !isStatic) {
                                curvalue = collectionIt.next();
                                ++index;
                                curpoint = pred.size() - 1;
                                ipStack.clear();
                                continue;
                            }
                            if (result.isEmpty()) {
                                return Boolean.TRUE;
                            }
                            return result;
                        }
                    }
                    if (mode == M.P_ALL) {
                        return Boolean.FALSE;
                    }
                    if (stack.isEmpty()) {
                        if (collectionIt.hasNext() && !isStatic) {
                            curvalue = collectionIt.next();
                            ++index;
                            curpoint = pred.size() - 1;
                            ipStack.clear();
                            continue;
                        }
                        if (mode == M.P_FILTER) {
                            return filter;
                        }
                        if (!result.isEmpty()) {
                            return result;
                        }
                        return Boolean.FALSE;
                    }
                    frame = (PredStackRecord)stack.peek();
                    ipStack = new ArrayDeque(frame.getStack());
                    curpoint = frame.getPointer();
                    ipStack.push(frame.next());
                    --curpoint;
                    if (frame.hasNext()) continue;
                    stack.pop();
                    continue;
                }
                if (mode == M.P_CHECK) {
                    return Boolean.TRUE;
                }
                result.addAllTyped(ooo);
                if (mode == M.P_FILTER || mode == M.P_ALL) {
                    filter.addAllTyped(curvalue);
                    if (collectionIt.hasNext()) {
                        curvalue = collectionIt.next();
                        ++index;
                        curpoint = pred.size() - 1;
                        ipStack.clear();
                        stack.clear();
                        continue;
                    }
                    if (mode == M.P_FILTER) {
                        return filter;
                    }
                    return Boolean.TRUE;
                }
                if (stack.isEmpty()) {
                    if (collectionIt.hasNext() && (!isStatic || mode != M.P_COMPUTE)) {
                        curvalue = collectionIt.next();
                        ++index;
                        curpoint = pred.size() - 1;
                        ipStack.clear();
                        continue;
                    }
                    return result;
                }
                frame = (PredStackRecord)stack.peek();
                ipStack = new ArrayDeque(frame.getStack());
                curpoint = frame.getPointer();
                ipStack.push(frame.next());
                --curpoint;
                if (frame.hasNext()) continue;
                stack.pop();
                continue;
            }
            --curpoint;
        }
    }

    private boolean objectRel(EntityId oo1, EntityId oo2, int rel, Token cur) {
        int res;
        try {
            BoxWorker worker = this.konto.getWorker();
            String o1 = worker.name(oo1.id());
            String o2 = worker.name(oo2.id());
            res = o1.compareTo(o2);
        }
        catch (Exception e) {
            throw new RuntimeException("The problem with getting the full id of the object " + cur.getPosition());
        }
        if (rel == Operation.EQ.ordinal()) {
            return res == 0;
        }
        if (rel == Operation.NEQ.ordinal()) {
            return res != 0;
        }
        throw new RuntimeException("Invalid application of the arithmetic relation to the ontology objects " + cur.getPosition());
    }

    static boolean arithRel(Object o1, Object o2, int rel, Token cur) {
        double f2;
        double f1;
        if (o1 instanceof String && o2 instanceof String) {
            int res = ((String)o1).compareTo((String)o2);
            if (rel == Operation.LEQ.ordinal()) {
                return res <= 0;
            }
            if (rel == Operation.LT.ordinal()) {
                return res < 0;
            }
            if (rel == Operation.GEQ.ordinal()) {
                return res >= 0;
            }
            if (rel == Operation.GT.ordinal()) {
                return res > 0;
            }
            if (rel == Operation.EQ.ordinal()) {
                return res == 0;
            }
            if (rel == Operation.NEQ.ordinal()) {
                return res != 0;
            }
            throw new RuntimeException("Something wrong with arith relation " + cur.getPosition());
        }
        try {
            f1 = Interp.getDouble(o1, cur);
            f2 = Interp.getDouble(o2, cur);
        }
        catch (Exception e) {
            if (o1.equals(Boolean.FALSE) || o2.equals(Boolean.FALSE)) {
                return false;
            }
            if (rel == Operation.EQ.ordinal() && (o1 instanceof String || o2 instanceof String)) {
                return false;
            }
            throw new RuntimeException("Can not cast " + o1.toString() + " and " + o2.toString() + ' ' + cur.getPosition());
        }
        if (rel == Operation.LEQ.ordinal()) {
            return f1 <= f2;
        }
        if (rel == Operation.LT.ordinal()) {
            return f1 < f2;
        }
        if (rel == Operation.GEQ.ordinal()) {
            return f1 >= f2;
        }
        if (rel == Operation.GT.ordinal()) {
            return f1 > f2;
        }
        if (rel == Operation.EQ.ordinal()) {
            return f1 == f2;
        }
        if (rel == Operation.NEQ.ordinal()) {
            return f1 != f2;
        }
        throw new RuntimeException("Something wrong with arith relation " + cur.getPosition());
    }

    static Object arithOp(Object o1, Object o2, int op, Token cur) {
        double f2;
        double f1;
        if ((o1 instanceof String || o2 instanceof String) && op == Operation.PLUS.ordinal()) {
            return o1.toString() + o2.toString();
        }
        if (o1 instanceof Integer && o2 instanceof Integer) {
            int i1 = (Integer)o1;
            int i2 = (Integer)o2;
            if (op == Operation.PLUS.ordinal()) {
                return i1 + i2;
            }
            if (op == Operation.MINUS.ordinal()) {
                return i1 - i2;
            }
            if (op == Operation.MULT.ordinal()) {
                return i1 * i2;
            }
            if (op == Operation.DIV.ordinal()) {
                if (i2 == 0) {
                    throw new RuntimeException("/ by zero " + cur.getPosition());
                }
                return i1 / i2;
            }
            if (op == Operation.MOD.ordinal()) {
                return i1 % i2;
            }
            throw new RuntimeException("Something wrong with arithop " + cur.getPosition() + ' ' + cur.getPosition());
        }
        if ((o1 instanceof Integer || o1 instanceof Long) && (o2 instanceof Integer || o2 instanceof Long)) {
            long i1 = o1 instanceof Integer ? ((Integer)o1).longValue() : ((Long)o1).longValue();
            long i2 = o2 instanceof Integer ? ((Integer)o2).longValue() : ((Long)o2).longValue();
            if (op == Operation.PLUS.ordinal()) {
                return i1 + i2;
            }
            if (op == Operation.MINUS.ordinal()) {
                return i1 - i2;
            }
            if (op == Operation.MULT.ordinal()) {
                return i1 * i2;
            }
            if (op == Operation.DIV.ordinal()) {
                if (i2 == 0L) {
                    throw new RuntimeException("/ by zero " + cur.getPosition());
                }
                return i1 / i2;
            }
            if (op == Operation.MOD.ordinal()) {
                return i1 % i2;
            }
            throw new RuntimeException("Something wrong with arithop " + cur.getPosition() + ' ' + cur.getPosition());
        }
        try {
            f1 = Interp.getDouble(o1, cur);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert the 1st argument " + o1 + " to double/integer in arith operation " + cur.getPosition());
        }
        try {
            f2 = Interp.getDouble(o2, cur);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert the 2nd argument " + o2 + "  to double/integer in arith operation " + cur.getPosition());
        }
        if (op == Operation.PLUS.ordinal()) {
            return f1 + f2;
        }
        if (op == Operation.MINUS.ordinal()) {
            return f1 - f2;
        }
        if (op == Operation.MULT.ordinal()) {
            return f1 * f2;
        }
        if (op == Operation.DIV.ordinal()) {
            return f1 / f2;
        }
        throw new RuntimeException("Something wrong with arithop " + cur.getPosition());
    }

    static boolean getBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof OntCollection) {
            return !((OntCollection)obj).isEmpty();
        }
        return obj != null;
    }

    static double getDouble(Object obj, Token cur) {
        double f;
        if (obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            throw new FailureException();
        }
        if (obj instanceof Integer) {
            f = ((Integer)obj).intValue();
        } else if (obj instanceof Long) {
            f = ((Long)obj).longValue();
        } else if (obj instanceof Double) {
            f = (Double)obj;
        } else if (obj instanceof String) {
            f = new Double((String)obj);
        } else {
            throw new RuntimeException("Something wrong with arguments of the arithmetic operation " + cur.getPosition());
        }
        return f;
    }

    private Token calcIf(OntCollection col, Token ifrec, Object ddot, Integer indx, Object previous) {
        Token cond = ifrec.getSub(0);
        Object cres = this.calcPredicate(col, cond, M.P_CHECK, ddot, indx, previous);
        if (Interp.isFalse(cres)) {
            return ifrec.getSub(2);
        }
        return ifrec.getSub(1);
    }

    String debugFunCall(String name, int arity, Object[] rargs) {
        String call = "";
        call = name + '(';
        for (int i = 0; i < arity; ++i) {
            if (i > 0) {
                call = call + ", ";
            }
            call = call + rargs[i].toString();
        }
        call = call + ')';
        System.out.println(" + " + call);
        return call;
    }

    public Object calcSGetter(ObjectId ooo, Object arg, int fnum) {
        Object[] rargs1;
        int arity = arg == null ? 0 : 1;
        OntCollection res = OntCC.newCol();
        FunctionDef fd = this.functions.getDefinition(fnum);
        Object[] rargs = new Object[arity + 1];
        rargs[0] = ooo;
        if (arg != null) {
            rargs[1] = arg;
        }
        Object def = fd.select(this.konto, rargs);
        Token deffun = (Token)def;
        Sequence defSeq = deffun.getSeq();
        int nnvars = deffun.getNumber();
        if (nnvars > arity) {
            rargs1 = new Object[nnvars + 1];
            for (int i = 0; i < rargs.length; ++i) {
                rargs1[i] = rargs[i];
            }
        } else {
            rargs1 = rargs;
        }
        this.vars.pushEnv(rargs1, (HashMap)deffun.getObj());
        Object o = this.applyOperators(ooo, defSeq.get(1).getSeq(), ooo, null, null);
        if (!Interp.isFalse(o)) {
            res.addAllTyped(o);
        }
        this.vars.popEnv();
        return res;
    }

    Token createClosure(Token quote) {
        int nnvars;
        Token fun = quote.getSub(0);
        if (fun.getType() == TokenType.DECLARE_INSTR) {
            nnvars = fun.getNumber();
        } else {
            if (fun.getType() == TokenType.SET_EXP) {
                int nnvars2 = fun.getNumber();
                Object[] rargs1 = new Object[nnvars2 + 1];
                Token closure = new Token(TokenType.CLOSURE, 0, null);
                closure.getSeq().addToken(fun);
                closure.setObj(rargs1);
                Map closedvars = (Map)fun.getInfo();
                Iterator i$ = closedvars.keySet().iterator();
                while (i$.hasNext()) {
                    int idx = (Integer)i$.next();
                    Token var = (Token)closedvars.get(idx);
                    int lnum = -var.getValue();
                    int gnum = (Integer)var.getObj();
                    rargs1[lnum] = this.vars.getVarValue(gnum);
                }
                return closure;
            }
            nnvars = fun.getNumber();
        }
        Object[] rargs1 = new Object[nnvars + 1];
        Token closure = new Token(TokenType.CLOSURE, 0, null);
        closure.getSeq().addToken(fun);
        closure.setObj(rargs1);
        Map closedvars = (Map)fun.getInfo();
        Iterator i$ = closedvars.keySet().iterator();
        while (i$.hasNext()) {
            int idx = (Integer)i$.next();
            Token var = (Token)closedvars.get(idx);
            int lnum = -var.getValue();
            int gnum = (Integer)var.getObj();
            rargs1[lnum] = this.vars.getVarValue(gnum);
        }
        return closure;
    }

    Object calcFunction(Token cur, Object curvalue, OntCollection inputCol, Integer index, Object ddot, Object previous) {
        Object curresult;
        boolean debug = false;
        String debugCall = "";
        Sequence fargs = cur.getSeq();
        int fnum = cur.getValue();
        FunctionDef fd = this.functions.getDefinition(fnum);
        int arity = fargs.size();
        if (fd == null) {
            throw new RuntimeException("Function " + this.functions.getName(fnum) + " not defined " + cur.getPosition());
        }
        Object ddotnew = inputCol == null ? curvalue : inputCol;
        Object[] rargs = new Object[arity + 1];
        if (fd.isCollectionWise()) {
            Object o;
            rargs[0] = curvalue;
            for (int i = 1; i <= arity; ++i) {
                rargs[i] = o = this.calcPredicate(null, fargs.get(i - 1), M.P_COMPUTE, ddotnew, null, null);
            }
            Object def = fd.select(this.konto, rargs);
            if (def instanceof LibrettoFunction) {
                LibrettoFunction bdef = (LibrettoFunction)def;
                if (inputCol == null) {
                    if (Interp.isFalse(curvalue)) {
                        bdef.setContext(OntCC.newCol());
                    } else if (curvalue instanceof OntCollection) {
                        bdef.setContext((OntCollection)curvalue);
                    } else if (curvalue instanceof ChoicePoint) {
                        ChoicePoint cp = (ChoicePoint)curvalue;
                        OntCollection oc = OntCC.newCol();
                        while (cp.hasNext()) {
                            oc.addAllTyped(cp.next());
                        }
                        bdef.setContext(oc);
                    } else {
                        bdef.setContext(OntCC.singleton(curvalue));
                    }
                } else {
                    bdef.setContext(inputCol);
                }
                ((LibrettoFunction)def).setArguments(rargs);
                ((LibrettoFunction)def).setIndex(-1);
                ((LibrettoFunction)def).setPrevious(null);
                ((LibrettoFunction)def).setCurrentValue(null);
                ((LibrettoFunction)def).setCurrentObject(cur.getObj());
                curresult = ((LibrettoFunction)def).call(this.konto);
            } else {
                Object[] rargs1;
                Token deffun = (Token)def;
                Sequence defSeq = deffun.getSeq();
                int nvars = deffun.getNumber();
                if (nvars + 1 > arity) {
                    rargs1 = new Object[nvars + 1 + 1];
                    for (int i = 1; i <= rargs.length; ++i) {
                        rargs1[i] = rargs[i - 1];
                    }
                } else {
                    rargs1 = rargs;
                }
                this.vars.pushEnv(rargs1, (HashMap)deffun.getObj());
                this.vars.putVarValue(this.yieldvar, (Object)OntCC.newCol());
                if (defSeq.get(1).getType() == TokenType.AUTOMATA) {
                    if (Interp.isFalse(curvalue)) {
                        curvalue = OntCC.newCol();
                    }
                    o = this.generateSeq((OntCollection)curvalue, (IterProg)defSeq.get(1).getObj());
                } else {
                    int indx = -1;
                    Object prev = null;
                    if (curvalue instanceof OntCollection) {
                        OntCollectionCP cp = new OntCollectionCP((OntCollection)curvalue);
                        try {
                            this.applyOperators(cp, defSeq.get(1).getSeq(), cp, null, prev);
                        }
                        catch (BreakException e) {
                            throw new RuntimeException("Uncaught break in the generator");
                        }
                        catch (ReturnException e) {
                            o = e.getResult();
                            OntCollection oc = (OntCollection)this.vars.getVarValue(this.yieldvar);
                            oc.addAllTyped(o);
                        }
                        catch (RuntimeException e) {
                            throw new RuntimeException(e.getMessage() + " in generator " + this.functions.getName(fnum));
                        }
                    } else {
                        try {
                            this.applyOperators(null, defSeq.get(1).getSeq(), null, null, prev);
                        }
                        catch (BreakException e) {
                            throw new RuntimeException("Uncaught break in the generator");
                        }
                        catch (ReturnException e) {
                            o = e.getResult();
                            OntCollection oc = (OntCollection)this.vars.getVarValue(this.yieldvar);
                            oc.addAllTyped(o);
                        }
                        catch (ThroughException e) {
                            throw new ThroughException(e.getMessage());
                        }
                        catch (RuntimeException e) {
                            throw new ThroughException(e.getMessage() + " in generator " + this.functions.getName(fnum));
                        }
                    }
                    o = this.vars.getVarValue(this.yieldvar);
                }
                OntCollection resultCol = OntCC.newCol();
                if (o != null && !o.equals(Boolean.FALSE)) {
                    resultCol.addAllTyped(o);
                }
                this.vars.popEnv();
                curresult = resultCol;
            }
        } else {
            OntCollection oc = curvalue instanceof OntCollection ? (OntCollection)curvalue : OntCC.singleton(curvalue);
            OntCollection res = OntCC.newCol();
            for (Object ooo : oc) {
                Object[] rargs1;
                Object o;
                rargs[0] = ooo;
                for (int i = 1; i <= arity; ++i) {
                    o = this.calcPredicate(ooo, fargs.get(i - 1), M.P_COMPUTE, oc, index, previous);
                    rargs[i] = o = OntCC.normalize(o);
                }
                Object def = fd.select(this.konto, rargs);
                if (def instanceof LibrettoFunction) {
                    curvalue = OntCC.singleton(ooo);
                    LibrettoFunction func = (LibrettoFunction)def;
                    func.setArguments(rargs);
                    func.setCurrentValue(ooo);
                    func.setContext(oc);
                    ((LibrettoFunction)def).setIndex(index);
                    ((LibrettoFunction)def).setPrevious(previous);
                    func.setCurrentObject(cur.getObj());
                    try {
                        curresult = func.call(this.konto);
                    }
                    catch (LabelException e) {
                        throw new LabelException(e.getKey());
                    }
                    catch (BreakException e) {
                        throw new BreakException(e.getResult());
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException && ExceptionPass.isPassed(e)) {
                            throw (RuntimeException)e;
                        }
                        throw (RuntimeException)ExUtil.copy((Throwable)new RuntimeException(e.getMessage() + " in " + this.functions.getName(fnum)), (Throwable)e);
                    }
                    res.addAllTyped(curresult);
                    continue;
                }
                Token deffun = (Token)def;
                Sequence defSeq = deffun.getSeq();
                Token body = defSeq.get(defSeq.size() - 1);
                int nnvars = deffun.getNumber();
                if (nnvars > arity) {
                    rargs1 = new Object[nnvars + 1];
                    for (int i = 0; i < rargs.length; ++i) {
                        rargs1[i] = rargs[i];
                    }
                } else {
                    rargs1 = rargs;
                }
                this.vars.pushEnv(rargs1, (HashMap)deffun.getObj());
                try {
                    o = this.applyOperators(ooo, defSeq.get(1).getSeq(), inputCol, index, previous);
                }
                catch (ReturnException e) {
                    o = e.getResult();
                }
                catch (BreakException e) {
                    throw new BreakException(e.getResult());
                }
                catch (ThroughException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw (ThroughException)ExUtil.copy((Throwable)new ThroughException(e.getMessage() + " in user-defined function " + this.functions.getName(fnum)), (Throwable)e);
                }
                if (o != null && !o.equals(Boolean.FALSE)) {
                    res.addAllTyped(o);
                }
                this.vars.popEnv();
            }
            curresult = res;
        }
        return curresult;
    }

    private static boolean changeCollection(OntCollection sc, Object res) {
        if (res == null) {
            return false;
        }
        if (res.equals(Boolean.FALSE)) {
            return false;
        }
        sc.addAllTyped(res);
        return true;
    }

    private Object getEntityType(BoxWorker worker, Token cur) {
        String uri = this.konto.getTokenURI(cur);
        String prefix = cur.getPrefix();
        if (uri == null) {
            throw new RuntimeException("Entity `" + (prefix == null ? "" : prefix + ":" + (cur.getName() == null ? "*" : cur.getName())) + " not found " + cur.getPosition());
        }
        if (cur.getName() == null || cur.getName().equals("*")) {
            Integer ont = worker.id(uri);
            if (ont == null) {
                throw new RuntimeException("Failed to find ontology \"" + uri + "\"");
            }
            return OntologyId.newId(ont);
        }
        Integer ne = this.konto.getEntity(uri + '#' + cur.getName());
        if (ne == null) {
            throw new RuntimeException("Entity `" + (prefix == null ? "" : prefix + ":" + cur.getName()) + " not found " + cur.getPosition());
        }
        EntityId obj = null;
        switch (worker.entity(worker.name(ne))) {
            case ONTCLASS: {
                obj = ClassId.newId(ne);
                break;
            }
            case ONTOLOGY: {
                obj = OntologyId.newId(ne);
                break;
            }
            case TYPE: {
                obj = TypeId.newId(ne);
                break;
            }
            case OPROPERTY: {
                obj = OPropertyId.newId(ne);
                break;
            }
            case TPROPERTY: {
                obj = TPropertyId.newId(ne);
                break;
            }
            case ONTOBJECT: {
                obj = ObjectId.newId(worker, ne);
            }
        }
        return obj;
    }

    public static boolean isAbsolutePath(Token fst) {
        TokenType fsttype = fst.getType();
        return fsttype == TokenType.ASTERISK || fsttype == TokenType.VAR_REF || fsttype == TokenType.CLASS_NAME || fsttype == TokenType.OBJ_NAME || fsttype == TokenType.DDOT || fsttype == TokenType.ENTITY_TYPE || fsttype == TokenType.EMBEDDED_LANG;
    }

    public OntCollection calcPath(OntCollection col, Token pth, CalledFrom calledFrom, Object ddot, Integer indx, Object previous) {
        ChoicePoint rec;
        Object curvalue;
        Object res;
        OntCollection sc;
        int shift;
        boolean hasEmptyContext;
        Sequence m2p = pth.getType() == TokenType.PATH_EXP ? pth.getSeq() : pth.createSingleton();
        int inserted = 0;
        Token fst = m2p.get(0);
        TokenType fsttype = fst.getType();
        if (fsttype == TokenType.EMPTY_CONTEXT) {
            hasEmptyContext = true;
            col = null;
            fst = m2p.get(1);
            fsttype = fst.getType();
        } else {
            hasEmptyContext = false;
        }
        if (fsttype == TokenType.IF_EXP) {
            Token cur = this.calcIf(col, fst, ddot, indx, previous);
            OntCollection emptycol = OntCC.newCol(CollectionType.UNDEF_COL);
            Object res2 = this.calcPredicate(col, cur, M.P_COMPUTE, ddot, indx, previous);
            if (res2 instanceof OntCollection) {
                return (OntCollection)res2;
            }
            if (res2.equals(Boolean.FALSE)) {
                return emptycol;
            }
            return OntCC.singleton(res2);
        }
        if (fsttype == TokenType.PATH_EXP) {
            col = this.calcPath(col, fst, CalledFrom.PATH, col, indx, previous);
            shift = 0;
        } else if (fsttype == TokenType.FUN_CALL) {
            sc = OntCC.newCol();
            res = this.calcFunction(fst, col, null, 0, ddot, previous);
            Interp.changeCollection(sc, res);
            shift = 0;
            col = sc;
        } else if (fsttype == TokenType.ANONYM_FUN || fsttype == TokenType.SWITCH) {
            sc = OntCC.newCol();
            res = this.applyOperators(col, fst.getSeq(), col, 0, previous);
            Interp.changeCollection(sc, res);
            shift = 0;
            col = sc;
        } else if (fsttype == TokenType.PREDICATE) {
            sc = OntCC.newCol();
            if (!Interp.changeCollection(sc, res = this.calcPredicate(col, fst.getSub(), M.P_COMPUTE, ddot, indx, previous))) {
                return sc;
            }
            col = sc;
            shift = 0;
        } else if (fsttype == TokenType.STRING_SEGMENT) {
            String rstr;
            OntCollection cl = OntCC.newCol();
            if (Interp.isFalse(col)) {
                rstr = this.stringSegment(fst, null, indx, previous);
                cl.addAllTyped(rstr);
            } else {
                for (Object o : col) {
                    rstr = this.stringSegment(fst, null, indx, previous);
                    cl.addAllTyped(rstr);
                }
            }
            col = cl;
            shift = 0;
        } else if ((Interp.isAbsolutePath(fst) || col == null && fsttype == TokenType.SET_EXP) && col == null || fsttype == TokenType.VAR_REF) {
            col = this.getInitCol(col, fst, ddot, indx, previous);
            if (m2p.size() == 1) {
                return col;
            }
            shift = 0;
        } else if (fsttype == TokenType.SORTER) {
            Sequence sorters = (Sequence)fst.getObj();
            Token ordered = fst.getSub();
            OntCollection sc2 = OntCC.sort(this.calcPath(col, ordered, CalledFrom.PATH, ddot, indx, previous), new PathComparator(this, sorters));
            shift = 0;
            if (sc2.isEmpty()) {
                return OntCC.newCol();
            }
            col = sc2;
        } else if (fsttype == TokenType.BASIC_TYPE) {
            col = OntCC.singleton(fst.getObj());
            shift = 0;
        } else if (fsttype == TokenType.QUOTED_EXP) {
            col = OntCC.singleton(this.createClosure(fst));
            shift = 0;
        } else if (fsttype == TokenType.FORALL_QUANT) {
            if (col == null) {
                col = OntCC.newCol(CollectionType.UNDEF_COL);
                col.addAllTyped(Boolean.FALSE);
            }
            shift = 1;
        } else if (fsttype == TokenType.OBJ_MODIFIER) {
            col = this.modifyObjects(col, fst, indx, previous);
            shift = 0;
        } else if (fsttype == TokenType.MAP_OBJECT_CREATOR) {
            OntCollection r = OntCC.newCol();
            if (Interp.isFalse(col)) {
                this.objCreatorContext = null;
                r.addAllTyped(this.createObjOrMap(fst, indx, previous));
            } else {
                for (Object o : col) {
                    this.objCreatorContext = o;
                    r.addAllTyped(this.createObjOrMap(fst, indx, previous));
                }
            }
            col = r;
            shift = 0;
        } else {
            if (col == null) {
                Entity e;
                if (fsttype == TokenType.PROP_NAME && (e = this.konto.getWorker().entity(this.konto.getFullName(fst))) != Entity.TPROPERTY && e != Entity.OPROPERTY) {
                    throw new RuntimeException("Property or class not found " + this.konto.getFullName(fst) + fst.getPosition());
                }
                return OntCC.newCol();
            }
            shift = 1;
        }
        ArrayDeque<ChoicePoint> stack = new ArrayDeque<ChoicePoint>();
        int[] counts = new int[m2p.size() + shift];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = -1;
        }
        OntCollection result = OntCC.newCol();
        int curstep = 0;
        if (col.isEmpty()) {
            return col;
        }
        if (col.size() > 1) {
            stack.push(new PathStackRecord(col, 0));
            curvalue = ((ChoicePoint)stack.peek()).next();
            previous = Boolean.FALSE;
            indx = ((ChoicePoint)stack.peek()).getCounter();
            this.vars.putVarValue(this.konto.getHandler().indexVarNumber, (Object)indx);
        } else {
            curvalue = col.get(0);
            if (curvalue instanceof ChoicePoint) {
                rec = (ChoicePoint)curvalue;
                if (!rec.hasNext() && curvalue instanceof OntCollectionCP) {
                    OntCollectionCP ocp = (OntCollectionCP)curvalue;
                    ocp.rewind();
                }
                if (rec.hasNext()) {
                    curvalue = rec.next();
                    previous = Boolean.FALSE;
                    indx = rec.getCounter();
                    this.vars.putVarValue(this.konto.getHandler().indexVarNumber, (Object)indx);
                    if (rec.hasNext()) {
                        stack.push(rec);
                        rec.setPointer(curstep);
                    }
                } else {
                    return OntCC.newCol();
                }
            }
        }
        int rightmost = m2p.size() + shift - 1;
        if (hasEmptyContext) {
            ++curstep;
        }
        if (curstep >= rightmost) {
            return col;
        }
        int collectorPt = -1;
        while (true) {
            Token cur = m2p.get(++curstep - shift);
            int n = curstep;
            counts[n] = counts[n] + 1;
            indx = counts[curstep];
            this.vars.putVarValue(this.konto.getHandler().indexVarNumber, (Object)indx);
            TokenType type = cur.getType();
            Object curresult = null;
            block13 : switch (type) {
                case VAR_REF: {
                    Object o;
                    int varnum = cur.getValue();
                    if (this.parser.isSpecVar(cur)) {
                        if (varnum == this.konto.getHandler().indexVarNumber) {
                            if (indx == null) {
                                throw new RuntimeException("The index value for $_i is not determined " + cur.getPosition());
                            }
                            curresult = indx;
                            break;
                        }
                        if (varnum == this.konto.getHandler().thisVarNumber) {
                            curresult = curvalue;
                            break;
                        }
                        if (varnum == this.konto.getHandler().prevVarNumber) {
                            if (previous == null) {
                                throw new RuntimeException("The previous value for $_prev is not determined " + cur.getPosition());
                            }
                            curresult = previous;
                            break;
                        }
                    }
                    if ((o = this.vars.getVarValue(varnum)) == null) {
                        throw new RuntimeException("Variable $" + cur.getName() + " is not instantiated" + ' ' + cur.getPosition());
                    }
                    if (o instanceof OntCollection) {
                        curresult = Interp.getCurResult((OntCollection)o);
                        break;
                    }
                    curresult = o;
                    break;
                }
                case PROP_NAME: 
                case INVERSE_OPROP_NAME: 
                case INVERSE_TPROP_NAME: 
                case INVERSE_KEY: 
                case EDITED_PROP_NAME: {
                    OntCollection sc3;
                    OntCollection ocl;
                    Token cterm;
                    ObjectId oo;
                    if (curvalue instanceof ObjectContainer) {
                        curvalue = ((ObjectContainer)curvalue).getObject();
                    }
                    if (!(curvalue instanceof ObjectId) && type != TokenType.INVERSE_TPROP_NAME && !cur.isKey()) {
                        throw new RuntimeException("\"" + cur.getName() + "\" is an undeclared variable or a property applied to a non-object " + cur.getPosition());
                    }
                    if (curvalue instanceof ObjectId) {
                        oo = (ObjectId)curvalue;
                    } else {
                        if (curvalue instanceof EntityId) {
                            if (!cur.isKey()) {
                                throw new RuntimeException("Only @keys can be used as entity annotations");
                            }
                            int eid = ((EntityId)curvalue).id();
                            String key = this.konto.getFullName(cur);
                            curresult = this.konto.getWorker().anno(eid, key);
                            if (cur.getType() != TokenType.EDITED_PROP_NAME) break;
                            if (!cur.isRightmostEditedProp()) {
                                throw new RuntimeException("Misplaced predicate/filter after the modified entity key/annotation");
                            }
                            cur = m2p.get(++curstep - shift);
                            cterm = cur.getSub(0);
                            Object res3 = Boolean.FALSE;
                            if (cterm != null) {
                                res3 = this.calcPredicate(curvalue, cterm, M.P_COMPUTE, curvalue, null, null);
                            }
                            String v = "";
                            if (res3 instanceof OntCollection) {
                                for (Object a : (OntCollection)res3) {
                                    if (!v.equals("")) {
                                        v = v + " ";
                                    }
                                    v = v + a.toString();
                                }
                                res3 = v;
                            }
                            if (res3 == Boolean.FALSE) {
                                this.konto.getWorker().write().annotate(eid, key, null);
                            } else {
                                this.konto.getWorker().write().annotate(eid, key, res3.toString());
                            }
                            return OntCC.newCol();
                        }
                        oo = null;
                    }
                    PropertyId pp = this.konto.getProperty(cur);
                    if (type == TokenType.EDITED_PROP_NAME) {
                        this.editedProp = pp;
                        if (this.editedProp == null) {
                            this.konto.getLE();
                            int fnum = LibrettoEnv.getSetter(this.konto, cur);
                            if (fnum != -1) {
                                if (cur.isRightmostEditedProp()) {
                                    cur = m2p.get(++curstep - shift);
                                    cterm = cur.getSub(0);
                                    Object res4 = this.calcPredicate(oo, cterm, M.P_COMPUTE, oo, null, null);
                                    this.calcSGetter(oo, res4, fnum);
                                    return OntCC.newCol();
                                }
                                throw new RuntimeException("Misplaced setter " + this.konto.getFullName(cur) + cur.getPosition());
                            }
                        }
                    }
                    this.konto.getLE();
                    int fnum = LibrettoEnv.getGetter(this.konto, cur);
                    if (pp == null && !cur.isKey() && fnum == -1) {
                        throw new RuntimeException("The property " + this.konto.getFullName(cur) + " not found");
                    }
                    if (pp != null && fnum != -1) {
                        throw new RuntimeException("Ambiguous property name " + this.konto.getFullName(cur) + " both a property and a getter");
                    }
                    if (pp instanceof TPropertyId && type == TokenType.INVERSE_OPROP_NAME) {
                        throw new RuntimeException("Invalid attempt to inverse t-property " + cur.getPosition());
                    }
                    try {
                        Collection<Object> l;
                        BoxWorker worker = this.konto.getWorker();
                        if (type == TokenType.INVERSE_TPROP_NAME) {
                            l = ObjectId.convert(worker, worker.owners(pp.id(), curvalue.toString()));
                        } else if (fnum != -1) {
                            l = OntCC.newCol().addAllTyped(this.calcSGetter(oo, null, fnum));
                        } else if (pp instanceof TPropertyId) {
                            l = this.konto.typedCollection(Arrays.asList(worker.strings(oo.id(), pp.id())), (TPropertyId)pp);
                        } else if (pp instanceof OPropertyId) {
                            l = type == TokenType.INVERSE_OPROP_NAME ? ObjectId.convert(worker, worker.owners(pp.id(), oo.id())) : ObjectId.convert(worker, worker.objects(oo.id(), pp.id()));
                        } else {
                            throw new Exception("");
                        }
                        curresult = l.size() == 1 ? l.iterator().next() : (l.size() > 1 ? OntCC.newCol(l) : null);
                    }
                    catch (Exception e) {
                        if (!cur.isKey()) {
                            curresult = null;
                        }
                        if (cur.isKey() && cur.getPrefix() == null) {
                            Entity ken;
                            String name = cur.getName();
                            BoxWorker w = this.konto.getWorker();
                            if (oo == null) {
                                if (cur.getType() != TokenType.INVERSE_KEY) {
                                    throw new RuntimeException("Attempt to apply a property or key '" + cur.getName() + "' to a non-object");
                                }
                                String tkey = "http://ontobox.org/map#tprop-" + cur.getName();
                                ken = w.entity(tkey);
                                if (ken == null) {
                                    throw new RuntimeException("TKey @" + cur.getName() + " not defined yet");
                                }
                                ocl = OntCC.newCol(w, w.owners((int)w.id(tkey), curvalue.toString()));
                            } else if (cur.getType() == TokenType.INVERSE_KEY) {
                                String okey = "http://ontobox.org/map#oprop-" + cur.getName();
                                ken = w.entity(okey);
                                if (ken == null) {
                                    throw new RuntimeException("OKey @" + cur.getName() + " not defined yet");
                                }
                                ocl = OntCC.newCol(w, w.owners((int)w.id(okey), oo.id()));
                            } else {
                                ocl = this.konto.getMapKeyValues(oo, name);
                            }
                            curresult = ocl != null && ocl.size() == 1 ? ocl.get(0) : (ocl == null ? null : ocl);
                            if (type == TokenType.EDITED_PROP_NAME) {
                                this.editedProp = this.konto.getMapKey(oo, name);
                                if (this.editedProp == null) {
                                    this.editedPropName = name;
                                }
                                this.editedObj = oo;
                                sc3 = OntCC.newCol(CollectionType.UNDEF_COL);
                                if (curresult instanceof OntCollection) {
                                    int num = 0;
                                    for (Object ooo : (OntCollection)curresult) {
                                        sc3.addAllTyped(new PropValContainer(ooo, num));
                                        ++num;
                                    }
                                    curresult = sc3;
                                } else if (curresult != null) {
                                    curresult = new PropValContainer(curresult, 0);
                                }
                            }
                            if (!cur.isRightmostEditedProp()) {
                                break;
                            }
                        }
                        if (cur.isKey() && cur.getPrefix() != null) {
                            throw new RuntimeException("Qualified keys (with the prefix) are allowed only for entities (ontologies, classes, properties)");
                        }
                        if (pp == null && cur.getPrefix() != null) {
                            throw new RuntimeException("'" + cur + " neither o-property, nor t-property " + cur.getPosition());
                        }
                        if (cur.getPrefix() == null && pp == null && !this.konto.doesKeyExist(cur)) {
                            throw new RuntimeException("'" + cur + " neither o-property, nor t-property " + cur.getPosition());
                        }
                        curresult = null;
                    }
                    if (type != TokenType.EDITED_PROP_NAME) break;
                    this.editedObj = oo;
                    if (cur.isRightmostEditedProp()) {
                        inserted = Interp.isFalse(curresult) ? 0 : (curresult instanceof OntCollection ? ((OntCollection)curresult).size() : 1);
                        cur = m2p.get(++curstep - shift);
                        this.modifyObj(curresult, cur, inserted, null, null);
                        return OntCC.newCol();
                    }
                    sc3 = OntCC.newCol(CollectionType.UNDEF_COL);
                    if (curresult instanceof OntCollection) {
                        int num = 0;
                        for (Object ooo : (OntCollection)curresult) {
                            sc3.addAllTyped(new PropValContainer(ooo, num));
                            ++num;
                        }
                        curresult = sc3;
                        break;
                    }
                    if (curresult == null) break;
                    curresult = new PropValContainer(curresult, 0);
                    break;
                }
                case MAP_OBJECT_CREATOR: {
                    this.objCreatorContext = curvalue;
                    curresult = this.createObjOrMap(cur, indx, previous);
                    if (!Interp.isFalse(curresult)) break;
                    curresult = null;
                    break;
                }
                case CLASS_NAME: {
                    curresult = Interp.getCurResult(OntCC.newCol(this.konto.getWorker(), this.konto.getClassObjects(cur)));
                    break;
                }
                case OBJ_NAME: {
                    ObjectId oo = this.konto.getOntObject(cur);
                    curresult = oo;
                    break;
                }
                case ENTITY_TYPE: {
                    curresult = cur.getObj();
                    break;
                }
                case QUOTED_EXP: {
                    curresult = this.createClosure(cur);
                    break;
                }
                case DATATYPE_NAME: {
                    BoxWorker w = this.konto.getWorker();
                    Integer datatype = w.id(this.konto.getFullName(cur));
                    curresult = DValue.checkValue(w, curvalue, datatype) ? curvalue : null;
                    if (datatype != null) break;
                    throw new RuntimeException("Datatype " + this.konto.getFullName(cur) + " not found" + cur.getPosition());
                }
                case PREDICATE: {
                    Token term;
                    if (cur.isCollectionWise(this.parser)) {
                        if (curvalue != null) {
                            result.addAllTyped(curvalue);
                        }
                        if (stack.isEmpty()) {
                            collectorPt = -1;
                            term = cur.getSub();
                            try {
                                OntCollection oc = OntCC.newCol();
                                for (Object el : result) {
                                    OntCollection res5 = (OntCollection)this.calcPredicate(el, term, M.P_FILTER, result, null, previous);
                                    oc.addAllTyped(res5);
                                }
                                curresult = oc;
                            }
                            catch (BreakException e) {
                                curresult = null;
                            }
                            result.clear();
                            break;
                        }
                        collectorPt = curstep;
                        curresult = null;
                        break;
                    }
                    term = cur.getSub();
                    try {
                        OntCollection res6 = (OntCollection)this.calcPredicate(curvalue, term, M.P_FILTER, null, indx, previous);
                        curresult = Interp.getCurResult(res6);
                    }
                    catch (BreakException e) {
                        stack.clear();
                        curresult = null;
                    }
                    break;
                }
                case TERM_EXP: {
                    OntCollection res7;
                    if (cur.isCollectionWise(this.parser)) {
                        if (curvalue != null) {
                            result.addAllTyped(curvalue);
                        }
                        if (stack.isEmpty()) {
                            collectorPt = -1;
                            try {
                                res7 = (OntCollection)this.calcPredicate(result, cur, M.P_COMPUTE, ddot, null, null);
                                curresult = Interp.getCurResult(res7);
                            }
                            catch (BreakException e) {
                                curresult = null;
                            }
                            result.clear();
                            break;
                        }
                        collectorPt = curstep;
                        curresult = null;
                        break;
                    }
                    try {
                        res7 = (OntCollection)this.calcPredicate(curvalue, cur, M.P_COMPUTE, null, indx, previous);
                        curresult = Interp.getCurResult(res7);
                    }
                    catch (BreakException e) {
                        stack.clear();
                        curresult = null;
                    }
                    break;
                }
                case SET_EXP: {
                    Sequence pps;
                    OntCollection sc3;
                    Object o;
                    if (cur.isCollectionWise(this.parser)) {
                        if (curvalue != null) {
                            result.addAllTyped(curvalue);
                        }
                        if (stack.isEmpty()) {
                            collectorPt = -1;
                            sc3 = OntCC.newCol(CollectionType.UNDEF_COL);
                            pps = cur.getSeq();
                            try {
                                for (Object r : result) {
                                    for (int i = 0; i < pps.size(); ++i) {
                                        sc3.addAllTyped(this.calcPredicate(r, pps.get(i), M.P_COMPUTE, result, null, null));
                                    }
                                }
                                curresult = Interp.getCurResult(sc3);
                            }
                            catch (BreakException e) {
                                curresult = null;
                            }
                            result.clear();
                            break;
                        }
                        collectorPt = curstep;
                        curresult = null;
                        break;
                    }
                    sc3 = OntCC.newCol();
                    pps = cur.getSeq();
                    try {
                        for (int i = 0; i < pps.size(); ++i) {
                            try {
                                o = this.calcPredicate(curvalue, pps.get(i), M.P_COMPUTE, null, indx, previous);
                                sc3.addAllTyped(o);
                                continue;
                            }
                            catch (BreakException e) {
                                stack.clear();
                            }
                        }
                        curresult = Interp.getCurResult(sc3);
                    }
                    catch (BreakException e) {
                        stack.clear();
                        curresult = null;
                    }
                    break;
                }
                case EMPTY_CONTEXT: {
                    if (curstep == rightmost) {
                        curresult = null;
                        break;
                    }
                    if (!((curresult = (cur = m2p.get(++curstep - shift)).getType() == TokenType.FUN_CALL ? this.calcFunction(cur, null, null, 0, ddot, previous) : this.getInitCol(null, cur, ddot, indx, previous)) instanceof OntCollection)) break;
                    curresult = Interp.getCurResult((OntCollection)curresult);
                    break;
                }
                case EMBEDDED_LANG: {
                    List al = (List)cur.getObj();
                    EmbeddedLanguage el = (EmbeddedLanguage)al.get(0);
                    Object code = al.get(1);
                    col = curvalue.equals(Boolean.FALSE) ? OntCC.newCol() : OntCC.singleton(curvalue);
                    OntCollection resc = el.execute(this.konto, code, col);
                    curresult = Interp.getCurResult(resc);
                    break;
                }
                case OBJ_MODIFIER: {
                    OntCollection res8;
                    if (cur.isCollectionWise(this.parser)) {
                        if (curvalue != null) {
                            result.addAllTyped(curvalue);
                        }
                        if (stack.isEmpty()) {
                            collectorPt = -1;
                            Token term = cur.getSub();
                            OntCollection res9 = this.modifyObjects(result, cur, null, null);
                            curresult = Interp.getCurResult(res9);
                            result.clear();
                            break;
                        }
                        collectorPt = curstep;
                        curresult = null;
                        break;
                    }
                    try {
                        res8 = this.modifyObjects(OntCC.singleton(curvalue), cur, indx, previous);
                    }
                    catch (BreakException e) {
                        res8 = e.getResult();
                        stack.clear();
                    }
                    curresult = Interp.getCurResult(res8);
                    break;
                }
                case ANONYM_FUN: {
                    Object o;
                    try {
                        o = this.applyOperators(curvalue, cur.getSeq(), curvalue, indx, previous);
                        if (o instanceof OntCollection) {
                            curresult = Interp.getCurResult((OntCollection)o);
                            break;
                        }
                        curresult = o;
                    }
                    catch (BreakException e) {
                        stack.clear();
                        curresult = null;
                    }
                    break;
                }
                case RETURN: {
                    Object o = cur.getSeq().size() == 1 ? this.eval(curvalue, cur.getSub(0), indx, previous) : OntCC.newCol();
                    throw new ReturnException(o);
                }
                case OBJ_MODIFY_INSTR: {
                    if (cur.isRightmostEditedProp()) {
                        if (curvalue != null) {
                            result.addAllTyped(curvalue);
                        }
                        if (stack.isEmpty()) {
                            collectorPt = -1;
                            inserted = this.modifyObj(result, cur, result.size(), null, null);
                            result.clear();
                        } else {
                            collectorPt = curstep;
                            curresult = null;
                        }
                    } else {
                        inserted = this.modifyObj(curvalue, cur, inserted, indx, previous);
                    }
                    curresult = curvalue;
                    break;
                }
                case ASTERISK: {
                    if (cur.getValue() == Asterisk.AST_ALL.ordinal()) {
                        curresult = curvalue;
                        break;
                    }
                    if (!(curvalue instanceof ObjectId)) {
                        throw new RuntimeException("ontology entities 'a*' can be applied only to objects " + cur.getPosition());
                    }
                    ObjectId oo = (ObjectId)curvalue;
                    if (!this.konto.belongsTo(oo, this.konto.getOntology(this.konto.getTokenURI(cur)))) break;
                    curresult = curvalue;
                    break;
                }
                case INDX_OPER: {
                    OntCollection ocl;
                    Token ix = cur.getSub(0);
                    Object idx = this.calcPredicate(curvalue, ix, M.P_COMPUTE, null, indx, previous);
                    if (idx instanceof Integer) {
                        if (idx instanceof Integer && idx.equals(indx)) {
                            curresult = curvalue;
                            break;
                        }
                        curresult = null;
                        break;
                    }
                    if (idx instanceof OntCollection) {
                        ocl = (OntCollection)idx;
                        curresult = null;
                        for (Object ob : ocl) {
                            if (!(ob instanceof Integer) || !ob.equals(indx)) continue;
                            curresult = curvalue;
                            break block13;
                        }
                        break;
                    }
                    curresult = null;
                    break;
                }
                case DOT: 
                case DDOT: {
                    curresult = curvalue;
                    break;
                }
                case BREAK: {
                    throw new BreakException();
                }
                case SWITCH: {
                    Object o;
                    try {
                        o = this.calcSwitch(curvalue, cur, curvalue, indx, previous);
                        if (o instanceof OntCollection) {
                            curresult = Interp.getCurResult((OntCollection)o);
                            break;
                        }
                        curresult = o;
                    }
                    catch (BreakException e) {
                        stack.clear();
                        curresult = null;
                    }
                    break;
                }
                case MODIF_SWITCH: {
                    try {
                        this.calcSwitch(curvalue, cur, curvalue, indx, previous);
                        curresult = curvalue;
                    }
                    catch (BreakException e) {
                        stack.clear();
                        curresult = null;
                    }
                    break;
                }
                case SET_FIELD: {
                    curresult = curvalue;
                    this.vars.putVarValue(cur, curvalue);
                    break;
                }
                case FUN_CALL: {
                    if (cur.isCollectionWise(this.parser)) {
                        if (curvalue != null) {
                            result.addAllTyped(curvalue);
                        }
                        if (stack.isEmpty()) {
                            collectorPt = -1;
                            curresult = this.calcFunction(cur, result, result, null, result, null);
                            if (curresult instanceof OntCollection) {
                                curresult = Interp.getCurResult((OntCollection)curresult);
                            }
                            result = OntCC.newCol();
                            break;
                        }
                        collectorPt = curstep;
                        curresult = null;
                        break;
                    }
                    try {
                        curresult = this.calcFunction(cur, curvalue, null, indx, null, previous);
                    }
                    catch (BreakException e) {
                        stack.clear();
                        curresult = null;
                    }
                    if (!(curresult instanceof OntCollection)) break;
                    curresult = Interp.getCurResult((OntCollection)curresult);
                    break;
                }
                case PATH_EXP: {
                    col = OntCC.singleton(curvalue);
                    OntCollection ocl = this.calcPath(col, cur, CalledFrom.PATH, ddot, indx, previous);
                    curresult = Interp.getCurResult(ocl);
                    break;
                }
                case GET_FIELD: {
                    String field = cur.getName();
                    if (!this.fieldValues.containsKey(field)) {
                        throw new RuntimeException("The field '" + field + "' is not defined in the path " + cur.getPosition());
                    }
                    curresult = this.fieldValues.get(field);
                    break;
                }
            }
            if (curresult == null) {
                if (stack.isEmpty()) {
                    indx = null;
                    this.vars.putVarValue(this.konto.getHandler().indexVarNumber, (Object)-1);
                    if (collectorPt < 0) {
                        return result;
                    }
                    previous = Boolean.FALSE;
                    curvalue = null;
                    curstep = collectorPt - 1;
                    continue;
                }
                rec = (ChoicePoint)stack.peek();
                curstep = rec.getPointer();
                for (int i = curstep + 2; i < counts.length; ++i) {
                    counts[i] = -1;
                }
                previous = rec.getCurrent();
                curvalue = rec.next();
                indx = rec.getCounter();
                this.vars.putVarValue(this.konto.getHandler().indexVarNumber, (Object)indx);
                if (!rec.hasNext()) {
                    stack.pop();
                }
            } else if (curresult instanceof OntCollection) {
                OntCollection c = (OntCollection)curresult;
                if (c.size() == 1) {
                    curvalue = curresult = c.get(0);
                    previous = Boolean.FALSE;
                } else if (curstep == rightmost) {
                    curresult = c;
                } else {
                    rec = new PathStackRecord(c, curstep);
                    stack.push(rec);
                    curvalue = rec.next();
                    indx = rec.getCounter();
                    this.vars.putVarValue(this.konto.getHandler().indexVarNumber, (Object)indx);
                }
            } else if (curresult instanceof ChoicePoint) {
                if (curstep == rightmost) {
                    curresult = this.getAllInCP((ChoicePoint)curresult);
                } else {
                    rec = (ChoicePoint)curresult;
                    rec.setPointer(curstep);
                    stack.push(rec);
                    curvalue = rec.next();
                    indx = rec.getCounter();
                    this.vars.putVarValue(this.konto.getHandler().indexVarNumber, (Object)indx);
                }
            } else {
                curvalue = curresult;
            }
            if (curstep != rightmost) continue;
            if (calledFrom == CalledFrom.OUTSIDE && !this.fieldValues.isEmpty()) {
                if (curresult instanceof OntCollection) {
                    OntCollection fsc = OntCC.newCol();
                    for (Object ooo : (OntCollection)curresult) {
                        fsc.addAllTyped(new FieldContainer(ooo, this.fieldValues));
                    }
                    curresult = fsc;
                } else {
                    curresult = new FieldContainer(curresult, this.fieldValues);
                }
            }
            result.addAllTyped(curresult);
            if (stack.isEmpty()) break;
            rec = (ChoicePoint)stack.peek();
            curstep = rec.getPointer();
            for (int i = curstep + 2; i < counts.length; ++i) {
                counts[i] = -1;
            }
            previous = rec.getCurrent();
            curvalue = rec.next();
            indx = rec.getCounter();
            this.vars.putVarValue(this.konto.getHandler().indexVarNumber, (Object)indx);
            if (rec.hasNext()) continue;
            stack.pop();
        }
        return result;
    }

    public void setSpecVar(int vnum, Object value) {
        this.vars.putVarValue(this.konto.getHandler().specialVarsBase + vnum, value);
    }

    private static Object getCurResult(OntCollection sc) {
        if (sc.size() == 1) {
            return sc.get(0);
        }
        if (sc.size() > 1) {
            return sc;
        }
        return null;
    }

    OntCollection getInitCol(OntCollection curvalue, Token ps, Object ddot, Integer indx, Object previous) {
        TokenType fsttype = ps.getType();
        if (fsttype == TokenType.ASTERISK) {
            if (ps.getValue() == Asterisk.AST_ALL.ordinal()) {
                return this.konto.getAllObjects();
            }
            OntCollection sc = OntCC.newCol(CollectionType.OBJECT_COL);
            String uri = this.konto.getTokenURI(ps);
            if (uri == null) {
                if (ps.getPrefix() == null) {
                    throw new RuntimeException("Default ontology not found");
                }
                throw new RuntimeException("Ontology with prefix '" + ps.getPrefix() + "' not found");
            }
            sc.addAll(this.konto.getAllOntObjects(uri));
            return sc;
        }
        if (fsttype == TokenType.EMBEDDED_LANG) {
            List al = (List)ps.getObj();
            EmbeddedLanguage el = (EmbeddedLanguage)al.get(0);
            Object code = al.get(1);
            return el.execute(this.konto, code, null);
        }
        if (fsttype == TokenType.VAR_REF) {
            Object o;
            int varnum = ps.getValue();
            if (varnum < this.konto.getHandler().specialVarsNumber) {
                if (varnum == this.konto.getHandler().indexVarNumber) {
                    if (indx == null) {
                        throw new RuntimeException("The index value for $_i is not determined " + ps.getPosition());
                    }
                    return OntCC.singleton(indx);
                }
                if (varnum == this.konto.getHandler().thisVarNumber) {
                    return curvalue;
                }
                if (varnum == this.konto.getHandler().prevVarNumber) {
                    if (previous == null) {
                        throw new RuntimeException("The previous value for $_prev is not determined " + ps.getPosition());
                    }
                    return OntCC.singleton(previous);
                }
            }
            if (Boolean.FALSE.equals(o = this.vars.getVarValue(varnum))) {
                o = OntCC.newCol(CollectionType.UNDEF_COL);
            }
            if (o == null) {
                throw new RuntimeException("Variable is not instantiated $" + ps.getName() + ' ' + ps.getPosition());
            }
            if (!(o instanceof OntCollection)) {
                o = OntCC.singleton(o);
            }
            return (OntCollection)o;
        }
        if (fsttype == TokenType.SET_EXP) {
            Sequence pps = ps.getSeq();
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL);
            for (int i = 0; i < pps.size(); ++i) {
                res.addAllTyped(this.calcPredicate(null, pps.get(i), M.P_COMPUTE, ddot, indx, previous));
            }
            return res;
        }
        if (fsttype == TokenType.CLASS_NAME) {
            return OntCC.newCol(this.konto.getWorker(), this.konto.getClassObjects(ps));
        }
        if (fsttype == TokenType.OBJ_NAME) {
            ObjectId oo;
            try {
                oo = this.konto.getOntObject(ps);
            }
            catch (Exception e) {
                throw new RuntimeException("Object " + ps + " does not exist in ontology " + this.konto.getTokenURI(ps) + ' ' + ps.getPosition());
            }
            return OntCC.singleton(oo);
        }
        if (fsttype == TokenType.ENTITY_TYPE) {
            return OntCC.singleton(this.getEntityType(this.konto.getWorker(), ps));
        }
        if (fsttype == TokenType.PATH_EXP) {
            return this.calcPath(null, ps, CalledFrom.PATH, ddot, indx, previous);
        }
        if (fsttype == TokenType.DDOT) {
            if (Interp.isFalse(ddot)) {
                return OntCC.newCol();
            }
            if (ddot instanceof OntCollection) {
                return (OntCollection)ddot;
            }
            return OntCC.singleton(ddot);
        }
        if (fsttype == TokenType.OBJ_MODIFIER) {
            return this.modifyObjects(null, ps, indx, previous);
        }
        if (fsttype == TokenType.MAP_OBJECT_CREATOR) {
            OntCollection r = OntCC.newCol();
            this.objCreatorContext = null;
            return r.addAllTyped(this.createObjOrMap(ps, indx, previous));
        }
        return null;
    }

    public Object eval(Object o, Object quoted, Integer indx, Object previous) {
        Token termexp;
        if (o instanceof OntCollectionCP) {
            o = ((OntCollectionCP)o).getCollection();
        }
        if (!(quoted instanceof Token)) {
            return quoted;
        }
        if (!(quoted instanceof Token)) {
            throw new RuntimeException("The argument of eval/1 must be a quoted expression ");
        }
        Token tq = (Token)quoted;
        if (tq.getType() == TokenType.QUOTED_EXP) {
            termexp = new Token(TokenType.TERM_EXP, 0, null);
            termexp.setPosition(tq.getPosition());
            termexp.setSeq(tq.getSeq());
        } else {
            termexp = tq.getType() == TokenType.QUERY_INSTR ? tq.getSub() : tq;
        }
        Object oo = indx == null ? null : o;
        return this.calcPredicate(oo, termexp, M.P_COMPUTE, o, indx, previous);
    }

    public void resetYield() {
        this.vars.putVarValue(this.yieldvar, (Object)OntCC.newCol());
    }

    public OntCollection getYield() {
        return (OntCollection)this.vars.getVarValue(this.yieldvar);
    }

    public static boolean isFalse(Object o) {
        if (o == null) {
            return true;
        }
        if ((o = ObjectContainer.getObject(o)) instanceof Boolean) {
            return o.equals(Boolean.FALSE);
        }
        if (o instanceof OntCollection) {
            if (((OntCollection)o).isEmpty()) {
                return true;
            }
            o = ((OntCollection)o).get(0);
            o = ObjectContainer.getObject(o);
            return o.equals(Boolean.FALSE);
        }
        return false;
    }

    public static boolean isTrue(Object o) {
        return !Interp.isFalse(o);
    }

    private class EmptyValException
    extends RuntimeException {
        private EmptyValException() {
        }
    }

    private static class FailureException
    extends RuntimeException {
        private FailureException() {
        }
    }
}

