/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto;

import java.util.Set;
import org.ontobox.box.BoxWorker;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.parser.Token;

public class LibrettoEnv {
    private static final String LEU = "http://libretto.ontobox.org/";
    private static final String L = "http://libretto.ontobox.org/#";
    private static final String ANNOT_GETTER = "http://libretto.ontobox.org/#propgetter";
    private static final String ANNOT_SETTER = "http://libretto.ontobox.org/#propsetter";
    private static final String MMETH_CLASS = "http://libretto.ontobox.org/#Multimethod";
    private static final String FUN_CLASS = "http://libretto.ontobox.org/#Function";
    private static final String MMETH_NAME_PROP = "http://libretto.ontobox.org/#name";
    private static final String FUN_FULLNAME_PROP = "http://libretto.ontobox.org/#fullname";
    private static final String MMETH_ARITY_PROP = "http://libretto.ontobox.org/#arity";
    private static final String FUN_CODE_PROP = "http://libretto.ontobox.org/#code";
    private static final String MMETH_FUNCTIONS_PROP = "http://libretto.ontobox.org/#functions";
    private static final String URI_CLASS = "http://libretto.ontobox.org/#HasURI";
    private static final String PREFIXED_CLASS = "http://libretto.ontobox.org/#Prefixed";
    private static final String PREFIXED_PREFIXES_PROP = "http://libretto.ontobox.org/#prefixes";
    private static final String PREFIX_CLASS = "http://libretto.ontobox.org/#Prefix";
    private static final String PREFIX_PREFIX_PROP = "http://libretto.ontobox.org/#prefix";
    private static final String URI_URI_PROP = "http://libretto.ontobox.org/#uri";
    private static final String PREFIXED_OBJECT = "__the_collector_of_prefixes";
    private int intype;
    private int stringtype;
    private Integer libonto;
    private Integer mmethClass;
    private Integer functionClass;
    private Integer uriClass;
    private Integer prefixClass;
    private Integer prefixedClass;
    private Integer mmethNameProp;
    private Integer funFullnameProp;
    private Integer mmethArityProp;
    private Integer funCodeProp;
    private Integer prefixedPrefixesProp;
    private Integer mmethFunctionsProp;
    private Integer uriUriProp;
    private Integer prefixPrefixProp;
    private Set<String> setterProps;
    public static final String XML_HEAP = "http://xml.ontobox.org/heap";
    public static final String XHEAP_PREFIX = "xheap";
    private LocalContext lc;

    public static int getGetter(LocalContext lc, Token prop) {
        return lc.getHandler().getFunctions().checkFunction(LibrettoEnv.getterName(prop), 0);
    }

    public static int getSetter(LocalContext lc, Token prop) {
        return lc.getHandler().getFunctions().checkFunction(LibrettoEnv.setterName(prop), 1);
    }

    public static int getSetter(LocalContext lc, String uri, String name) {
        return lc.getHandler().getFunctions().checkFunction(LibrettoEnv.setterName(uri, name), 1);
    }

    private static String getterName(Token prop) {
        String uri = prop.getUri();
        String name = prop.getName();
        return uri + "#getter_" + name;
    }

    private static String setterName(Token prop) {
        String uri = prop.getUri();
        String name = prop.getName();
        return uri + "#setter_" + name;
    }

    private static String setterName(String uri, String name) {
        return uri + "#setter_" + name;
    }

    public static String mmethObjectName(String name, int arity) {
        return name + "_" + arity;
    }

    public Integer getXMLHeap(LocalContext lc) {
        String xmlHeap = lc.getHandler().getMapping().get(XHEAP_PREFIX);
        Integer xheap = lc.getWorker().id(xmlHeap);
        if (xheap == null) {
            throw new RuntimeException("The XML heap ontology " + xmlHeap + " does not exist");
        }
        return xheap;
    }

    public static Integer setXMLHeap(LocalContext lc, String newheap) {
        BoxWorker worker = lc.getWorker();
        Integer xheap = worker.id(newheap);
        if (xheap == null) {
            xheap = worker.write().newOntology(newheap);
        }
        lc.getHandler().putUriInMap(XHEAP_PREFIX, newheap);
        return xheap;
    }
}

