/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.collection;

import java.util.Collection;
import java.util.Comparator;
import org.ontobox.box.BoxWorker;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.collection.SimpleCol;
import org.ontobox.libretto.function.OntCollectionCP;

public class OntCC {
    public static OntCollection newCol() {
        return new SimpleCol();
    }

    public static OntCollection newCol(CollectionType type) {
        return new SimpleCol(type);
    }

    public static OntCollection newCol(CollectionType type, int initCapacity) {
        return new SimpleCol(type, initCapacity);
    }

    public static OntCollection newCol(Collection c) {
        return new SimpleCol(c);
    }

    public static OntCollection newCol(BoxWorker worker, int[] ids) {
        return new SimpleCol(worker, ids);
    }

    public static OntCollection newCol(OntCollectionCP cp) {
        SimpleCol oc = new SimpleCol();
        cp.rewind();
        while (cp.hasNext()) {
            oc.addAllTyped(cp.next());
        }
        return oc;
    }

    public static OntCollection singleton(Object o) {
        SimpleCol sc;
        Object o1 = ObjectContainer.getObject(o);
        if (o1 instanceof ObjectId) {
            sc = new SimpleCol(CollectionType.OBJECT_COL);
        } else {
            if (o1 instanceof OntCollection) {
                throw new RuntimeException("Attempt to apply OntCC.singleton to a collection " + o.toString());
            }
            sc = new SimpleCol(CollectionType.DATA_COL);
        }
        sc.add(o);
        return sc;
    }

    public static OntCollection sort(OntCollection input, Comparator<? super Object> comp) {
        SimpleCol ordered = new SimpleCol(input);
        ordered.sort(comp);
        return ordered;
    }

    public static Object normalize(Object sc) {
        if (sc == null) {
            return OntCC.newCol();
        }
        if (sc instanceof OntCollection) {
            if (((OntCollection)sc).size() == 0) {
                return sc;
            }
            if (((OntCollection)sc).size() == 1) {
                return ((OntCollection)sc).get(0);
            }
            return sc;
        }
        if (sc.equals(Boolean.FALSE)) {
            return OntCC.newCol();
        }
        return sc;
    }
}

