/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;

public class BoxHelper {
    public static ClassId getOntClass(LocalContext lc, Object obj) {
        if (obj instanceof String) {
            String className;
            BoxWorker worker = lc.getWorker();
            if (worker.entity(className = (String)obj) != Entity.ONTCLASS) {
                throw new RuntimeException(className + " is not a class");
            }
            return ClassId.newId(worker.id(className));
        }
        if (obj instanceof ClassId) {
            return (ClassId)obj;
        }
        throw new RuntimeException("Invalid class (" + obj + ")");
    }

    public static OntologyId getOnt(LocalContext lc, Object ont) {
        if (ont instanceof String) {
            String name;
            BoxWorker worker = lc.getWorker();
            if (worker.entity(name = (String)ont) != Entity.ONTOLOGY) {
                throw new RuntimeException(name + " is not an ontology");
            }
            return OntologyId.newId(worker.id(name));
        }
        if (ont instanceof OntologyId) {
            return (OntologyId)ont;
        }
        throw new RuntimeException("Invalid ontology (" + ont + ")");
    }

    public static ObjectId createObject(LocalContext lc, Object cls, Object ont) {
        ClassId oc = BoxHelper.getOntClass(lc, cls);
        OntologyId ontId = BoxHelper.getOnt(lc, ont);
        BoxWorker worker = lc.getWorker();
        BoxWriter writer = worker.write();
        int objId = writer.newObject(writer.newName(ontId.id()));
        writer.addObjectClass(objId, oc.id());
        return ObjectId.newId(worker, objId);
    }
}

