/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import java.util.ArrayList;
import java.util.List;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.T;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.function.FunctionType;

public class FunctionDef {
    private final ArrayList<Object> defs = new ArrayList();
    private ArrayList<FunctionType> ftypes = new ArrayList();
    private int arity;
    private T cardtype;
    private String name;

    public FunctionDef(String fullname, FunctionType ftype, Object def) {
        this.ftypes.add(ftype);
        this.cardtype = ftype.getCard(0);
        this.defs.add(def);
        this.arity = ftype.getArity();
        this.name = fullname;
    }

    public FunctionDef(FunctionDef def) {
        this.defs.addAll(def.defs);
        this.ftypes.addAll(def.ftypes);
        this.arity = def.arity;
        this.cardtype = def.cardtype;
        this.name = def.name;
    }

    public int insert(FunctionType ftype, Object def) {
        if (ftype.getCard(0) != this.cardtype) {
            throw new RuntimeException("A generator and a function can not have the same name and arity");
        }
        int n = this.getInsertPosition(ftype);
        if (n == -1) {
            n = this.ftypes.size() + 1;
            this.ftypes.add(ftype);
            this.defs.add(def);
        } else {
            this.ftypes.set(n, ftype);
            this.defs.set(n, def);
        }
        return n;
    }

    private int getInsertPosition(FunctionType ft) {
        for (int i = 0; i < this.ftypes.size(); ++i) {
            if (!ft.isEquiv(this.ftypes.get(i))) continue;
            return i;
        }
        return -1;
    }

    public Object select(LocalContext lc, Object[] rargs) {
        List<Integer> sel = this.filter(lc, rargs);
        int size = sel.size();
        if (size == 0) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < rargs.length; ++i) {
                Object o = OntCC.normalize(rargs[i]);
                if (o instanceof String) {
                    o = "\"" + o + "\"";
                }
                if (i == 0) {
                    s.append(" for context ");
                    s.append(o);
                    s.append(" and arguments (");
                    continue;
                }
                if (i > 1) {
                    s.append(", ");
                }
                s.append(o);
            }
            s.append(")");
            throw new RuntimeException("Function not found " + this.name + '/' + (rargs.length - 1) + s);
        }
        if (size == 1) {
            return this.defs.get(sel.get(0));
        }
        ArrayList<Integer> reslist = new ArrayList<Integer>();
        reslist.add(sel.get(0));
        block1: for (int i = 1; i < size; ++i) {
            FunctionType t1 = this.ftypes.get(sel.get(i));
            int j = 0;
            while (true) {
                FunctionType t2;
                int res;
                if ((res = t1.compare(lc, t2 = this.ftypes.get((Integer)reslist.get(j)))) == -1) {
                    ++j;
                    continue;
                }
                if (res == 1) {
                    reslist.remove(j);
                } else if (res == 2) continue block1;
                if (j == reslist.size()) break;
            }
            reslist.add(sel.get(i));
        }
        if (reslist.size() > 1) {
            throw new RuntimeException("Ambiguous definitions of the multimethod");
        }
        return this.defs.get((Integer)reslist.get(0));
    }

    private List<Integer> filter(LocalContext lc, Object[] rargs) {
        int size = this.ftypes.size();
        ArrayList<Integer> reslist = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            if (!this.ftypes.get(i).matches(lc, rargs)) continue;
            reslist.add(i);
        }
        return reslist;
    }

    public boolean isCollectionWise() {
        return this.cardtype == T.COLLECTION_WISE;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<FunctionType> getTypes() {
        return this.ftypes;
    }

    public int getArity() {
        return this.arity;
    }
}

