/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import java.util.Date;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.MapHelper;
import org.ontobox.box.helper.RHelper;
import org.ontobox.box.helper.XMLHelper;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.T;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.EntityId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.FunctionType;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Token;

public abstract class LibrettoFunction {
    protected final String name;
    protected final int arity;
    protected final T type;
    private String uri;
    private FunctionType ftype;
    private Object[] arguments;
    private Integer index;
    private Object previous;
    private OntCollection context;
    private Object current;
    private Object object;

    public LibrettoFunction(String name, int arity, T ctxtype, String uri, String funtype) {
        if (!Parser.checkURI(uri)) {
            throw new RuntimeException("Invalid URI of installed builtin function " + name + '/' + arity);
        }
        this.name = uri + '#' + name;
        this.arity = arity;
        this.type = ctxtype;
        this.ftype = funtype == null ? FunctionType.createUntyped(arity) : FunctionType.readType(arity, funtype);
        if (ctxtype != T.COLLECTION_WISE) {
            this.ftype.setElementwise();
        } else {
            this.ftype.setCollectionwise();
        }
        this.uri = uri;
    }

    public abstract Object call(LocalContext var1);

    public final String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public FunctionType getFType() {
        return this.ftype;
    }

    public void setFType(FunctionType ft) {
        this.ftype = ft;
    }

    public final String getTitle() {
        return this.name + '/' + this.arity;
    }

    public final T getType() {
        return this.type;
    }

    public final void setIndex(Integer ix) {
        this.index = ix;
    }

    public final void setPrevious(Object pr) {
        this.previous = pr;
    }

    protected final Integer getIndex() {
        return this.index;
    }

    protected final Object getPrevious() {
        return this.previous;
    }

    public final void setContext(OntCollection cx) {
        this.context = cx;
    }

    public final OntCollection getContext() {
        return this.context;
    }

    public final void setCurrentValue(Object cr) {
        this.current = cr;
    }

    public final void setCurrentObject(Object obj) {
        this.object = obj;
    }

    public final Object getCurrentValue() {
        return ObjectContainer.getObject(this.current);
    }

    protected final String getCurrentString() {
        Object obj = this.getCurrentValue();
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new RuntimeException("The context value must be a string");
    }

    protected final int getCurrentXEntity(LocalContext lc, int classId) {
        Object obj = this.getCurrentValue();
        if (obj instanceof ObjectId) {
            int oid = ((ObjectId)obj).id();
            if (classId == lc.getXmlEl() && RHelper.isInstanceOf(lc.getWorker(), oid, lc.getXmlDoc())) {
                return lc.getWorker().objects(oid, lc.getXmlRootProp())[0];
            }
            if (!RHelper.isInstanceOf(lc.getWorker(), oid, classId)) {
                throw new RuntimeException("The context value must be a XML " + lc.getWorker().local(classId));
            }
            return oid;
        }
        throw new RuntimeException("The context value must be a XML " + lc.getWorker().local(classId));
    }

    protected final Object getRawValue() {
        return this.current;
    }

    public final void setArguments(Object[] args) {
        this.arguments = args;
    }

    protected static Object getSingleObject(Object o) {
        Object oo = o instanceof OntCollection ? ((OntCollection)o).get(0) : o;
        oo = ObjectContainer.getObject(oo);
        return oo;
    }

    public Object getSingleArg(int index) {
        if (index < 1 || index >= this.arguments.length) {
            return null;
        }
        Object oo = this.arguments[index];
        if (Interp.isFalse(oo)) {
            return null;
        }
        if (oo instanceof OntCollection) {
            oo = ((OntCollection)oo).get(0);
        }
        oo = ObjectContainer.getObject(oo);
        return oo;
    }

    protected Object getArg(int index) {
        if (index < 1 || index >= this.arguments.length) {
            return null;
        }
        return this.arguments[index];
    }

    protected Integer getIntegerArg(int index) {
        Object oo = this.getSingleArg(index);
        if (oo instanceof Integer) {
            return (Integer)oo;
        }
        return null;
    }

    protected int getIntegerM(int index) {
        Object oo = this.getSingleArg(index);
        if (oo instanceof Integer) {
            return (Integer)oo;
        }
        throw new IllegalArgumentException("Invalid " + index + " argument (must be an integer)");
    }

    protected Long getLongArg(int index) {
        Object oo = this.getSingleArg(index);
        if (oo instanceof Integer) {
            return ((Integer)oo).longValue();
        }
        if (oo instanceof Long) {
            return (Long)oo;
        }
        return null;
    }

    protected long getLongM(int index) {
        Object oo = this.getSingleArg(index);
        if (oo instanceof Integer) {
            return ((Integer)oo).longValue();
        }
        if (oo instanceof Long) {
            return (Long)oo;
        }
        throw new IllegalArgumentException("Invalid " + index + " argument (must be an integer or a long)");
    }

    public String getStringArg(int index) {
        Object oo = this.getSingleArg(index);
        if (oo instanceof String) {
            return (String)oo;
        }
        return null;
    }

    public String getString(int index) {
        Object oo = this.getSingleArg(index);
        if (oo instanceof String) {
            return (String)oo;
        }
        return null;
    }

    public String getStringM(int index) {
        String str = this.getString(index);
        if (str == null) {
            throw new IllegalArgumentException("Invalid " + index + " argument (must be a string)");
        }
        return str;
    }

    protected Date getDateArg(int index) {
        Object oo = this.getSingleArg(index);
        if (oo instanceof Date) {
            return (Date)oo;
        }
        return null;
    }

    @Deprecated
    protected Token getQuotedArg(int index) {
        Object oo = this.getSingleArg(index);
        if (oo instanceof Token) {
            return (Token)oo;
        }
        return null;
    }

    protected int getMapM(BoxWorker worker, int index) {
        ObjectId obj;
        int id;
        Object o = this.getArg(index);
        if (o instanceof ObjectId && MapHelper.isMap(worker, id = (obj = (ObjectId)o).id())) {
            return id;
        }
        throw new IllegalArgumentException("Invalid " + index + " argument (must be a map)");
    }

    protected Integer getXML(BoxWorker worker, int index) {
        ObjectId obj;
        int id;
        Object o = this.getArg(index);
        if (o instanceof ObjectId && (XMLHelper.isElement(worker, id = (obj = (ObjectId)o).id()) || XMLHelper.isXML(worker, id))) {
            return id;
        }
        return null;
    }

    public boolean isElementWise() {
        return this.type == T.ELEMENT_WISE;
    }

    public boolean isCollectionWise() {
        return this.type == T.COLLECTION_WISE;
    }

    public boolean isStatic() {
        return this.type == T.STATIC;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    protected Object context() {
        return ObjectContainer.getObject(this.current);
    }

    protected OntCollection contextCollection() {
        return this.context;
    }

    protected Object arg(int index) {
        if (index < 1 || index >= this.arguments.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.arguments[index];
    }

    protected static Integer entity(Object obj) {
        if (obj instanceof EntityId) {
            EntityId entity = (EntityId)obj;
            return entity.id();
        }
        return null;
    }

    protected int entityM() {
        Integer ret = LibrettoFunction.entity(this.context());
        if (ret == null) {
            throw new WrongContext("an entity");
        }
        return ret;
    }

    protected int entityM(int arg) {
        Integer ret = LibrettoFunction.entity(this.arg(arg));
        if (ret == null) {
            throw new WrongArg(arg, "an entity");
        }
        return ret;
    }

    protected static Integer object(Object o) {
        if (o instanceof ObjectId) {
            ObjectId obj = (ObjectId)o;
            return obj.id();
        }
        return null;
    }

    protected int objectM() {
        Integer ret = LibrettoFunction.object(this.context());
        if (ret == null) {
            throw new WrongContext("an object");
        }
        return ret;
    }

    protected int objectM(int index) {
        Integer ret = LibrettoFunction.object(this.arg(index));
        if (ret == null) {
            throw new WrongArg(index, "an object");
        }
        return ret;
    }

    protected static Integer map(BoxWorker worker, Object o) {
        int id;
        if (o instanceof ObjectId && MapHelper.isMap(worker, id = ((ObjectId)o).id())) {
            return id;
        }
        return null;
    }

    protected int mapM(BoxWorker worker) {
        Integer ret = LibrettoFunction.map(worker, this.context());
        if (ret == null) {
            throw new WrongContext("a map");
        }
        return ret;
    }

    protected int mapM(BoxWorker worker, int index) {
        Integer ret = LibrettoFunction.map(worker, this.arg(index));
        if (ret == null) {
            throw new WrongArg(index, "a map");
        }
        return ret;
    }

    protected static Integer xml(BoxWorker worker, Object o) {
        ObjectId obj;
        int id;
        if (o instanceof ObjectId && (XMLHelper.isElement(worker, id = (obj = (ObjectId)o).id()) || XMLHelper.isXML(worker, id))) {
            return id;
        }
        return null;
    }

    protected int xmlM(BoxWorker worker) {
        Integer xml = LibrettoFunction.xml(worker, this.context());
        if (xml == null) {
            throw new WrongContext("a XLM element or a XML document");
        }
        return xml;
    }

    protected int xmlM(BoxWorker worker, int index) {
        Integer xml = LibrettoFunction.xml(worker, this.arg(index));
        if (xml == null) {
            throw new WrongArg(index, "a XLM element or a XML document");
        }
        return xml;
    }

    protected static Integer ontclass(Object obj) {
        if (obj instanceof ClassId) {
            return ((ClassId)obj).id();
        }
        return null;
    }

    protected int ontclassM() {
        Integer ont = LibrettoFunction.ontclass(this.context());
        if (ont == null) {
            throw new WrongContext("a class");
        }
        return ont;
    }

    protected int ontclassM(int arg) {
        Integer ont = LibrettoFunction.ontclass(this.arg(arg));
        if (ont == null) {
            throw new WrongArg(arg, "a class");
        }
        return ont;
    }

    protected static Integer ontology(Object obj) {
        if (obj instanceof OntologyId) {
            return ((OntologyId)obj).id();
        }
        return null;
    }

    protected int ontologyM() {
        Integer ont = LibrettoFunction.ontology(this.context());
        if (ont == null) {
            throw new WrongContext("an ontology");
        }
        return ont;
    }

    protected int ontologyM(int arg) {
        Integer ont = LibrettoFunction.ontology(this.arg(arg));
        if (ont == null) {
            throw new WrongArg(arg, "an ontology");
        }
        return ont;
    }

    protected static String string(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    protected String stringM() {
        String str = LibrettoFunction.string(this.context());
        if (str == null) {
            throw new WrongContext("a string");
        }
        return str;
    }

    protected String stringM(int arg) {
        Object val = this.arg(arg);
        String str = LibrettoFunction.string(val);
        if (str == null) {
            throw new WrongArg(arg, "a string", val);
        }
        return str;
    }

    protected static class WrongArg
    extends IllegalArgumentException {
        public WrongArg(int arg, String type) {
            super("Invalid " + arg + " argument (must be " + type + ")");
        }

        public WrongArg(int arg, String type, Object val) {
            super("Invalid " + arg + " argument (must be " + type + ", " + (val == null ? "null" : val.getClass()) + " actually)");
        }
    }

    protected static class WrongContext
    extends IllegalStateException {
        public WrongContext(String type) {
            super("The context must be " + type);
        }
    }
}

