/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.function;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.BinaryHelper;
import org.ontobox.libretto.BreakException;
import org.ontobox.libretto.ChoicePoint;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.LabelException;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.ObjectContainer;
import org.ontobox.libretto.PropValContainer;
import org.ontobox.libretto.ReturnException;
import org.ontobox.libretto.T;
import org.ontobox.libretto.ThroughException;
import org.ontobox.libretto.adapter.FunctionId;
import org.ontobox.libretto.adapter.NamedEntityId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.BaseFuncs;
import org.ontobox.libretto.function.BuiltInFunction;
import org.ontobox.libretto.function.FunctionDef;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;
import org.ontobox.libretto.parser.VarTable;

public class StringFuncs {
    public static String EVAL_FUN = "eval";

    public static void init(FunctionTable funs) {
        funs.pushFunction(new FunString0());
        funs.pushFunction(new FunNL0());
        funs.pushFunction(new FunCodesString0());
        funs.pushFunction(new FunCodesStrings1());
        funs.pushFunction(new FunStringCodes0());
        funs.pushFunction(new FunStringsCodes1());
        funs.pushFunction(new FunCompare1());
        funs.pushFunction(new FunJoin3());
        funs.pushFunction(new FunJoin1());
        funs.pushFunction(new FunJoin0());
        funs.pushFunction(new FunStartsWith1());
        funs.pushFunction(new FunEndsWith1());
        funs.pushFunction(new FunCharAt1());
        funs.pushFunction(new FunSubstring2());
        funs.pushFunction(new FunLength0());
        funs.pushFunction(new FunTrim0());
        funs.pushFunction(new FunUpper0());
        funs.pushFunction(new FunLower0());
        funs.pushFunction(new FunStringPad1());
        funs.pushFunction(new FunMatch2());
        funs.pushFunction(new FunMatchAll2());
        funs.pushFunction(new FunGroup1());
        funs.pushFunction(new FunReplace3());
        funs.pushFunction(new FunSplit2());
        funs.pushFunction(new FunBinBase64Hex0());
        funs.pushFunction(new BinHexBase640());
        funs.pushFunction(new FunBinExport3());
        funs.pushFunction(new FunBinSet3());
        funs.pushFunction(new FunBinAdd3());
        funs.pushFunction(new FunTxtSet3());
        funs.pushFunction(new FunTxtAdd3());
        funs.pushFunction(new FunTxtSet4());
        funs.pushFunction(new FunTxtAdd4());
        funs.pushFunction(new FunTxtExport3());
        funs.pushFunction(new FunTxtExport4());
        funs.pushFunction(new FunEval1());
        funs.pushFunction(new FunEval2());
        funs.pushFunction(new EncodeURL0());
        funs.pushFunction(new EncodeURL1());
        funs.pushFunction(new DecodeURL0());
        funs.pushFunction(new DecodeURL1());
    }

    static OntCollection joinStrings(OntCollection col, Object chkpath, String typestr, Interp interp, Integer indx, String delim) {
        BaseFuncs.SPLITTER type;
        if (Interp.isFalse(col)) {
            return null;
        }
        OntCollection result = OntCC.newCol();
        LocalContext konto = interp.konto;
        if (typestr.equals("starts")) {
            type = BaseFuncs.SPLITTER.STARTS;
        } else if (typestr.equals("ends")) {
            type = BaseFuncs.SPLITTER.ENDS;
        } else if (typestr.equals("between")) {
            type = BaseFuncs.SPLITTER.BETWEEN;
        } else {
            throw new RuntimeException("Invalid type (" + typestr + ")");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Object previous = Boolean.FALSE;
        for (Object ooo : col) {
            if (!((ooo = ObjectContainer.getObject(ooo)) instanceof String)) {
                throw new RuntimeException("The context values must be strings. Found: " + ooo);
            }
            String str = (String)ooo;
            if (Interp.isTrue(interp.eval(ooo, chkpath, indx, previous))) {
                if (type == BaseFuncs.SPLITTER.ENDS) {
                    if (i > 0) {
                        sb.append(delim);
                    }
                    sb.append(str);
                    i = 0;
                }
                result.addAllTyped(sb.toString());
                sb.setLength(0);
                if (type == BaseFuncs.SPLITTER.STARTS) {
                    sb.append(str);
                    i = 1;
                }
                if (type == BaseFuncs.SPLITTER.BETWEEN) {
                    i = 0;
                }
                previous = ooo;
                continue;
            }
            if (i > 0) {
                sb.append(delim);
            }
            ++i;
            sb.append(str);
            previous = ooo;
        }
        result.addAllTyped(sb.toString());
        return result;
    }

    static void addString(OntCollection result, Object e, int loc, int len) {
        if (e instanceof String) {
            int sbeg;
            int send;
            int sl = ((String)e).length();
            if (len >= 0 && sl + 1 < len + Math.abs(loc)) {
                return;
            }
            if (loc < 0) {
                send = sl + 1 + loc;
                sbeg = len >= 0 ? send - len : 0;
            } else {
                sbeg = loc - 1;
                send = len >= 0 ? sbeg + len : sl;
            }
            result.add(((String)e).substring(sbeg, send));
        }
    }

    private static int getFlags(String flg) {
        char[] farr;
        int flags = 0;
        block4: for (char aFarr : farr = flg.toCharArray()) {
            switch (aFarr) {
                case 'i': {
                    flags |= 2;
                    continue block4;
                }
                case 'm': {
                    flags |= 8;
                }
            }
        }
        return flags;
    }

    @Deprecated
    static Values getDmapArgs(BuiltInFunction bf, LocalContext konto) {
        int oid = bf.objectM();
        int propId = bf.entityM(1);
        int idx = bf.getIntegerArg(2);
        BoxWorker worker = konto.getWorker();
        Entity entity = worker.entity(propId);
        String[] oc = worker.strings(oid, propId);
        int length = oc.length;
        if (idx < 0) {
            idx = length + idx + 1;
        }
        String filename = bf.getStringArg(3);
        return new Values(propId, oid, idx, filename, length);
    }

    static Token parseParamString(LocalContext lc, CharStream in, String escfun) {
        Token segment;
        StringBuilder sb = new StringBuilder();
        Parser p = lc.getParser();
        HashMap<String, Integer> varnums = lc.getVars().getVarnums();
        Token stringchain = new Token(TokenType.STRING_SEGMENT, 0, in);
        Sequence seq = stringchain.getSeq();
        if (in.isEndOfStream()) {
            in.nextChk();
            return null;
        }
        while (true) {
            if (in.ch == '\\') {
                in.nextChk();
                if (in.ch == '\\' || in.ch == '{' || in.ch == '}') {
                    sb.append(in.ch);
                    in.next();
                    continue;
                }
                throw new RuntimeException("Undefined escaping sequence '\\" + in.ch + "' in the parametrized string");
            }
            if (in.ch == '{') {
                segment = new Token(TokenType.BASIC_TYPE, 0, (Object)sb.toString(), null);
                seq.addToken(segment);
                sb.setLength(0);
                in.nextValidChk();
                p.next();
                Token tok = p.getPathTerm(seq);
                if (varnums != null) {
                    lc.getParser().funVarsChk(tok, varnums);
                }
                sb.append((CharSequence)in.getEaten());
                continue;
            }
            if (in.isEndOfStream()) break;
            sb.append(in.ch);
            in.next();
        }
        segment = new Token(TokenType.BASIC_TYPE, 0, (Object)sb.toString(), null);
        seq.addToken(segment);
        if (escfun != null) {
            String[] qname = Helper.getQName(escfun);
            String prefix = qname[0];
            String name = qname[1];
            Token fun = new Token(TokenType.FUN_CALL, prefix, name, null);
            FunctionTable functions = p.getFunctions();
            int numb = functions.checkFunction(lc.getFullName(fun), 1);
            if (numb == -1) {
                throw new RuntimeException("Escaping function " + (prefix == null ? name : prefix + ":" + name) + " not found in");
            }
            fun.setValue(numb);
            for (Token s : seq) {
                if (s.getType() != TokenType.TERM_EXP) continue;
                Token nw = fun.copy(null);
                nw.getSeq().addToken(s.copy(null));
                s.copyFrom(nw);
            }
        }
        return stringchain;
    }

    static class DecodeURL1
    extends BuiltInFunction {
        DecodeURL1() {
            super("decodeURL", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            try {
                return URLDecoder.decode(this.stringM(1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class DecodeURL0
    extends BuiltInFunction {
        DecodeURL0() {
            super("decodeURL", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            try {
                return URLDecoder.decode(this.stringM(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class EncodeURL1
    extends BuiltInFunction {
        EncodeURL1() {
            super("encodeURL", 1, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            try {
                return URLEncoder.encode(this.getStringArg(1), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class EncodeURL0
    extends BuiltInFunction {
        EncodeURL0() {
            super("encodeURL", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            try {
                return URLEncoder.encode(this.getCurrentString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class FunEval2
    extends BuiltInFunction {
        FunEval2() {
            super("eval", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object exp = this.getSingleArg(1);
            if (exp instanceof String) {
                String quoted = this.getStringArg(1);
                String esc = this.getStringArg(2);
                CharStream in = CharStream.createCharStream();
                in.rewindString(quoted);
                lc.pushIn0(in);
                Token query = StringFuncs.parseParamString(lc, in, esc);
                lc.popIn1();
                return lc.getInterp().eval(this.getCurrentValue(), query, this.getIndex(), this.getPrevious());
            }
            if (exp instanceof FunctionId) {
                Object[] rargs;
                VarTable vars = lc.getVars();
                int fid = ((FunctionId)exp).id();
                FunctionTable functions = lc.getHandler().getFunctions();
                FunctionDef fd = functions.getDefinition(fid);
                int ar = fd.getArity();
                Object args = this.getArg(2);
                if (args instanceof OntCollection) {
                    OntCollection oc = args instanceof OntCollection ? (OntCollection)args : (Interp.isFalse(args) ? OntCC.newCol() : OntCC.singleton(args));
                    int parity = oc.size();
                    rargs = new Object[parity + 1];
                    if (ar != parity) {
                        throw new RuntimeException("The ar of the anonymous function does not correspond to the number of actual parameters !(..)");
                    }
                    rargs[0] = this.getCurrentValue();
                    for (int i = 1; i <= parity; ++i) {
                        rargs[i] = oc.get(i - 1);
                    }
                } else if (args instanceof Token) {
                    Token arts = (Token)args;
                    if (arts.getType() != TokenType.CLOSURE) {
                        throw new RuntimeException("The closure not found in the 2nd argument in eval/2");
                    }
                    Object[] argsargs1 = (Object[])arts.getObj();
                    argsargs1[0] = this.getCurrentValue();
                    HashMap varsinargs = (HashMap)arts.getSub(0).getInfo();
                    int nnvar = arts.getSub(0).getNumber();
                    while (arts.getType() != TokenType.SET_EXP) {
                        if (arts.getSeq().size() != 1) {
                            throw new RuntimeException("Something wrong with the 2nd argument of eval/2");
                        }
                        arts = arts.getSub(0);
                    }
                    int parity = arts.getSeq().size();
                    if (ar != parity) {
                        throw new RuntimeException("The ar of the anonymous function does not correspond to the number of actual parameters !(..)");
                    }
                    rargs = new Object[ar + 1];
                    vars.pushEnv(argsargs1, varsinargs);
                    for (int i = 1; i <= parity; ++i) {
                        rargs[i] = lc.getInterp().eval(this.getCurrentValue(), arts.getSub(i - 1), this.getIndex(), this.getPrevious());
                    }
                    vars.popEnv();
                } else {
                    throw new RuntimeException("The 2nd argument of eval/2 must contain the arguments applied to the function entity " + exp);
                }
                Object def = fd.select(lc, rargs);
                Object ooo = this.getCurrentValue();
                OntCollection res = OntCC.newCol();
                if (def instanceof LibrettoFunction) {
                    Object curresult;
                    LibrettoFunction func = (LibrettoFunction)def;
                    func.setArguments(rargs);
                    func.setCurrentValue(ooo);
                    ((LibrettoFunction)def).setIndex(this.getIndex());
                    ((LibrettoFunction)def).setPrevious(this.getPrevious());
                    try {
                        curresult = func.call(lc);
                    }
                    catch (LabelException e) {
                        throw new LabelException(e.getKey());
                    }
                    catch (BreakException e) {
                        throw new BreakException(e.getResult());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage() + " in builtin function " + functions.getName(fid));
                    }
                    res.addAllTyped(curresult);
                } else {
                    Object[] rargs1;
                    Interp interp = lc.getInterp();
                    Token deffun = (Token)def;
                    Sequence defSeq = deffun.getSeq();
                    Token body = defSeq.get(defSeq.size() - 1);
                    int nnvars = deffun.getNumber();
                    int yieldshift = 0;
                    if (fd.isCollectionWise()) {
                        yieldshift = 1;
                    }
                    if (nnvars + yieldshift > ar) {
                        rargs1 = new Object[nnvars + 1 + yieldshift];
                        for (int i = yieldshift; i < rargs.length + yieldshift; ++i) {
                            rargs1[i] = rargs[i - yieldshift];
                        }
                    } else {
                        rargs1 = rargs;
                    }
                    vars.pushEnv(rargs1, (HashMap)deffun.getObj());
                    if (fd.isCollectionWise()) {
                        interp.resetYield();
                    }
                    try {
                        ooo = lc.getInterp().applyOperators(ooo, defSeq.get(1).getSeq(), ooo, this.getIndex(), this.getPrevious());
                    }
                    catch (ReturnException e) {
                        ooo = e.getResult();
                        if (fd.isCollectionWise()) {
                            interp.getYield().addAllTyped(ooo);
                        }
                    }
                    catch (ThroughException e) {
                        throw new ThroughException(e.getMessage());
                    }
                    catch (RuntimeException e) {
                        throw new ThroughException(e.getMessage() + " in user-defined function " + functions.getName(fid));
                    }
                    if (fd.isCollectionWise()) {
                        ooo = interp.getYield();
                    }
                    if (ooo != null && !ooo.equals(Boolean.FALSE)) {
                        res.addAllTyped(ooo);
                    }
                    vars.popEnv();
                }
                return res;
            }
            if (exp instanceof Token) {
                Object o;
                Token closure = (Token)exp;
                if (closure.getType() != TokenType.CLOSURE) {
                    throw new RuntimeException("No anonymous function found at the 1st argument");
                }
                VarTable vars = lc.getVars();
                Token fun = closure.getSub(0);
                int ar = fun.getSub(0).getSeq().size();
                Object[] rargs1 = (Object[])closure.getObj();
                Object args = this.getArg(2);
                if (args instanceof Token) {
                    Token arts = (Token)args;
                    if (arts.getType() != TokenType.CLOSURE) {
                        throw new RuntimeException("The closure not found in the 2nd argument in eval/2");
                    }
                    Object[] argsargs1 = (Object[])arts.getObj();
                    argsargs1[0] = this.getCurrentValue();
                    HashMap varsinargs = (HashMap)arts.getSub(0).getInfo();
                    int nnvar = arts.getSub(0).getNumber();
                    while (arts.getType() != TokenType.SET_EXP) {
                        if (arts.getSeq().size() != 1) {
                            throw new RuntimeException("Something wrong with the 2nd argument of eval/2");
                        }
                        arts = arts.getSub(0);
                    }
                    int parity = arts.getSeq().size();
                    if (ar != parity) {
                        throw new RuntimeException("The ar of the anonymous function does not correspond to the number of actual parameters !(..)");
                    }
                    vars.pushEnv(argsargs1, varsinargs);
                    for (int i = 1; i <= parity; ++i) {
                        rargs1[i] = lc.getInterp().eval(this.getCurrentValue(), arts.getSub(i - 1), this.getIndex(), this.getPrevious());
                    }
                    vars.popEnv();
                } else {
                    OntCollection oc = args instanceof OntCollection ? (OntCollection)args : (Interp.isFalse(args) ? OntCC.newCol() : OntCC.singleton(args));
                    int parity = oc.size();
                    if (ar != parity) {
                        throw new RuntimeException("The ar of the anonymous function does not correspond to the number of actual parameters !(..)");
                    }
                    rargs1[0] = this.getCurrentValue();
                    for (int i = 1; i <= parity; ++i) {
                        rargs1[i] = oc.get(i - 1);
                    }
                }
                Token body = fun.getSub(1);
                Interp interp = lc.getInterp();
                vars.pushEnv(rargs1, (HashMap)fun.getObj());
                try {
                    o = interp.applyOperators(this.getCurrentValue(), body.getSeq(), this.getContext(), this.getIndex(), this.getPrevious());
                }
                catch (ReturnException e) {
                    o = e.getResult();
                }
                catch (BreakException e) {
                    throw new BreakException(e.getResult());
                }
                OntCollection res = OntCC.newCol();
                if (o != null && !o.equals(Boolean.FALSE)) {
                    res.addAllTyped(o);
                }
                vars.popEnv();
                return res;
            }
            throw new RuntimeException("Invalid argument " + Helper.shortenString(exp));
        }
    }

    static class FunEval1
    extends BuiltInFunction {
        FunEval1() {
            super("eval", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Object quoted = this.getSingleArg(1);
            if (quoted instanceof String) {
                CharStream in = CharStream.createCharStream();
                in.rewindStringNoEat((String)quoted);
                lc.pushIn0(in);
                Token query = StringFuncs.parseParamString(lc, in, null);
                lc.popIn1();
                return lc.getInterp().eval(this.getCurrentValue(), query, this.getIndex(), this.getPrevious());
            }
            if (quoted instanceof Token) {
                Object o;
                Token body;
                Token closure = (Token)quoted;
                if (closure.getType() != TokenType.CLOSURE) {
                    throw new RuntimeException("No anonymous function found at the 1st argument");
                }
                Token fun = closure.getSub(0);
                Object[] rargs1 = (Object[])closure.getObj();
                rargs1[0] = this.getCurrentValue();
                if (fun.getType() == TokenType.ANONYM_FUN || fun.getType() == TokenType.SWITCH) {
                    body = fun;
                } else if (fun.getType() == TokenType.DECLARE_INSTR) {
                    int arity = fun.getSub(0).getSeq().size();
                    if (arity > 0) {
                        throw new RuntimeException("Actual parameters of the anonymous function are not defined in eval/1. Use eval/2");
                    }
                    body = fun.getSub(1);
                } else {
                    throw new RuntimeException("The 1st argument is invalid in eval/1");
                }
                Interp interp = lc.getInterp();
                VarTable vars = lc.getVars();
                vars.pushEnv(rargs1, (HashMap)fun.getObj());
                try {
                    o = interp.applyOperators(this.getCurrentValue(), body.getSeq(), this.getContext(), this.getIndex(), this.getPrevious());
                }
                catch (ReturnException e) {
                    o = e.getResult();
                }
                catch (BreakException e) {
                    throw new BreakException(e.getResult());
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(e.getMessage() + " in anonymous function");
                }
                OntCollection res = OntCC.newCol();
                if (o != null && !o.equals(Boolean.FALSE)) {
                    res.addAllTyped(o);
                }
                vars.popEnv();
                return res;
            }
            throw new RuntimeException("The 1st value of the eval/1 (the expression before '!') must be a parametrized string or a quoted expression");
        }
    }

    static class FunTxtExport4
    extends BuiltInFunction {
        FunTxtExport4() {
            super("txtExport", 4, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            String inc = this.getStringArg(4);
            try {
                FileOutputStream os = new FileOutputStream(vs.filename);
                OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os, inc);
                worker.string(vs.oid, vs.pid, vs.idx, wr);
            }
            catch (IOException e) {
                throw new RuntimeException("File/url '" + vs.filename + "': " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class FunTxtExport3
    extends BuiltInFunction {
        FunTxtExport3() {
            super("txtExport", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            try {
                FileOutputStream os = new FileOutputStream(vs.filename);
                OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os, "utf-8");
                worker.string(vs.oid, vs.pid, vs.idx, wr);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to access file/url '" + vs.filename + "': " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class FunTxtAdd4
    extends BuiltInFunction {
        FunTxtAdd4() {
            super("txtAdd", 4, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            String inc = this.getStringArg(4);
            try {
                InputStream is = Helper.getProtocolStream(vs.filename);
                InputStreamReader reader = new InputStreamReader(is, inc);
                worker.write().addString(vs.oid, vs.pid, vs.idx, reader);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to access file/url '" + vs.filename + "': " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class FunTxtSet4
    extends BuiltInFunction {
        FunTxtSet4() {
            super("txtSet", 4, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            String inc = this.getStringArg(4);
            try {
                InputStream is = Helper.getProtocolStream(vs.filename);
                InputStreamReader reader = new InputStreamReader(is, inc);
                if (vs.idx >= 0 && vs.idx < vs.length) {
                    worker.write().removeValue(vs.oid, vs.pid, vs.idx);
                }
                worker.write().addString(vs.oid, vs.pid, vs.idx, reader);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to access file/url '" + vs.filename + "': " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class FunTxtAdd3
    extends BuiltInFunction {
        FunTxtAdd3() {
            super("txtAdd", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            try {
                InputStream is = Helper.getProtocolStream(vs.filename);
                InputStreamReader reader = new InputStreamReader(is, "utf-8");
                worker.write().addString(vs.oid, vs.pid, vs.idx, reader);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to access file/url '" + vs.filename + "': " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class FunTxtSet3
    extends BuiltInFunction {
        FunTxtSet3() {
            super("txtSet", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            try {
                InputStream is = Helper.getProtocolStream(vs.filename);
                InputStreamReader reader = new InputStreamReader(is, "utf-8");
                if (vs.idx >= 0 && vs.idx < vs.length) {
                    worker.write().removeValue(vs.oid, vs.pid, vs.idx);
                }
                worker.write().addString(vs.oid, vs.pid, vs.idx, reader);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to access file/url '" + vs.filename + "': " + e.getMessage() + "in txt-set/3");
            }
            return Boolean.TRUE;
        }
    }

    static class FunBinExport3
    extends BuiltInFunction {
        FunBinExport3() {
            super("binExport", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            try {
                FileOutputStream os = new FileOutputStream(vs.filename);
                worker.binaries(vs.oid, vs.pid, vs.idx, os);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to access file/url '" + vs.filename + "': " + e.getMessage());
            }
            catch (RuntimeException e) {
                throw new RuntimeException("OntoBox reports: " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class FunBinAdd3
    extends BuiltInFunction {
        FunBinAdd3() {
            super("binAdd", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            try {
                InputStream is = Helper.getProtocolStream(vs.filename);
                worker.write().addBinary(vs.oid, vs.pid, vs.idx, is);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to access file/url '" + vs.filename + "': " + e.getMessage());
            }
            catch (RuntimeException e) {
                throw new RuntimeException("OntoBox reports: " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class FunBinSet3
    extends BuiltInFunction {
        FunBinSet3() {
            super("binSet", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext konto) {
            Values vs = StringFuncs.getDmapArgs(this, konto);
            BoxWorker worker = konto.getWorker();
            try {
                InputStream is = Helper.getProtocolStream(vs.filename);
                if (vs.idx >= 0 && vs.idx < vs.length) {
                    worker.write().removeValue(vs.oid, vs.pid, vs.idx);
                }
                worker.write().addBinary(vs.oid, vs.pid, vs.idx, is);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to access file/url '" + vs.filename + "': " + e.getMessage());
            }
            catch (RuntimeException e) {
                throw new RuntimeException("OntoBox reports: " + e.getMessage());
            }
            return Boolean.TRUE;
        }
    }

    static class Values {
        int pid;
        int oid;
        int idx;
        String filename;
        int length;

        Values(int p, int o, int i, String f, int l) {
            this.pid = p;
            this.oid = o;
            this.idx = i;
            this.filename = f;
            this.length = l;
        }
    }

    static class FunBinBase64Hex0
    extends BuiltInFunction {
        FunBinBase64Hex0() {
            super("binBase64Hex", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            String bin = this.getCurrentString();
            return BinaryHelper.toHex(BinaryHelper.fromBase64(bin));
        }
    }

    static class BinHexBase640
    extends BuiltInFunction {
        BinHexBase640() {
            super("binHexBase64", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            String hex = this.getCurrentString();
            return BinaryHelper.toBase64(BinaryHelper.fromHex(hex));
        }
    }

    static class FunSplit2
    extends BuiltInFunction {
        FunSplit2() {
            super("split", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            String ptrn = this.getStringArg(1);
            if (ptrn == null) {
                return null;
            }
            String flg = this.getStringArg(2);
            if (flg == null) {
                flg = "";
            }
            int flags = StringFuncs.getFlags(flg);
            Pattern pattern = Pattern.compile(ptrn, flags);
            Object e = this.getCurrentValue();
            try {
                FunSplit2.addString(result, pattern, (String)e);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }

        static void addString(OntCollection result, Pattern pattern, String e) {
            String[] splitted = pattern.split(e);
            result.addAll(Arrays.asList(splitted));
        }
    }

    static class FunReplace3
    extends BuiltInFunction {
        FunReplace3() {
            super("replace", 3, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            String ptrn = this.getStringArg(1);
            if (ptrn == null) {
                return null;
            }
            String rpls = this.getStringArg(2);
            if (rpls == null) {
                return null;
            }
            String flg = this.getStringArg(3);
            if (flg == null) {
                flg = "";
            }
            int flags = StringFuncs.getFlags(flg);
            Pattern pattern = Pattern.compile(ptrn, flags);
            Object e = this.getCurrentValue();
            try {
                FunReplace3.addString(result, pattern, rpls, (String)e);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }

        static void addString(OntCollection result, Pattern pattern, String replacement, String e) {
            if (e != null) {
                Matcher m = pattern.matcher(e);
                String res = m.replaceAll(replacement);
                result.add(res);
            }
        }
    }

    static class FunGroup1
    extends BuiltInFunction {
        FunGroup1() {
            super("group", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol();
            Object e = this.getRawValue();
            int n = this.getIntegerArg(1);
            if (e instanceof ObjectContainer) {
                try {
                    String[] gres = (String[])((ObjectContainer)e).getData();
                    String res = gres[n];
                    result.addAllTyped(res);
                }
                catch (Exception err) {
                    throw new RuntimeException("Invalid context or argument in function group/1");
                }
            } else {
                throw new RuntimeException("Invalid context in function group/1");
            }
            return result;
        }
    }

    private static class MatchAllRange
    implements ChoicePoint {
        final LocalContext lc;
        final Pattern pattern;
        int offset;
        final String string;
        final Matcher m;
        boolean hasnext;
        final String[] result = new String[10];
        String current;
        int pointer;
        boolean up;
        int counter;
        OntCollection collection = null;

        MatchAllRange(LocalContext konto, String ptrn, String str, String flg) {
            this.lc = konto;
            ptrn = ".*?(" + ptrn + ").*?";
            this.pattern = Pattern.compile(ptrn, StringFuncs.getFlags(flg));
            this.offset = 0;
            this.string = str;
            this.m = this.pattern.matcher(this.string);
            this.hasnext = this.m.find(this.offset);
            if (this.hasnext) {
                this.offset = this.m.end(1);
                this.setResult();
            }
        }

        private void setResult() {
            int gcount = this.m.groupCount();
            for (int i = 1; i <= 9; ++i) {
                this.result[i - 1] = i <= gcount ? this.m.group(i) : null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasnext;
        }

        @Override
        public Object next() {
            if (this.hasnext) {
                for (int i = 0; i <= 9; ++i) {
                    this.lc.getVars().putVarValue(this.lc.getHandler().matchVarNumber + i, (Object)this.result[i]);
                }
                this.current = this.result[0];
                this.hasnext = this.m.find(this.offset);
                if (this.hasnext) {
                    this.offset = this.m.end(1);
                    this.setResult();
                }
            }
            return this.current;
        }

        @Override
        public int getCounter() {
            return this.counter;
        }

        @Override
        public int getPointer() {
            return this.pointer;
        }

        @Override
        public Object getCurrent() {
            return this.current;
        }

        @Override
        public void setPointer(int pt) {
            this.pointer = pt;
        }

        @Override
        public OntCollection getCollection() {
            if (this.collection == null) {
                this.collection = OntCC.newCol();
                Matcher m = this.pattern.matcher(this.string);
                while (m.matches()) {
                    this.collection.addAllTyped(m.group(1));
                }
            }
            return this.collection;
        }
    }

    static class FunMatchAll2
    extends BuiltInFunction {
        FunMatchAll2() {
            super("matchAll", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            String string = this.getCurrentString();
            String pattern = this.getStringArg(1);
            String flg = this.getStringArg(2);
            if (pattern == null) {
                throw new RuntimeException("The pattern (1st argument) is not a string");
            }
            if (flg == null) {
                throw new RuntimeException("The flags (2nd argument) is not a string");
            }
            MatchAllRange cp = new MatchAllRange(lc, pattern, string, flg);
            return cp;
        }
    }

    static class FunMatch2
    extends BuiltInFunction {
        FunMatch2() {
            super("match", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            String ptrn = this.getStringArg(1);
            if (ptrn == null) {
                return null;
            }
            String flg = this.getStringArg(2);
            if (flg == null) {
                flg = "";
            }
            int flags = StringFuncs.getFlags(flg);
            Pattern pattern = Pattern.compile(ptrn, flags);
            Object e = this.getRawValue();
            try {
                FunMatch2.addString(lc, result, pattern, e);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }

        static void addString(LocalContext lc, OntCollection result, Pattern pattern, Object e) {
            if (e != null) {
                Object ee = ObjectContainer.getObject(e);
                if (!(ee instanceof String)) {
                    throw new RuntimeException("The context of matches/2 must be a string");
                }
                Matcher m = pattern.matcher((String)ee);
                if (m.matches()) {
                    int gcount = m.groupCount();
                    String[] gres = new String[gcount + 1];
                    for (int i = 0; i <= 9; ++i) {
                        if (i <= gcount) {
                            lc.getVars().putVarValue(lc.getHandler().matchVarNumber + i, (Object)m.group(i));
                            gres[i] = m.group(i);
                            continue;
                        }
                        lc.getVars().putVarValue(lc.getHandler().matchVarNumber + i, null);
                    }
                    if (!(e instanceof ObjectContainer)) {
                        e = new PropValContainer(e, 0);
                    }
                    ((ObjectContainer)e).setData(gres);
                    result.add(e);
                }
            }
        }
    }

    static class FunStringPad1
    extends BuiltInFunction {
        FunStringPad1() {
            super("stringPad", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Integer mult = this.getIntegerArg(1);
            if (mult == null) {
                return null;
            }
            Object e = this.getCurrentValue();
            try {
                FunStringPad1.addString(result, (String)e, mult);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }

        static void addString(OntCollection result, String e, int mm) {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            for (int i = 0; i < mm; ++i) {
                sb.append(e);
            }
            result.add(sb.toString());
        }
    }

    static class FunLower0
    extends BuiltInFunction {
        FunLower0() {
            super("lower", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            try {
                if (!(e instanceof String)) {
                    return null;
                }
                String trimmed = ((String)e).toLowerCase();
                result.add(trimmed);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }
    }

    static class FunUpper0
    extends BuiltInFunction {
        FunUpper0() {
            super("upper", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            try {
                if (!(e instanceof String)) {
                    return null;
                }
                String trimmed = ((String)e).toUpperCase();
                result.add(trimmed);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }
    }

    static class FunTrim0
    extends BuiltInFunction {
        FunTrim0() {
            super("trim", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            try {
                if (!(e instanceof String)) {
                    return null;
                }
                String trimmed = ((String)e).trim();
                result.add(trimmed);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }
    }

    static class FunLength0
    extends BuiltInFunction {
        FunLength0() {
            super("length", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            try {
                if (!(e instanceof String)) {
                    return null;
                }
                result.add(((String)e).length());
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }
    }

    static class FunSubstring2
    extends BuiltInFunction {
        FunSubstring2() {
            super("substring", 2, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            int len;
            int loc;
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object location = this.getSingleArg(1);
            Object ln = this.getSingleArg(2);
            if (location instanceof Integer) {
                loc = (Integer)location;
            } else if (location instanceof Double) {
                loc = (int)Math.round((Double)location);
            } else {
                return null;
            }
            if (ln instanceof Integer) {
                len = (Integer)ln;
            } else if (ln instanceof Double) {
                len = (int)Math.round((Double)ln);
            } else {
                return null;
            }
            Object e = this.getCurrentValue();
            try {
                StringFuncs.addString(result, e, loc, len);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }
    }

    static class FunCharAt1
    extends BuiltInFunction {
        FunCharAt1() {
            super("charAt", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            Integer location = this.getIntegerArg(1);
            String string = this.getCurrentString();
            if (location < 0 || location >= string.length()) {
                throw new RuntimeException("The index is out of bounds of the string");
            }
            return (int)string.charAt(location);
        }
    }

    static class FunEndsWith1
    extends BuiltInFunction {
        FunEndsWith1() {
            super("endsWith", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            String cmp = this.getStringArg(1);
            if (cmp == null) {
                return null;
            }
            Object e = this.getCurrentValue();
            try {
                if (((String)e).endsWith(cmp)) {
                    result.add(e);
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }
    }

    static class FunStartsWith1
    extends BuiltInFunction {
        FunStartsWith1() {
            super("startsWith", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            String cmp = this.getStringArg(1);
            if (cmp == null) {
                return null;
            }
            Object e = this.getCurrentValue();
            try {
                if (((String)e).startsWith(cmp)) {
                    result.add(e);
                }
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }
    }

    static class FunJoin3
    extends BuiltInFunction {
        FunJoin3() {
            super("join", 3, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            Object chkpath = this.getSingleArg(1);
            String typestr = this.getStringArg(2);
            String delim = this.getStringArg(3);
            return StringFuncs.joinStrings(o, chkpath, typestr, lc.getInterp(), this.getIndex(), delim);
        }
    }

    static class FunJoin0
    extends BuiltInFunction {
        FunJoin0() {
            super("join", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            StringBuilder sb = new StringBuilder();
            try {
                for (Object e : o) {
                    if ((e = ObjectContainer.getObject(e)) instanceof ObjectId) {
                        sb.append(lc.getWorker().name(((ObjectId)e).id()));
                        continue;
                    }
                    sb.append(e.toString());
                }
            }
            catch (Exception ee) {
                return null;
            }
            return sb.toString();
        }
    }

    static class FunJoin1
    extends BuiltInFunction {
        FunJoin1() {
            super("join", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            String separator = this.getStringArg(1);
            StringBuilder sb = new StringBuilder();
            if (separator == null) {
                return null;
            }
            try {
                int count = 0;
                for (Object e : o) {
                    e = ObjectContainer.getObject(e);
                    if (count > 0) {
                        sb.append(separator);
                    }
                    ++count;
                    if (e instanceof ObjectId) {
                        sb.append(lc.getWorker().name(((ObjectId)e).id()));
                        continue;
                    }
                    sb.append(e.toString());
                }
            }
            catch (Exception ee) {
                return null;
            }
            return sb.toString();
        }
    }

    static class FunCompare1
    extends BuiltInFunction {
        FunCompare1() {
            super("compare", 1, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            String cmp = this.getStringArg(1);
            if (cmp == null) {
                return null;
            }
            Object e = this.getCurrentValue();
            try {
                int n = ((String)e).compareTo(cmp);
                result.add(n);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }
    }

    static class FunStringsCodes1
    extends BuiltInFunction {
        FunStringsCodes1() {
            super("stringsCodes", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Integer separator = this.getIntegerArg(1);
            try {
                int count = 0;
                for (Object e : o) {
                    char[] codes;
                    if (!((e = ObjectContainer.getObject(e)) instanceof String)) continue;
                    if (count > 0) {
                        result.add(separator);
                    }
                    ++count;
                    for (char code : codes = ((String)e).toCharArray()) {
                        result.add(Integer.valueOf(code));
                    }
                }
            }
            catch (Exception ee) {
                return null;
            }
            return result;
        }
    }

    static class FunStringCodes0
    extends BuiltInFunction {
        FunStringCodes0() {
            super("stringCodes", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            try {
                FunStringCodes0.addString(result, e);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }

        static void addString(OntCollection result, Object e) {
            char[] codes;
            for (char code : codes = ((String)e).toCharArray()) {
                result.add(Integer.valueOf(code));
            }
        }
    }

    static class FunCodesStrings1
    extends BuiltInFunction {
        FunCodesStrings1() {
            super("codesStrings", 1, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection o = this.getContext();
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            int separator = this.getIntegerArg(1);
            int sz = o.size();
            char[] codes = new char[sz];
            int i = 0;
            try {
                String str;
                for (Object e : o) {
                    if (!((e = ObjectContainer.getObject(e)) instanceof Integer)) continue;
                    int n = (Integer)e;
                    if (n == separator) {
                        str = new String(codes, 0, i);
                        result.add(str);
                        i = 0;
                        continue;
                    }
                    if (n < 0) {
                        return null;
                    }
                    codes[i] = (char)n;
                    ++i;
                }
                str = new String(codes, 0, i);
                result.add(str);
            }
            catch (Exception ee) {
                return null;
            }
            return result;
        }
    }

    static class FunCodesString0
    extends BuiltInFunction {
        FunCodesString0() {
            super("codesString", 0, T.COLLECTION_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            String result;
            OntCollection o = this.getContext();
            int sz = o.size();
            char[] codes = new char[sz];
            int i = 0;
            try {
                for (Object e : o) {
                    if (!((e = ObjectContainer.getObject(e)) instanceof Integer)) continue;
                    int n = (Integer)e;
                    if (n < 0) {
                        return null;
                    }
                    codes[i] = (char)n;
                    ++i;
                }
                result = new String(codes);
            }
            catch (Exception ee) {
                return null;
            }
            return result;
        }
    }

    static class FunNL0
    extends BuiltInFunction {
        FunNL0() {
            super("nl", 0, T.STATIC);
        }

        @Override
        public Object call(LocalContext lc) {
            return System.getProperty("line.separator");
        }
    }

    static class FunString0
    extends BuiltInFunction {
        FunString0() {
            super("string", 0, T.ELEMENT_WISE);
        }

        @Override
        public Object call(LocalContext lc) {
            OntCollection result = OntCC.newCol(CollectionType.DATA_COL);
            Object e = this.getCurrentValue();
            try {
                this.addString(lc, result, e);
            }
            catch (Exception ee) {
                // empty catch block
            }
            return result;
        }

        void addString(LocalContext lc, OntCollection result, Object e) {
            if (e instanceof String) {
                result.add(e);
            } else if (e instanceof Integer || e instanceof Double) {
                result.add(e.toString());
            } else if (e instanceof NamedEntityId) {
                result.add(lc.getWorker().name(((NamedEntityId)e).id()));
            } else if (e instanceof Token) {
                Token t = (Token)e;
                if (t.getType() == TokenType.QUOTED_EXP) {
                    t = t.getSub();
                }
                result.add(t.toString());
            } else {
                result.add(e.toString());
            }
        }
    }
}

