/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.getchar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ontobox.libretto.getchar.NameTable;
import org.ontobox.libretto.getchar.Namespace;

public class NSContext {
    public final NameTable names;
    protected final ArrayList<Namespace> namespaces = new ArrayList();
    protected final NameTable nsTable = new NameTable();
    protected final Map<String, String> pu = new HashMap<String, String>();
    protected final Map<String, String> up = new HashMap<String, String>();
    private final Namespace nullNS;

    protected NSContext(NameTable ns) {
        Namespace defaultNS = this.nullNS = this.createNS("", "");
        this.names = ns;
    }

    protected Namespace createNS(String u, String p) {
        Namespace ns;
        int number = this.nsTable.checkName(u);
        if (number == -1) {
            number = this.nsTable.putName(u);
            ns = new Namespace(u, p, number, this);
            this.namespaces.add(number, ns);
        } else {
            ns = this.getNSbyNum(number);
            ns.setPrefix(p);
        }
        this.pu.put(p, u);
        this.up.put(u, p);
        return ns;
    }

    public Namespace createNS(String u) {
        int number = this.nsTable.checkName(u);
        if (number == -1) {
            number = this.nsTable.putName(u);
            Namespace ns = new Namespace(u, null, number, this);
            this.namespaces.add(number, ns);
            return ns;
        }
        return this.getNSbyNum(number);
    }

    public Namespace declareNS(String u, String p) {
        int i = this.nsTable.checkName(u);
        boolean pp = this.pu.containsKey(p);
        if (pp) {
            throw new RuntimeException("Double declaration of NS prefix " + p);
        }
        if (i != -1) {
            throw new RuntimeException("Double declaration of namespace " + u);
        }
        return this.createNS(u, p);
    }

    public Namespace getNSbyPrefix(String prefix) {
        if (prefix == null) {
            return null;
        }
        if (!this.pu.containsKey(prefix)) {
            return null;
        }
        String u = this.pu.get(prefix);
        if (u == null) {
            return null;
        }
        return this.getNSbyURI(u);
    }

    protected Namespace getNSbyNum(int n) {
        if (n < 0 || n >= this.namespaces.size()) {
            return null;
        }
        return this.namespaces.get(n);
    }

    public Namespace getNSbyURI(String u) {
        int n = this.nsTable.checkName(u);
        if (n == -1) {
            return null;
        }
        return this.namespaces.get(n);
    }

    public String getPrefixByURI(String uri) throws IllegalArgumentException {
        if (uri == null) {
            return null;
        }
        if (!this.up.containsKey(uri)) {
            return null;
        }
        return this.up.get(uri);
    }

    String getURIByPrefix(String prefix) throws IllegalArgumentException {
        if (prefix == null) {
            return null;
        }
        if (!this.pu.containsKey(prefix)) {
            return null;
        }
        return this.pu.get(prefix);
    }

    public Iterator getPrefixes(String uri) throws IllegalArgumentException {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        String prefix = this.getURIByPrefix(uri);
        if (prefix == null) {
            return null;
        }
        ArrayList<String> aa = new ArrayList<String>();
        aa.add(prefix);
        return aa.iterator();
    }

    public Namespace getNullNS() {
        return this.nullNS;
    }

    public String getNameByNum(int n) {
        return this.names.getName(n);
    }

    public boolean isNullNSNumber(int n) {
        return n == this.nullNS.getNumber();
    }
}

