/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.getchar;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;

class Stream {
    private final boolean echo;
    char ch;
    Reader reader;
    public int lineNum;
    public int posNum;
    public int filePos;
    String filename;
    private final StringBuilder collectbuffer = new StringBuilder();
    private StringBuilder extbuffer = null;

    public Stream(Reader reader, boolean echo) {
        this.reader = reader;
        this.lineNum = 1;
        this.posNum = 0;
        this.filePos = 0;
        this.echo = true;
    }

    public void setNewReader(Reader reader, String file) {
        this.reader = reader;
        this.lineNum = 1;
        this.posNum = 1;
        this.filename = file;
    }

    public void close() throws Exception {
        this.reader.close();
    }

    public char next() {
        try {
            char cha;
            while ((cha = (char)this.reader.read()) == '\ufeff') {
            }
            ++this.filePos;
            if (cha == '\n') {
                ++this.lineNum;
                this.posNum = 1;
            } else {
                ++this.posNum;
            }
            this.collectbuffer.append(cha);
            if (this.extbuffer != null) {
                this.extbuffer.append(cha);
            }
            this.ch = cha;
            return cha;
        }
        catch (IOException e) {
            return '\u0000';
        }
    }

    void setCollectBuffer() {
        this.collectbuffer.setLength(0);
        this.collectbuffer.append(this.ch);
    }

    String getCollectBuffer() {
        return this.collectbuffer.toString();
    }

    static void depth(PrintWriter writer, int n) {
        writer.println();
        for (int i = 0; i < n; ++i) {
            writer.print("  ");
        }
    }

    public void setExtbuffer(StringBuilder sb) {
        this.extbuffer = sb;
    }
}

