/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.helper;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.libretto.BreakException;
import org.ontobox.libretto.ChoicePoint;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.LabelException;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.ReturnException;
import org.ontobox.libretto.ThroughException;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.EntityId;
import org.ontobox.libretto.adapter.FunctionId;
import org.ontobox.libretto.adapter.OPropertyId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.TPropertyId;
import org.ontobox.libretto.adapter.TypeId;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.FunctionDef;
import org.ontobox.libretto.function.LibrettoFunction;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.parser.FunctionTable;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;
import org.ontobox.libretto.parser.VarTable;

public class Helper {
    public static int SHORTEN_LENGTH = 7;

    public static boolean isFirstNameLetter(Character ch) {
        return Character.isLetter(ch.charValue()) || ch.charValue() == '_';
    }

    public static boolean isNextNameLetter(Character ch) {
        return Character.isLetterOrDigit(ch.charValue()) || ch.charValue() == '-' || ch.charValue() == '_';
    }

    public static String[] getQName(String str) {
        if (str == null || str.equals("")) {
            throw new RuntimeException("Entity name not found");
        }
        char[] ch = str.toCharArray();
        if (ch[0] == '*' || ch[0] == '.') {
            if (ch.length == 1) {
                return new String[]{"", ""};
            }
            throw new RuntimeException("Invalid name " + Helper.shortenString(str));
        }
        StringBuilder nameChars = new StringBuilder();
        nameChars.setLength(0);
        String nsprefix = null;
        if (!Helper.isFirstNameLetter(Character.valueOf(ch[0])) && ch[0] != ':') {
            throw new RuntimeException("Invalid name \"" + str + "\"");
        }
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == ':' && nsprefix == null) {
                nsprefix = nameChars.toString();
                nameChars.delete(0, nameChars.length());
                if (!Helper.isNextNameLetter(Character.valueOf(ch[i])) && nsprefix == null) {
                    throw new RuntimeException("Something wrong in prefix of name " + Helper.shortenString(str, 7));
                }
                if (i == ch.length - 1) {
                    throw new RuntimeException("Invalid local part in name \"" + Helper.shortenString(str) + "\"");
                }
                if (ch[i + 1] != '*' || ch.length - 1 != i + 1) continue;
                return new String[]{nsprefix, ""};
            }
            nameChars.append(ch[i]);
        }
        String name = nameChars.toString();
        return new String[]{nsprefix, name};
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escapeString(String str) {
        char[] sr = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] arr$ = sr;
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block10: {
                if (i$ >= len$) {
                    return sr.toString();
                }
                char ch = arr$[i$];
                switch (ch) {
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case '{': {
                        sb.append("\\");
                        break;
                    }
                    case '\b': {
                        sb.append("\b");
                        break block10;
                    }
                    case '\n': {
                        sb.append("\n");
                        break block10;
                    }
                    case '\f': {
                        sb.append("\f");
                        break block10;
                    }
                    case '\r': {
                        sb.append("\r");
                        break block10;
                    }
                    case '\t': {
                        sb.append("\t");
                        break block10;
                    }
                }
                sb.append(ch);
            }
            ++i$;
        }
    }

    public static String escapeQuote(String str, char quote) {
        char[] sr = str.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char ch : sr) {
            if (ch == quote || ch == '\\') {
                sb.append("\\");
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String getFullByName(LocalContext lc, String name) {
        if (name.startsWith("http://")) {
            return name;
        }
        String[] nm = Helper.getQName(name);
        if (nm[1] == null) {
            throw new RuntimeException("Wrong name");
        }
        String uri = lc.getHandler().getUriByPrefix(nm[0]);
        if (nm[1].equals("")) {
            return uri;
        }
        return uri + "#" + nm[1];
    }

    public static EntityId getEntityByToken(LocalContext lc, Token tk) {
        String prefix = tk.getPrefix();
        String name = tk.getName();
        if (name == null) {
            name = "*";
        }
        if (prefix != null && !prefix.equals("")) {
            name = prefix + ":" + name;
        }
        return Helper.getEntityByString(lc, name, null);
    }

    public static EntityId getEntityByString(LocalContext lc, String name, Entity type) {
        BoxWorker w = lc.getWorker();
        Integer id = w.id(name);
        if (id == null) {
            try {
                name = Helper.getFullByName(lc, name);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to find entity \"" + name + "\"");
            }
            id = w.id(name);
        }
        return Helper.getEntityById(lc, id, type);
    }

    public static Integer checkEntity(Object obj, Entity e) {
        if (e == null && obj instanceof EntityId) {
            return ((EntityId)obj).id();
        }
        switch (e) {
            case ONTOLOGY: {
                if (!(obj instanceof OntologyId)) break;
                return ((EntityId)obj).id();
            }
            case ONTCLASS: {
                if (!(obj instanceof ClassId)) break;
                return ((EntityId)obj).id();
            }
            case OPROPERTY: {
                if (!(obj instanceof OPropertyId)) break;
                return ((EntityId)obj).id();
            }
            case TPROPERTY: {
                if (!(obj instanceof TPropertyId)) break;
                return ((EntityId)obj).id();
            }
            case ONTOBJECT: {
                if (!(obj instanceof ObjectId)) break;
                return ((EntityId)obj).id();
            }
            case TYPE: {
                if (!(obj instanceof TypeId)) break;
                return ((EntityId)obj).id();
            }
        }
        return null;
    }

    public static Integer createAnonym(Object lc, Object ont) {
        int oid;
        BoxWriter writer;
        if (lc instanceof LocalContext) {
            writer = ((LocalContext)lc).getWorker().write();
        } else if (lc instanceof BoxWorker) {
            writer = ((BoxWorker)lc).write();
        } else if (lc instanceof BoxWriter) {
            writer = (BoxWriter)lc;
        } else {
            return null;
        }
        if (ont instanceof OntologyId) {
            oid = ((OntologyId)ont).id();
        } else if (ont instanceof Integer) {
            oid = (Integer)ont;
        } else {
            return null;
        }
        String name = writer.newName(oid);
        return writer.newObject(name);
    }

    public static EntityId getEntityById(LocalContext lc, Integer id, Entity type) {
        if (id == null) {
            return null;
        }
        Entity entity = lc.getWorker().entity(id);
        if (type != null && type != entity) {
            return null;
        }
        switch (entity) {
            case ONTCLASS: {
                return ClassId.newId(id);
            }
            case OPROPERTY: {
                return OPropertyId.newId(id);
            }
            case TPROPERTY: {
                return TPropertyId.newId(id);
            }
            case ONTOLOGY: {
                return OntologyId.newId(id);
            }
            case TYPE: {
                return TypeId.newId(id);
            }
            case ONTOBJECT: {
                return ObjectId.newId(lc.getWorker(), id);
            }
        }
        return null;
    }

    public static String shortenString(Object obj) {
        return Helper.shortenString(obj, SHORTEN_LENGTH);
    }

    public static String shortenString(Object obj, int length) {
        if (obj == null) {
            return "null";
        }
        String str = obj.toString();
        if (str.length() < length + 5) {
            return str;
        }
        char[] ch = str.toCharArray();
        return String.copyValueOf(ch, 0, 4) + ".." + String.copyValueOf(ch, ch.length - 3, 3);
    }

    public static Integer getEntityByURI(LocalContext lc, String uri, Integer typeId) {
        BoxWorker w = lc.getWorker();
        Integer id = w.id(uri);
        if (id == null) {
            return null;
        }
        if (typeId != null) {
            int t = lc.entityType(id);
            if (t == typeId) {
                return id;
            }
            return null;
        }
        return id;
    }

    public static OntologyId getOntologyByAll(LocalContext lc, Object onto) {
        int ontid;
        if (onto instanceof Integer) {
            return OntologyId.newId((Integer)onto);
        }
        if (onto instanceof OntologyId) {
            return (OntologyId)onto;
        }
        if (onto instanceof String) {
            String uri;
            boolean create = false;
            String sonto = (String)onto;
            if (sonto.length() > 0 && sonto.charAt(0) == '+') {
                create = true;
                sonto = sonto.substring(1, sonto.length());
            }
            if (sonto.equals("") || Parser.prefixPattern.matcher(sonto).matches()) {
                uri = lc.getHandler().getMapping().get(sonto);
                if (uri == null) {
                    if (create) {
                        uri = Parser.createTempOntology(lc.getWorker());
                        lc.getOntology(uri);
                        lc.getHandler().getMapping().put(sonto, uri);
                    } else {
                        throw new RuntimeException("Ontology with prefix '" + sonto + "' not found");
                    }
                }
                onto = uri;
            }
            try {
                ontid = lc.getWorker().resolve((String)onto);
            }
            catch (Exception e) {
                if (!create) {
                    throw new RuntimeException("Ontology with prefix '" + sonto + "' not found");
                }
                uri = Parser.createTempOntology(lc.getWorker());
                lc.getOntology(uri);
                lc.getHandler().getMapping().put(sonto, uri);
                ontid = lc.getWorker().resolve(uri);
            }
        } else {
            throw new RuntimeException("The 1st argument must be an ontology name or an ontology datatype valuel");
        }
        return OntologyId.newId(ontid);
    }

    public static Token getNakedObjectCreater(Token tok1) {
        Token tok = tok1;
        while (tok.getType() == TokenType.QUERY_INSTR || tok.getType() == TokenType.TERM_EXP) {
            Sequence seq = tok.getSeq();
            if (seq.size() != 1) {
                return null;
            }
            tok = seq.getLast();
            if (tok.getType() != TokenType.MAP_OBJECT_CREATOR) continue;
            seq = tok.getSeq();
            for (int i = 0; i < seq.size(); ++i) {
                Token subtok = seq.get(i);
                if (subtok.getType() != TokenType.OBJ_MODIFIER) continue;
                seq.remove(i);
            }
            return tok1;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InputStream getProtocolStream(String str) throws IOException {
        String locaddr;
        String protocol;
        int pos = str.indexOf("://");
        InputStream in = null;
        if (pos >= 0) {
            protocol = str.substring(0, pos);
            locaddr = str.substring(pos + 3);
        } else {
            protocol = "file";
            locaddr = str;
        }
        try {
            if (protocol.equals("file")) {
                return new FileInputStream(locaddr);
            }
            if (protocol.equals("http")) {
                URL url = new URL(str);
                return url.openStream();
            }
            if (!protocol.equals("ftp")) return in;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return in;
    }

    public static Object getNormalized(Object o) {
        if (!(o instanceof OntCollection)) {
            return o;
        }
        OntCollection sc = (OntCollection)o;
        if (sc.size() == 1) {
            return sc.get(0);
        }
        if (sc.size() > 1) {
            return sc;
        }
        return Boolean.FALSE;
    }

    public static String shortName(LocalContext lc, Object entity) {
        if (entity instanceof String) {
            BoxWorker worker = lc.getWorker();
            Integer cid = worker.id((String)entity);
            Integer onto = worker.ontology(cid);
            String shortname = lc.getHandler().getPrefixByURI(worker.name(onto));
            shortname = shortname + ":" + worker.local(cid);
            return shortname;
        }
        if (entity instanceof Token) {
            Token tk = (Token)entity;
            String shortname = lc.getHandler().getPrefixByURI(lc.getTokenURI(tk));
            shortname = shortname + ":" + tk.getName();
            return shortname;
        }
        return null;
    }

    public static String sha(String uri) {
        try {
            MessageDigest m = MessageDigest.getInstance("SHA");
            m.update(uri.getBytes("UTF-8"));
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TypeId getDatatype(LocalContext lc, Token dt) {
        String full_name = lc.getFullName(dt);
        TypeId tp = lc.getDatatype(full_name);
        if (tp == null) {
            throw new RuntimeException("Datatype '" + dt.getName() + "' not found");
        }
        return tp;
    }

    public static String col2String(Object val, String delim) {
        String value;
        if (val instanceof OntCollection) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Object o : (OntCollection)val) {
                if (i > 0) {
                    sb.append(delim);
                }
                sb.append(o.toString());
                ++i;
            }
            value = sb.toString();
        } else {
            value = val.toString();
        }
        return value;
    }

    public static OntCollection wrapInCol(Object vals) {
        OntCollection ovals;
        if (vals instanceof OntCollection) {
            if (((OntCollection)vals).size() == 0) {
                return (OntCollection)vals;
            }
            Object fst = ((OntCollection)vals).get(0);
            if (fst instanceof ChoicePoint) {
                return ((ChoicePoint)fst).getCollection();
            }
            ovals = (OntCollection)vals;
        } else {
            ovals = vals instanceof ChoicePoint ? ((ChoicePoint)vals).getCollection() : (Interp.isFalse(vals) ? OntCC.newCol() : OntCC.singleton(vals));
        }
        return ovals;
    }

    public static Object applyFunction(LocalContext lc, Object curvalue, Integer index, Object previous, Object funcobj, Object[] rargs) {
        if (funcobj instanceof FunctionId) {
            int parity;
            VarTable vars = lc.getVars();
            int fid = ((FunctionId)funcobj).id();
            FunctionTable functions = lc.getHandler().getFunctions();
            FunctionDef fd = functions.getDefinition(fid);
            int arity = fd.getArity();
            if (arity != (parity = rargs.length - 1)) {
                throw new RuntimeException("The arity of function " + ((FunctionId)funcobj).toString() + " does not correspond to the number of actual parameters (" + parity + ")");
            }
            Object def = fd.select(lc, rargs);
            Object ooo = curvalue;
            OntCollection res = OntCC.newCol();
            if (def instanceof LibrettoFunction) {
                Object curresult;
                LibrettoFunction func = (LibrettoFunction)def;
                func.setArguments(rargs);
                func.setCurrentValue(ooo);
                ((LibrettoFunction)def).setIndex(index);
                ((LibrettoFunction)def).setPrevious(previous);
                try {
                    curresult = func.call(lc);
                }
                catch (LabelException e) {
                    throw new LabelException(e.getKey());
                }
                catch (BreakException e) {
                    throw new BreakException(e.getResult());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage() + " in builtin function " + functions.getName(fid));
                }
                res.addAllTyped(curresult);
            } else {
                Object[] rargs1;
                Interp interp = lc.getInterp();
                Token deffun = (Token)def;
                Sequence defSeq = deffun.getSeq();
                Token body = defSeq.get(defSeq.size() - 1);
                int nnvars = deffun.getNumber();
                int yieldshift = 0;
                if (fd.isCollectionWise()) {
                    yieldshift = 1;
                }
                if (nnvars + yieldshift > arity) {
                    rargs1 = new Object[nnvars + 1 + yieldshift];
                    for (int i = yieldshift; i < rargs.length + yieldshift; ++i) {
                        rargs1[i] = rargs[i - yieldshift];
                    }
                } else {
                    rargs1 = rargs;
                }
                vars.pushEnv(rargs1, (HashMap)deffun.getObj());
                if (fd.isCollectionWise()) {
                    interp.resetYield();
                }
                try {
                    ooo = lc.getInterp().applyOperators(ooo, defSeq.get(1).getSeq(), ooo, index, previous);
                }
                catch (ReturnException e) {
                    ooo = e.getResult();
                    if (fd.isCollectionWise()) {
                        interp.getYield().addAllTyped(ooo);
                    }
                }
                catch (ThroughException e) {
                    throw new ThroughException(e.getMessage());
                }
                catch (RuntimeException e) {
                    throw new ThroughException(e.getMessage() + " in user-defined function " + functions.getName(fid));
                }
                if (fd.isCollectionWise()) {
                    ooo = interp.getYield();
                }
                if (ooo != null && !ooo.equals(Boolean.FALSE)) {
                    res.addAllTyped(ooo);
                }
                vars.popEnv();
            }
            return res;
        }
        if (funcobj instanceof Token) {
            Object o;
            Token closure = (Token)funcobj;
            if (closure.getType() != TokenType.CLOSURE) {
                throw new RuntimeException("No anonymous function found at the 1st argument");
            }
            VarTable vars = lc.getVars();
            Token fun = closure.getSub(0);
            int arity = fun.getSub(0).getSeq().size();
            Object[] rargs1 = (Object[])closure.getObj();
            Token body = fun.getSub(1);
            Interp interp = lc.getInterp();
            vars.pushEnv(rargs1, (HashMap)fun.getObj());
            int parity = rargs.length - 1;
            if (arity != parity) {
                throw new RuntimeException("The arity of the anonymous function (" + arity + ") does not correspond to the number of actual parameters (" + parity + ")");
            }
            rargs1[0] = curvalue;
            for (int i = 1; i <= parity; ++i) {
                rargs1[i] = rargs[i];
            }
            try {
                o = interp.applyOperators(curvalue, body.getSeq(), curvalue, index, previous);
            }
            catch (ReturnException e) {
                o = e.getResult();
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e.getMessage() + " in anonymous function");
            }
            OntCollection res = OntCC.newCol();
            if (o != null && !o.equals(Boolean.FALSE)) {
                res.addAllTyped(o);
            }
            vars.popEnv();
            return res;
        }
        return null;
    }

    public static Token createFun(LocalContext lc, Sequence seq, String funuri, String funlocal, int arity, CharStream in) {
        String prefix = lc.getHandler().getPrefixByURI(funuri);
        Token fun = new Token(TokenType.FUN_CALL, prefix, funlocal, in);
        seq.addToken(fun);
        FunctionTable functions = lc.getHandler().getFunctions();
        int numb = functions.checkFunction(lc.getFullName(fun), 2);
        if (numb == -1) {
            throw new RuntimeException("Can not find function " + funlocal + "/" + arity);
        }
        fun.setValue(numb);
        fun.setObj(null);
        return fun;
    }

    public static void printST(PrintStream out, Throwable tr) {
        out.println(tr);
        for (StackTraceElement element : tr.getStackTrace()) {
            System.out.println("\tat " + element);
        }
        if ((tr = tr.getCause()) != null) {
            out.print("Caused by: ");
            Helper.printST(out, tr);
        }
    }
}

