/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.util.Collection;
import org.meta2project.model.OntObject;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.Entity;
import org.ontobox.libretto.Interp;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.M;
import org.ontobox.libretto.adapter.ClassId;
import org.ontobox.libretto.adapter.OPropertyId;
import org.ontobox.libretto.adapter.ObjectId;
import org.ontobox.libretto.adapter.OntologyId;
import org.ontobox.libretto.adapter.PropertyId;
import org.ontobox.libretto.adapter.TPropertyId;
import org.ontobox.libretto.adapter.TypeId;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.collection.OntCollection;
import org.ontobox.libretto.function.ModelFuncs;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;

public class LQuery {
    protected final Token query;
    protected final Interp interp;
    protected final Parser parser;
    protected final Object[] localVars;
    protected final LocalContext konto;

    public LQuery(Parser p, Interp i, String querystring) {
        this.parser = p;
        this.interp = i;
        this.localVars = new Object[10];
        for (int j = 0; j < 10; ++j) {
            this.localVars[j] = null;
        }
        CharStream in = CharStream.createCharStream();
        in.rewindString(querystring);
        this.parser.reset(in);
        this.parser.resetQuestionVarNum();
        Token program = new Token(TokenType.PROGRAM, 0, null);
        Sequence qseq = program.getSeq();
        this.query = this.parser.getQuery(qseq, null);
        this.konto = this.interp.konto;
    }

    public LQuery(Parser p, Interp i, CharStream in) {
        this.parser = p;
        this.interp = i;
        this.localVars = new Object[10];
        for (int j = 0; j < 10; ++j) {
            this.localVars[j] = null;
        }
        this.parser.resetQuestionVarNum();
        Token program = new Token(TokenType.PROGRAM, 0, null);
        Sequence qseq = program.getSeq();
        this.query = this.parser.getQuery(qseq, null);
        this.konto = this.interp.konto;
    }

    public void setString(int idx, String val) {
        if (idx < 0 || idx > 9) {
            throw new IllegalArgumentException("The index of query setString should belong to 0..9");
        }
        this.localVars[idx] = val;
    }

    public Collection execute() {
        for (int j = 0; j < 10; ++j) {
            if (this.localVars[j] == null) continue;
            int varnum = this.parser.vars.checkVar(String.valueOf(j));
            this.parser.vars.putVarValue(varnum, this.localVars[j]);
        }
        OntCollection res = this.interp.computePath(this.query);
        res = LQuery.convertTokens(this.konto, res);
        return res;
    }

    public Object execute1(OntObject obj) {
        return this.execute(OntCC.singleton(obj));
    }

    public OntCollection execute(Object curvalue) {
        if (curvalue instanceof Collection) {
            Collection col = (Collection)curvalue;
            OntCollection res = OntCC.newCol(CollectionType.UNDEF_COL, col.size());
            for (Object o : col) {
                if (o instanceof OntologyId) {
                    o = ModelFuncs.createQuotedOntology(this.konto, (OntologyId)o);
                } else if (o instanceof ClassId) {
                    o = ModelFuncs.createQuotedClass(this.konto, ((ClassId)o).id());
                } else if (o instanceof PropertyId) {
                    o = ModelFuncs.createQuotedProperty(this.konto, ((PropertyId)o).id());
                }
                res.addAllTyped(o);
            }
            curvalue = res;
        } else if (curvalue instanceof OntologyId) {
            curvalue = ModelFuncs.createQuotedOntology(this.konto, (OntologyId)curvalue);
        } else if (curvalue instanceof ClassId) {
            curvalue = ModelFuncs.createQuotedClass(this.konto, ((ClassId)curvalue).id());
        } else if (curvalue instanceof PropertyId) {
            curvalue = ModelFuncs.createQuotedProperty(this.konto, ((PropertyId)curvalue).id());
        }
        for (int j = 0; j < 10; ++j) {
            if (this.localVars[j] == null) continue;
            int varnum = this.parser.vars.checkVar(String.valueOf(j));
            this.parser.vars.putVarValue(varnum, this.localVars[j]);
        }
        Sequence seq = this.query.getSeq();
        Token q = seq.get(0);
        Object res = this.interp.calcPredicate(curvalue, q, M.P_COMPUTE, null, null, null);
        if (!(res instanceof OntCollection)) {
            res = OntCC.singleton(res);
        }
        res = LQuery.convertTokens(this.konto, (OntCollection)res);
        return (OntCollection)res;
    }

    public static OntCollection convertTokens(LocalContext konto, Collection input) {
        OntCollection output = OntCC.newCol();
        for (Object o : input) {
            if (o instanceof Token) {
                Token entity = ModelFuncs.getQuotedEntity(o);
                BoxWorker worker = konto.getWorker();
                if (entity.getType() == TokenType.ASTERISK) {
                    o = konto.getTokenURI(entity);
                    o = OntologyId.newId(worker.resolve((String)o, Entity.ONTOLOGY));
                } else {
                    o = konto.getFullName(entity);
                    String name = (String)o;
                    Entity e = worker.entity(name);
                    if (e != null) {
                        int id = worker.id(name);
                        switch (e) {
                            case ONTCLASS: {
                                o = ClassId.newId(id);
                                break;
                            }
                            case ONTOBJECT: {
                                o = ObjectId.newId(worker, id);
                                break;
                            }
                            case OPROPERTY: {
                                o = OPropertyId.newId(id);
                                break;
                            }
                            case TPROPERTY: {
                                o = TPropertyId.newId(id);
                                break;
                            }
                            case TYPE: {
                                o = TypeId.newId(id);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected:" + e.toString() + ", " + o);
                            }
                        }
                    } else {
                        throw new IllegalStateException("Unexpected:" + o);
                    }
                }
            }
            output.addAllTyped(o);
        }
        return output;
    }

    public Token getQuery() {
        return this.query;
    }
}

