/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.ontobox.libretto.collection.CollectionType;
import org.ontobox.libretto.collection.OntCC;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;

public class VarTable {
    int globalVarCounter = 0;
    Object[] localTop;
    private final HashMap<String, Integer> globalTab = new HashMap();
    private final ArrayList globalValues = new ArrayList();
    private final Stack<Object[]> localEnv = new Stack();
    final HashMap<Integer, String> varNumTable = new HashMap();
    private final Stack<HashMap<String, Integer>> varnumsEnv = new Stack();

    public VarTable() {
        this.globalValues.add(OntCC.newCol(CollectionType.UNDEF_COL));
    }

    public void reset() {
        this.varnumsEnv.clear();
        this.localEnv.clear();
    }

    public int checkVar(String var) {
        if (this.globalTab.containsKey(var)) {
            return this.globalTab.get(var);
        }
        return -1;
    }

    public int putNewVar(String var) {
        ++this.globalVarCounter;
        this.globalTab.put(var, this.globalVarCounter);
        this.varNumTable.put(this.globalVarCounter, var);
        this.globalValues.add(null);
        return this.globalVarCounter;
    }

    public int putVar(String var) {
        int num = this.checkVar(var);
        if (num == -1) {
            num = this.putNewVar(var);
        }
        return num;
    }

    public void pushEnv(Object[] vars, HashMap<String, Integer> varnums) {
        this.localEnv.push(vars);
        this.varnumsEnv.push(varnums);
    }

    public int getEnvSize() {
        return this.localEnv.size();
    }

    public void popEnv() {
        if (this.localEnv.empty()) {
            throw new RuntimeException("The attempt to pop from empty local environment");
        }
        this.localEnv.pop();
        this.varnumsEnv.pop();
    }

    public void putVarValue(int varnum, Object val) {
        if (varnum > 0) {
            this.globalValues.set(varnum, val);
        } else {
            this.localEnv.peek()[-varnum] = val;
        }
    }

    public void putVarValue(Token var, Object val) {
        if (var.getType() == TokenType.VAR_REF || var.getType() == TokenType.SET_FIELD) {
            this.putVarValue(var.getValue(), val);
        }
    }

    public Object getVarValue(int varnum) {
        if (varnum > 0) {
            if (varnum < this.globalValues.size()) {
                return this.globalValues.get(varnum);
            }
            return null;
        }
        return this.localEnv.peek()[-varnum];
    }

    public HashMap<String, Integer> getGlobalTab() {
        return this.globalTab;
    }

    public HashMap<String, Integer> getVarnums() {
        if (this.varnumsEnv.isEmpty()) {
            return null;
        }
        return this.varnumsEnv.peek();
    }

    static boolean isGlobalVar(int num) {
        return num > 0;
    }

    static boolean isLocalVar(int num) {
        return num < 0;
    }
}

