/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.ontobox.libretto.LocalContext;
import org.ontobox.libretto.function.StringFuncs;
import org.ontobox.libretto.getchar.CharStream;
import org.ontobox.libretto.helper.Helper;
import org.ontobox.libretto.parser.Parser;
import org.ontobox.libretto.parser.Sequence;
import org.ontobox.libretto.parser.Token;
import org.ontobox.libretto.parser.TokenType;

public class XMLCompiler {
    public static final String ELEM = "http://xml.ontobox.org/#elem";
    public static final String ATTR = "http://xml.ontobox.org/#attr";
    public static final String TEXT = "http://xml.ontobox.org/#text";
    public static final String ADD = "http://xml.ontobox.org/#add";
    private static final Map<String, Integer> entities = new HashMap<String, Integer>();
    private CharStream in;
    private LocalContext lc;
    private Parser parser;
    private Token paramset;
    private Token head;
    private String varprefix = "var";
    private int varcounter = 0;

    public XMLCompiler(LocalContext lc, Sequence seq, CharStream in) {
        this.lc = lc;
        this.in = in;
        this.parser = lc.getParser();
        Token qun = new Token(TokenType.QUOTED_EXP, 0, null);
        this.head = new Token(TokenType.FUNCTOR, 0, null);
        this.head.setName("_");
        Sequence pseq = Parser.createToken(TokenType.SET_EXP, 0, qun.getSeq(), in);
        this.paramset = pseq.parent;
        HashMap<String, Integer> localvarnums = lc.getParser().varnums;
        HashMap varnums = new HashMap();
        lc.getParser().varnums = varnums;
        int localvarnum = this.parser.varnum;
        this.parser.varnum = -1;
        Map<Integer, Token> localvarsinanonym = lc.getParser().varsinanonym;
        lc.getParser().varsinanonym = new HashMap<Integer, Token>();
        Token elem = this.getElement(qun.getSeq());
        Token fun = Helper.createFun(lc, seq, "http://ontobox.org/", StringFuncs.EVAL_FUN, 2, in);
        Sequence qseq = Parser.createPolishToken(TokenType.QUOTED_EXP, 0, fun.getSeq(), in);
        Sequence dseq = Parser.createToken(TokenType.DECLARE_INSTR, qseq, in);
        dseq.addToken(this.head);
        Sequence oseq = Parser.createToken(TokenType.OBJ_MODIFIER, 1, dseq, in);
        oseq.addToken(elem);
        Sequence aseq = Parser.createPolishToken(TokenType.QUOTED_EXP, 0, fun.getSeq(), in);
        aseq.addToken(this.paramset);
        dseq.getParent().setInfo(lc.getParser().varsinanonym);
        this.paramset.setInfo(lc.getParser().varsinanonym);
        this.parser.varnum = -1;
        lc.getParser().funVarsChk(dseq.get(0), lc.getParser().varnums);
        lc.getParser().funVarsChk(dseq.get(1), lc.getParser().varnums);
        lc.getParser().funVarsChk(this.paramset, lc.getParser().varnums);
        dseq.getParent().setNumber(varnums.size());
        this.paramset.setNumber(varnums.size());
        lc.getParser().varsinanonym = localvarsinanonym;
        lc.getParser().varnums = localvarnums;
        lc.getParser().varnum = localvarnum;
        in.nextValid();
    }

    private Token getElement(Sequence parent) {
        Sequence curseq = this.wrapper(parent);
        String[] nms = this.in.getXMLQName();
        if (nms[0] == null) {
            nms[0] = "";
        }
        String name = nms[1];
        this.elem(curseq, name);
        while (this.in.ch != '>') {
            if (this.in.ch == '/') {
                this.in.nextChk();
                if (this.in.ch != '>') {
                    throw new RuntimeException("'>' not found in the void element of the XML expression");
                }
                return curseq.parent;
            }
            this.in.eatSpacesChk();
            nms = this.in.getXMLQName();
            if (nms[0] == null) {
                nms[0] = "";
            }
            if (this.in.ch != '=') {
                throw new RuntimeException("'=' in the opening tag");
            }
            this.in.nextValidChk();
            if (this.in.ch == '\"' || this.in.ch == '\'') {
                String value = this.in.getString();
                this.add(curseq, this.attr(null, nms[1], value));
                continue;
            }
            if (this.in.ch == '{') {
                Parser p = this.lc.getParser();
                this.in.nextValidChk();
                p.next();
                Token var = this.getvar();
                this.head.getSeq().addToken(var);
                Token expr = p.getPathTerm(null);
                this.paramset.getSeq().addToken(expr);
                this.add(curseq, this.attr(null, nms[1], var));
                continue;
            }
            throw new RuntimeException("The value of attribute '" + nms[1] + "' not found");
        }
        this.in.nextChk();
        this.getBody(curseq, name, nms[0]);
        return curseq.parent;
    }

    private void getText(Sequence seq, char delim) {
        StringBuilder sb = new StringBuilder();
        while (this.in.ch != delim || delim == '<') {
            if (this.in.ch == '&') {
                sb.append((char)this.getEntity(seq));
                continue;
            }
            if (this.in.ch == '{') {
                Parser p = this.lc.getParser();
                Token var = this.getvar();
                this.head.getSeq().addToken(var);
                this.saveText(seq, sb);
                this.in.nextValidChk();
                p.next();
                Token expr = p.getPathTerm(null);
                this.paramset.getSeq().addToken(expr);
                this.add(seq, var);
                sb.append((CharSequence)this.in.getEaten());
                this.saveText(seq, sb);
                continue;
            }
            if (this.in.ch == '<' && delim == '<') {
                this.in.nextChk();
                this.saveText(seq, sb);
                if (this.in.ch == '/') {
                    this.in.nextChk();
                    break;
                }
                this.add(seq, this.getElement(null));
                this.in.nextChk();
                continue;
            }
            sb.append(this.in.ch);
            this.in.nextChk();
        }
        this.saveText(seq, sb);
    }

    private void saveText(Sequence seq, StringBuilder sb) {
        if (sb.length() > 0) {
            this.add(seq, this.text(null, sb.toString()));
            sb.setLength(0);
        }
    }

    private void getBody(Sequence seq, String opening, String prefix) {
        this.getText(seq, '<');
        if (this.in.ch == '>') {
            if (!opening.equals("")) {
                throw new RuntimeException("'</>' can be used only in elements with parametrized names");
            }
        } else if (this.in.isFirstNameLetter()) {
            String closing;
            if (opening.equals("")) {
                throw new RuntimeException("'</>' not found as the closing tag of the parametrized element");
            }
            String[] nms = this.in.getXMLQName();
            if (nms[0] == null) {
                nms[0] = "";
            }
            if (!(closing = nms[1]).equals(opening)) {
                throw new RuntimeException("The closing tag name does not correspond to the opening tag name (\"" + opening + "\" and \"" + closing + "\")");
            }
            if (!nms[0].equals(prefix)) {
                throw new RuntimeException("The prefixes of opening and closing tags do not match (\"" + prefix + "\" and \"" + nms[0] + "\" in element " + opening);
            }
            if (this.in.ch != '>') {
                throw new RuntimeException("'>' not found in the closing tag");
            }
        }
    }

    private int getEntity(Sequence parent) {
        int ch;
        StringBuilder sb = new StringBuilder();
        this.in.nextChk();
        int radix = 0;
        if (this.in.ch == '#') {
            this.in.nextChk();
            if (this.in.ch == 'x') {
                radix = 16;
                this.in.nextChk();
            } else {
                radix = 10;
            }
        }
        while (this.in.ch != ';') {
            if (this.in.ch == '\n' || this.in.ch == '\r') {
                throw new RuntimeException("New line within the XML entity in the XML expression");
            }
            sb.append(this.in.ch);
            this.in.nextChk();
        }
        this.in.nextChk();
        String str = sb.toString();
        if (radix > 0) {
            try {
                ch = Integer.parseInt(str, radix);
            }
            catch (Exception e) {
                throw new RuntimeException("XML parser: invalid &...;");
            }
        } else if (entities.containsKey(str)) {
            ch = (char)entities.get(str).intValue();
        } else {
            throw new RuntimeException("Invalid entity &" + str + "; in the XML expression");
        }
        return ch;
    }

    private Token elem(Sequence seq, String name) {
        Token t = this.funcall(ELEM, 1);
        if (seq != null) {
            seq.addToken(t);
        }
        t.getSeq().addToken(this.string(name));
        return t;
    }

    private Token attr(Sequence seq, String key, Object value) {
        Token t = this.funcall(ATTR, 2);
        if (seq != null) {
            seq.addToken(t);
        }
        t.getSeq().addToken(this.string(key));
        if (value instanceof String) {
            t.getSeq().addToken(this.string((String)value));
        } else {
            t.getSeq().addToken((Token)value);
        }
        return t;
    }

    private Token text(Sequence seq, String text) {
        Token t = this.funcall(TEXT, 1);
        if (seq != null) {
            seq.addToken(t);
        }
        t.getSeq().addToken(this.string(text));
        return t;
    }

    private Token add(Sequence seq, Token added) {
        Token t = this.funcall(ADD, 1);
        if (seq != null) {
            seq.addToken(t);
        }
        t.getSeq().addToken(added);
        return t;
    }

    private Token funcall(String name, int arity) {
        int funnum = this.lc.getHandler().getFunctions().checkFunction(name, arity);
        Token t = new Token(TokenType.FUN_CALL, funnum, this.in);
        t.prefix = this.lc.getHandler().getPrefixByURI("http://xml.ontobox.org/");
        t.uri = "http://xml.ontobox.org/";
        if (t.prefix == null) {
            throw new RuntimeException("Prefix is not defined for the XML ontology http://xml.ontobox.org/");
        }
        if (name.equals(TEXT)) {
            t.name = "text";
        } else if (name.equals(ELEM)) {
            t.name = "elem";
        } else if (name.equals(ATTR)) {
            t.name = "attr";
        } else if (name.equals(ADD)) {
            t.name = "add";
        }
        return t;
    }

    private Sequence wrapper(Sequence seq) {
        Token t = new Token(TokenType.PATH_EXP, 0, this.in);
        if (seq != null) {
            seq.addToken(t);
        }
        return t.getSeq();
    }

    private Token string(String name) {
        return new Token(TokenType.BASIC_TYPE, 0, (Object)name, this.in);
    }

    private static int getNumRef(String ent) {
        int radix = 10;
        int start = 1;
        if (ent.charAt(1) == 'x') {
            radix = 16;
            start = 2;
        }
        String num = ent.substring(start);
        try {
            return Integer.parseInt(num, radix);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid numeric character reference " + ent);
        }
    }

    public static int getCharEntity(String entity) {
        Integer res = entity.charAt(0) == '#' ? Integer.valueOf(XMLCompiler.getNumRef(entity)) : entities.get(entity);
        if (res == null) {
            throw new RuntimeException("Entity \"" + entity + "\" not found");
        }
        return res;
    }

    public static Collection html5entities() {
        return new TreeSet<String>(entities.keySet());
    }

    private Token getvar() {
        ++this.varcounter;
        String varname = this.varprefix + this.varcounter;
        int glvarnum = this.lc.getVars().putVar(varname);
        Token var = new Token(TokenType.VAR_REF, glvarnum, this.in);
        var.setName(varname);
        return var;
    }

    private static void setHTML5Entities() {
        entities.put("AElig", 198);
        entities.put("AMP", 38);
        entities.put("Aacute", 193);
        entities.put("Abreve", 258);
        entities.put("Acirc", 194);
        entities.put("Acy", 1040);
        entities.put("Afr", 120068);
        entities.put("Agrave", 192);
        entities.put("Alpha", 913);
        entities.put("Amacr", 256);
        entities.put("And", 10835);
        entities.put("Aogon", 260);
        entities.put("Aopf", 120120);
        entities.put("ApplyFunction", 8289);
        entities.put("Aring", 197);
        entities.put("Ascr", 119964);
        entities.put("Assign", 8788);
        entities.put("Atilde", 195);
        entities.put("Auml", 196);
        entities.put("Backslash", 8726);
        entities.put("Barv", 10983);
        entities.put("Barwed", 8966);
        entities.put("Bcy", 1041);
        entities.put("Because", 8757);
        entities.put("Bernoullis", 8492);
        entities.put("Beta", 914);
        entities.put("Bfr", 120069);
        entities.put("Bopf", 120121);
        entities.put("Breve", 728);
        entities.put("Bscr", 8492);
        entities.put("Bumpeq", 8782);
        entities.put("CHcy", 1063);
        entities.put("COPY", 169);
        entities.put("Cacute", 262);
        entities.put("Cap", 8914);
        entities.put("CapitalDifferentialD", 8517);
        entities.put("Cayleys", 8493);
        entities.put("Ccaron", 268);
        entities.put("Ccedil", 199);
        entities.put("Ccirc", 264);
        entities.put("Cconint", 8752);
        entities.put("Cdot", 266);
        entities.put("Cedilla", 184);
        entities.put("CenterDot", 183);
        entities.put("Cfr", 8493);
        entities.put("Chi", 935);
        entities.put("CircleDot", 8857);
        entities.put("CircleMinus", 8854);
        entities.put("CirclePlus", 8853);
        entities.put("CircleTimes", 8855);
        entities.put("ClockwiseContourIntegral", 8754);
        entities.put("CloseCurlyDoubleQuote", 8221);
        entities.put("CloseCurlyQuote", 8217);
        entities.put("Colon", 8759);
        entities.put("Colone", 10868);
        entities.put("Congruent", 8801);
        entities.put("Conint", 8751);
        entities.put("ContourIntegral", 8750);
        entities.put("Copf", 8450);
        entities.put("Coproduct", 8720);
        entities.put("CounterClockwiseContourIntegral", 8755);
        entities.put("Cross", 10799);
        entities.put("Cscr", 119966);
        entities.put("Cup", 8915);
        entities.put("CupCap", 8781);
        entities.put("DD", 8517);
        entities.put("DDotrahd", 10513);
        entities.put("DJcy", 1026);
        entities.put("DScy", 1029);
        entities.put("DZcy", 1039);
        entities.put("Dagger", 8225);
        entities.put("Darr", 8609);
        entities.put("Dashv", 10980);
        entities.put("Dcaron", 270);
        entities.put("Dcy", 1044);
        entities.put("Del", 8711);
        entities.put("Delta", 916);
        entities.put("Dfr", 120071);
        entities.put("DiacriticalAcute", 180);
        entities.put("DiacriticalDot", 729);
        entities.put("DiacriticalDoubleAcute", 733);
        entities.put("DiacriticalGrave", 96);
        entities.put("DiacriticalTilde", 732);
        entities.put("Diamond", 8900);
        entities.put("DifferentialD", 8518);
        entities.put("Dopf", 120123);
        entities.put("Dot", 168);
        entities.put("DotDot", 8412);
        entities.put("DotEqual", 8784);
        entities.put("DoubleContourIntegral", 8751);
        entities.put("DoubleDot", 168);
        entities.put("DoubleDownArrow", 8659);
        entities.put("DoubleLeftArrow", 8656);
        entities.put("DoubleLeftRightArrow", 8660);
        entities.put("DoubleLeftTee", 10980);
        entities.put("DoubleLongLeftArrow", 10232);
        entities.put("DoubleLongLeftRightArrow", 10234);
        entities.put("DoubleLongRightArrow", 10233);
        entities.put("DoubleRightArrow", 8658);
        entities.put("DoubleRightTee", 8872);
        entities.put("DoubleUpArrow", 8657);
        entities.put("DoubleUpDownArrow", 8661);
        entities.put("DoubleVerticalBar", 8741);
        entities.put("DownArrow", 8595);
        entities.put("DownArrowBar", 10515);
        entities.put("DownArrowUpArrow", 8693);
        entities.put("DownBreve", 785);
        entities.put("DownLeftRightVector", 10576);
        entities.put("DownLeftTeeVector", 10590);
        entities.put("DownLeftVector", 8637);
        entities.put("DownLeftVectorBar", 10582);
        entities.put("DownRightTeeVector", 10591);
        entities.put("DownRightVector", 8641);
        entities.put("DownRightVectorBar", 10583);
        entities.put("DownTee", 8868);
        entities.put("DownTeeArrow", 8615);
        entities.put("Downarrow", 8659);
        entities.put("Dscr", 119967);
        entities.put("Dstrok", 272);
        entities.put("ENG", 330);
        entities.put("ETH", 208);
        entities.put("Eacute", 201);
        entities.put("Ecaron", 282);
        entities.put("Ecirc", 202);
        entities.put("Ecy", 1069);
        entities.put("Edot", 278);
        entities.put("Efr", 120072);
        entities.put("Egrave", 200);
        entities.put("Element", 8712);
        entities.put("Emacr", 274);
        entities.put("EmptySmallSquare", 9723);
        entities.put("EmptyVerySmallSquare", 9643);
        entities.put("Eogon", 280);
        entities.put("Eopf", 120124);
        entities.put("Epsilon", 917);
        entities.put("Equal", 10869);
        entities.put("EqualTilde", 8770);
        entities.put("Equilibrium", 8652);
        entities.put("Escr", 8496);
        entities.put("Esim", 10867);
        entities.put("Eta", 919);
        entities.put("Euml", 203);
        entities.put("Exists", 8707);
        entities.put("ExponentialE", 8519);
        entities.put("Fcy", 1060);
        entities.put("Ffr", 120073);
        entities.put("FilledSmallSquare", 9724);
        entities.put("FilledVerySmallSquare", 9642);
        entities.put("Fopf", 120125);
        entities.put("ForAll", 8704);
        entities.put("Fouriertrf", 8497);
        entities.put("Fscr", 8497);
        entities.put("GJcy", 1027);
        entities.put("GT", 62);
        entities.put("Gamma", 915);
        entities.put("Gammad", 988);
        entities.put("Gbreve", 286);
        entities.put("Gcedil", 290);
        entities.put("Gcirc", 284);
        entities.put("Gcy", 1043);
        entities.put("Gdot", 288);
        entities.put("Gfr", 120074);
        entities.put("Gg", 8921);
        entities.put("Gopf", 120126);
        entities.put("GreaterEqual", 8805);
        entities.put("GreaterEqualLess", 8923);
        entities.put("GreaterFullEqual", 8807);
        entities.put("GreaterGreater", 10914);
        entities.put("GreaterLess", 8823);
        entities.put("GreaterSlantEqual", 10878);
        entities.put("GreaterTilde", 8819);
        entities.put("Gscr", 119970);
        entities.put("Gt", 8811);
        entities.put("HARDcy", 1066);
        entities.put("Hacek", 711);
        entities.put("Hat", 94);
        entities.put("Hcirc", 292);
        entities.put("Hfr", 8460);
        entities.put("HilbertSpace", 8459);
        entities.put("Hopf", 8461);
        entities.put("HorizontalLine", 9472);
        entities.put("Hscr", 8459);
        entities.put("Hstrok", 294);
        entities.put("HumpDownHump", 8782);
        entities.put("HumpEqual", 8783);
        entities.put("IEcy", 1045);
        entities.put("IJlig", 306);
        entities.put("IOcy", 1025);
        entities.put("Iacute", 205);
        entities.put("Icirc", 206);
        entities.put("Icy", 1048);
        entities.put("Idot", 304);
        entities.put("Ifr", 8465);
        entities.put("Igrave", 204);
        entities.put("Im", 8465);
        entities.put("Imacr", 298);
        entities.put("ImaginaryI", 8520);
        entities.put("Implies", 8658);
        entities.put("Int", 8748);
        entities.put("Integral", 8747);
        entities.put("Intersection", 8898);
        entities.put("InvisibleComma", 8291);
        entities.put("InvisibleTimes", 8290);
        entities.put("Iogon", 302);
        entities.put("Iopf", 120128);
        entities.put("Iota", 921);
        entities.put("Iscr", 8464);
        entities.put("Itilde", 296);
        entities.put("Iukcy", 1030);
        entities.put("Iuml", 207);
        entities.put("Jcirc", 308);
        entities.put("Jcy", 1049);
        entities.put("Jfr", 120077);
        entities.put("Jopf", 120129);
        entities.put("Jscr", 119973);
        entities.put("Jsercy", 1032);
        entities.put("Jukcy", 1028);
        entities.put("KHcy", 1061);
        entities.put("KJcy", 1036);
        entities.put("Kappa", 922);
        entities.put("Kcedil", 310);
        entities.put("Kcy", 1050);
        entities.put("Kfr", 120078);
        entities.put("Kopf", 120130);
        entities.put("Kscr", 119974);
        entities.put("LJcy", 1033);
        entities.put("LT", 60);
        entities.put("Lacute", 313);
        entities.put("Lambda", 923);
        entities.put("Lang", 10218);
        entities.put("Laplacetrf", 8466);
        entities.put("Larr", 8606);
        entities.put("Lcaron", 317);
        entities.put("Lcedil", 315);
        entities.put("Lcy", 1051);
        entities.put("LeftAngleBracket", 10216);
        entities.put("LeftArrow", 8592);
        entities.put("LeftArrowBar", 8676);
        entities.put("LeftArrowRightArrow", 8646);
        entities.put("LeftCeiling", 8968);
        entities.put("LeftDoubleBracket", 10214);
        entities.put("LeftDownTeeVector", 10593);
        entities.put("LeftDownVector", 8643);
        entities.put("LeftDownVectorBar", 10585);
        entities.put("LeftFloor", 8970);
        entities.put("LeftRightArrow", 8596);
        entities.put("LeftRightVector", 10574);
        entities.put("LeftTee", 8867);
        entities.put("LeftTeeArrow", 8612);
        entities.put("LeftTeeVector", 10586);
        entities.put("LeftTriangle", 8882);
        entities.put("LeftTriangleBar", 10703);
        entities.put("LeftTriangleEqual", 8884);
        entities.put("LeftUpDownVector", 10577);
        entities.put("LeftUpTeeVector", 10592);
        entities.put("LeftUpVector", 8639);
        entities.put("LeftUpVectorBar", 10584);
        entities.put("LeftVector", 8636);
        entities.put("LeftVectorBar", 10578);
        entities.put("Leftarrow", 8656);
        entities.put("Leftrightarrow", 8660);
        entities.put("LessEqualGreater", 8922);
        entities.put("LessFullEqual", 8806);
        entities.put("LessGreater", 8822);
        entities.put("LessLess", 10913);
        entities.put("LessSlantEqual", 10877);
        entities.put("LessTilde", 8818);
        entities.put("Lfr", 120079);
        entities.put("Ll", 8920);
        entities.put("Lleftarrow", 8666);
        entities.put("Lmidot", 319);
        entities.put("LongLeftArrow", 10229);
        entities.put("LongLeftRightArrow", 10231);
        entities.put("LongRightArrow", 10230);
        entities.put("Longleftarrow", 10232);
        entities.put("Longleftrightarrow", 10234);
        entities.put("Longrightarrow", 10233);
        entities.put("Lopf", 120131);
        entities.put("LowerLeftArrow", 8601);
        entities.put("LowerRightArrow", 8600);
        entities.put("Lscr", 8466);
        entities.put("Lsh", 8624);
        entities.put("Lstrok", 321);
        entities.put("Lt", 8810);
        entities.put("Map", 10501);
        entities.put("Mcy", 1052);
        entities.put("MediumSpace", 8287);
        entities.put("Mellintrf", 8499);
        entities.put("Mfr", 120080);
        entities.put("MinusPlus", 8723);
        entities.put("Mopf", 120132);
        entities.put("Mscr", 8499);
        entities.put("Mu", 924);
        entities.put("NJcy", 1034);
        entities.put("Nacute", 323);
        entities.put("Ncaron", 327);
        entities.put("Ncedil", 325);
        entities.put("Ncy", 1053);
        entities.put("NegativeMediumSpace", 8203);
        entities.put("NegativeThickSpace", 8203);
        entities.put("NegativeThinSpace", 8203);
        entities.put("NegativeVeryThinSpace", 8203);
        entities.put("NestedGreaterGreater", 8811);
        entities.put("NestedLessLess", 8810);
        entities.put("NewLine", 10);
        entities.put("Nfr", 120081);
        entities.put("NoBreak", 8288);
        entities.put("NonBreakingSpace", 160);
        entities.put("Nopf", 8469);
        entities.put("Not", 10988);
        entities.put("NotCongruent", 8802);
        entities.put("NotCupCap", 8813);
        entities.put("NotDoubleVerticalBar", 8742);
        entities.put("NotElement", 8713);
        entities.put("NotEqual", 8800);
        entities.put("NotExists", 8708);
        entities.put("NotGreater", 8815);
        entities.put("NotGreaterEqual", 8817);
        entities.put("NotGreaterLess", 8825);
        entities.put("NotGreaterTilde", 8821);
        entities.put("NotLeftTriangle", 8938);
        entities.put("NotLeftTriangleEqual", 8940);
        entities.put("NotLess", 8814);
        entities.put("NotLessEqual", 8816);
        entities.put("NotLessGreater", 8824);
        entities.put("NotLessTilde", 8820);
        entities.put("NotPrecedes", 8832);
        entities.put("NotPrecedesSlantEqual", 8928);
        entities.put("NotReverseElement", 8716);
        entities.put("NotRightTriangle", 8939);
        entities.put("NotRightTriangleEqual", 8941);
        entities.put("NotSquareSubsetEqual", 8930);
        entities.put("NotSquareSupersetEqual", 8931);
        entities.put("NotSubsetEqual", 8840);
        entities.put("NotSucceeds", 8833);
        entities.put("NotSucceedsSlantEqual", 8929);
        entities.put("NotSupersetEqual", 8841);
        entities.put("NotTilde", 8769);
        entities.put("NotTildeEqual", 8772);
        entities.put("NotTildeFullEqual", 8775);
        entities.put("NotTildeTilde", 8777);
        entities.put("NotVerticalBar", 8740);
        entities.put("Nscr", 119977);
        entities.put("Ntilde", 209);
        entities.put("Nu", 925);
        entities.put("OElig", 338);
        entities.put("Oacute", 211);
        entities.put("Ocirc", 212);
        entities.put("Ocy", 1054);
        entities.put("Odblac", 336);
        entities.put("Ofr", 120082);
        entities.put("Ograve", 210);
        entities.put("Omacr", 332);
        entities.put("Omega", 937);
        entities.put("Omicron", 927);
        entities.put("Oopf", 120134);
        entities.put("OpenCurlyDoubleQuote", 8220);
        entities.put("OpenCurlyQuote", 8216);
        entities.put("Or", 10836);
        entities.put("Oscr", 119978);
        entities.put("Oslash", 216);
        entities.put("Otilde", 213);
        entities.put("Otimes", 10807);
        entities.put("Ouml", 214);
        entities.put("OverBar", 8254);
        entities.put("OverBrace", 9182);
        entities.put("OverBracket", 9140);
        entities.put("OverParenthesis", 9180);
        entities.put("PartialD", 8706);
        entities.put("Pcy", 1055);
        entities.put("Pfr", 120083);
        entities.put("Phi", 934);
        entities.put("Pi", 928);
        entities.put("PlusMinus", 177);
        entities.put("Poincareplane", 8460);
        entities.put("Popf", 8473);
        entities.put("Pr", 10939);
        entities.put("Precedes", 8826);
        entities.put("PrecedesEqual", 10927);
        entities.put("PrecedesSlantEqual", 8828);
        entities.put("PrecedesTilde", 8830);
        entities.put("Prime", 8243);
        entities.put("Product", 8719);
        entities.put("Proportion", 8759);
        entities.put("Proportional", 8733);
        entities.put("Pscr", 119979);
        entities.put("Psi", 936);
        entities.put("QUOT", 34);
        entities.put("Qfr", 120084);
        entities.put("Qopf", 8474);
        entities.put("Qscr", 119980);
        entities.put("RBarr", 10512);
        entities.put("REG", 174);
        entities.put("Racute", 340);
        entities.put("Rang", 10219);
        entities.put("Rarr", 8608);
        entities.put("Rarrtl", 10518);
        entities.put("Rcaron", 344);
        entities.put("Rcedil", 342);
        entities.put("Rcy", 1056);
        entities.put("Re", 8476);
        entities.put("ReverseElement", 8715);
        entities.put("ReverseEquilibrium", 8651);
        entities.put("ReverseUpEquilibrium", 10607);
        entities.put("Rfr", 8476);
        entities.put("Rho", 929);
        entities.put("RightAngleBracket", 10217);
        entities.put("RightArrow", 8594);
        entities.put("RightArrowBar", 8677);
        entities.put("RightArrowLeftArrow", 8644);
        entities.put("RightCeiling", 8969);
        entities.put("RightDoubleBracket", 10215);
        entities.put("RightDownTeeVector", 10589);
        entities.put("RightDownVector", 8642);
        entities.put("RightDownVectorBar", 10581);
        entities.put("RightFloor", 8971);
        entities.put("RightTee", 8866);
        entities.put("RightTeeArrow", 8614);
        entities.put("RightTeeVector", 10587);
        entities.put("RightTriangle", 8883);
        entities.put("RightTriangleBar", 10704);
        entities.put("RightTriangleEqual", 8885);
        entities.put("RightUpDownVector", 10575);
        entities.put("RightUpTeeVector", 10588);
        entities.put("RightUpVector", 8638);
        entities.put("RightUpVectorBar", 10580);
        entities.put("RightVector", 8640);
        entities.put("RightVectorBar", 10579);
        entities.put("Rightarrow", 8658);
        entities.put("Ropf", 8477);
        entities.put("RoundImplies", 10608);
        entities.put("Rrightarrow", 8667);
        entities.put("Rscr", 8475);
        entities.put("Rsh", 8625);
        entities.put("RuleDelayed", 10740);
        entities.put("SHCHcy", 1065);
        entities.put("SHcy", 1064);
        entities.put("SOFTcy", 1068);
        entities.put("Sacute", 346);
        entities.put("Sc", 10940);
        entities.put("Scaron", 352);
        entities.put("Scedil", 350);
        entities.put("Scirc", 348);
        entities.put("Scy", 1057);
        entities.put("Sfr", 120086);
        entities.put("ShortDownArrow", 8595);
        entities.put("ShortLeftArrow", 8592);
        entities.put("ShortRightArrow", 8594);
        entities.put("ShortUpArrow", 8593);
        entities.put("Sigma", 931);
        entities.put("SmallCircle", 8728);
        entities.put("Sopf", 120138);
        entities.put("Sqrt", 8730);
        entities.put("Square", 9633);
        entities.put("SquareIntersection", 8851);
        entities.put("SquareSubset", 8847);
        entities.put("SquareSubsetEqual", 8849);
        entities.put("SquareSuperset", 8848);
        entities.put("SquareSupersetEqual", 8850);
        entities.put("SquareUnion", 8852);
        entities.put("Sscr", 119982);
        entities.put("Star", 8902);
        entities.put("Sub", 8912);
        entities.put("Subset", 8912);
        entities.put("SubsetEqual", 8838);
        entities.put("Succeeds", 8827);
        entities.put("SucceedsEqual", 10928);
        entities.put("SucceedsSlantEqual", 8829);
        entities.put("SucceedsTilde", 8831);
        entities.put("SuchThat", 8715);
        entities.put("Sum", 8721);
        entities.put("Sup", 8913);
        entities.put("Superset", 8835);
        entities.put("SupersetEqual", 8839);
        entities.put("Supset", 8913);
        entities.put("THORN", 222);
        entities.put("TRADE", 8482);
        entities.put("TSHcy", 1035);
        entities.put("TScy", 1062);
        entities.put("Tab", 9);
        entities.put("Tau", 932);
        entities.put("Tcaron", 356);
        entities.put("Tcedil", 354);
        entities.put("Tcy", 1058);
        entities.put("Tfr", 120087);
        entities.put("Therefore", 8756);
        entities.put("Theta", 920);
        entities.put("ThinSpace", 8201);
        entities.put("Tilde", 8764);
        entities.put("TildeEqual", 8771);
        entities.put("TildeFullEqual", 8773);
        entities.put("TildeTilde", 8776);
        entities.put("Topf", 120139);
        entities.put("TripleDot", 8411);
        entities.put("Tscr", 119983);
        entities.put("Tstrok", 358);
        entities.put("Uacute", 218);
        entities.put("Uarr", 8607);
        entities.put("Uarrocir", 10569);
        entities.put("Ubrcy", 1038);
        entities.put("Ubreve", 364);
        entities.put("Ucirc", 219);
        entities.put("Ucy", 1059);
        entities.put("Udblac", 368);
        entities.put("Ufr", 120088);
        entities.put("Ugrave", 217);
        entities.put("Umacr", 362);
        entities.put("UnderBar", 95);
        entities.put("UnderBrace", 9183);
        entities.put("UnderBracket", 9141);
        entities.put("UnderParenthesis", 9181);
        entities.put("Union", 8899);
        entities.put("UnionPlus", 8846);
        entities.put("Uogon", 370);
        entities.put("Uopf", 120140);
        entities.put("UpArrow", 8593);
        entities.put("UpArrowBar", 10514);
        entities.put("UpArrowDownArrow", 8645);
        entities.put("UpDownArrow", 8597);
        entities.put("UpEquilibrium", 10606);
        entities.put("UpTee", 8869);
        entities.put("UpTeeArrow", 8613);
        entities.put("Uparrow", 8657);
        entities.put("Updownarrow", 8661);
        entities.put("UpperLeftArrow", 8598);
        entities.put("UpperRightArrow", 8599);
        entities.put("Upsi", 978);
        entities.put("Upsilon", 933);
        entities.put("Uring", 366);
        entities.put("Uscr", 119984);
        entities.put("Utilde", 360);
        entities.put("Uuml", 220);
        entities.put("VDash", 8875);
        entities.put("Vbar", 10987);
        entities.put("Vcy", 1042);
        entities.put("Vdash", 8873);
        entities.put("Vdashl", 10982);
        entities.put("Vee", 8897);
        entities.put("Verbar", 8214);
        entities.put("Vert", 8214);
        entities.put("VerticalBar", 8739);
        entities.put("VerticalLine", 124);
        entities.put("VerticalSeparator", 10072);
        entities.put("VerticalTilde", 8768);
        entities.put("VeryThinSpace", 8202);
        entities.put("Vfr", 120089);
        entities.put("Vopf", 120141);
        entities.put("Vscr", 119985);
        entities.put("Vvdash", 8874);
        entities.put("Wcirc", 372);
        entities.put("Wedge", 8896);
        entities.put("Wfr", 120090);
        entities.put("Wopf", 120142);
        entities.put("Wscr", 119986);
        entities.put("Xfr", 120091);
        entities.put("Xi", 926);
        entities.put("Xopf", 120143);
        entities.put("Xscr", 119987);
        entities.put("YAcy", 1071);
        entities.put("YIcy", 1031);
        entities.put("YUcy", 1070);
        entities.put("Yacute", 221);
        entities.put("Ycirc", 374);
        entities.put("Ycy", 1067);
        entities.put("Yfr", 120092);
        entities.put("Yopf", 120144);
        entities.put("Yscr", 119988);
        entities.put("Yuml", 376);
        entities.put("ZHcy", 1046);
        entities.put("Zacute", 377);
        entities.put("Zcaron", 381);
        entities.put("Zcy", 1047);
        entities.put("Zdot", 379);
        entities.put("ZeroWidthSpace", 8203);
        entities.put("Zeta", 918);
        entities.put("Zfr", 8488);
        entities.put("Zopf", 8484);
        entities.put("Zscr", 119989);
        entities.put("aacute", 225);
        entities.put("abreve", 259);
        entities.put("ac", 8766);
        entities.put("acd", 8767);
        entities.put("acirc", 226);
        entities.put("acute", 180);
        entities.put("acy", 1072);
        entities.put("aelig", 230);
        entities.put("af", 8289);
        entities.put("afr", 120094);
        entities.put("agrave", 224);
        entities.put("alefsym", 8501);
        entities.put("aleph", 8501);
        entities.put("alpha", 945);
        entities.put("amacr", 257);
        entities.put("amalg", 10815);
        entities.put("amp", 38);
        entities.put("and", 8743);
        entities.put("andand", 10837);
        entities.put("andd", 10844);
        entities.put("andslope", 10840);
        entities.put("andv", 10842);
        entities.put("ang", 8736);
        entities.put("ange", 10660);
        entities.put("angle", 8736);
        entities.put("angmsd", 8737);
        entities.put("angmsdaa", 10664);
        entities.put("angmsdab", 10665);
        entities.put("angmsdac", 10666);
        entities.put("angmsdad", 10667);
        entities.put("angmsdae", 10668);
        entities.put("angmsdaf", 10669);
        entities.put("angmsdag", 10670);
        entities.put("angmsdah", 10671);
        entities.put("angrt", 8735);
        entities.put("angrtvb", 8894);
        entities.put("angrtvbd", 10653);
        entities.put("angsph", 8738);
        entities.put("angst", 197);
        entities.put("angzarr", 9084);
        entities.put("aogon", 261);
        entities.put("aopf", 120146);
        entities.put("ap", 8776);
        entities.put("apE", 10864);
        entities.put("apacir", 10863);
        entities.put("ape", 8778);
        entities.put("apid", 8779);
        entities.put("apos", 39);
        entities.put("approx", 8776);
        entities.put("approxeq", 8778);
        entities.put("aring", 229);
        entities.put("ascr", 119990);
        entities.put("ast", 42);
        entities.put("asymp", 8776);
        entities.put("asympeq", 8781);
        entities.put("atilde", 227);
        entities.put("auml", 228);
        entities.put("awconint", 8755);
        entities.put("awint", 10769);
        entities.put("bNot", 10989);
        entities.put("backcong", 8780);
        entities.put("backepsilon", 1014);
        entities.put("backprime", 8245);
        entities.put("backsim", 8765);
        entities.put("backsimeq", 8909);
        entities.put("barvee", 8893);
        entities.put("barwed", 8965);
        entities.put("barwedge", 8965);
        entities.put("bbrk", 9141);
        entities.put("bbrktbrk", 9142);
        entities.put("bcong", 8780);
        entities.put("bcy", 1073);
        entities.put("bdquo", 8222);
        entities.put("becaus", 8757);
        entities.put("because", 8757);
        entities.put("bemptyv", 10672);
        entities.put("bepsi", 1014);
        entities.put("bernou", 8492);
        entities.put("beta", 946);
        entities.put("beth", 8502);
        entities.put("between", 8812);
        entities.put("bfr", 120095);
        entities.put("bigcap", 8898);
        entities.put("bigcirc", 9711);
        entities.put("bigcup", 8899);
        entities.put("bigodot", 10752);
        entities.put("bigoplus", 10753);
        entities.put("bigotimes", 10754);
        entities.put("bigsqcup", 10758);
        entities.put("bigstar", 9733);
        entities.put("bigtriangledown", 9661);
        entities.put("bigtriangleup", 9651);
        entities.put("biguplus", 10756);
        entities.put("bigvee", 8897);
        entities.put("bigwedge", 8896);
        entities.put("bkarow", 10509);
        entities.put("blacklozenge", 10731);
        entities.put("blacksquare", 9642);
        entities.put("blacktriangle", 9652);
        entities.put("blacktriangledown", 9662);
        entities.put("blacktriangleleft", 9666);
        entities.put("blacktriangleright", 9656);
        entities.put("blank", 9251);
        entities.put("blk12", 9618);
        entities.put("blk14", 9617);
        entities.put("blk34", 9619);
        entities.put("block", 9608);
        entities.put("bnot", 8976);
        entities.put("bopf", 120147);
        entities.put("bot", 8869);
        entities.put("bottom", 8869);
        entities.put("bowtie", 8904);
        entities.put("boxDL", 9559);
        entities.put("boxDR", 9556);
        entities.put("boxDl", 9558);
        entities.put("boxDr", 9555);
        entities.put("boxH", 9552);
        entities.put("boxHD", 9574);
        entities.put("boxHU", 9577);
        entities.put("boxHd", 9572);
        entities.put("boxHu", 9575);
        entities.put("boxUL", 9565);
        entities.put("boxUR", 9562);
        entities.put("boxUl", 9564);
        entities.put("boxUr", 9561);
        entities.put("boxV", 9553);
        entities.put("boxVH", 9580);
        entities.put("boxVL", 9571);
        entities.put("boxVR", 9568);
        entities.put("boxVh", 9579);
        entities.put("boxVl", 9570);
        entities.put("boxVr", 9567);
        entities.put("boxbox", 10697);
        entities.put("boxdL", 9557);
        entities.put("boxdR", 9554);
        entities.put("boxdl", 9488);
        entities.put("boxdr", 9484);
        entities.put("boxh", 9472);
        entities.put("boxhD", 9573);
        entities.put("boxhU", 9576);
        entities.put("boxhd", 9516);
        entities.put("boxhu", 9524);
        entities.put("boxminus", 8863);
        entities.put("boxplus", 8862);
        entities.put("boxtimes", 8864);
        entities.put("boxuL", 9563);
        entities.put("boxuR", 9560);
        entities.put("boxul", 9496);
        entities.put("boxur", 9492);
        entities.put("boxv", 9474);
        entities.put("boxvH", 9578);
        entities.put("boxvL", 9569);
        entities.put("boxvR", 9566);
        entities.put("boxvh", 9532);
        entities.put("boxvl", 9508);
        entities.put("boxvr", 9500);
        entities.put("bprime", 8245);
        entities.put("breve", 728);
        entities.put("brvbar", 166);
        entities.put("bscr", 119991);
        entities.put("bsemi", 8271);
        entities.put("bsim", 8765);
        entities.put("bsime", 8909);
        entities.put("bsol", 92);
        entities.put("bsolb", 10693);
        entities.put("bsolhsub", 10184);
        entities.put("bull", 8226);
        entities.put("bullet", 8226);
        entities.put("bump", 8782);
        entities.put("bumpE", 10926);
        entities.put("bumpe", 8783);
        entities.put("bumpeq", 8783);
        entities.put("cacute", 263);
        entities.put("cap", 8745);
        entities.put("capand", 10820);
        entities.put("capbrcup", 10825);
        entities.put("capcap", 10827);
        entities.put("capcup", 10823);
        entities.put("capdot", 10816);
        entities.put("caret", 8257);
        entities.put("caron", 711);
        entities.put("ccaps", 10829);
        entities.put("ccaron", 269);
        entities.put("ccedil", 231);
        entities.put("ccirc", 265);
        entities.put("ccups", 10828);
        entities.put("ccupssm", 10832);
        entities.put("cdot", 267);
        entities.put("cedil", 184);
        entities.put("cemptyv", 10674);
        entities.put("cent", 162);
        entities.put("centerdot", 183);
        entities.put("cfr", 120096);
        entities.put("chcy", 1095);
        entities.put("check", 10003);
        entities.put("checkmark", 10003);
        entities.put("chi", 967);
        entities.put("cir", 9675);
        entities.put("cirE", 10691);
        entities.put("circ", 710);
        entities.put("circeq", 8791);
        entities.put("circlearrowleft", 8634);
        entities.put("circlearrowright", 8635);
        entities.put("circledR", 174);
        entities.put("circledS", 9416);
        entities.put("circledast", 8859);
        entities.put("circledcirc", 8858);
        entities.put("circleddash", 8861);
        entities.put("cire", 8791);
        entities.put("cirfnint", 10768);
        entities.put("cirmid", 10991);
        entities.put("cirscir", 10690);
        entities.put("clubs", 9827);
        entities.put("clubsuit", 9827);
        entities.put("colon", 58);
        entities.put("colone", 8788);
        entities.put("coloneq", 8788);
        entities.put("comma", 44);
        entities.put("commat", 64);
        entities.put("comp", 8705);
        entities.put("compfn", 8728);
        entities.put("complement", 8705);
        entities.put("complexes", 8450);
        entities.put("cong", 8773);
        entities.put("congdot", 10861);
        entities.put("conint", 8750);
        entities.put("copf", 120148);
        entities.put("coprod", 8720);
        entities.put("copy", 169);
        entities.put("copysr", 8471);
        entities.put("crarr", 8629);
        entities.put("cross", 10007);
        entities.put("cscr", 119992);
        entities.put("csub", 10959);
        entities.put("csube", 10961);
        entities.put("csup", 10960);
        entities.put("csupe", 10962);
        entities.put("ctdot", 8943);
        entities.put("cudarrl", 10552);
        entities.put("cudarrr", 10549);
        entities.put("cuepr", 8926);
        entities.put("cuesc", 8927);
        entities.put("cularr", 8630);
        entities.put("cularrp", 10557);
        entities.put("cup", 8746);
        entities.put("cupbrcap", 10824);
        entities.put("cupcap", 10822);
        entities.put("cupcup", 10826);
        entities.put("cupdot", 8845);
        entities.put("cupor", 10821);
        entities.put("curarr", 8631);
        entities.put("curarrm", 10556);
        entities.put("curlyeqprec", 8926);
        entities.put("curlyeqsucc", 8927);
        entities.put("curlyvee", 8910);
        entities.put("curlywedge", 8911);
        entities.put("curren", 164);
        entities.put("curvearrowleft", 8630);
        entities.put("curvearrowright", 8631);
        entities.put("cuvee", 8910);
        entities.put("cuwed", 8911);
        entities.put("cwconint", 8754);
        entities.put("cwint", 8753);
        entities.put("cylcty", 9005);
        entities.put("dArr", 8659);
        entities.put("dHar", 10597);
        entities.put("dagger", 8224);
        entities.put("daleth", 8504);
        entities.put("darr", 8595);
        entities.put("dash", 8208);
        entities.put("dashv", 8867);
        entities.put("dbkarow", 10511);
        entities.put("dblac", 733);
        entities.put("dcaron", 271);
        entities.put("dcy", 1076);
        entities.put("dd", 8518);
        entities.put("ddagger", 8225);
        entities.put("ddarr", 8650);
        entities.put("ddotseq", 10871);
        entities.put("deg", 176);
        entities.put("delta", 948);
        entities.put("demptyv", 10673);
        entities.put("dfisht", 10623);
        entities.put("dfr", 120097);
        entities.put("dharl", 8643);
        entities.put("dharr", 8642);
        entities.put("diam", 8900);
        entities.put("diamond", 8900);
        entities.put("diamondsuit", 9830);
        entities.put("diams", 9830);
        entities.put("die", 168);
        entities.put("digamma", 989);
        entities.put("disin", 8946);
        entities.put("div", 247);
        entities.put("divide", 247);
        entities.put("divideontimes", 8903);
        entities.put("divonx", 8903);
        entities.put("djcy", 1106);
        entities.put("dlcorn", 8990);
        entities.put("dlcrop", 8973);
        entities.put("dollar", 36);
        entities.put("dopf", 120149);
        entities.put("dot", 729);
        entities.put("doteq", 8784);
        entities.put("doteqdot", 8785);
        entities.put("dotminus", 8760);
        entities.put("dotplus", 8724);
        entities.put("dotsquare", 8865);
        entities.put("doublebarwedge", 8966);
        entities.put("downarrow", 8595);
        entities.put("downdownarrows", 8650);
        entities.put("downharpoonleft", 8643);
        entities.put("downharpoonright", 8642);
        entities.put("drbkarow", 10512);
        entities.put("drcorn", 8991);
        entities.put("drcrop", 8972);
        entities.put("dscr", 119993);
        entities.put("dscy", 1109);
        entities.put("dsol", 10742);
        entities.put("dstrok", 273);
        entities.put("dtdot", 8945);
        entities.put("dtri", 9663);
        entities.put("dtrif", 9662);
        entities.put("duarr", 8693);
        entities.put("duhar", 10607);
        entities.put("dwangle", 10662);
        entities.put("dzcy", 1119);
        entities.put("dzigrarr", 10239);
        entities.put("eDDot", 10871);
        entities.put("eDot", 8785);
        entities.put("eacute", 233);
        entities.put("easter", 10862);
        entities.put("ecaron", 283);
        entities.put("ecir", 8790);
        entities.put("ecirc", 234);
        entities.put("ecolon", 8789);
        entities.put("ecy", 1101);
        entities.put("edot", 279);
        entities.put("ee", 8519);
        entities.put("efDot", 8786);
        entities.put("efr", 120098);
        entities.put("eg", 10906);
        entities.put("egrave", 232);
        entities.put("egs", 10902);
        entities.put("egsdot", 10904);
        entities.put("el", 10905);
        entities.put("elinters", 9191);
        entities.put("ell", 8467);
        entities.put("els", 10901);
        entities.put("elsdot", 10903);
        entities.put("emacr", 275);
        entities.put("empty", 8709);
        entities.put("emptyset", 8709);
        entities.put("emptyv", 8709);
        entities.put("emsp13", 8196);
        entities.put("emsp14", 8197);
        entities.put("emsp", 8195);
        entities.put("eng", 331);
        entities.put("ensp", 8194);
        entities.put("eogon", 281);
        entities.put("eopf", 120150);
        entities.put("epar", 8917);
        entities.put("eparsl", 10723);
        entities.put("eplus", 10865);
        entities.put("epsi", 949);
        entities.put("epsilon", 949);
        entities.put("epsiv", 1013);
        entities.put("eqcirc", 8790);
        entities.put("eqcolon", 8789);
        entities.put("eqsim", 8770);
        entities.put("eqslantgtr", 10902);
        entities.put("eqslantless", 10901);
        entities.put("equals", 61);
        entities.put("equest", 8799);
        entities.put("equiv", 8801);
        entities.put("equivDD", 10872);
        entities.put("eqvparsl", 10725);
        entities.put("erDot", 8787);
        entities.put("erarr", 10609);
        entities.put("escr", 8495);
        entities.put("esdot", 8784);
        entities.put("esim", 8770);
        entities.put("eta", 951);
        entities.put("eth", 240);
        entities.put("euml", 235);
        entities.put("euro", 8364);
        entities.put("excl", 33);
        entities.put("exist", 8707);
        entities.put("expectation", 8496);
        entities.put("exponentiale", 8519);
        entities.put("fallingdotseq", 8786);
        entities.put("fcy", 1092);
        entities.put("female", 9792);
        entities.put("ffilig", 64259);
        entities.put("fflig", 64256);
        entities.put("ffllig", 64260);
        entities.put("ffr", 120099);
        entities.put("filig", 64257);
        entities.put("flat", 9837);
        entities.put("fllig", 64258);
        entities.put("fltns", 9649);
        entities.put("fnof", 402);
        entities.put("fopf", 120151);
        entities.put("forall", 8704);
        entities.put("fork", 8916);
        entities.put("forkv", 10969);
        entities.put("fpartint", 10765);
        entities.put("frac12", 189);
        entities.put("frac13", 8531);
        entities.put("frac14", 188);
        entities.put("frac15", 8533);
        entities.put("frac16", 8537);
        entities.put("frac18", 8539);
        entities.put("frac23", 8532);
        entities.put("frac25", 8534);
        entities.put("frac34", 190);
        entities.put("frac35", 8535);
        entities.put("frac38", 8540);
        entities.put("frac45", 8536);
        entities.put("frac56", 8538);
        entities.put("frac58", 8541);
        entities.put("frac78", 8542);
        entities.put("frasl", 8260);
        entities.put("frown", 8994);
        entities.put("fscr", 119995);
        entities.put("gE", 8807);
        entities.put("gEl", 10892);
        entities.put("gacute", 501);
        entities.put("gamma", 947);
        entities.put("gammad", 989);
        entities.put("gap", 10886);
        entities.put("gbreve", 287);
        entities.put("gcirc", 285);
        entities.put("gcy", 1075);
        entities.put("gdot", 289);
        entities.put("ge", 8805);
        entities.put("gel", 8923);
        entities.put("geq", 8805);
        entities.put("geqq", 8807);
        entities.put("geqslant", 10878);
        entities.put("ges", 10878);
        entities.put("gescc", 10921);
        entities.put("gesdot", 10880);
        entities.put("gesdoto", 10882);
        entities.put("gesdotol", 10884);
        entities.put("gesles", 10900);
        entities.put("gfr", 120100);
        entities.put("gg", 8811);
        entities.put("ggg", 8921);
        entities.put("gimel", 8503);
        entities.put("gjcy", 1107);
        entities.put("gl", 8823);
        entities.put("glE", 10898);
        entities.put("gla", 10917);
        entities.put("glj", 10916);
        entities.put("gnE", 8809);
        entities.put("gnap", 10890);
        entities.put("gnapprox", 10890);
        entities.put("gne", 10888);
        entities.put("gneq", 10888);
        entities.put("gneqq", 8809);
        entities.put("gnsim", 8935);
        entities.put("gopf", 120152);
        entities.put("grave", 96);
        entities.put("gscr", 8458);
        entities.put("gsim", 8819);
        entities.put("gsime", 10894);
        entities.put("gsiml", 10896);
        entities.put("gt", 62);
        entities.put("gtcc", 10919);
        entities.put("gtcir", 10874);
        entities.put("gtdot", 8919);
        entities.put("gtlPar", 10645);
        entities.put("gtquest", 10876);
        entities.put("gtrapprox", 10886);
        entities.put("gtrarr", 10616);
        entities.put("gtrdot", 8919);
        entities.put("gtreqless", 8923);
        entities.put("gtreqqless", 10892);
        entities.put("gtrless", 8823);
        entities.put("gtrsim", 8819);
        entities.put("hArr", 8660);
        entities.put("hairsp", 8202);
        entities.put("half", 189);
        entities.put("hamilt", 8459);
        entities.put("hardcy", 1098);
        entities.put("harr", 8596);
        entities.put("harrcir", 10568);
        entities.put("harrw", 8621);
        entities.put("hbar", 8463);
        entities.put("hcirc", 293);
        entities.put("hearts", 9829);
        entities.put("heartsuit", 9829);
        entities.put("hellip", 8230);
        entities.put("hercon", 8889);
        entities.put("hfr", 120101);
        entities.put("hksearow", 10533);
        entities.put("hkswarow", 10534);
        entities.put("hoarr", 8703);
        entities.put("homtht", 8763);
        entities.put("hookleftarrow", 8617);
        entities.put("hookrightarrow", 8618);
        entities.put("hopf", 120153);
        entities.put("horbar", 8213);
        entities.put("hscr", 119997);
        entities.put("hslash", 8463);
        entities.put("hstrok", 295);
        entities.put("hybull", 8259);
        entities.put("hyphen", 8208);
        entities.put("iacute", 237);
        entities.put("ic", 8291);
        entities.put("icirc", 238);
        entities.put("icy", 1080);
        entities.put("iecy", 1077);
        entities.put("iexcl", 161);
        entities.put("iff", 8660);
        entities.put("ifr", 120102);
        entities.put("igrave", 236);
        entities.put("ii", 8520);
        entities.put("iiiint", 10764);
        entities.put("iiint", 8749);
        entities.put("iinfin", 10716);
        entities.put("iiota", 8489);
        entities.put("ijlig", 307);
        entities.put("imacr", 299);
        entities.put("image", 8465);
        entities.put("imagline", 8464);
        entities.put("imagpart", 8465);
        entities.put("imath", 305);
        entities.put("imof", 8887);
        entities.put("imped", 437);
        entities.put("in", 8712);
        entities.put("incare", 8453);
        entities.put("infin", 8734);
        entities.put("infintie", 10717);
        entities.put("inodot", 305);
        entities.put("int", 8747);
        entities.put("intcal", 8890);
        entities.put("integers", 8484);
        entities.put("intercal", 8890);
        entities.put("intlarhk", 10775);
        entities.put("intprod", 10812);
        entities.put("iocy", 1105);
        entities.put("iogon", 303);
        entities.put("iopf", 120154);
        entities.put("iota", 953);
        entities.put("iprod", 10812);
        entities.put("iquest", 191);
        entities.put("iscr", 119998);
        entities.put("isin", 8712);
        entities.put("isinE", 8953);
        entities.put("isindot", 8949);
        entities.put("isins", 8948);
        entities.put("isinsv", 8947);
        entities.put("isinv", 8712);
        entities.put("it", 8290);
        entities.put("itilde", 297);
        entities.put("iukcy", 1110);
        entities.put("iuml", 239);
        entities.put("jcirc", 309);
        entities.put("jcy", 1081);
        entities.put("jfr", 120103);
        entities.put("jmath", 567);
        entities.put("jopf", 120155);
        entities.put("jscr", 119999);
        entities.put("jsercy", 1112);
        entities.put("jukcy", 1108);
        entities.put("kappa", 954);
        entities.put("kappav", 1008);
        entities.put("kcedil", 311);
        entities.put("kcy", 1082);
        entities.put("kfr", 120104);
        entities.put("kgreen", 312);
        entities.put("khcy", 1093);
        entities.put("kjcy", 1116);
        entities.put("kopf", 120156);
        entities.put("kscr", 120000);
        entities.put("lAarr", 8666);
        entities.put("lArr", 8656);
        entities.put("lAtail", 10523);
        entities.put("lBarr", 10510);
        entities.put("lE", 8806);
        entities.put("lEg", 10891);
        entities.put("lHar", 10594);
        entities.put("lacute", 314);
        entities.put("laemptyv", 10676);
        entities.put("lagran", 8466);
        entities.put("lambda", 955);
        entities.put("lang", 10216);
        entities.put("langd", 10641);
        entities.put("langle", 10216);
        entities.put("lap", 10885);
        entities.put("laquo", 171);
        entities.put("larr", 8592);
        entities.put("larrb", 8676);
        entities.put("larrbfs", 10527);
        entities.put("larrfs", 10525);
        entities.put("larrhk", 8617);
        entities.put("larrlp", 8619);
        entities.put("larrpl", 10553);
        entities.put("larrsim", 10611);
        entities.put("larrtl", 8610);
        entities.put("lat", 10923);
        entities.put("latail", 10521);
        entities.put("late", 10925);
        entities.put("lbarr", 10508);
        entities.put("lbbrk", 10098);
        entities.put("lbrace", 123);
        entities.put("lbrack", 91);
        entities.put("lbrke", 10635);
        entities.put("lbrksld", 10639);
        entities.put("lbrkslu", 10637);
        entities.put("lcaron", 318);
        entities.put("lcedil", 316);
        entities.put("lceil", 8968);
        entities.put("lcub", 123);
        entities.put("lcy", 1083);
        entities.put("ldca", 10550);
        entities.put("ldquo", 8220);
        entities.put("ldquor", 8222);
        entities.put("ldrdhar", 10599);
        entities.put("ldrushar", 10571);
        entities.put("ldsh", 8626);
        entities.put("le", 8804);
        entities.put("leftarrow", 8592);
        entities.put("leftarrowtail", 8610);
        entities.put("leftharpoondown", 8637);
        entities.put("leftharpoonup", 8636);
        entities.put("leftleftarrows", 8647);
        entities.put("leftrightarrow", 8596);
        entities.put("leftrightarrows", 8646);
        entities.put("leftrightharpoons", 8651);
        entities.put("leftrightsquigarrow", 8621);
        entities.put("leftthreetimes", 8907);
        entities.put("leg", 8922);
        entities.put("leq", 8804);
        entities.put("leqq", 8806);
        entities.put("leqslant", 10877);
        entities.put("les", 10877);
        entities.put("lescc", 10920);
        entities.put("lesdot", 10879);
        entities.put("lesdoto", 10881);
        entities.put("lesdotor", 10883);
        entities.put("lesges", 10899);
        entities.put("lessapprox", 10885);
        entities.put("lessdot", 8918);
        entities.put("lesseqgtr", 8922);
        entities.put("lesseqqgtr", 10891);
        entities.put("lessgtr", 8822);
        entities.put("lesssim", 8818);
        entities.put("lfisht", 10620);
        entities.put("lfloor", 8970);
        entities.put("lfr", 120105);
        entities.put("lg", 8822);
        entities.put("lgE", 10897);
        entities.put("lhard", 8637);
        entities.put("lharu", 8636);
        entities.put("lharul", 10602);
        entities.put("lhblk", 9604);
        entities.put("ljcy", 1113);
        entities.put("ll", 8810);
        entities.put("llarr", 8647);
        entities.put("llcorner", 8990);
        entities.put("llhard", 10603);
        entities.put("lltri", 9722);
        entities.put("lmidot", 320);
        entities.put("lmoust", 9136);
        entities.put("lmoustache", 9136);
        entities.put("lnE", 8808);
        entities.put("lnap", 10889);
        entities.put("lnapprox", 10889);
        entities.put("lne", 10887);
        entities.put("lneq", 10887);
        entities.put("lneqq", 8808);
        entities.put("lnsim", 8934);
        entities.put("loang", 10220);
        entities.put("loarr", 8701);
        entities.put("lobrk", 10214);
        entities.put("longleftarrow", 10229);
        entities.put("longleftrightarrow", 10231);
        entities.put("longmapsto", 10236);
        entities.put("longrightarrow", 10230);
        entities.put("looparrowleft", 8619);
        entities.put("looparrowright", 8620);
        entities.put("lopar", 10629);
        entities.put("lopf", 120157);
        entities.put("loplus", 10797);
        entities.put("lotimes", 10804);
        entities.put("lowast", 8727);
        entities.put("lowbar", 95);
        entities.put("loz", 9674);
        entities.put("lozenge", 9674);
        entities.put("lozf", 10731);
        entities.put("lpar", 40);
        entities.put("lparlt", 10643);
        entities.put("lrarr", 8646);
        entities.put("lrcorner", 8991);
        entities.put("lrhar", 8651);
        entities.put("lrhard", 10605);
        entities.put("lrm", 8206);
        entities.put("lrtri", 8895);
        entities.put("lsaquo", 8249);
        entities.put("lscr", 120001);
        entities.put("lsh", 8624);
        entities.put("lsim", 8818);
        entities.put("lsime", 10893);
        entities.put("lsimg", 10895);
        entities.put("lsqb", 91);
        entities.put("lsquo", 8216);
        entities.put("lsquor", 8218);
        entities.put("lstrok", 322);
        entities.put("lt", 60);
        entities.put("ltcc", 10918);
        entities.put("ltcir", 10873);
        entities.put("ltdot", 8918);
        entities.put("lthree", 8907);
        entities.put("ltimes", 8905);
        entities.put("ltlarr", 10614);
        entities.put("ltquest", 10875);
        entities.put("ltrPar", 10646);
        entities.put("ltri", 9667);
        entities.put("ltrie", 8884);
        entities.put("ltrif", 9666);
        entities.put("lurdshar", 10570);
        entities.put("luruhar", 10598);
        entities.put("mDDot", 8762);
        entities.put("macr", 175);
        entities.put("male", 9794);
        entities.put("malt", 10016);
        entities.put("maltese", 10016);
        entities.put("map", 8614);
        entities.put("mapsto", 8614);
        entities.put("mapstodown", 8615);
        entities.put("mapstoleft", 8612);
        entities.put("mapstoup", 8613);
        entities.put("marker", 9646);
        entities.put("mcomma", 10793);
        entities.put("mcy", 1084);
        entities.put("mdash", 8212);
        entities.put("measuredangle", 8737);
        entities.put("mfr", 120106);
        entities.put("mho", 8487);
        entities.put("micro", 181);
        entities.put("mid", 8739);
        entities.put("midast", 42);
        entities.put("midcir", 10992);
        entities.put("middot", 183);
        entities.put("minus", 8722);
        entities.put("minusb", 8863);
        entities.put("minusd", 8760);
        entities.put("minusdu", 10794);
        entities.put("mlcp", 10971);
        entities.put("mldr", 8230);
        entities.put("mnplus", 8723);
        entities.put("models", 8871);
        entities.put("mopf", 120158);
        entities.put("mp", 8723);
        entities.put("mscr", 120002);
        entities.put("mstpos", 8766);
        entities.put("mu", 956);
        entities.put("multimap", 8888);
        entities.put("mumap", 8888);
        entities.put("nLeftarrow", 8653);
        entities.put("nLeftrightarrow", 8654);
        entities.put("nRightarrow", 8655);
        entities.put("nVDash", 8879);
        entities.put("nVdash", 8878);
        entities.put("nabla", 8711);
        entities.put("nacute", 324);
        entities.put("nap", 8777);
        entities.put("napos", 329);
        entities.put("napprox", 8777);
        entities.put("natur", 9838);
        entities.put("natural", 9838);
        entities.put("naturals", 8469);
        entities.put("nbsp", 160);
        entities.put("ncap", 10819);
        entities.put("ncaron", 328);
        entities.put("ncedil", 326);
        entities.put("ncong", 8775);
        entities.put("ncup", 10818);
        entities.put("ncy", 1085);
        entities.put("ndash", 8211);
        entities.put("ne", 8800);
        entities.put("neArr", 8663);
        entities.put("nearhk", 10532);
        entities.put("nearr", 8599);
        entities.put("nearrow", 8599);
        entities.put("nequiv", 8802);
        entities.put("nesear", 10536);
        entities.put("nexist", 8708);
        entities.put("nexists", 8708);
        entities.put("nfr", 120107);
        entities.put("nge", 8817);
        entities.put("ngeq", 8817);
        entities.put("ngsim", 8821);
        entities.put("ngt", 8815);
        entities.put("ngtr", 8815);
        entities.put("nhArr", 8654);
        entities.put("nharr", 8622);
        entities.put("nhpar", 10994);
        entities.put("ni", 8715);
        entities.put("nis", 8956);
        entities.put("nisd", 8954);
        entities.put("niv", 8715);
        entities.put("njcy", 1114);
        entities.put("nlArr", 8653);
        entities.put("nlarr", 8602);
        entities.put("nldr", 8229);
        entities.put("nle", 8816);
        entities.put("nleftarrow", 8602);
        entities.put("nleftrightarrow", 8622);
        entities.put("nleq", 8816);
        entities.put("nless", 8814);
        entities.put("nlsim", 8820);
        entities.put("nlt", 8814);
        entities.put("nltri", 8938);
        entities.put("nltrie", 8940);
        entities.put("nmid", 8740);
        entities.put("nopf", 120159);
        entities.put("not", 172);
        entities.put("notin", 8713);
        entities.put("notinva", 8713);
        entities.put("notinvb", 8951);
        entities.put("notinvc", 8950);
        entities.put("notni", 8716);
        entities.put("notniva", 8716);
        entities.put("notnivb", 8958);
        entities.put("notnivc", 8957);
        entities.put("npar", 8742);
        entities.put("nparallel", 8742);
        entities.put("npolint", 10772);
        entities.put("npr", 8832);
        entities.put("nprcue", 8928);
        entities.put("nprec", 8832);
        entities.put("nrArr", 8655);
        entities.put("nrarr", 8603);
        entities.put("nrightarrow", 8603);
        entities.put("nrtri", 8939);
        entities.put("nrtrie", 8941);
        entities.put("nsc", 8833);
        entities.put("nsccue", 8929);
        entities.put("nscr", 120003);
        entities.put("nshortmid", 8740);
        entities.put("nshortparallel", 8742);
        entities.put("nsim", 8769);
        entities.put("nsime", 8772);
        entities.put("nsimeq", 8772);
        entities.put("nsmid", 8740);
        entities.put("nspar", 8742);
        entities.put("nsqsube", 8930);
        entities.put("nsqsupe", 8931);
        entities.put("nsub", 8836);
        entities.put("nsube", 8840);
        entities.put("nsubseteq", 8840);
        entities.put("nsucc", 8833);
        entities.put("nsup", 8837);
        entities.put("nsupe", 8841);
        entities.put("nsupseteq", 8841);
        entities.put("ntgl", 8825);
        entities.put("ntilde", 241);
        entities.put("ntlg", 8824);
        entities.put("ntriangleleft", 8938);
        entities.put("ntrianglelefteq", 8940);
        entities.put("ntriangleright", 8939);
        entities.put("ntrianglerighteq", 8941);
        entities.put("nu", 957);
        entities.put("num", 35);
        entities.put("numero", 8470);
        entities.put("numsp", 8199);
        entities.put("nvDash", 8877);
        entities.put("nvHarr", 10500);
        entities.put("nvdash", 8876);
        entities.put("nvinfin", 10718);
        entities.put("nvlArr", 10498);
        entities.put("nvrArr", 10499);
        entities.put("nwArr", 8662);
        entities.put("nwarhk", 10531);
        entities.put("nwarr", 8598);
        entities.put("nwarrow", 8598);
        entities.put("nwnear", 10535);
        entities.put("oS", 9416);
        entities.put("oacute", 243);
        entities.put("oast", 8859);
        entities.put("ocir", 8858);
        entities.put("ocirc", 244);
        entities.put("ocy", 1086);
        entities.put("odash", 8861);
        entities.put("odblac", 337);
        entities.put("odiv", 10808);
        entities.put("odot", 8857);
        entities.put("odsold", 10684);
        entities.put("oelig", 339);
        entities.put("ofcir", 10687);
        entities.put("ofr", 120108);
        entities.put("ogon", 731);
        entities.put("ograve", 242);
        entities.put("ogt", 10689);
        entities.put("ohbar", 10677);
        entities.put("ohm", 937);
        entities.put("oint", 8750);
        entities.put("olarr", 8634);
        entities.put("olcir", 10686);
        entities.put("olcross", 10683);
        entities.put("oline", 8254);
        entities.put("olt", 10688);
        entities.put("omacr", 333);
        entities.put("omega", 969);
        entities.put("omicron", 959);
        entities.put("omid", 10678);
        entities.put("ominus", 8854);
        entities.put("oopf", 120160);
        entities.put("opar", 10679);
        entities.put("operp", 10681);
        entities.put("oplus", 8853);
        entities.put("or", 8744);
        entities.put("orarr", 8635);
        entities.put("ord", 10845);
        entities.put("order", 8500);
        entities.put("orderof", 8500);
        entities.put("ordf", 170);
        entities.put("ordm", 186);
        entities.put("origof", 8886);
        entities.put("oror", 10838);
        entities.put("orslope", 10839);
        entities.put("orv", 10843);
        entities.put("oscr", 8500);
        entities.put("oslash", 248);
        entities.put("osol", 8856);
        entities.put("otilde", 245);
        entities.put("otimes", 8855);
        entities.put("otimesas", 10806);
        entities.put("ouml", 246);
        entities.put("ovbar", 9021);
        entities.put("par", 8741);
        entities.put("para", 182);
        entities.put("parallel", 8741);
        entities.put("parsim", 10995);
        entities.put("parsl", 11005);
        entities.put("part", 8706);
        entities.put("pcy", 1087);
        entities.put("percnt", 37);
        entities.put("period", 46);
        entities.put("permil", 8240);
        entities.put("perp", 8869);
        entities.put("pertenk", 8241);
        entities.put("pfr", 120109);
        entities.put("phi", 966);
        entities.put("phiv", 981);
        entities.put("phmmat", 8499);
        entities.put("phone", 9742);
        entities.put("pi", 960);
        entities.put("pitchfork", 8916);
        entities.put("piv", 982);
        entities.put("planck", 8463);
        entities.put("planckh", 8462);
        entities.put("plankv", 8463);
        entities.put("plus", 43);
        entities.put("plusacir", 10787);
        entities.put("plusb", 8862);
        entities.put("pluscir", 10786);
        entities.put("plusdo", 8724);
        entities.put("plusdu", 10789);
        entities.put("pluse", 10866);
        entities.put("plusmn", 177);
        entities.put("plussim", 10790);
        entities.put("plustwo", 10791);
        entities.put("pm", 177);
        entities.put("pointint", 10773);
        entities.put("popf", 120161);
        entities.put("pound", 163);
        entities.put("pr", 8826);
        entities.put("prE", 10931);
        entities.put("prap", 10935);
        entities.put("prcue", 8828);
        entities.put("pre", 10927);
        entities.put("prec", 8826);
        entities.put("precapprox", 10935);
        entities.put("preccurlyeq", 8828);
        entities.put("preceq", 10927);
        entities.put("precnapprox", 10937);
        entities.put("precneqq", 10933);
        entities.put("precnsim", 8936);
        entities.put("precsim", 8830);
        entities.put("prime", 8242);
        entities.put("primes", 8473);
        entities.put("prnE", 10933);
        entities.put("prnap", 10937);
        entities.put("prnsim", 8936);
        entities.put("prod", 8719);
        entities.put("profalar", 9006);
        entities.put("profline", 8978);
        entities.put("profsurf", 8979);
        entities.put("prop", 8733);
        entities.put("propto", 8733);
        entities.put("prsim", 8830);
        entities.put("prurel", 8880);
        entities.put("pscr", 120005);
        entities.put("psi", 968);
        entities.put("puncsp", 8200);
        entities.put("qfr", 120110);
        entities.put("qint", 10764);
        entities.put("qopf", 120162);
        entities.put("qprime", 8279);
        entities.put("qscr", 120006);
        entities.put("quaternions", 8461);
        entities.put("quatint", 10774);
        entities.put("quest", 63);
        entities.put("questeq", 8799);
        entities.put("quot", 34);
        entities.put("rAarr", 8667);
        entities.put("rArr", 8658);
        entities.put("rAtail", 10524);
        entities.put("rBarr", 10511);
        entities.put("rHar", 10596);
        entities.put("racute", 341);
        entities.put("radic", 8730);
        entities.put("raemptyv", 10675);
        entities.put("rang", 10217);
        entities.put("rangd", 10642);
        entities.put("range", 10661);
        entities.put("rangle", 10217);
        entities.put("raquo", 187);
        entities.put("rarr", 8594);
        entities.put("rarrap", 10613);
        entities.put("rarrb", 8677);
        entities.put("rarrbfs", 10528);
        entities.put("rarrc", 10547);
        entities.put("rarrfs", 10526);
        entities.put("rarrhk", 8618);
        entities.put("rarrlp", 8620);
        entities.put("rarrpl", 10565);
        entities.put("rarrsim", 10612);
        entities.put("rarrtl", 8611);
        entities.put("rarrw", 8605);
        entities.put("ratail", 10522);
        entities.put("ratio", 8758);
        entities.put("rationals", 8474);
        entities.put("rbarr", 10509);
        entities.put("rbbrk", 10099);
        entities.put("rbrace", 125);
        entities.put("rbrack", 93);
        entities.put("rbrke", 10636);
        entities.put("rbrksld", 10638);
        entities.put("rbrkslu", 10640);
        entities.put("rcaron", 345);
        entities.put("rcedil", 343);
        entities.put("rceil", 8969);
        entities.put("rcub", 125);
        entities.put("rcy", 1088);
        entities.put("rdca", 10551);
        entities.put("rdldhar", 10601);
        entities.put("rdquo", 8221);
        entities.put("rdquor", 8221);
        entities.put("rdsh", 8627);
        entities.put("real", 8476);
        entities.put("realine", 8475);
        entities.put("realpart", 8476);
        entities.put("reals", 8477);
        entities.put("rect", 9645);
        entities.put("reg", 174);
        entities.put("rfisht", 10621);
        entities.put("rfloor", 8971);
        entities.put("rfr", 120111);
        entities.put("rhard", 8641);
        entities.put("rharu", 8640);
        entities.put("rharul", 10604);
        entities.put("rho", 961);
        entities.put("rhov", 1009);
        entities.put("rightarrow", 8594);
        entities.put("rightarrowtail", 8611);
        entities.put("rightharpoondown", 8641);
        entities.put("rightharpoonup", 8640);
        entities.put("rightleftarrows", 8644);
        entities.put("rightleftharpoons", 8652);
        entities.put("rightrightarrows", 8649);
        entities.put("rightsquigarrow", 8605);
        entities.put("rightthreetimes", 8908);
        entities.put("ring", 730);
        entities.put("risingdotseq", 8787);
        entities.put("rlarr", 8644);
        entities.put("rlhar", 8652);
        entities.put("rlm", 8207);
        entities.put("rmoust", 9137);
        entities.put("rmoustache", 9137);
        entities.put("rnmid", 10990);
        entities.put("roang", 10221);
        entities.put("roarr", 8702);
        entities.put("robrk", 10215);
        entities.put("ropar", 10630);
        entities.put("ropf", 120163);
        entities.put("roplus", 10798);
        entities.put("rotimes", 10805);
        entities.put("rpar", 41);
        entities.put("rpargt", 10644);
        entities.put("rppolint", 10770);
        entities.put("rrarr", 8649);
        entities.put("rsaquo", 8250);
        entities.put("rscr", 120007);
        entities.put("rsh", 8625);
        entities.put("rsqb", 93);
        entities.put("rsquo", 8217);
        entities.put("rsquor", 8217);
        entities.put("rthree", 8908);
        entities.put("rtimes", 8906);
        entities.put("rtri", 9657);
        entities.put("rtrie", 8885);
        entities.put("rtrif", 9656);
        entities.put("rtriltri", 10702);
        entities.put("ruluhar", 10600);
        entities.put("rx", 8478);
        entities.put("sacute", 347);
        entities.put("sbquo", 8218);
        entities.put("sc", 8827);
        entities.put("scE", 10932);
        entities.put("scap", 10936);
        entities.put("scaron", 353);
        entities.put("sccue", 8829);
        entities.put("sce", 10928);
        entities.put("scedil", 351);
        entities.put("scirc", 349);
        entities.put("scnE", 10934);
        entities.put("scnap", 10938);
        entities.put("scnsim", 8937);
        entities.put("scpolint", 10771);
        entities.put("scsim", 8831);
        entities.put("scy", 1089);
        entities.put("sdot", 8901);
        entities.put("sdotb", 8865);
        entities.put("sdote", 10854);
        entities.put("seArr", 8664);
        entities.put("searhk", 10533);
        entities.put("searr", 8600);
        entities.put("searrow", 8600);
        entities.put("sect", 167);
        entities.put("semi", 59);
        entities.put("seswar", 10537);
        entities.put("setminus", 8726);
        entities.put("setmn", 8726);
        entities.put("sext", 10038);
        entities.put("sfr", 120112);
        entities.put("sfrown", 8994);
        entities.put("sharp", 9839);
        entities.put("shchcy", 1097);
        entities.put("shcy", 1096);
        entities.put("shortmid", 8739);
        entities.put("shortparallel", 8741);
        entities.put("shy", 173);
        entities.put("sigma", 963);
        entities.put("sigmaf", 962);
        entities.put("sigmav", 962);
        entities.put("sim", 8764);
        entities.put("simdot", 10858);
        entities.put("sime", 8771);
        entities.put("simeq", 8771);
        entities.put("simg", 10910);
        entities.put("simgE", 10912);
        entities.put("siml", 10909);
        entities.put("simlE", 10911);
        entities.put("simne", 8774);
        entities.put("simplus", 10788);
        entities.put("simrarr", 10610);
        entities.put("slarr", 8592);
        entities.put("smallsetminus", 8726);
        entities.put("smashp", 10803);
        entities.put("smeparsl", 10724);
        entities.put("smid", 8739);
        entities.put("smile", 8995);
        entities.put("smt", 10922);
        entities.put("smte", 10924);
        entities.put("softcy", 1100);
        entities.put("sol", 47);
        entities.put("solb", 10692);
        entities.put("solbar", 9023);
        entities.put("sopf", 120164);
        entities.put("spades", 9824);
        entities.put("spadesuit", 9824);
        entities.put("spar", 8741);
        entities.put("sqcap", 8851);
        entities.put("sqcup", 8852);
        entities.put("sqsub", 8847);
        entities.put("sqsube", 8849);
        entities.put("sqsubset", 8847);
        entities.put("sqsubseteq", 8849);
        entities.put("sqsup", 8848);
        entities.put("sqsupe", 8850);
        entities.put("sqsupset", 8848);
        entities.put("sqsupseteq", 8850);
        entities.put("squ", 9633);
        entities.put("square", 9633);
        entities.put("squarf", 9642);
        entities.put("squf", 9642);
        entities.put("srarr", 8594);
        entities.put("sscr", 120008);
        entities.put("ssetmn", 8726);
        entities.put("ssmile", 8995);
        entities.put("sstarf", 8902);
        entities.put("star", 9734);
        entities.put("starf", 9733);
        entities.put("straightepsilon", 1013);
        entities.put("straightphi", 981);
        entities.put("strns", 175);
        entities.put("sub", 8834);
        entities.put("subE", 10949);
        entities.put("subdot", 10941);
        entities.put("sube", 8838);
        entities.put("subedot", 10947);
        entities.put("submult", 10945);
        entities.put("subnE", 10955);
        entities.put("subne", 8842);
        entities.put("subplus", 10943);
        entities.put("subrarr", 10617);
        entities.put("subset", 8834);
        entities.put("subseteq", 8838);
        entities.put("subseteqq", 10949);
        entities.put("subsetneq", 8842);
        entities.put("subsetneqq", 10955);
        entities.put("subsim", 10951);
        entities.put("subsub", 10965);
        entities.put("subsup", 10963);
        entities.put("succ", 8827);
        entities.put("succapprox", 10936);
        entities.put("succcurlyeq", 8829);
        entities.put("succeq", 10928);
        entities.put("succnapprox", 10938);
        entities.put("succneqq", 10934);
        entities.put("succnsim", 8937);
        entities.put("succsim", 8831);
        entities.put("sum", 8721);
        entities.put("sung", 9834);
        entities.put("sup1", 185);
        entities.put("sup2", 178);
        entities.put("sup3", 179);
        entities.put("sup", 8835);
        entities.put("supE", 10950);
        entities.put("supdot", 10942);
        entities.put("supdsub", 10968);
        entities.put("supe", 8839);
        entities.put("supedot", 10948);
        entities.put("suphsol", 10185);
        entities.put("suphsub", 10967);
        entities.put("suplarr", 10619);
        entities.put("supmult", 10946);
        entities.put("supnE", 10956);
        entities.put("supne", 8843);
        entities.put("supplus", 10944);
        entities.put("supset", 8835);
        entities.put("supseteq", 8839);
        entities.put("supseteqq", 10950);
        entities.put("supsetneq", 8843);
        entities.put("supsetneqq", 10956);
        entities.put("supsim", 10952);
        entities.put("supsub", 10964);
        entities.put("supsup", 10966);
        entities.put("swArr", 8665);
        entities.put("swarhk", 10534);
        entities.put("swarr", 8601);
        entities.put("swarrow", 8601);
        entities.put("swnwar", 10538);
        entities.put("szlig", 223);
        entities.put("target", 8982);
        entities.put("tau", 964);
        entities.put("tbrk", 9140);
        entities.put("tcaron", 357);
        entities.put("tcedil", 355);
        entities.put("tcy", 1090);
        entities.put("tdot", 8411);
        entities.put("telrec", 8981);
        entities.put("tfr", 120113);
        entities.put("there4", 8756);
        entities.put("therefore", 8756);
        entities.put("theta", 952);
        entities.put("thetasym", 977);
        entities.put("thetav", 977);
        entities.put("thickapprox", 8776);
        entities.put("thicksim", 8764);
        entities.put("thinsp", 8201);
        entities.put("thkap", 8776);
        entities.put("thksim", 8764);
        entities.put("thorn", 254);
        entities.put("tilde", 732);
        entities.put("times", 215);
        entities.put("timesb", 8864);
        entities.put("timesbar", 10801);
        entities.put("timesd", 10800);
        entities.put("tint", 8749);
        entities.put("toea", 10536);
        entities.put("top", 8868);
        entities.put("topbot", 9014);
        entities.put("topcir", 10993);
        entities.put("topf", 120165);
        entities.put("topfork", 10970);
        entities.put("tosa", 10537);
        entities.put("tprime", 8244);
        entities.put("trade", 8482);
        entities.put("triangle", 9653);
        entities.put("triangledown", 9663);
        entities.put("triangleleft", 9667);
        entities.put("trianglelefteq", 8884);
        entities.put("triangleq", 8796);
        entities.put("triangleright", 9657);
        entities.put("trianglerighteq", 8885);
        entities.put("tridot", 9708);
        entities.put("trie", 8796);
        entities.put("triminus", 10810);
        entities.put("triplus", 10809);
        entities.put("trisb", 10701);
        entities.put("tritime", 10811);
        entities.put("trpezium", 9186);
        entities.put("tscr", 120009);
        entities.put("tscy", 1094);
        entities.put("tshcy", 1115);
        entities.put("tstrok", 359);
        entities.put("twixt", 8812);
        entities.put("twoheadleftarrow", 8606);
        entities.put("twoheadrightarrow", 8608);
        entities.put("uArr", 8657);
        entities.put("uHar", 10595);
        entities.put("uacute", 250);
        entities.put("uarr", 8593);
        entities.put("ubrcy", 1118);
        entities.put("ubreve", 365);
        entities.put("ucirc", 251);
        entities.put("ucy", 1091);
        entities.put("udarr", 8645);
        entities.put("udblac", 369);
        entities.put("udhar", 10606);
        entities.put("ufisht", 10622);
        entities.put("ufr", 120114);
        entities.put("ugrave", 249);
        entities.put("uharl", 8639);
        entities.put("uharr", 8638);
        entities.put("uhblk", 9600);
        entities.put("ulcorn", 8988);
        entities.put("ulcorner", 8988);
        entities.put("ulcrop", 8975);
        entities.put("ultri", 9720);
        entities.put("umacr", 363);
        entities.put("uml", 168);
        entities.put("uogon", 371);
        entities.put("uopf", 120166);
        entities.put("uparrow", 8593);
        entities.put("updownarrow", 8597);
        entities.put("upharpoonleft", 8639);
        entities.put("upharpoonright", 8638);
        entities.put("uplus", 8846);
        entities.put("upsi", 965);
        entities.put("upsih", 978);
        entities.put("upsilon", 965);
        entities.put("upuparrows", 8648);
        entities.put("urcorn", 8989);
        entities.put("urcorner", 8989);
        entities.put("urcrop", 8974);
        entities.put("uring", 367);
        entities.put("urtri", 9721);
        entities.put("uscr", 120010);
        entities.put("utdot", 8944);
        entities.put("utilde", 361);
        entities.put("utri", 9653);
        entities.put("utrif", 9652);
        entities.put("uuarr", 8648);
        entities.put("uuml", 252);
        entities.put("uwangle", 10663);
        entities.put("vArr", 8661);
        entities.put("vBar", 10984);
        entities.put("vBarv", 10985);
        entities.put("vDash", 8872);
        entities.put("vangrt", 10652);
        entities.put("varepsilon", 1013);
        entities.put("varkappa", 1008);
        entities.put("varnothing", 8709);
        entities.put("varphi", 981);
        entities.put("varpi", 982);
        entities.put("varpropto", 8733);
        entities.put("varr", 8597);
        entities.put("varrho", 1009);
        entities.put("varsigma", 962);
        entities.put("vartheta", 977);
        entities.put("vartriangleleft", 8882);
        entities.put("vartriangleright", 8883);
        entities.put("vcy", 1074);
        entities.put("vdash", 8866);
        entities.put("vee", 8744);
        entities.put("veebar", 8891);
        entities.put("veeeq", 8794);
        entities.put("vellip", 8942);
        entities.put("verbar", 124);
        entities.put("vert", 124);
        entities.put("vfr", 120115);
        entities.put("vltri", 8882);
        entities.put("vopf", 120167);
        entities.put("vprop", 8733);
        entities.put("vrtri", 8883);
        entities.put("vscr", 120011);
        entities.put("vzigzag", 10650);
        entities.put("wcirc", 373);
        entities.put("wedbar", 10847);
        entities.put("wedge", 8743);
        entities.put("wedgeq", 8793);
        entities.put("weierp", 8472);
        entities.put("wfr", 120116);
        entities.put("wopf", 120168);
        entities.put("wp", 8472);
        entities.put("wr", 8768);
        entities.put("wreath", 8768);
        entities.put("wscr", 120012);
        entities.put("xcap", 8898);
        entities.put("xcirc", 9711);
        entities.put("xcup", 8899);
        entities.put("xdtri", 9661);
        entities.put("xfr", 120117);
        entities.put("xhArr", 10234);
        entities.put("xharr", 10231);
        entities.put("xi", 958);
        entities.put("xlArr", 10232);
        entities.put("xlarr", 10229);
        entities.put("xmap", 10236);
        entities.put("xnis", 8955);
        entities.put("xodot", 10752);
        entities.put("xopf", 120169);
        entities.put("xoplus", 10753);
        entities.put("xotime", 10754);
        entities.put("xrArr", 10233);
        entities.put("xrarr", 10230);
        entities.put("xscr", 120013);
        entities.put("xsqcup", 10758);
        entities.put("xuplus", 10756);
        entities.put("xutri", 9651);
        entities.put("xvee", 8897);
        entities.put("xwedge", 8896);
        entities.put("yacute", 253);
        entities.put("yacy", 1103);
        entities.put("ycirc", 375);
        entities.put("ycy", 1099);
        entities.put("yen", 165);
        entities.put("yfr", 120118);
        entities.put("yicy", 1111);
        entities.put("yopf", 120170);
        entities.put("yscr", 120014);
        entities.put("yucy", 1102);
        entities.put("yuml", 255);
        entities.put("zacute", 378);
        entities.put("zcaron", 382);
        entities.put("zcy", 1079);
        entities.put("zdot", 380);
        entities.put("zeetrf", 8488);
        entities.put("zeta", 950);
        entities.put("zfr", 120119);
        entities.put("zhcy", 1078);
        entities.put("zigrarr", 8669);
        entities.put("zopf", 120171);
        entities.put("zscr", 120015);
        entities.put("zwj", 8205);
        entities.put("zwnj", 512);
    }

    static {
        XMLCompiler.setHTML5Entities();
    }
}

