/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser.sql;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.meta2project.model.Connection;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.ontobox.libretto.parser.sql.SQLKey;
import org.ontobox.libretto.parser.sql.SQLToken;
import org.ontobox.libretto.parser.sql.SQLType;

class SQL2OntoBox {
    private final Map<SQLKey, Type> dtypes = new EnumMap<SQLKey, Type>(SQLKey.class);
    private final Map<String, Integer> numgen = new HashMap<String, Integer>();
    private final Ontology ont;

    public SQL2OntoBox(String ontoname, Connection con) {
        this.ont = con.createOntology(ontoname);
        Ontology dataont = con.getOntology("http://www.w3.org/2001/XMLSchema");
        this.dtypes.put(SQLKey.FLOAT, dataont.getType("float"));
        this.dtypes.put(SQLKey.INTEGER, dataont.getType("integer"));
        this.dtypes.put(SQLKey.SMALLINT, dataont.getType("integer"));
        this.dtypes.put(SQLKey.VARCHAR, dataont.getType("string"));
        this.dtypes.put(SQLKey.LONGBLOB, dataont.getType("string"));
        this.dtypes.put(SQLKey.DATETIME, dataont.getType("string"));
        this.dtypes.put(SQLKey.BLOB, dataont.getType("string"));
    }

    void trans(SQLToken expression) {
        if (expression.type == SQLType.CREATE) {
            this.transCreate(expression);
        } else if (expression.type == SQLType.INSERT) {
            this.transInsert(expression);
        }
    }

    void transCreate(SQLToken create) {
        String classname = create.name;
        OntClass ontclass = this.ont.createOntClass(classname, new OntClass[0]);
        if (this.numgen.containsKey(classname)) {
            throw new RuntimeException("double definition of table " + classname);
        }
        this.numgen.put(classname, 1);
        ArrayList al = (ArrayList)create.sub;
        for (int i = 0; i < al.size(); i += 2) {
            SQLToken nm = (SQLToken)al.get(i);
            SQLToken tp = (SQLToken)al.get(i + 1);
            String propname = SQL2OntoBox.genPropName(classname, nm.name);
            this.ont.createTProperty(propname, ontclass, this.dtypes.get((Object)tp.key), (Integer)1, (Integer)1);
        }
    }

    void transInsert(SQLToken insert) {
        String classname = insert.name;
        if (!this.numgen.containsKey(classname)) {
            throw new RuntimeException("Class not defined: '" + classname + '\'');
        }
        OntClass ontclass = this.ont.getOntClass(classname);
        String objectname = classname + '_' + "obj_";
        ArrayList al = (ArrayList)insert.obj;
        ArrayList els = (ArrayList)insert.sub;
        for (Object el1 : els) {
            SQLToken rec = (SQLToken)el1;
            ArrayList el = (ArrayList)rec.obj;
            int objnum = this.numgen.get(classname);
            OntObject obj = this.ont.createOntObject(objectname + objnum, new Object[0]);
            obj.addOntClass(ontclass);
            this.numgen.put(classname, objnum + 1);
            for (int i = 0; i < al.size(); ++i) {
                SQLToken value = (SQLToken)el.get(i);
                if (value.type == SQLType.NULL) continue;
                String prop = SQL2OntoBox.genPropName(classname, ((SQLToken)al.get((int)i)).name);
                TProperty tp = this.ont.getTProperty(prop);
                if (value.type == SQLType.STRING) {
                    obj.addTPropertyString(tp, (String)value.obj);
                    continue;
                }
                if (value.type == SQLType.INTEGER) {
                    obj.addTPropertyString(tp, String.valueOf(value.value));
                    continue;
                }
                if (value.type == SQLType.LONGBLOB) {
                    obj.addTPropertyString(tp, value.name);
                    continue;
                }
                if (value.type != SQLType.FLOAT) continue;
                obj.addTPropertyString(tp, String.valueOf(value.obj));
            }
        }
    }

    private static String genPropName(String classname, String column) {
        return classname + '_' + column;
    }

    private static void dbg(String str) {
        System.out.println(str);
    }
}

