/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser.sql;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.ontobox.libretto.parser.sql.SQLKey;
import org.ontobox.libretto.parser.sql.SQLToken;
import org.ontobox.libretto.parser.sql.SQLType;

class SQL2Path {
    private static final Map<SQLKey, String> dtypes = new EnumMap<SQLKey, String>(SQLKey.class);
    private final Map<String, Integer> numgen = new HashMap<String, Integer>();

    String trans(SQLToken expression) {
        if (expression.type == SQLType.CREATE) {
            return this.transCreate(expression);
        }
        if (expression.type == SQLType.INSERT) {
            return this.transInsert(expression);
        }
        return "";
    }

    String transCreate(SQLToken create) {
        StringBuilder sb = new StringBuilder();
        String classname = create.name;
        if (this.numgen.containsKey(classname)) {
            throw new RuntimeException("double definition of table " + classname);
        }
        this.numgen.put(classname, 1);
        sb.append("create @");
        sb.append(classname);
        sb.append("\n{\n");
        ArrayList al = (ArrayList)create.sub;
        for (int i = 0; i < al.size(); i += 2) {
            if (i == 0) {
                sb.append("");
            } else {
                sb.append(",\n");
            }
            SQLToken nm = (SQLToken)al.get(i);
            SQLToken tp = (SQLToken)al.get(i + 1);
            sb.append('\t');
            sb.append(SQL2Path.genPropName(classname, nm.name));
            sb.append(" {");
            sb.append(dtypes.get((Object)tp.key));
            sb.append('}');
        }
        sb.append("\n}\n\n");
        return sb.toString();
    }

    String transInsert(SQLToken insert) {
        StringBuilder sb = new StringBuilder();
        String classname = insert.name;
        if (!this.numgen.containsKey(classname)) {
            throw new RuntimeException("Class not defined: '" + classname + '\'');
        }
        String objectname = '&' + classname + '_' + "obj_";
        ArrayList al = (ArrayList)insert.obj;
        ArrayList els = (ArrayList)insert.sub;
        for (Object el1 : els) {
            SQLToken rec = (SQLToken)el1;
            ArrayList el = (ArrayList)rec.obj;
            sb.append("create ");
            int objnum = this.numgen.get(classname);
            sb.append(objectname).append(objnum);
            this.numgen.put(classname, objnum + 1);
            sb.append(" {\n\t@");
            sb.append(classname);
            sb.append(",\n");
            for (int i = 0; i < al.size(); ++i) {
                SQLToken value = (SQLToken)el.get(i);
                if (value.type == SQLType.NULL) continue;
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('\n');
                String prop = ((SQLToken)al.get((int)i)).name;
                sb.append('\t');
                sb.append(SQL2Path.genPropName(classname, prop));
                sb.append(" := ");
                if (value.type == SQLType.STRING) {
                    sb.append('\"').append((String)value.obj).append('\"');
                    continue;
                }
                if (value.type == SQLType.INTEGER) {
                    sb.append(value.value);
                    continue;
                }
                if (value.type == SQLType.LONGBLOB || value.type == SQLType.BLOB) {
                    sb.append('\"').append(value.name).append('\"');
                    continue;
                }
                if (value.type != SQLType.FLOAT) continue;
                sb.append(value.obj);
            }
            sb.append("\n}\n\n");
        }
        return sb.toString();
    }

    private static String genPropName(String classname, String column) {
        return classname + '_' + column;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isStringLike(SQLKey SQLKey2) {
        if (SQLKey2 == SQLKey.LONGBLOB) return true;
        if (SQLKey2 != SQLKey.VARCHAR) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isIntegerLike(SQLKey SQLKey2) {
        if (SQLKey2 == SQLKey.INTEGER) return true;
        if (SQLKey2 != SQLKey.SMALLINT) return false;
        return true;
    }

    private static boolean isFloatLike(SQLKey SQLKey2) {
        return SQLKey2 == SQLKey.FLOAT;
    }

    static {
        dtypes.put(SQLKey.FLOAT, "d:float");
        dtypes.put(SQLKey.INTEGER, "d:integer");
        dtypes.put(SQLKey.SMALLINT, "d:integer");
        dtypes.put(SQLKey.VARCHAR, "d:string");
        dtypes.put(SQLKey.LONGBLOB, "d:string");
        dtypes.put(SQLKey.DATETIME, "d:string");
    }
}

