/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.libretto.parser.sql;

import java.util.ArrayList;
import java.util.List;
import org.ontobox.libretto.parser.sql.SQLKey;
import org.ontobox.libretto.parser.sql.SQLType;

class SQLToken {
    SQLType type;
    SQLKey key;
    String name;
    int value;
    Object obj;
    List sub;

    public SQLToken(SQLType tp) {
        this.type = tp;
    }

    public SQLToken(SQLKey keyword) {
        this.type = SQLType.KEYWORD;
        this.key = keyword;
    }

    public SQLToken(String nm) {
        this.type = SQLType.NAME;
        this.name = nm;
    }

    public SQLToken(int val) {
        this.type = SQLType.INTEGER;
        this.value = val;
    }

    public SQLToken(Double fl) {
        this.type = SQLType.FLOAT;
        this.obj = fl;
    }

    public SQLToken(SQLType SQLType2, Object o) {
        this.type = SQLType2;
        this.obj = o;
    }

    public boolean isKW(SQLKey SQLKey2) {
        return this.key == SQLKey2;
    }

    public boolean is(SQLType SQLType2) {
        return this.type == SQLType2;
    }

    public String toString() {
        switch (this.type) {
            case INTEGER: {
                return String.valueOf(this.value);
            }
            case FLOAT: {
                return this.obj.toString();
            }
            case LONGBLOB: {
                return this.name;
            }
            case STRING: {
                return (String)this.obj;
            }
            case NAME: {
                return '`' + this.name + '`';
            }
            case NULL: {
                return "null";
            }
            case CREATE: {
                StringBuilder sb = new StringBuilder();
                sb.append("create table ");
                ArrayList al = (ArrayList)this.sub;
                sb.append('`').append(this.name).append('`');
                sb.append("(\n");
                for (int i = 0; i < al.size(); i += 2) {
                    if (i > 1) {
                        sb.append(",\n");
                    }
                    sb.append('\t');
                    sb.append(((SQLToken)al.get(i)).toString());
                    sb.append(' ');
                    sb.append(al.get(i + 1));
                }
                sb.append("\n);\n\n");
                return sb.toString();
            }
            case INSERT: {
                StringBuilder sb = new StringBuilder();
                sb.append("insert into ");
                sb.append('`').append(this.name).append('`');
                sb.append("\n\t");
                sb.append(SQLToken.printlist((ArrayList)this.obj));
                sb.append("\nvalues");
                for (Object a : this.sub) {
                    sb.append("\n\t");
                    ArrayList rec = (ArrayList)((SQLToken)a).obj;
                    sb.append(SQLToken.printlist(rec));
                }
                sb.append("\n\n");
                return sb.toString();
            }
            case DTYPE: {
                switch (this.key) {
                    case VARCHAR: {
                        return "varchar(" + this.value + ')';
                    }
                }
                return this.key.toString().toLowerCase();
            }
            case COMMIT: {
                return "COMMIT;\n\n";
            }
        }
        return "???";
    }

    private static String printlist(ArrayList<SQLToken> al) {
        StringBuilder sb = new StringBuilder();
        boolean notfirst = false;
        sb.append('(');
        for (SQLToken t : al) {
            if (notfirst) {
                sb.append(", ");
            }
            sb.append(t.toString());
            notfirst = true;
        }
        sb.append(')');
        return sb.toString();
    }
}

