/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.play.data;

import java.io.PrintWriter;
import java.util.logging.Logger;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.BoxWriter;
import org.ontobox.box.Entity;
import org.ontobox.box.helper.WHelper;
import org.ontobox.play.LibrettoInit;
import org.ontobox.play.data.BoxContext;
import org.ontobox.play.view.Renderer;
import play.Play;
import play.exceptions.ConfigurationException;

public class BoxInitter {
    public static Logger logger = Logger.getLogger(BoxInitter.class.getName());

    public static void createPlay(BoxContext box, BoxWorker worker) {
        BoxWriter writer = worker.write();
        writer.newOntology("http://play.ontobox.org/");
        box.ctx.setDefaultPrefix("http://play.ontobox.org/");
        WHelper.ontclass(worker, "http://play.ontobox.org/#Session").tprop("http://play.ontobox.org/#sessionId", "http://ontobox.org/#string", 1).tprop("http://play.ontobox.org/#sessionTime", "http://ontobox.org/#long", 1);
    }

    public static LibrettoInit findLI() {
        String initClass = Play.configuration.getProperty("libretto.init");
        if (initClass != null) {
            logger.info("Libretto Init Class: " + initClass);
            try {
                Class<?> s = Class.forName(initClass);
                Class<LibrettoInit> initInterface = LibrettoInit.class;
                if (!initInterface.isAssignableFrom(s)) {
                    throw new ConfigurationException("The " + initClass + " class must implement the " + initInterface.getName() + " interface " + " (" + "libretto.init" + "=" + initClass + ")");
                }
                Object obj = s.newInstance();
                return (LibrettoInit)obj;
            }
            catch (Exception e) {
                throw new ConfigurationException(e.toString() + " (" + "libretto.init" + "=" + initClass + ")");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(BoxContext box, String key) {
        LibrettoInit librettoInit = BoxInitter.findLI();
        BoxWorker worker = box.box.work();
        try {
            logger.info("Init for key: " + key);
            box.ctx.setPrintWriter(new PrintWriter(System.out));
            worker.q(box.ctx, "require x \"http://xml.ontobox.org/\"");
            if (worker.entity("http://play.ontobox.org/") != Entity.ONTOLOGY) {
                BoxInitter.createPlay(box, worker);
                if (librettoInit != null) {
                    librettoInit.init(box.ctx, worker);
                }
                Renderer.run(box.ctx, worker, "/app/models/init.ltt", true, false);
            } else {
                box.ctx.setDefaultPrefix("http://play.ontobox.org/");
            }
            Renderer.run(box.ctx, worker, "/app/models/start.ltt", true, false);
            worker.commit();
        }
        finally {
            worker.close();
        }
    }
}

