/*
 * Decompiled with CFR 0.152.
 */
package org.ontobox.play.view;

import java.io.StringWriter;
import org.ontobox.box.BoxWorker;
import org.ontobox.box.helper.Values;
import org.ontobox.box.helper.XMLHelper;
import org.ontobox.box.query.QContext;
import org.ontobox.play.data.Global;
import org.ontobox.play.view.LibrettoTemplate;
import play.Play;
import play.exceptions.TemplateExecutionException;
import play.exceptions.TemplateNotFoundException;
import play.mvc.results.RenderHtml;
import play.mvc.results.RenderText;
import play.mvc.results.Result;
import play.templates.Template;
import play.vfs.VirtualFile;

public class Renderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderTemplate(BoxWorker worker, QContext ctx, String action, int c) {
        Global.cVar.set(c);
        try {
            action = action.replace('.', '/');
            String[] dirs = action.split("/");
            System.arraycopy(dirs, 0, dirs, 1, dirs.length - 1);
            dirs[0] = ".";
            for (String dir : dirs) {
                Renderer.run(ctx, worker, "/app/views/" + dir + "/" + "_.ltt", true, false);
            }
            Values values = Renderer.run(ctx, worker, "/app/views/" + action.replace("/", "/_") + ".ltt", false, false);
            Renderer.renderResult(worker, values);
        }
        finally {
            Global.cVar.remove();
        }
    }

    protected static void renderResult(BoxWorker worker, Values values) {
        if (values.isObject()) {
            Integer obj = values.object();
            if (obj != null && XMLHelper.isElement(worker, obj)) {
                StringWriter writer = new StringWriter();
                XMLHelper.exportHTML(worker, writer, obj);
                throw new RenderHtml((CharSequence)writer.toString());
            }
            StringBuilder sb = new StringBuilder();
            for (Integer id : values.objects()) {
                sb.append(worker.name(id)).append("\n");
            }
            throw new RenderText((CharSequence)sb.toString());
        }
        throw new RenderHtml((CharSequence)values.string());
    }

    public static Values run(QContext ctx, BoxWorker worker, String path, boolean optional, boolean allowResult) {
        VirtualFile file = Play.getVirtualFile((String)path);
        if (file == null || !file.exists() || file.isDirectory()) {
            if (!optional) {
                throw new TemplateNotFoundException(path);
            }
            return null;
        }
        final LibrettoTemplate template = new LibrettoTemplate(file);
        try {
            return worker.qValues(ctx, template.source);
        }
        catch (Result result) {
            if (allowResult) {
                throw result;
            }
            throw new RuntimeException("Results are not allowed (use it from controllers), " + ((Object)((Object)result)).getClass(), result);
        }
        catch (RuntimeException e) {
            QContext.detectError(e, new QContext.ErrorProcessor(){

                @Override
                public void errorDetected(int line, int position) {
                    throw new TemplateExecutionException((Template)template, Integer.valueOf(line), e.getMessage(), (Throwable)e);
                }
            });
            throw e;
        }
    }
}

