/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.examples.fb2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.meta2project.examples.fb2.FB2;
import org.meta2project.examples.fb2.FB2ZipProcessor;

class FB2ZipScanner {
    private static final Logger logger = Logger.getLogger(FB2ZipScanner.class.getName());
    private final File baseDir;
    private final boolean verbose;

    public FB2ZipScanner(File dir, boolean v) {
        this.baseDir = dir;
        this.verbose = v;
    }

    public void scan(FB2ZipProcessor processor) throws IOException {
        this.scanDir(this.baseDir, processor);
    }

    private void scanDir(File dir, FB2ZipProcessor processor) throws IOException {
        if (this.verbose) {
            System.out.println(dir);
        }
        for (File file : dir.listFiles()) {
            if (file.isFile() && file.getName().toLowerCase().endsWith(".zip")) {
                this.scanZip(file, processor);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.scanDir(file, processor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanZip(File file, FB2ZipProcessor processor) {
        try {
            ZipFile zFile = new ZipFile(file, "Cp866");
            try {
                Enumeration entries = zFile.getEntries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    String name = entry.getName();
                    if (!name.toLowerCase().endsWith(".fb2")) continue;
                    InputStream in = zFile.getInputStream(entry);
                    try {
                        this.process(file, zFile, name, in, processor);
                    }
                    finally {
                        in.close();
                    }
                }
            }
            finally {
                zFile.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, file.getAbsolutePath(), e);
        }
    }

    private void process(File file, ZipFile zip, String name, InputStream in, FB2ZipProcessor processor) {
        try {
            if (this.verbose) {
                System.out.println(file + " -> " + name);
            }
            FB2 fb2 = new FB2(in);
            processor.processZip(zip, name, fb2);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, zip.toString(), e);
        }
    }
}

