/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.exchange;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.meta2project.exchange.OntExchange;
import org.meta2project.model.AnnotatedEntity;
import org.meta2project.model.Connection;
import org.meta2project.model.OProperty;
import org.meta2project.model.OntClass;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.Type;
import org.ontobox.box.exception.AlreadyExistsException;
import org.ontobox.box.helper.ProgressListener;
import org.ontobox.exchange.TypeMap;

public class OWLXImport
extends OntExchange {
    private static final Logger logger = Logger.getLogger(OWLXImport.class.getName());
    private final SAXBuilder builder = new SAXBuilder(false);
    private Document doc;
    private String sInfo = "";
    private ProgressListener listener;

    public void setListener(ProgressListener listener) {
        this.listener = listener;
    }

    void nextStep(String message) {
        if (this.listener != null) {
            this.listener.nextStep(message);
        }
    }

    public Ontology load(Connection con, InputStream in) throws Exception {
        this.doc = this.builder.build(in);
        return this.createOntology(con, null);
    }

    public Ontology load(Connection con, File file) throws Exception {
        this.doc = this.builder.build(file);
        return this.createOntology(con, null);
    }

    public Ontology load(Connection con, File file, String newNameOnt) throws Exception {
        this.doc = this.builder.build(file);
        return this.createOntology(con, newNameOnt);
    }

    public Ontology load(Connection con, InputStream in, String newNameOnt) throws Exception {
        this.doc = this.builder.build(in);
        return this.createOntology(con, newNameOnt);
    }

    private static String getAttr(Element el, String name, Namespace ns) throws Exception {
        String v = el.getAttributeValue(name, ns);
        if (v != null) {
            return v;
        }
        throw new Exception("\u0423 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 " + new XMLOutputter().outputString(el) + " \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0430\u0442\u0440\u0438\u0431\u0443\u0442 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c " + name + " \u0432 \u043f\u0440\u043e\u0441\u0442\u0440\u0430\u043d\u0441\u0442\u0432\u0435 \u0438\u043c\u0435\u043d " + ns.getURI() + " [" + ns.getPrefix() + ']');
    }

    private static String getFullName(Ontology ont, String name) {
        if (name.indexOf(35) == -1) {
            return ont.getURI() + '#' + name;
        }
        return name;
    }

    private static OntClass getOntClass(Connection con, Ontology ont, String name) {
        if (name == null) {
            return null;
        }
        return con.getOntClassByFullName(OWLXImport.getFullName(ont, name));
    }

    private static OntObject getOntObject(Connection con, Ontology ont, String name) {
        if (name == null) {
            return null;
        }
        return con.getOntObjectByFullName(OWLXImport.getFullName(ont, name));
    }

    private static Type getType(Connection con, Ontology ont, String name) {
        if (name == null) {
            return null;
        }
        return con.getTypeByFullName(TypeMap.type(OWLXImport.getFullName(ont, name)));
    }

    private static TProperty getTProperty(Connection con, Ontology ont, String name) {
        if (name == null) {
            return null;
        }
        return con.getTPropertyByFullName(OWLXImport.getFullName(ont, name));
    }

    private static OProperty getOProperty(Connection con, Ontology ont, String name) {
        if (name == null) {
            return null;
        }
        return con.getOPropertyByFullName(OWLXImport.getFullName(ont, name));
    }

    Ontology createOntology(Connection con, String newNameOnt) throws Exception {
        Element elIndiv;
        String name;
        Element elRoot = this.doc.getRootElement();
        Namespace ns = elRoot.getNamespace();
        long typeCount = 0L;
        long classCount = 0L;
        long opropCount = 0L;
        long objCount = 0L;
        long tpropCount = 0L;
        String sOntName = newNameOnt != null ? newNameOnt : OWLXImport.getAttr(elRoot, "name", ns);
        if (elRoot.getAttribute("exFormat", ns) == null || !"Meta2-Exchange-r1".equals(elRoot.getAttribute("exFormat", ns).getValue())) {
            throw new Exception("XML-\u0444\u0430\u0439\u043b \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
        }
        Ontology ont = con.createOntology(sOntName);
        OWLXImport.importAnnotations(elRoot, ont, ns);
        List list = elRoot.getChildren("DataType", ns);
        this.nextStep("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0442\u0438\u043f\u044b (" + list.size() + " \u044d\u043b\u0435\u043c.)");
        for (Object o : list) {
            Type type;
            Element el = (Element)o;
            name = OWLXImport.getAttr(el, "name", ns);
            try {
                type = ont.createType(name);
                ++typeCount;
            }
            catch (AlreadyExistsException e) {
                type = ont.getType(name);
            }
            OWLXImport.importAnnotations(el, type, ns);
        }
        list = elRoot.getChildren("Class", ns);
        this.nextStep("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u043a\u043b\u0430\u0441\u0441\u044b (" + list.size() + " \u044d\u043b\u0435\u043c.)");
        for (Object elsClass : list) {
            OntClass cl;
            Element elClass = (Element)elsClass;
            name = OWLXImport.getAttr(elClass, "name", ns);
            try {
                cl = ont.createOntClass(name, new OntClass[0]);
                ++classCount;
            }
            catch (AlreadyExistsException e) {
                cl = ont.getOntClass(name);
            }
            OWLXImport.importAnnotations(elClass, cl, ns);
        }
        list = elRoot.getChildren("Class", ns);
        this.nextStep("\u0421\u0442\u0440\u043e\u0438\u043c \u0438\u0435\u0440\u0430\u0440\u0445\u0438\u044e \u043a\u043b\u0430\u0441\u0441\u043e\u0432-1 (" + list.size() + " \u044d\u043b\u0435\u043c.)");
        for (Object o : elRoot.getChildren("Class", ns)) {
            Element classEl = (Element)o;
            List superClasses = classEl.getChildren("Class", ns);
            if (superClasses.isEmpty()) continue;
            String name2 = OWLXImport.getAttr(classEl, "name", ns);
            OntClass clazz = OWLXImport.getOntClass(con, ont, name2);
            for (Object superClass : superClasses) {
                Element superClassEl = (Element)superClass;
                String superName = OWLXImport.getAttr(superClassEl, "name", ns);
                OWLXImport.getOntClass(con, ont, superName).addSubClass(clazz);
            }
        }
        list = elRoot.getChildren("subClassOf", ns);
        this.nextStep("\u0421\u0442\u0440\u043e\u0438\u043c \u0438\u0435\u0440\u0430\u0440\u0445\u0438\u044e \u043a\u043b\u0430\u0441\u0441\u043e\u0432-2 (" + list.size() + " \u044d\u043b\u0435\u043c.)");
        for (Object anElsClassHierarchy : list) {
            Element elClassHier = (Element)anElsClassHierarchy;
            Element elSubClass = elClassHier.getChild("sub", ns);
            Element elSubClassItem = elSubClass.getChild("Class", ns);
            Element elSuperClass = elClassHier.getChild("super", ns);
            Element elSuperClassItem = elSuperClass.getChild("Class", ns);
            String subName = OWLXImport.getAttr(elSubClassItem, "name", ns);
            String superName = OWLXImport.getAttr(elSuperClassItem, "name", ns);
            OWLXImport.getOntClass(con, ont, superName).addSubClass(OWLXImport.getOntClass(con, ont, subName));
        }
        list = elRoot.getChildren("ObjectProperty", ns);
        this.nextStep("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u043e-\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 (" + list.size() + " \u044d\u043b\u0435\u043c.)");
        for (Object anElsOProp : list) {
            Element elOProp = (Element)anElsOProp;
            name = OWLXImport.getAttr(elOProp, "name", ns);
            try {
                Element elOPropDomain = elOProp.getChild("domain", ns);
                Element elOPropRange = elOProp.getChild("range", ns);
                Element elOPropMinCard = elOProp.getChild("minCardinality", ns);
                Element elOPropMaxCard = elOProp.getChild("maxCardinality", ns);
                OProperty oprop = ont.createOProperty(name, elOPropDomain != null ? ont.getOntClass(OWLXImport.getAttr(elOPropDomain, "class", ns)) : null, elOPropRange != null ? ont.getOntClass(OWLXImport.getAttr(elOPropRange, "class", ns)) : null, elOPropMinCard != null ? Integer.valueOf(OWLXImport.getAttr(elOPropMinCard, "value", ns)) : null, elOPropMaxCard != null ? Integer.valueOf(OWLXImport.getAttr(elOPropMaxCard, "value", ns)) : null);
                OWLXImport.importAnnotations(elOProp, oprop, ns);
                ++opropCount;
            }
            catch (Exception e) {
                throw new Exception("\u041f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043e-\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 " + name + " \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.toString(), e);
            }
        }
        list = elRoot.getChildren("DatatypeProperty", ns);
        this.nextStep("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0442-\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 (" + list.size() + " \u044d\u043b\u0435\u043c.)");
        for (Object anElsTProp : list) {
            Element elTProp = (Element)anElsTProp;
            name = OWLXImport.getAttr(elTProp, "name", ns);
            try {
                Element elTPropDomain = elTProp.getChild("domain", ns);
                Element elTPropRange = elTProp.getChild("range", ns);
                Element elTPropMinCard = elTProp.getChild("minCardinality", ns);
                Element elTPropMaxCard = elTProp.getChild("maxCardinality", ns);
                TProperty tprop = ont.createTProperty(name, elTPropDomain != null ? OWLXImport.getOntClass(con, ont, OWLXImport.getAttr(elTPropDomain, "class", ns)) : null, elTPropRange != null ? OWLXImport.getType(con, ont, OWLXImport.getAttr(elTPropRange, "datatype", ns)) : null, (Integer)(elTPropMinCard != null ? Integer.valueOf(OWLXImport.getAttr(elTPropMinCard, "value", ns)) : 0), elTPropMaxCard != null ? Integer.valueOf(OWLXImport.getAttr(elTPropMaxCard, "value", ns)) : null);
                ++tpropCount;
                OWLXImport.importAnnotations(elTProp, tprop, ns);
            }
            catch (Exception e) {
                throw new Exception("\u041f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0442-\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 " + name + " \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.toString(), e);
            }
        }
        list = elRoot.getChildren("Individual", ns);
        this.nextStep("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u044b (" + list.size() + " \u044d\u043b\u0435\u043c.)");
        for (Object elsIndividual1 : list) {
            elIndiv = (Element)elsIndividual1;
            String objName = OWLXImport.getAttr(elIndiv, "name", ns);
            try {
                OntObject obj;
                try {
                    obj = ont.createOntObject(objName, new Object[0]);
                    ++objCount;
                }
                catch (AlreadyExistsException e) {
                    obj = ont.getOntObject(objName);
                }
                OWLXImport.importAnnotations(elIndiv, obj, ns);
                for (Object elsType : elIndiv.getChildren("type", ns)) {
                    Element elType = (Element)elsType;
                    OntClass objClass = OWLXImport.getOntClass(con, ont, OWLXImport.getAttr(elType, "name", ns));
                    obj.addOntClass(objClass);
                }
            }
            catch (Exception e) {
                throw new Exception("\u041f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 " + objName + " \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.toString(), e);
            }
        }
        list = elRoot.getChildren("Individual", ns);
        this.nextStep("\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 (" + list.size() + " \u044d\u043b\u0435\u043c.)");
        for (Object elsIndividual : list) {
            elIndiv = (Element)elsIndividual;
            OntObject obj = ont.getOntObject(OWLXImport.getAttr(elIndiv, "name", ns));
            try {
                for (Object anElsIOProp : elIndiv.getChildren("ObjectPropertyValue", ns)) {
                    Element elIOProp = (Element)anElsIOProp;
                    Element elIndividual = elIOProp.getChild("Individual", ns);
                    OProperty oprop = OWLXImport.getOProperty(con, ont, OWLXImport.getAttr(elIOProp, "property", ns));
                    if (elIndividual == null) {
                        logger.warning("skipped null ovalue (" + oprop.getFullName() + ')');
                        continue;
                    }
                    obj.addOPropertyValue(oprop, OWLXImport.getOntObject(con, ont, OWLXImport.getAttr(elIndividual, "name", ns)));
                }
                for (Object anElsITProp : elIndiv.getChildren("DataPropertyValue", ns)) {
                    Element elITProp = (Element)anElsITProp;
                    TProperty tprop = OWLXImport.getTProperty(con, ont, OWLXImport.getAttr(elITProp, "property", ns));
                    Element elDataValue = elITProp.getChild("DataValue", ns);
                    if (elDataValue != null) {
                        String value = elDataValue.getText();
                        obj.addTPropertyString(tprop, value);
                        continue;
                    }
                    logger.warning("skipped null tvalue (" + tprop.getFullName() + ')');
                }
            }
            catch (Exception e) {
                throw new Exception("\u041f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 " + obj.getFullName() + " \u043f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.toString(), e);
            }
        }
        this.sInfo = this.sInfo + "\u0421\u043e\u0437\u0434\u0430\u043d\u043e \u0442\u0438\u043f\u043e\u0432: " + typeCount + ", \u043a\u043b\u0430\u0441\u0441\u043e\u0432: " + classCount + ", \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432:" + objCount + ", \u043e-\u0441\u0432\u043e\u0439\u0441\u0442\u0432: " + opropCount + ", \u0442-\u0441\u0432\u043e\u0439\u0441\u0442\u0432:" + tpropCount;
        return ont;
    }

    private static void importAnnotations(Element el, AnnotatedEntity ent, Namespace ns) throws Exception {
        for (Object o : el.getChildren("annotation", ns)) {
            String v;
            Element annoEl = (Element)o;
            String n = annoEl.getAttributeValue("name");
            if (n != null) {
                n = n.trim();
                v = annoEl.getAttributeValue("value");
                ent.putAnnotation(n, v);
                continue;
            }
            n = OWLXImport.getAttr(annoEl, "name", ns);
            n = n.trim();
            v = OWLXImport.getAttr(annoEl, "value", ns);
            ent.putAnnotation(n, v);
        }
    }

    public String getInfo() {
        return this.sInfo;
    }
}

