/*
 * Decompiled with CFR 0.152.
 */
package org.meta2project.model.test;

import java.util.ArrayList;
import org.meta2project.model.Connection;
import org.meta2project.model.FindOption;
import org.meta2project.model.OntObject;
import org.meta2project.model.Ontology;
import org.meta2project.model.TProperty;
import org.meta2project.model.test.support.SessionTestCase;

public class FindTestCase
extends SessionTestCase {
    private Connection con;
    private Ontology ont;

    protected void setUp() throws Exception {
        this.con = this.session.openConnection();
        this.ont = this.con.createOntology("http://findtestcase");
    }

    protected void tearDown() throws Exception {
        this.ont.delete();
        this.con.close();
    }

    private static boolean[] findProp(String[] q, String[] v) {
        boolean[] ret = new boolean[q.length];
        block0: for (int t = 0; t < ret.length; ++t) {
            for (String s : v) {
                if (!s.toLowerCase().contains(q[t].toLowerCase())) continue;
                ret[t] = true;
                continue block0;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFind() throws Exception {
        TProperty tprop1 = this.ont.createTProperty("test1", null, "http://ontobox.org/#string", 0, null);
        TProperty tprop2 = this.ont.createTProperty("test2", null, "http://ontobox.org/#string", 0, null);
        TProperty tprop3 = this.ont.createTProperty("test3", null, "http://ontobox.org/#string", 0, null);
        TProperty tpropInt = this.ont.createTProperty("test4", null, "http://ontobox.org/#int", 0, null);
        ArrayList<OntObject> objectPool = new ArrayList<OntObject>();
        for (int t = 0; t < 1000; ++t) {
            OntObject obj = this.ont.createOntObject(new Object[0]);
            obj.addTPropertyString(tprop1, "abc" + t + "def");
            obj.addTPropertyString(tprop2, t + 1 + "qwer");
            obj.addTPropertyString(tprop3, "mn" + (t + 2));
            obj.addTPropertyString(tpropInt, String.valueOf(t + 3));
            objectPool.add(obj);
        }
        try {
            boolean[] f;
            String v4;
            String v3;
            String v2;
            String v1;
            String v42;
            String v32;
            String v22;
            String v12;
            String q = "12";
            int count = 0;
            for (OntObject obj : this.ont.find(FindOption.AND, q)) {
                ++count;
                v12 = obj.getTPropertyString(tprop1);
                v22 = obj.getTPropertyString(tprop2);
                v32 = obj.getTPropertyString(tprop3);
                v42 = obj.getTPropertyString(tpropInt);
                FindTestCase.assertTrue((v12.contains(q) || v22.contains(q) || v32.contains(q) || v42.contains(q) ? 1 : 0) != 0);
            }
            FindTestCase.assertTrue((count > 0 ? 1 : 0) != 0);
            count = 0;
            for (OntObject obj : this.ont.find(FindOption.OR, q)) {
                ++count;
                v12 = obj.getTPropertyString(tprop1);
                v22 = obj.getTPropertyString(tprop2);
                v32 = obj.getTPropertyString(tprop3);
                v42 = obj.getTPropertyString(tpropInt);
                FindTestCase.assertTrue((v12.contains(q) || v22.contains(q) || v32.contains(q) || v42.contains(q) ? 1 : 0) != 0);
            }
            FindTestCase.assertTrue((count > 0 ? 1 : 0) != 0);
            count = 0;
            String q1 = "101";
            String q2 = "100";
            for (OntObject obj : this.ont.find(FindOption.AND, q1, q2)) {
                ++count;
                v1 = obj.getTPropertyString(tprop1);
                v2 = obj.getTPropertyString(tprop2);
                v3 = obj.getTPropertyString(tprop3);
                v4 = obj.getTPropertyString(tpropInt);
                f = FindTestCase.findProp(new String[]{q1, q2}, new String[]{v1, v2, v3, v4});
                FindTestCase.assertTrue((f[0] && f[1] ? 1 : 0) != 0);
            }
            FindTestCase.assertTrue((count > 0 ? 1 : 0) != 0);
            count = 0;
            q1 = "101";
            q2 = "100";
            for (OntObject obj : this.ont.find(FindOption.OR, q1, q2)) {
                ++count;
                v1 = obj.getTPropertyString(tprop1);
                v2 = obj.getTPropertyString(tprop2);
                v3 = obj.getTPropertyString(tprop3);
                v4 = obj.getTPropertyString(tpropInt);
                f = FindTestCase.findProp(new String[]{q1, q2}, new String[]{v1, v2, v3, v4});
                FindTestCase.assertTrue((f[0] || f[1] ? 1 : 0) != 0);
            }
            FindTestCase.assertTrue((count > 0 ? 1 : 0) != 0);
        }
        finally {
            for (OntObject ontObject : objectPool) {
                ontObject.delete();
            }
            tpropInt.delete();
            tprop3.delete();
            tprop2.delete();
            tprop1.delete();
        }
    }
}

